/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.Clock;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;

public class CapacitySchedulerPreemptionTestBase {
    final int GB = 1024;
    Configuration conf;
    RMNodeLabelsManager mgr;
    Clock clock;

    @Before
    void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        this.conf.setClass("yarn.resourcemanager.scheduler.monitor.policies", ProportionalCapacityPreemptionPolicy.class, SchedulingEditPolicy.class);
        this.conf = TestUtils.getConfigurationWithMultipleQueues(this.conf);
        this.conf.setInt("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 0);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 1.0f);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 1.0f);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", 60000L);
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init(this.conf);
        this.clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)this.clock.getTime()).thenReturn((Object)0L);
    }

    SchedulingEditPolicy getSchedulingEditPolicy(MockRM rm) {
        ResourceManager.RMSchedulerServices activeServices = rm.getRMActiveService();
        SchedulingMonitor mon = null;
        for (Service service : activeServices.getServices()) {
            if (!(service instanceof SchedulingMonitor)) continue;
            mon = (SchedulingMonitor)service;
            break;
        }
        if (mon != null) {
            return mon.getSchedulingEditPolicy();
        }
        return null;
    }

    public void waitNumberOfLiveContainersFromApp(FiCaSchedulerApp app, int expected) throws InterruptedException {
        for (int waitNum = 0; waitNum < 10; ++waitNum) {
            System.out.println(app.getLiveContainers().size());
            if (app.getLiveContainers().size() == expected) {
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail();
    }

    public void waitNumberOfReservedContainersFromApp(FiCaSchedulerApp app, int expected) throws InterruptedException {
        for (int waitNum = 0; waitNum < 10; ++waitNum) {
            System.out.println(app.getReservedContainers().size());
            if (app.getReservedContainers().size() == expected) {
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail();
    }

    public void waitNumberOfLiveContainersOnNodeFromApp(FiCaSchedulerNode node, ApplicationAttemptId appId, int expected) throws InterruptedException {
        for (int waitNum = 0; waitNum < 500; ++waitNum) {
            int total = 0;
            for (RMContainer c : node.getCopiedListOfRunningContainers()) {
                if (!c.getApplicationAttemptId().equals((Object)appId)) continue;
                ++total;
            }
            if (total == expected) {
                return;
            }
            Thread.sleep(10L);
        }
        Assert.fail();
    }
}

