/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSchedulingUpdate
extends FairSchedulerTestBase {
    @Override
    public Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setInt("yarn.scheduler.fair.update-interval-ms", Integer.MAX_VALUE);
        return conf;
    }

    @Before
    public void setup() throws IOException {
        this.conf = this.createConfiguration();
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
    }

    @Test(timeout=3000L)
    public void testSchedulingUpdateOnNodeJoinLeave() throws InterruptedException {
        this.verifyNoCalls();
        String host = "127.0.0.1";
        int memory = 4096;
        int cores = 4;
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, host);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        long expectedCalls = 1L;
        this.verifyExpectedCalls(expectedCalls, 4096, 4);
        NodeRemovedSchedulerEvent nodeEvent2 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        expectedCalls = 2L;
        this.verifyExpectedCalls(expectedCalls, 0, 0);
    }

    private void verifyExpectedCalls(long expectedCalls, int memory, int vcores) throws InterruptedException {
        boolean verified = false;
        for (int count = 0; count < 100 && !this.scheduler.fsOpDurations.hasUpdateThreadRunChanged(); ++count) {
            Thread.sleep(10L);
        }
        Assert.assertTrue((String)"Update Thread has not run based on its metrics", (boolean)this.scheduler.fsOpDurations.hasUpdateThreadRunChanged());
        Assert.assertEquals((String)"Root queue metrics memory does not have expected value", (long)memory, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((String)"Root queue metrics cpu does not have expected value", (long)vcores, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        this.scheduler.fsOpDurations.getMetrics((MetricsCollector)collector, true);
        MetricsRecord record = (MetricsRecord)collector.getRecords().get(0);
        for (AbstractMetric abstractMetric : record.metrics()) {
            if (!abstractMetric.name().contains("UpdateThreadRunNumOps")) continue;
            Assert.assertEquals((String)"Update Thread did not run expected number of times based on metric record count", (Object)expectedCalls, (Object)abstractMetric.value());
            verified = true;
        }
        Assert.assertTrue((String)"Did not find metric for UpdateThreadRunNumOps", (boolean)verified);
    }

    private void verifyNoCalls() {
        Assert.assertFalse((String)"Update thread should not have executed", (boolean)this.scheduler.fsOpDurations.hasUpdateThreadRunChanged());
        Assert.assertEquals((String)"Scheduler queue memory should not have been updated", (long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((String)"Scheduler queue cpu should not have been updated", (long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }
}

