/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.DateUtils;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdatedCryptoForApp;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeDecreaseContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeFinishedContainersPulledByAMEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeUpdateCryptoMaterialForAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMNodeImpl
implements RMNode,
EventHandler<RMNodeEvent> {
    private static final Log LOG = LogFactory.getLog(RMNodeImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ReentrantReadWriteLock.ReadLock readLock;
    protected final ReentrantReadWriteLock.WriteLock writeLock;
    protected final ConcurrentLinkedQueue<UpdatedContainerInfo> nodeUpdateQueue;
    protected volatile boolean nextHeartBeat = true;
    protected final NodeId nodeId;
    protected final RMContext context;
    protected final String hostName;
    protected final int commandPort;
    protected int httpPort;
    private final String nodeAddress;
    protected String httpAddress;
    private volatile Resource originalTotalCapability;
    protected volatile Resource totalCapability;
    private final Node node;
    private String healthReport;
    private long lastHealthReportTime;
    protected String nodeManagerVersion;
    private long timeStamp;
    private ResourceUtilization containersUtilization;
    private ResourceUtilization nodeUtilization;
    protected final ContainerAllocationExpirer containerAllocationExpirer;
    protected final Set<ContainerId> launchedContainers = new HashSet<ContainerId>();
    protected final Set<ContainerId> containersToClean = new TreeSet<ContainerId>((Comparator<ContainerId>)new BuilderUtils.ContainerIdComparator());
    protected final List<SignalContainerRequest> containersToSignal = new ArrayList<SignalContainerRequest>();
    protected final Set<ContainerId> containersToBeRemovedFromNM = new HashSet<ContainerId>();
    protected final List<ApplicationId> finishedApplications = new ArrayList<ApplicationId>();
    protected final List<ApplicationId> runningApplications = new ArrayList<ApplicationId>();
    protected final Map<ContainerId, Container> toBeDecreasedContainers = new HashMap<ContainerId, Container>();
    private final Map<ContainerId, Container> nmReportedIncreasedContainers = new HashMap<ContainerId, Container>();
    private final Map<ApplicationId, UpdatedCryptoForApp> appX509ToUpdate = new ConcurrentHashMap<ApplicationId, UpdatedCryptoForApp>();
    private final Map<ApplicationId, UpdatedCryptoForApp> appJWTToUpdate = new ConcurrentHashMap<ApplicationId, UpdatedCryptoForApp>();
    protected NodeHeartbeatResponse latestNodeHeartBeatResponse = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
    private static final StateMachineFactory<RMNodeImpl, NodeState, RMNodeEventType, RMNodeEvent> stateMachineFactory = new StateMachineFactory((Enum)NodeState.NEW).addTransition((Enum)NodeState.NEW, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.STARTED, (SingleArcTransition)new AddNodeTransition()).addTransition((Enum)NodeState.NEW, (Enum)NodeState.NEW, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.NEW, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.RUNNING, EnumSet.of(NodeState.RUNNING, NodeState.UNHEALTHY), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenHealthyTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.GRACEFUL_DECOMMISSION, (SingleArcTransition)new DecommissioningNodeTransition(NodeState.RUNNING, NodeState.DECOMMISSIONING)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.RUNNING, EnumSet.of(NodeState.RUNNING), (Enum)RMNodeEventType.RECONNECTED, (MultipleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenRunningTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.DECREASE_CONTAINER, (SingleArcTransition)new DecreaseContainersTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.SIGNAL_CONTAINER, (SingleArcTransition)new SignalContainerTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.SHUTDOWN, (SingleArcTransition)new DeactivateNodeTransition(NodeState.SHUTDOWN)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.UPDATE_CRYPTO_MATERIAL, (SingleArcTransition)new UpdateCryptoMaterialForAppTransition()).addTransition((Enum)NodeState.REBOOTED, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.DECOMMISSIONED, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.DECOMMISSIONED, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.RECOMMISSION, (SingleArcTransition)new RecommissionNodeTransition(NodeState.RUNNING)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenRunningTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, EnumSet.of(NodeState.DECOMMISSIONING, NodeState.DECOMMISSIONED), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenHealthyTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.GRACEFUL_DECOMMISSION, (SingleArcTransition)new DecommissioningNodeTransition(NodeState.DECOMMISSIONING, NodeState.DECOMMISSIONING)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.SHUTDOWN, (SingleArcTransition)new DeactivateNodeTransition(NodeState.SHUTDOWN)).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, EnumSet.of(NodeState.DECOMMISSIONING, NodeState.DECOMMISSIONED), (Enum)RMNodeEventType.RECONNECTED, (MultipleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.DECOMMISSIONING, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenRunningTransition()).addTransition((Enum)NodeState.LOST, (Enum)NodeState.LOST, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.LOST, (Enum)NodeState.LOST, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.UNHEALTHY, EnumSet.of(NodeState.UNHEALTHY, NodeState.RUNNING), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenUnHealthyTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.DECOMMISSIONING, (Enum)RMNodeEventType.GRACEFUL_DECOMMISSION, (SingleArcTransition)new DecommissioningNodeTransition(NodeState.UNHEALTHY, NodeState.DECOMMISSIONING)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.UNHEALTHY, EnumSet.of(NodeState.UNHEALTHY), (Enum)RMNodeEventType.RECONNECTED, (MultipleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.SIGNAL_CONTAINER, (SingleArcTransition)new SignalContainerTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.SHUTDOWN, (SingleArcTransition)new DeactivateNodeTransition(NodeState.SHUTDOWN)).addTransition((Enum)NodeState.SHUTDOWN, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.RESOURCE_UPDATE, (SingleArcTransition)new UpdateNodeResourceWhenUnusableTransition()).addTransition((Enum)NodeState.SHUTDOWN, (Enum)NodeState.SHUTDOWN, (Enum)RMNodeEventType.FINISHED_CONTAINERS_PULLED_BY_AM, (SingleArcTransition)new AddContainersToBeRemovedFromNMTransition()).installTopology();
    protected final StateMachine<NodeState, RMNodeEventType, RMNodeEvent> stateMachine;

    public RMNodeImpl(NodeId nodeId, RMContext context, String hostName, int cmPort, int httpPort, Node node, Resource capability, String nodeManagerVersion) {
        this.nodeId = nodeId;
        this.context = context;
        this.hostName = hostName;
        this.commandPort = cmPort;
        this.httpPort = httpPort;
        this.totalCapability = capability;
        this.nodeAddress = hostName + ":" + cmPort;
        this.httpAddress = hostName + ":" + httpPort;
        this.node = node;
        this.healthReport = "Healthy";
        this.lastHealthReportTime = System.currentTimeMillis();
        this.nodeManagerVersion = nodeManagerVersion;
        this.timeStamp = 0L;
        this.latestNodeHeartBeatResponse.setResponseId(0);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.nodeUpdateQueue = new ConcurrentLinkedQueue();
        this.containerAllocationExpirer = context.getContainerAllocationExpirer();
    }

    public String toString() {
        return this.nodeId.toString();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getCommandPort() {
        return this.commandPort;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    @Override
    public NodeId getNodeID() {
        return this.nodeId;
    }

    @Override
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public String getHttpAddress() {
        return this.httpAddress;
    }

    @Override
    public Resource getTotalCapability() {
        return this.totalCapability;
    }

    @Override
    public String getRackName() {
        return this.node.getNetworkLocation();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String getHealthReport() {
        this.readLock.lock();
        try {
            String string = this.healthReport;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setHealthReport(String healthReport) {
        this.writeLock.lock();
        try {
            this.healthReport = healthReport;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setLastHealthReportTime(long lastHealthReportTime) {
        this.writeLock.lock();
        try {
            this.lastHealthReportTime = lastHealthReportTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getLastHealthReportTime() {
        this.readLock.lock();
        try {
            long l = this.lastHealthReportTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getNodeManagerVersion() {
        return this.nodeManagerVersion;
    }

    @Override
    public ResourceUtilization getAggregatedContainersUtilization() {
        this.readLock.lock();
        try {
            ResourceUtilization resourceUtilization = this.containersUtilization;
            return resourceUtilization;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setAggregatedContainersUtilization(ResourceUtilization containersUtilization) {
        this.writeLock.lock();
        try {
            this.containersUtilization = containersUtilization;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ResourceUtilization getNodeUtilization() {
        this.readLock.lock();
        try {
            ResourceUtilization resourceUtilization = this.nodeUtilization;
            return resourceUtilization;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setNodeUtilization(ResourceUtilization nodeUtilization) {
        this.writeLock.lock();
        try {
            this.nodeUtilization = nodeUtilization;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NodeState getState() {
        this.readLock.lock();
        try {
            NodeState nodeState = (NodeState)this.stateMachine.getCurrentState();
            return nodeState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<ApplicationId> getAppsToCleanup() {
        this.readLock.lock();
        try {
            ArrayList<ApplicationId> arrayList = new ArrayList<ApplicationId>(this.finishedApplications);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<ApplicationId> getRunningApps() {
        this.readLock.lock();
        try {
            ArrayList<ApplicationId> arrayList = new ArrayList<ApplicationId>(this.runningApplications);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<ContainerId> getContainersToCleanUp() {
        this.readLock.lock();
        try {
            ArrayList<ContainerId> arrayList = new ArrayList<ContainerId>(this.containersToClean);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public Collection<Container> getToBeDecreasedContainers() {
        return this.toBeDecreasedContainers.values();
    }

    @Override
    public NodeHeartbeatResponse getLastNodeHeartBeatResponse() {
        this.readLock.lock();
        try {
            NodeHeartbeatResponse nodeHeartbeatResponse = this.latestNodeHeartBeatResponse;
            return nodeHeartbeatResponse;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void resetLastNodeHeartBeatResponse() {
        this.writeLock.lock();
        try {
            this.latestNodeHeartBeatResponse.setResponseId(0);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void updateMetricsForRejoinedNode(NodeState previousNodeState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        metrics.incrNumActiveNodes();
        switch (previousNodeState) {
            case LOST: {
                metrics.decrNumLostNMs();
                break;
            }
            case REBOOTED: {
                metrics.decrNumRebootedNMs();
                break;
            }
            case DECOMMISSIONED: {
                metrics.decrDecommisionedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
                break;
            }
            case SHUTDOWN: {
                metrics.decrNumShutdownNMs();
                break;
            }
            default: {
                LOG.debug((Object)"Unexpected previous node state");
            }
        }
    }

    private void updateMetricsForGracefulDecommission(NodeState initialState, NodeState finalState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        switch (initialState) {
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
                break;
            }
            case RUNNING: {
                metrics.decrNumActiveNodes();
                break;
            }
            case DECOMMISSIONING: {
                metrics.decrDecommissioningNMs();
                break;
            }
            default: {
                LOG.warn((Object)"Unexpcted initial state");
            }
        }
        switch (finalState) {
            case DECOMMISSIONING: {
                metrics.incrDecommissioningNMs();
                break;
            }
            case RUNNING: {
                metrics.incrNumActiveNodes();
                break;
            }
            default: {
                LOG.warn((Object)"Unexpected final state");
            }
        }
    }

    protected void updateMetricsForDeactivatedNode(NodeState initialState, NodeState finalState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        switch (initialState) {
            case RUNNING: {
                metrics.decrNumActiveNodes();
                break;
            }
            case DECOMMISSIONING: {
                metrics.decrDecommissioningNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
                break;
            }
            case NEW: {
                break;
            }
            default: {
                LOG.warn((Object)"Unexpected initial state");
            }
        }
        switch (finalState) {
            case DECOMMISSIONED: {
                metrics.incrDecommisionedNMs();
                break;
            }
            case LOST: {
                metrics.incrNumLostNMs();
                break;
            }
            case REBOOTED: {
                metrics.incrNumRebootedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.incrNumUnhealthyNMs();
                break;
            }
            case SHUTDOWN: {
                metrics.incrNumShutdownNMs();
                break;
            }
            default: {
                LOG.warn((Object)"Unexpected final state");
            }
        }
    }

    protected abstract void handleRunningAppOnNode(RMNodeImpl var1, RMContext var2, ApplicationId var3, NodeId var4);

    private static void updateNodeResourceFromEvent(RMNodeImpl rmNode, RMNodeResourceUpdateEvent event) {
        ResourceOption resourceOption = event.getResourceOption();
        rmNode.totalCapability = resourceOption.getResource();
    }

    protected abstract void addNodeTransitionInternal(RMNodeImpl var1, RMNodeEvent var2);

    protected static List<NMContainerStatus> updateNewNodeMetricsAndContainers(RMNodeImpl rmNode, RMNodeStartedEvent startEvent) {
        ClusterMetrics.getMetrics().incrNumActiveNodes();
        List<NMContainerStatus> containers = startEvent.getNMContainerStatuses();
        if (containers != null && !containers.isEmpty()) {
            for (NMContainerStatus container : containers) {
                if (container.getContainerState() != ContainerState.RUNNING) continue;
                rmNode.launchedContainers.add(container.getContainerId());
            }
        }
        return containers;
    }

    protected abstract NodeState reconnectNodeTransitionInternal(RMNodeImpl var1, RMNodeEvent var2);

    protected void handleNMContainerStatus(List<NMContainerStatus> nmContainerStatuses, RMNodeImpl rmnode) {
        if (nmContainerStatuses != null) {
            ArrayList<ContainerStatus> containerStatuses = new ArrayList<ContainerStatus>();
            for (NMContainerStatus nmContainerStatus : nmContainerStatuses) {
                containerStatuses.add(this.createContainerStatus(nmContainerStatus));
            }
            rmnode.handleContainerStatus(containerStatuses);
        }
    }

    private ContainerStatus createContainerStatus(NMContainerStatus remoteContainer) {
        ContainerStatus cStatus = ContainerStatus.newInstance((ContainerId)remoteContainer.getContainerId(), (ContainerState)remoteContainer.getContainerState(), (String)remoteContainer.getDiagnostics(), (int)remoteContainer.getContainerExitStatus());
        return cStatus;
    }

    protected abstract void cleanUpAppTransitionInternal(RMNodeImpl var1, RMNodeEvent var2);

    protected abstract void cleanUpContainerTransitionInternal(RMNodeImpl var1, RMNodeEvent var2);

    protected abstract void decreaseContainersInt(RMNodeImpl var1, RMNodeDecreaseContainerEvent var2);

    protected abstract void deactivateNode(RMNodeImpl var1, NodeState var2);

    protected abstract NodeState statusUpdateWhenHealthyTransitionInternal(RMNodeImpl var1, RMNodeEvent var2);

    protected abstract NodeState statusUpdateWhenUnHealthyTransitionInternal(RMNodeImpl var1, RMNodeEvent var2);

    protected abstract void signalContainerInt(RMNodeImpl var1, RMNodeEvent var2);

    @Override
    public List<UpdatedContainerInfo> pullContainerUpdates() {
        return this.pullContainerUpdatesInternal();
    }

    protected abstract List<UpdatedContainerInfo> pullContainerUpdatesInternal();

    @VisibleForTesting
    public void setNextHeartBeat(boolean nextHeartBeat) {
        this.nextHeartBeat = nextHeartBeat;
    }

    @VisibleForTesting
    public int getQueueSize() {
        return this.nodeUpdateQueue.size();
    }

    @VisibleForTesting
    public Set<ContainerId> getLaunchedContainers() {
        return this.launchedContainers;
    }

    @Override
    public Set<String> getNodeLabels() {
        RMNodeLabelsManager nlm = this.context.getNodeLabelManager();
        if (nlm == null || nlm.getLabelsOnNode(this.nodeId) == null) {
            return CommonNodeLabelsManager.EMPTY_STRING_SET;
        }
        return nlm.getLabelsOnNode(this.nodeId);
    }

    protected void handleReportedIncreasedContainers(List<Container> reportedIncreasedContainers) {
        for (Container container : reportedIncreasedContainers) {
            ContainerId containerId = container.getId();
            if (this.containersToClean.contains(containerId)) {
                LOG.info((Object)("Container " + containerId + " already scheduled for cleanup, no further processing"));
                continue;
            }
            ApplicationId containerAppId = containerId.getApplicationAttemptId().getApplicationId();
            if (this.finishedApplications.contains(containerAppId)) {
                LOG.info((Object)("Container " + containerId + " belongs to an application that is already killed, no further processing"));
                continue;
            }
            this.nmReportedIncreasedContainers.put(containerId, container);
        }
    }

    protected abstract void handleContainerStatus(List<ContainerStatus> var1);

    protected List<ContainerStatus> findLostContainers(int numRemoteRunning, List<ContainerStatus> containerStatuses) {
        if (numRemoteRunning >= this.launchedContainers.size()) {
            return Collections.emptyList();
        }
        HashSet<ContainerId> nodeContainers = new HashSet<ContainerId>(numRemoteRunning);
        ArrayList<ContainerStatus> lostContainers = new ArrayList<ContainerStatus>(this.launchedContainers.size() - numRemoteRunning);
        for (ContainerStatus remoteContainer : containerStatuses) {
            if (remoteContainer.getState() != ContainerState.RUNNING) continue;
            nodeContainers.add(remoteContainer.getContainerId());
        }
        Iterator<ContainerId> iter = this.launchedContainers.iterator();
        while (iter.hasNext()) {
            ContainerId containerId = iter.next();
            if (nodeContainers.contains(containerId)) continue;
            String diag = "Container " + containerId + " was running but not reported from " + this.nodeId;
            LOG.warn((Object)diag);
            lostContainers.add(SchedulerUtils.createAbnormalContainerStatus(containerId, diag));
            iter.remove();
        }
        return lostContainers;
    }

    protected void handleLogAggregationStatus(List<LogAggregationReport> logAggregationReportsForApps) {
        for (LogAggregationReport report : logAggregationReportsForApps) {
            RMApp rmApp = (RMApp)this.context.getRMApps().get(report.getApplicationId());
            if (rmApp == null) continue;
            ((RMAppImpl)rmApp).aggregateLogReport(this.nodeId, report);
        }
    }

    @Override
    public List<Container> pullNewlyIncreasedContainers() {
        try {
            this.writeLock.lock();
            if (this.nmReportedIncreasedContainers.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<Container> container = new ArrayList<Container>(this.nmReportedIncreasedContainers.values());
            this.nmReportedIncreasedContainers.clear();
            ArrayList<Container> arrayList = container;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Resource getOriginalTotalCapability() {
        return this.originalTotalCapability;
    }

    @Override
    public long getUntrackedTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setUntrackedTimeStamp(long ts) {
        this.timeStamp = ts;
    }

    public boolean getNextHeartbeat() {
        return this.nextHeartBeat;
    }

    @Override
    public Map<ApplicationId, UpdatedCryptoForApp> getAppX509ToUpdate() {
        return this.appX509ToUpdate;
    }

    @Override
    public Map<ApplicationId, UpdatedCryptoForApp> getAppJWTToUpdate() {
        return this.appJWTToUpdate;
    }

    public static class SignalContainerTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.signalContainerInt(rmNode, event);
        }
    }

    public static class StatusUpdateWhenUnHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, NodeState> {
        public NodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            return rmNode.statusUpdateWhenUnHealthyTransitionInternal(rmNode, event);
        }
    }

    public static class StatusUpdateWhenHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, NodeState> {
        public NodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            return rmNode.statusUpdateWhenHealthyTransitionInternal(rmNode, event);
        }
    }

    public static class RecommissionNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        private final NodeState finalState;

        public RecommissionNodeTransition(NodeState finalState) {
            this.finalState = finalState;
        }

        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            if (rmNode.originalTotalCapability != null) {
                rmNode.totalCapability = rmNode.originalTotalCapability;
                rmNode.originalTotalCapability = null;
            }
            LOG.info((Object)("Node " + rmNode.nodeId + " in DECOMMISSIONING is recommissioned back to RUNNING."));
            rmNode.updateMetricsForGracefulDecommission(rmNode.getState(), this.finalState);
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeResourceUpdateSchedulerEvent(rmNode, ResourceOption.newInstance((Resource)rmNode.totalCapability, (int)0)));
        }
    }

    public static class DecommissioningNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        private final NodeState initState;
        private final NodeState finalState;

        public DecommissioningNodeTransition(NodeState initState, NodeState finalState) {
            this.initState = initState;
            this.finalState = finalState;
        }

        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            LOG.info((Object)("Put Node " + rmNode.nodeId + " in DECOMMISSIONING."));
            rmNode.updateMetricsForGracefulDecommission(this.initState, this.finalState);
            if (rmNode.originalTotalCapability == null) {
                rmNode.originalTotalCapability = Resources.clone((Resource)rmNode.totalCapability);
                LOG.info((Object)("Preserve original total capability: " + rmNode.originalTotalCapability));
            }
        }
    }

    public static class DeactivateNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        private final NodeState finalState;

        public DeactivateNodeTransition(NodeState finalState) {
            this.finalState = finalState;
        }

        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.deactivateNode(rmNode, this.finalState);
        }
    }

    public static class DecreaseContainersTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeDecreaseContainerEvent de = (RMNodeDecreaseContainerEvent)event;
            rmNode.decreaseContainersInt(rmNode, de);
        }
    }

    public static class AddContainersToBeRemovedFromNMTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.containersToBeRemovedFromNM.addAll(((RMNodeFinishedContainersPulledByAMEvent)event).getContainers());
        }
    }

    public static class CleanUpContainerTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.cleanUpContainerTransitionInternal(rmNode, event);
        }
    }

    public static class CleanUpAppTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.cleanUpAppTransitionInternal(rmNode, event);
        }
    }

    public static class UpdateCryptoMaterialForAppTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent rmNodeEvent) {
            RMAppSecurityManager.SecurityManagerMaterial updatedMaterial;
            RMNodeUpdateCryptoMaterialForAppEvent updateEvent = (RMNodeUpdateCryptoMaterialForAppEvent)rmNodeEvent;
            LOG.info((Object)("Node " + rmNode.toString() + " received UPDATE_CRYPTO_MATERIAL event for app " + ((RMAppSecurityManager.SecurityManagerMaterial)updateEvent.getSecurityMaterial()).getApplicationId()));
            UpdatedCryptoForApp updatedCrypto = (UpdatedCryptoForApp)recordFactory.newRecordInstance(UpdatedCryptoForApp.class);
            if (updateEvent.getSecurityMaterial() instanceof X509SecurityHandler.X509SecurityManagerMaterial) {
                updatedMaterial = (X509SecurityHandler.X509SecurityManagerMaterial)updateEvent.getSecurityMaterial();
                ByteBuffer keyStore = ByteBuffer.wrap(((X509SecurityHandler.X509SecurityManagerMaterial)updatedMaterial).getKeyStore());
                ByteBuffer trustStore = ByteBuffer.wrap(((X509SecurityHandler.X509SecurityManagerMaterial)updatedMaterial).getTrustStore());
                updatedCrypto.setKeyStore(keyStore);
                updatedCrypto.setKeyStorePassword(((X509SecurityHandler.X509SecurityManagerMaterial)updatedMaterial).getKeyStorePassword());
                updatedCrypto.setTrustStore(trustStore);
                updatedCrypto.setTrustStorePassword(((X509SecurityHandler.X509SecurityManagerMaterial)updatedMaterial).getTrustStorePassword());
                updatedCrypto.setVersion(((X509SecurityHandler.X509SecurityManagerMaterial)updatedMaterial).getCryptoMaterialVersion().intValue());
                rmNode.appX509ToUpdate.put(((RMAppSecurityManager.SecurityManagerMaterial)updateEvent.getSecurityMaterial()).getApplicationId(), updatedCrypto);
            }
            if (updateEvent.getSecurityMaterial() instanceof JWTSecurityHandler.JWTSecurityManagerMaterial) {
                updatedMaterial = (JWTSecurityHandler.JWTSecurityManagerMaterial)updateEvent.getSecurityMaterial();
                updatedCrypto.setJWT(((JWTSecurityHandler.JWTSecurityManagerMaterial)updatedMaterial).getToken());
                updatedCrypto.setJWTExpiration(DateUtils.localDateTime2UnixEpoch((LocalDateTime)((JWTSecurityHandler.JWTSecurityManagerMaterial)updatedMaterial).getExpirationDate()));
                rmNode.appJWTToUpdate.put(((RMAppSecurityManager.SecurityManagerMaterial)updateEvent.getSecurityMaterial()).getApplicationId(), updatedCrypto);
            }
        }
    }

    public static class UpdateNodeResourceWhenUnusableTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            LOG.warn((Object)("Try to update resource on a " + rmNode.getState().toString() + " node: " + rmNode.toString()));
            RMNodeImpl.updateNodeResourceFromEvent(rmNode, (RMNodeResourceUpdateEvent)event);
        }
    }

    public static class UpdateNodeResourceWhenRunningTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeResourceUpdateEvent updateEvent = (RMNodeResourceUpdateEvent)event;
            RMNodeImpl.updateNodeResourceFromEvent(rmNode, updateEvent);
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeResourceUpdateSchedulerEvent(rmNode, updateEvent.getResourceOption()));
        }
    }

    public static class ReconnectNodeTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, NodeState> {
        public NodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            return rmNode.reconnectNodeTransitionInternal(rmNode, event);
        }
    }

    public static class AddNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.addNodeTransitionInternal(rmNode, event);
        }
    }
}

