/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;

public final class RMAppSecurityActionsFactory {
    private static volatile RMAppSecurityActionsFactory _INSTANCE;
    private RMAppSecurityActions actor = null;

    private RMAppSecurityActionsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RMAppSecurityActionsFactory getInstance() {
        if (_INSTANCE != null) return _INSTANCE;
        Class<RMAppSecurityActionsFactory> clazz = RMAppSecurityActionsFactory.class;
        synchronized (RMAppSecurityActionsFactory.class) {
            if (_INSTANCE != null) return _INSTANCE;
            _INSTANCE = new RMAppSecurityActionsFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _INSTANCE;
        }
    }

    public synchronized RMAppSecurityActions getActor(Configuration conf) throws Exception {
        if (this.actor != null) {
            return this.actor;
        }
        String actorClass = conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, YarnConfiguration.HOPS_RM_SECURITY_ACTOR_DEFAULT);
        Class clazz = conf.getClassByName(actorClass);
        this.actor = (RMAppSecurityActions)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        this.actor.init();
        return this.actor;
    }

    @VisibleForTesting
    public void clear() {
        if (this.actor != null) {
            this.actor.destroy();
        }
        this.actor = null;
    }

    @VisibleForTesting
    public void register(RMAppSecurityActions actor) {
        this.actor = actor;
    }
}

