/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.metadata.yarn.entity.ContainerToSignal;
import io.hops.metadata.yarn.entity.NextHeartbeat;
import io.hops.metadata.yarn.entity.RMNodeApplication;
import io.hops.streaming.ContainerIdToCleanEvent;
import io.hops.streaming.ContainerToDecreaseEvent;
import io.hops.streaming.ContainerToSignalEvent;
import io.hops.streaming.DBEvent;
import io.hops.streaming.NextHeartBeatEvent;
import io.hops.streaming.RMNodeApplicationsEvent;
import io.hops.util.StreamingReceiver;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImplDist;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class RtStreamingProcessor
extends StreamingReceiver {
    public RtStreamingProcessor(RMContext rmContext) {
        super(rmContext, "RT Event retriever");
        this.setRetrievingRunnable(new RetrievingThread());
    }

    private class RetrievingThread
    implements Runnable {
        private RetrievingThread() {
        }

        @Override
        public void run() {
            while (RtStreamingProcessor.this.running) {
                if (RtStreamingProcessor.this.rmContext.isLeader()) continue;
                try {
                    RMNode node;
                    DBEvent event = DBEvent.receivedEvents.take();
                    if (event instanceof ContainerIdToCleanEvent) {
                        io.hops.metadata.yarn.entity.ContainerId containerId = ((ContainerIdToCleanEvent)event).getContainerId();
                        node = (RMNode)RtStreamingProcessor.this.rmContext.getRMNodes().get(ConverterUtils.toNodeId((String)containerId.getRmnodeid()));
                        ((RMNodeImplDist)node).addContainersToCleanUp(ConverterUtils.toContainerId((String)containerId.getContainerId()));
                        continue;
                    }
                    if (event instanceof ContainerToSignalEvent) {
                        ContainerToSignal containerToSignal = ((ContainerToSignalEvent)event).getContainerToSignal();
                        node = (RMNode)RtStreamingProcessor.this.rmContext.getRMNodes().get(NodeId.fromString((String)containerToSignal.getRmnodeid()));
                        ((RMNodeImplDist)node).addContainersToSignal(SignalContainerRequest.newInstance((ContainerId)ContainerId.fromString((String)containerToSignal.getContainerId()), (SignalContainerCommand)SignalContainerCommand.valueOf((String)containerToSignal.getCommand())));
                        continue;
                    }
                    if (event instanceof ContainerToDecreaseEvent) {
                        io.hops.metadata.yarn.entity.Container container = ((ContainerToDecreaseEvent)event).getContainer();
                        node = (RMNode)RtStreamingProcessor.this.rmContext.getRMNodes().get(NodeId.fromString((String)container.getNodeId()));
                        ((RMNodeImplDist)node).addContainersToDecrease(Container.newInstance((ContainerId)ContainerId.fromString((String)container.getContainerId()), (NodeId)NodeId.fromString((String)container.getNodeId()), (String)container.getHttpAddress(), (Resource)Resource.newInstance((long)container.getMemSize(), (int)container.getVirtualCores(), (int)container.getGpus()), (Priority)Priority.newInstance((int)container.getPriority()), null));
                        continue;
                    }
                    if (event instanceof NextHeartBeatEvent) {
                        NextHeartbeat nextHB = ((NextHeartBeatEvent)event).getNextHeartbeat();
                        node = (RMNode)RtStreamingProcessor.this.rmContext.getRMNodes().get(ConverterUtils.toNodeId((String)nextHB.getRmnodeid()));
                        if (node == null) continue;
                        ((RMNodeImplDist)node).setNextHeartbeat(nextHB.isNextheartbeat());
                        continue;
                    }
                    if (!(event instanceof RMNodeApplicationsEvent)) continue;
                    RMNodeApplication rmNodeApp = ((RMNodeApplicationsEvent)event).getRmNodeApplication();
                    node = (RMNode)RtStreamingProcessor.this.rmContext.getRMNodes().get(NodeId.fromString((String)rmNodeApp.getRMNodeID()));
                    if (rmNodeApp.getStatus().equals((Object)RMNodeApplication.RMNodeApplicationStatus.FINISHED)) {
                        ((RMNodeImplDist)node).addAppToCleanUp(ApplicationId.fromString((String)rmNodeApp.getApplicationId()));
                        continue;
                    }
                    if (!rmNodeApp.getStatus().equals((Object)RMNodeApplication.RMNodeApplicationStatus.RUNNING)) continue;
                    ((RMNodeImplDist)node).addToRunningApps(ApplicationId.fromString((String)rmNodeApp.getApplicationId()));
                }
                catch (InterruptedException ex) {
                    RtStreamingProcessor.this.LOG.error((Object)ex, (Throwable)ex);
                }
            }
            RtStreamingProcessor.this.LOG.info((Object)"HOP :: RT Event retriever interrupted");
        }
    }
}

