/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.exception.StorageException;
import io.hops.metadata.yarn.dal.ContainerStatusDataAccess;
import io.hops.metadata.yarn.dal.NextHeartbeatDataAccess;
import io.hops.metadata.yarn.dal.PendingEventDataAccess;
import io.hops.metadata.yarn.dal.RMNodeDataAccess;
import io.hops.metadata.yarn.dal.ResourceDataAccess;
import io.hops.metadata.yarn.dal.UpdatedContainerInfoDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.metadata.yarn.entity.NextHeartbeat;
import io.hops.metadata.yarn.entity.PendingEvent;
import io.hops.metadata.yarn.entity.RMNode;
import io.hops.metadata.yarn.entity.Resource;
import io.hops.transaction.handler.AsyncLightWeightRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.RMStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;

public class ToCommitHB {
    private static final Log LOG = LogFactory.getLog(ToCommitHB.class);
    private static AtomicInteger nextPendingEventId = new AtomicInteger(0);
    final String nodeId;
    PendingEvent.Type pendingEventType = null;
    PendingEvent.Status pendingEventStatus;
    int pendingEventContains = 0;
    final List<io.hops.metadata.yarn.entity.UpdatedContainerInfo> uciToAdd = new ArrayList<io.hops.metadata.yarn.entity.UpdatedContainerInfo>();
    final List<io.hops.metadata.yarn.entity.ContainerStatus> containerStatusToAdd = new ArrayList<io.hops.metadata.yarn.entity.ContainerStatus>();
    int uciID;
    int pendingEventId;
    RMNode rmNode = null;
    Resource rmNodeResource = null;
    NextHeartbeat nextHeartBeat = null;

    public ToCommitHB(String nodeId) {
        this.nodeId = nodeId;
        this.pendingEventId = nextPendingEventId.incrementAndGet();
    }

    public void addPendingEvent(PendingEvent.Type pendingEventType, PendingEvent.Status pendingEventStatus) {
        this.pendingEventStatus = pendingEventStatus;
        this.pendingEventType = pendingEventType;
        ++this.pendingEventContains;
    }

    public void addNodeUpdateQueue(UpdatedContainerInfo uci) {
        io.hops.metadata.yarn.entity.ContainerStatus hopConStatus;
        io.hops.metadata.yarn.entity.UpdatedContainerInfo hopUCI;
        this.uciID = uci.getUciId();
        if (uci.getNewlyLaunchedContainers() != null && !uci.getNewlyLaunchedContainers().isEmpty()) {
            for (ContainerStatus containerStatus : uci.getNewlyLaunchedContainers()) {
                hopUCI = new io.hops.metadata.yarn.entity.UpdatedContainerInfo(this.nodeId, containerStatus.getContainerId().toString(), this.uciID, this.pendingEventId);
                this.uciToAdd.add(hopUCI);
                ++this.pendingEventContains;
                hopConStatus = new io.hops.metadata.yarn.entity.ContainerStatus(containerStatus.getContainerId().toString(), containerStatus.getState().toString(), containerStatus.getDiagnostics(), containerStatus.getExitStatus(), this.nodeId, this.pendingEventId, this.uciID);
                this.containerStatusToAdd.add(hopConStatus);
                ++this.pendingEventContains;
            }
        }
        if (uci.getCompletedContainers() != null && !uci.getCompletedContainers().isEmpty()) {
            for (ContainerStatus containerStatus : uci.getCompletedContainers()) {
                hopUCI = new io.hops.metadata.yarn.entity.UpdatedContainerInfo(this.nodeId, containerStatus.getContainerId().toString(), this.uciID, this.pendingEventId);
                this.uciToAdd.add(hopUCI);
                ++this.pendingEventContains;
                hopConStatus = new io.hops.metadata.yarn.entity.ContainerStatus(containerStatus.getContainerId().toString(), containerStatus.getState().toString(), containerStatus.getDiagnostics(), containerStatus.getExitStatus(), this.nodeId, this.pendingEventId, this.uciID);
                this.containerStatusToAdd.add(hopConStatus);
                ++this.pendingEventContains;
            }
        }
    }

    public void addRMNode(String hostName, int commandPort, int httpPort, org.apache.hadoop.yarn.api.records.Resource totalCapability, String nodeManagerVersion, NodeState currentState, String healthReport, long lastHealthReportTime) {
        this.rmNode = new RMNode(this.nodeId, hostName, commandPort, httpPort, healthReport, lastHealthReportTime, currentState.name(), nodeManagerVersion, this.pendingEventId);
        ++this.pendingEventContains;
        this.rmNodeResource = new Resource(this.nodeId, totalCapability.getMemory(), totalCapability.getVirtualCores(), totalCapability.getGPUs(), this.pendingEventId);
        ++this.pendingEventContains;
    }

    public void addNextHeartBeat(boolean nextHeartBeat) {
        this.nextHeartBeat = new NextHeartbeat(this.nodeId, nextHeartBeat);
    }

    public void commit() throws IOException {
        if (this.pendingEventType == null) {
            return;
        }
        final PendingEvent pendingEvent = new PendingEvent(this.nodeId, this.pendingEventType, this.pendingEventStatus, this.pendingEventId, this.pendingEventContains);
        Object handler = null;
        handler = pendingEvent.getType().equals((Object)PendingEvent.Type.NODE_ADDED) ? new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ToCommitHB.this.persistHeartbeat(pendingEvent);
                connector.commit();
                return null;
            }
        } : new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ToCommitHB.this.persistHeartbeat(pendingEvent);
                connector.commit();
                return null;
            }
        };
        handler.handle();
    }

    private void persistHeartbeat(PendingEvent pendingEvent) throws StorageException {
        PendingEventDataAccess peDA = (PendingEventDataAccess)RMStorageFactory.getDataAccess(PendingEventDataAccess.class);
        NextHeartbeatDataAccess nextHBDA = (NextHeartbeatDataAccess)RMStorageFactory.getDataAccess(NextHeartbeatDataAccess.class);
        UpdatedContainerInfoDataAccess uciDA = (UpdatedContainerInfoDataAccess)RMStorageFactory.getDataAccess(UpdatedContainerInfoDataAccess.class);
        ContainerStatusDataAccess contStatDA = (ContainerStatusDataAccess)RMStorageFactory.getDataAccess(ContainerStatusDataAccess.class);
        RMNodeDataAccess rmNodeDA = (RMNodeDataAccess)RMStorageFactory.getDataAccess(RMNodeDataAccess.class);
        ResourceDataAccess resourceDA = (ResourceDataAccess)RMStorageFactory.getDataAccess(ResourceDataAccess.class);
        peDA.add((Object)pendingEvent);
        if (pendingEvent.getType().equals((Object)PendingEvent.Type.NODE_ADDED)) {
            nextHBDA.update(new NextHeartbeat(this.nodeId, true));
        }
        if (!this.uciToAdd.isEmpty()) {
            uciDA.addAll(this.uciToAdd);
            contStatDA.addAll(this.containerStatusToAdd);
        }
        if (this.rmNode != null) {
            rmNodeDA.add((Object)this.rmNode);
            resourceDA.add((Object)this.rmNodeResource);
        }
        if (this.nextHeartBeat != null) {
            nextHBDA.update(this.nextHeartBeat);
        }
    }
}

