/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class FifoScheduler
extends AbstractYarnScheduler<FiCaSchedulerApp, FiCaSchedulerNode>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(FifoScheduler.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    Configuration conf;
    private boolean usePortForNodeName;
    private ActiveUsersManager activeUsersManager;
    private static final String DEFAULT_QUEUE_NAME = "default";
    private QueueMetrics metrics;
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    private final Queue DEFAULT_QUEUE = new Queue(){

        @Override
        public String getQueueName() {
            return FifoScheduler.DEFAULT_QUEUE_NAME;
        }

        @Override
        public QueueMetrics getMetrics() {
            return FifoScheduler.this.metrics;
        }

        @Override
        public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
            QueueInfo queueInfo = (QueueInfo)recordFactory.newRecordInstance(QueueInfo.class);
            queueInfo.setQueueName(FifoScheduler.this.DEFAULT_QUEUE.getQueueName());
            queueInfo.setCapacity(1.0f);
            if (FifoScheduler.this.clusterResource.getMemorySize() == 0L) {
                queueInfo.setCurrentCapacity(0.0f);
            } else {
                queueInfo.setCurrentCapacity((float)FifoScheduler.this.usedResource.getMemorySize() / (float)FifoScheduler.this.clusterResource.getMemorySize());
            }
            queueInfo.setMaximumCapacity(1.0f);
            queueInfo.setChildQueues(new ArrayList());
            queueInfo.setQueueState(QueueState.RUNNING);
            return queueInfo;
        }

        public Map<QueueACL, AccessControlList> getQueueAcls() {
            HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
            for (QueueACL acl : QueueACL.values()) {
                acls.put(acl, new AccessControlList("*"));
            }
            return acls;
        }

        @Override
        public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation unused) {
            QueueUserACLInfo queueUserAclInfo = (QueueUserACLInfo)recordFactory.newRecordInstance(QueueUserACLInfo.class);
            queueUserAclInfo.setQueueName(FifoScheduler.DEFAULT_QUEUE_NAME);
            queueUserAclInfo.setUserAcls(Arrays.asList(QueueACL.values()));
            return Collections.singletonList(queueUserAclInfo);
        }

        @Override
        public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
            return this.getQueueAcls().get(acl).isUserAllowed(user);
        }

        @Override
        public ActiveUsersManager getActiveUsersManager() {
            return FifoScheduler.this.activeUsersManager;
        }

        @Override
        public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt schedulerAttempt, RMContainer rmContainer) {
            if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
                return;
            }
            FifoScheduler.this.increaseUsedResources(rmContainer);
            FifoScheduler.this.updateAppHeadRoom(schedulerAttempt);
            FifoScheduler.this.updateAvailableResourcesMetrics();
        }

        @Override
        public Set<String> getAccessibleNodeLabels() {
            return null;
        }

        @Override
        public String getDefaultNodeLabelExpression() {
            return null;
        }

        @Override
        public void incPendingResource(String nodeLabel, Resource resourceToInc) {
        }

        @Override
        public void decPendingResource(String nodeLabel, Resource resourceToDec) {
        }

        @Override
        public Priority getDefaultApplicationPriority() {
            return null;
        }

        @Override
        public void incReservedResource(String partition, Resource reservedRes) {
        }

        @Override
        public void decReservedResource(String partition, Resource reservedRes) {
        }
    };
    private Resource usedResource = (Resource)recordFactory.newRecordInstance(Resource.class);

    public FifoScheduler() {
        super(FifoScheduler.class.getName());
    }

    private synchronized void initScheduler(Configuration conf) {
        this.validateConf(conf);
        this.applications = new ConcurrentSkipListMap();
        this.minimumAllocation = Resources.createResource((int)conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024));
        this.initMaximumResourceCapability(Resources.createResource((int)conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192), (int)conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4)));
        this.usePortForNodeName = conf.getBoolean("yarn.scheduler.include-port-in-node-name", false);
        this.metrics = QueueMetrics.forQueue(DEFAULT_QUEUE_NAME, null, false, conf);
        this.activeUsersManager = new ActiveUsersManager(this.metrics);
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        this.initScheduler(conf);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        super.serviceStop();
    }

    public synchronized void setConf(Configuration conf) {
        this.conf = conf;
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem <= 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min and max should be greater than 0, max should be no smaller than min.");
        }
    }

    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodes.size();
    }

    @Override
    public synchronized void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    @Override
    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        this.setConf(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals, List<UpdateContainerRequest> increaseRequests, List<UpdateContainerRequest> decreaseRequests) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getApplicationAttempt(applicationAttemptId);
        if (application == null) {
            LOG.error((Object)("Calling allocate on removed or non existant application " + applicationAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, this.resourceCalculator, this.clusterResource, this.minimumAllocation, this.getMaximumResourceCapability());
        this.releaseContainers(release, application);
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            if (application.isStopped()) {
                LOG.info((Object)("Calling allocate on a stopped application " + applicationAttemptId));
                return EMPTY_ALLOCATION;
            }
            if (!ask.isEmpty()) {
                LOG.debug((Object)("allocate: pre-update applicationId=" + applicationAttemptId + " application=" + application));
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)("allocate: post-update applicationId=" + applicationAttemptId + " application=" + application));
                application.showRequests();
                LOG.debug((Object)("allocate: applicationId=" + applicationAttemptId + " #ask=" + ask.size()));
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            Resource headroom = application.getHeadroom();
            application.setApplicationHeadroomForMetrics(headroom);
            return new Allocation(application.pullNewlyAllocatedContainers(), headroom, null, null, null, application.pullUpdatedNMTokens());
        }
    }

    private FiCaSchedulerNode getNode(NodeId nodeId) {
        return (FiCaSchedulerNode)this.nodes.get(nodeId);
    }

    @VisibleForTesting
    public synchronized void addApplication(ApplicationId applicationId, String queue, String user, boolean isAppRecovering) {
        SchedulerApplication application = new SchedulerApplication(this.DEFAULT_QUEUE, user);
        this.applications.put(applicationId, application);
        this.metrics.submitApp(user);
        LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", currently num of applications: " + this.applications.size()));
        if (isAppRecovering) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(applicationId + " is recovering. Skip notifying APP_ACCEPTED"));
            }
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
        }
    }

    @VisibleForTesting
    public synchronized void addApplicationAttempt(ApplicationAttemptId appAttemptId, boolean transferStateFromPreviousAttempt, boolean isAttemptRecovering) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(appAttemptId.getApplicationId());
        String user = application.getUser();
        FiCaSchedulerApp schedulerApp = new FiCaSchedulerApp(appAttemptId, user, this.DEFAULT_QUEUE, this.activeUsersManager, this.rmContext);
        if (transferStateFromPreviousAttempt) {
            schedulerApp.transferStateFromPreviousAttempt((SchedulerApplicationAttempt)application.getCurrentAppAttempt());
        }
        application.setCurrentAppAttempt(schedulerApp);
        this.metrics.submitAppAttempt(user);
        LOG.info((Object)("Added Application Attempt " + appAttemptId + " to scheduler from user " + application.getUser()));
        if (isAttemptRecovering) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(appAttemptId + " is recovering. Skipping notifying ATTEMPT_ADDED"));
            }
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
        }
    }

    private synchronized void doneApplication(ApplicationId applicationId, RMAppState finalState) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
        if (application == null) {
            LOG.warn((Object)("Couldn't find application " + applicationId));
            return;
        }
        this.activeUsersManager.deactivateApplication(application.getUser(), applicationId);
        application.stop(finalState);
        this.applications.remove(applicationId);
    }

    private synchronized void doneApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) throws IOException {
        FiCaSchedulerApp attempt = (FiCaSchedulerApp)this.getApplicationAttempt(applicationAttemptId);
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        if (application == null || attempt == null) {
            throw new IOException("Unknown application " + applicationAttemptId + " has completed!");
        }
        for (RMContainer container : attempt.getLiveContainers()) {
            if (keepContainers && container.getState().equals((Object)RMContainerState.RUNNING)) {
                LOG.info((Object)("Skip killing " + container.getContainerId()));
                continue;
            }
            super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        attempt.stop(rmAppAttemptFinalState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignContainers(FiCaSchedulerNode node) {
        LOG.debug((Object)("assignContainers: node=" + node.getRMNode().getNodeAddress() + " #applications=" + this.applications.size()));
        for (Map.Entry e : this.applications.entrySet()) {
            FiCaSchedulerApp application = (FiCaSchedulerApp)((SchedulerApplication)e.getValue()).getCurrentAppAttempt();
            if (application == null) continue;
            LOG.debug((Object)"pre-assignContainers");
            application.showRequests();
            FiCaSchedulerApp fiCaSchedulerApp = application;
            synchronized (fiCaSchedulerApp) {
                int assignedContainers;
                Priority priority;
                int maxContainers;
                if (SchedulerAppUtils.isPlaceBlacklisted(application, node, LOG)) {
                    continue;
                }
                Iterator<Priority> iterator = application.getPriorities().iterator();
                while (iterator.hasNext() && ((maxContainers = this.getMaxAllocatableContainers(application, priority = iterator.next(), node, NodeType.OFF_SWITCH)) <= 0 || (assignedContainers = this.assignContainersOnNode(node, application, priority)) != 0)) {
                }
            }
            LOG.debug((Object)"post-assignContainers");
            application.showRequests();
            if (!Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)node.getAvailableResource(), (Resource)this.minimumAllocation)) continue;
            break;
        }
        for (SchedulerApplication application : this.applications.values()) {
            FiCaSchedulerApp attempt = (FiCaSchedulerApp)application.getCurrentAppAttempt();
            if (attempt == null) continue;
            this.updateAppHeadRoom(attempt);
        }
    }

    private int getMaxAllocatableContainers(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, NodeType type) {
        ResourceRequest nodeLocalRequest;
        int maxContainers = 0;
        ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
        if (offSwitchRequest != null) {
            maxContainers = offSwitchRequest.getNumContainers();
        }
        if (type == NodeType.OFF_SWITCH) {
            return maxContainers;
        }
        if (type == NodeType.RACK_LOCAL) {
            ResourceRequest rackLocalRequest = application.getResourceRequest(priority, node.getRMNode().getRackName());
            if (rackLocalRequest == null) {
                return maxContainers;
            }
            maxContainers = Math.min(maxContainers, rackLocalRequest.getNumContainers());
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = application.getResourceRequest(priority, node.getRMNode().getNodeAddress())) != null) {
            maxContainers = Math.min(maxContainers, nodeLocalRequest.getNumContainers());
        }
        return maxContainers;
    }

    private int assignContainersOnNode(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int nodeLocalContainers = this.assignNodeLocalContainers(node, application, priority);
        int rackLocalContainers = this.assignRackLocalContainers(node, application, priority);
        int offSwitchContainers = this.assignOffSwitchContainers(node, application, priority);
        LOG.debug((Object)("assignContainersOnNode: node=" + node.getRMNode().getNodeAddress() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " #assigned=" + (nodeLocalContainers + rackLocalContainers + offSwitchContainers)));
        return nodeLocalContainers + rackLocalContainers + offSwitchContainers;
    }

    private int assignNodeLocalContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, node.getNodeName());
        if (request != null) {
            ResourceRequest rackRequest = application.getResourceRequest(priority, node.getRMNode().getRackName());
            if (rackRequest == null || rackRequest.getNumContainers() <= 0) {
                return 0;
            }
            int assignableContainers = Math.min(this.getMaxAllocatableContainers(application, priority, node, NodeType.NODE_LOCAL), request.getNumContainers());
            assignedContainers = this.assignContainer(node, application, priority, assignableContainers, request, NodeType.NODE_LOCAL);
        }
        return assignedContainers;
    }

    private int assignRackLocalContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, node.getRMNode().getRackName());
        if (request != null) {
            ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
            if (offSwitchRequest.getNumContainers() <= 0) {
                return 0;
            }
            int assignableContainers = Math.min(this.getMaxAllocatableContainers(application, priority, node, NodeType.RACK_LOCAL), request.getNumContainers());
            assignedContainers = this.assignContainer(node, application, priority, assignableContainers, request, NodeType.RACK_LOCAL);
        }
        return assignedContainers;
    }

    private int assignOffSwitchContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, "*");
        if (request != null) {
            assignedContainers = this.assignContainer(node, application, priority, request.getNumContainers(), request, NodeType.OFF_SWITCH);
        }
        return assignedContainers;
    }

    private int assignContainer(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, int assignableContainers, ResourceRequest request, NodeType type) {
        LOG.debug((Object)("assignContainers: node=" + node.getRMNode().getNodeAddress() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " assignableContainers=" + assignableContainers + " request=" + request + " type=" + (Object)((Object)type)));
        Resource capability = request.getCapability();
        int availableContainers = (int)(node.getAvailableResource().getMemorySize() / capability.getMemorySize());
        int assignedContainers = Math.min(assignableContainers, availableContainers);
        if (assignedContainers > 0) {
            for (int i = 0; i < assignedContainers; ++i) {
                NodeId nodeId = node.getRMNode().getNodeID();
                ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (long)application.getNewContainerId());
                Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, null);
                RMContainer rmContainer = application.allocate(type, node, priority, request, container);
                node.allocateContainer(rmContainer);
                this.increaseUsedResources(rmContainer);
            }
        }
        return assignedContainers;
    }

    private synchronized void nodeUpdate(RMNode rmNode) {
        FiCaSchedulerNode node = this.getNode(rmNode.getNodeID());
        List<UpdatedContainerInfo> containerInfoList = rmNode.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            super.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
            node.releaseContainer(containerId, true);
        }
        node.setAggregatedContainersUtilization(rmNode.getAggregatedContainersUtilization());
        node.setNodeUtilization(rmNode.getNodeUtilization());
        if (rmNode.getState() == NodeState.DECOMMISSIONING) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeResourceUpdateEvent(rmNode.getNodeID(), ResourceOption.newInstance((Resource)this.getSchedulerNode(rmNode.getNodeID()).getUsedResource(), (int)0)));
        }
        if (this.rmContext.isWorkPreservingRecoveryEnabled() && !this.rmContext.isSchedulerReadyForAllocatingContainers()) {
            return;
        }
        if (Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)node.getAvailableResource(), (Resource)this.minimumAllocation)) {
            LOG.debug((Object)("Node heartbeat " + rmNode.getNodeID() + " available resource = " + node.getAvailableResource()));
            this.assignContainers(node);
            LOG.debug((Object)("Node after allocation " + rmNode.getNodeID() + " resource = " + node.getAvailableResource()));
        }
        this.updateAvailableResourcesMetrics();
    }

    private void increaseUsedResources(RMContainer rmContainer) {
        Resources.addTo((Resource)this.usedResource, (Resource)rmContainer.getAllocatedResource());
    }

    private void updateAppHeadRoom(SchedulerApplicationAttempt schedulerAttempt) {
        schedulerAttempt.setHeadroom(Resources.subtract((Resource)this.clusterResource, (Resource)this.usedResource));
    }

    private void updateAvailableResourcesMetrics() {
        this.metrics.setAvailableResourcesToQueue(Resources.subtract((Resource)this.clusterResource, (Resource)this.usedResource));
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                this.recoverContainersOnNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_RESOURCE_UPDATE: {
                NodeResourceUpdateSchedulerEvent nodeResourceUpdatedEvent = (NodeResourceUpdateSchedulerEvent)event;
                this.updateNodeResource(nodeResourceUpdatedEvent.getRMNode(), nodeResourceUpdatedEvent.getResourceOption());
                break;
            }
            case NODE_UPDATE: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                this.addApplication(appAddedEvent.getApplicationId(), appAddedEvent.getQueue(), appAddedEvent.getUser(), appAddedEvent.getIsAppRecovering());
                break;
            }
            case APP_REMOVED: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.doneApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getIsAttemptRecovering());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                try {
                    this.doneApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                }
                catch (IOException ie) {
                    LOG.error((Object)("Unable to remove application " + appAttemptRemovedEvent.getApplicationAttemptID()), (Throwable)ie);
                }
                break;
            }
            case CONTAINER_EXPIRED: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerid = containerExpiredEvent.getContainerId();
                super.completedContainer(this.getRMContainer(containerid), SchedulerUtils.createAbnormalContainerStatus(containerid, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    @Override
    @Lock(value={FifoScheduler.class})
    protected synchronized void completedContainerInternal(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = container.getId().getApplicationAttemptId().getApplicationId();
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        if (application == null) {
            LOG.info((Object)("Unknown application: " + appId + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
            return;
        }
        application.containerCompleted(rmContainer, containerStatus, event, "");
        node.releaseContainer(rmContainer.getContainerId(), false);
        Resources.subtractFrom((Resource)this.usedResource, (Resource)container.getResource());
        LOG.info((Object)("Application attempt " + application.getApplicationAttemptId() + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    private synchronized void removeNode(RMNode nodeInfo) {
        FiCaSchedulerNode node = this.getNode(nodeInfo.getNodeID());
        if (node == null) {
            return;
        }
        for (RMContainer container : node.getCopiedListOfRunningContainers()) {
            super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(nodeInfo.getNodeID());
        this.updateMaximumAllocation(node, false);
        Resources.subtractFrom((Resource)this.clusterResource, (Resource)node.getTotalResource());
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) {
        return this.DEFAULT_QUEUE.getQueueInfo(false, false);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        return this.DEFAULT_QUEUE.getQueueUserAclInfo(null);
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return this.resourceCalculator;
    }

    private synchronized void addNode(RMNode nodeManager) {
        FiCaSchedulerNode schedulerNode = new FiCaSchedulerNode(nodeManager, this.usePortForNodeName);
        this.nodes.put(nodeManager.getNodeID(), schedulerNode);
        Resources.addTo((Resource)this.clusterResource, (Resource)schedulerNode.getTotalResource());
        this.updateMaximumAllocation(schedulerNode, true);
    }

    @Override
    public void recover(RMStateStore.RMState state) {
    }

    @Override
    public RMContainer getRMContainer(ContainerId containerId) {
        FiCaSchedulerApp attempt = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(containerId);
        return attempt == null ? null : attempt.getRMContainer(containerId);
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.DEFAULT_QUEUE.getMetrics();
    }

    @Override
    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        return this.DEFAULT_QUEUE.hasAccess(acl, callerUGI);
    }

    @Override
    public synchronized List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        if (queueName.equals(this.DEFAULT_QUEUE.getQueueName())) {
            ArrayList<ApplicationAttemptId> attempts = new ArrayList<ApplicationAttemptId>(this.applications.size());
            for (SchedulerApplication app : this.applications.values()) {
                attempts.add(((FiCaSchedulerApp)app.getCurrentAppAttempt()).getApplicationAttemptId());
            }
            return attempts;
        }
        return null;
    }

    public Resource getUsedResource() {
        return this.usedResource;
    }

    @Override
    protected void decreaseContainer(SchedContainerChangeRequest decreaseRequest, SchedulerApplicationAttempt attempt) {
    }
}

