/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import io.hops.security.CertificateLocalizationService;
import io.hops.security.HopsSecurityActionsFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppKillByClientEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestRMAppTransitions {
    static final Log LOG = LogFactory.getLog(TestRMAppTransitions.class);
    private boolean isSecurityEnabled;
    private Configuration conf;
    private RMContext rmContext;
    private static int maxAppAttempts = 2;
    private static int appId = 1;
    private DrainDispatcher rmDispatcher;
    private RMStateStore store;
    private RMApplicationHistoryWriter writer;
    private SystemMetricsPublisher publisher;
    private YarnScheduler scheduler;
    private TestSchedulerEventDispatcher schedulerDispatcher;
    private RMAppSecurityManager rmAppSecurityManager;
    private X509SecurityHandler x509SecurityHandler;
    private JWTSecurityHandler jwtSecurityHandler;
    private CertificateLocalizationService certificateLocalizationService;
    private final char[] cryptoPassword = "password".toCharArray();

    @Parameterized.Parameters
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    public TestRMAppTransitions(boolean isSecurityEnabled) {
        this.isSecurityEnabled = isSecurityEnabled;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("ipc.server.ssl.enabled", this.isSecurityEnabled);
        this.conf.setBoolean(YarnConfiguration.RM_JWT_ENABLED, this.isSecurityEnabled);
        this.conf.set(YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD, "1s");
        this.conf.set(YarnConfiguration.RM_JWT_EXPIRATION_LEEWAY, "1s");
        UserGroupInformation.AuthenticationMethod authMethod = UserGroupInformation.AuthenticationMethod.SIMPLE;
        if (this.isSecurityEnabled) {
            authMethod = UserGroupInformation.AuthenticationMethod.KERBEROS;
        }
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)authMethod, (Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.rmDispatcher = new DrainDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        AMLivelinessMonitor amLivelinessMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        AMLivelinessMonitor amFinishingMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        this.store = (RMStateStore)Mockito.mock(RMStateStore.class);
        this.writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        DelegationTokenRenewer renewer = (DelegationTokenRenewer)Mockito.mock(DelegationTokenRenewer.class);
        RMContextImpl realRMContext = new RMContextImpl((Dispatcher)this.rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, renewer, new AMRMTokenSecretManager(this.conf, this.rmContext), new RMContainerTokenSecretManager(this.conf), new NMTokenSecretManagerInRM(this.conf), new ClientToAMTokenSecretManagerInRM());
        realRMContext.setStateStore(this.store);
        this.publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        realRMContext.setSystemMetricsPublisher(this.publisher);
        realRMContext.setRMApplicationHistoryWriter(this.writer);
        this.certificateLocalizationService = new CertificateLocalizationService(CertificateLocalizationService.ServiceType.RM);
        this.certificateLocalizationService.init(this.conf);
        this.certificateLocalizationService.start();
        realRMContext.setCertificateLocalizationService(this.certificateLocalizationService);
        this.rmContext = (RMContext)Mockito.spy((Object)realRMContext);
        ResourceScheduler resourceScheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        ((ResourceScheduler)Mockito.doReturn(null).when((Object)resourceScheduler)).getAppResourceUsageReport((ApplicationAttemptId)Matchers.any());
        ((RMContext)Mockito.doReturn((Object)resourceScheduler).when((Object)this.rmContext)).getScheduler();
        this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new TestApplicationAttemptEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new TestApplicationEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)new TestApplicationManagerEventDispatcher());
        this.schedulerDispatcher = new TestSchedulerEventDispatcher();
        this.rmDispatcher.register(SchedulerEventType.class, (EventHandler)this.schedulerDispatcher);
        HopsSecurityActionsFactory.getInstance().clear();
        this.conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        this.rmAppSecurityManager = (RMAppSecurityManager)Mockito.spy((Object)new RMAppSecurityManager(this.rmContext));
        this.x509SecurityHandler = (X509SecurityHandler)Mockito.spy((Object)new X509SecurityHandler(this.rmContext, this.rmAppSecurityManager));
        this.rmAppSecurityManager.registerRMAppSecurityHandlerWithType((RMAppSecurityHandler)this.x509SecurityHandler, X509SecurityHandler.class);
        this.jwtSecurityHandler = (JWTSecurityHandler)Mockito.spy((Object)new JWTSecurityHandler(this.rmContext, this.rmAppSecurityManager));
        this.rmAppSecurityManager.registerRMAppSecurityHandlerWithType((RMAppSecurityHandler)this.jwtSecurityHandler, JWTSecurityHandler.class);
        this.rmAppSecurityManager.init(this.conf);
        this.rmAppSecurityManager.start();
        this.rmContext.setRMAppSecurityManager(this.rmAppSecurityManager);
        Mockito.when((Object)this.x509SecurityHandler.generateRandomPassword()).thenReturn((Object)this.cryptoPassword);
        ((X509SecurityHandler)Mockito.doReturn((Object)this.loadMockTrustStore()).when((Object)this.x509SecurityHandler)).loadSystemTrustStore((Configuration)Matchers.any(Configuration.class));
        this.rmDispatcher.register(RMAppSecurityManagerEventType.class, (EventHandler)this.rmAppSecurityManager);
        this.rmDispatcher.init(this.conf);
        this.rmDispatcher.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.certificateLocalizationService != null) {
            this.certificateLocalizationService.stop();
        }
        HopsSecurityActionsFactory.getInstance().clear();
    }

    private KeyStore loadMockTrustStore() throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, null);
        return trustStore;
    }

    protected RMApp createNewTestApp(ApplicationSubmissionContext submissionContext) throws IOException {
        ApplicationId applicationId = MockApps.newAppID((int)appId++);
        String user = MockApps.newUserName();
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", maxAppAttempts);
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, this.scheduler);
        if (submissionContext == null) {
            submissionContext = new ApplicationSubmissionContextPBImpl();
        }
        submissionContext.setApplicationId(applicationId);
        RMAppImpl application = new RMAppImpl(applicationId, this.rmContext, this.conf, name, user, queue, submissionContext, this.scheduler, masterService, System.currentTimeMillis(), "YARN", null, (ResourceRequest)Mockito.mock(ResourceRequest.class));
        TestRMAppTransitions.testAppStartState(applicationId, user, name, queue, (RMApp)application);
        this.rmContext.getRMApps().putIfAbsent(application.getApplicationId(), application);
        return application;
    }

    private static void testAppStartState(ApplicationId applicationId, String user, String name, String queue, RMApp application) {
        Assert.assertTrue((String)"application start time is not greater than 0", (application.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application start time is before currentTime", (application.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
        Assert.assertEquals((String)"application user is not correct", (Object)user, (Object)application.getUser());
        Assert.assertEquals((String)"application id is not correct", (Object)applicationId, (Object)application.getApplicationId());
        Assert.assertEquals((String)"application progress is not correct", (float)0.0f, (float)application.getProgress(), (float)0.0f);
        Assert.assertEquals((String)"application queue is not correct", (Object)queue, (Object)application.getQueue());
        Assert.assertEquals((String)"application name is not correct", (Object)name, (Object)application.getName());
        Assert.assertEquals((String)"application finish time is not 0 and should be", (long)0L, (long)application.getFinishTime());
        Assert.assertEquals((String)"application tracking url is not correct", null, (Object)application.getTrackingUrl());
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (long)0L, (long)diag.length());
    }

    private static void assertStartTimeSet(RMApp application) {
        Assert.assertTrue((String)"application start time is not greater than 0", (application.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application start time is before currentTime", (application.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    private static void assertAppState(RMAppState state, RMApp application) {
        Assert.assertEquals((String)("application state should have been " + state), (Object)state, (Object)application.getState());
    }

    private static void assertFinalAppStatus(FinalApplicationStatus status, RMApp application) {
        Assert.assertEquals((String)("Final application status should have been " + status), (Object)status, (Object)application.getFinalApplicationStatus());
    }

    private void assertTimesAtFinish(RMApp application) {
        TestRMAppTransitions.assertStartTimeSet(application);
        Assert.assertTrue((String)"application finish time is not greater than 0", (application.getFinishTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application finish time is not >= start time", (application.getFinishTime() >= application.getStartTime() ? 1 : 0) != 0);
    }

    private void assertAppFinalStateSaved(RMApp application) {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)1))).updateApplicationState((ApplicationStateData)Matchers.any(ApplicationStateData.class));
    }

    private void assertAppFinalStateNotSaved(RMApp application) {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)0))).updateApplicationState((ApplicationStateData)Matchers.any(ApplicationStateData.class));
    }

    private void assertKilled(RMApp application) {
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.KILLED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (Object)"Application killed by user.", (Object)diag.toString());
    }

    private void assertFailed(RMApp application, String regex) {
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertTrue((String)"application diagnostics is not correct", (boolean)diag.toString().matches(regex));
    }

    private void sendAppUpdateSavedEvent(RMApp application) {
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_UPDATE_SAVED);
        application.handle((Event)event);
        this.rmDispatcher.await();
    }

    private void sendAttemptUpdateSavedEvent(RMApp application) {
        application.getCurrentAppAttempt().handle((Event)new RMAppAttemptEvent(application.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptEventType.ATTEMPT_UPDATE_SAVED));
        this.rmDispatcher.await();
    }

    protected RMApp testCreateAppNewSaving(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.createNewTestApp(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.START);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.NEW_SAVING, application);
        ((SystemMetricsPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)0))).appCreated((RMApp)Matchers.eq((Object)application), Matchers.anyLong());
        return application;
    }

    protected RMApp testCreateAppGeneratingCerts(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppNewSaving(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_NEW_SAVED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        return application;
    }

    protected RMApp testCreateAppSubmittedNoRecovery(ApplicationSubmissionContext submissionContext) throws Exception {
        RMApp application = this.testCreateAppGeneratingCerts(submissionContext);
        this.rmDispatcher.await();
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
        TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
        if (this.conf.getBoolean("ipc.server.ssl.enabled", false)) {
            ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).registerRenewer((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
            Assert.assertNotNull((Object)application.getKeyStore());
            Assert.assertNotEquals((long)0L, (long)application.getKeyStore().length);
            Assert.assertNotNull((Object)application.getTrustStore());
            Assert.assertNotEquals((long)0L, (long)application.getTrustStore().length);
            Assert.assertNotNull((Object)application.getKeyStorePassword());
            Assert.assertNotEquals((long)0L, (long)application.getKeyStorePassword().length);
            Assert.assertTrue((boolean)Arrays.equals(this.cryptoPassword, application.getKeyStorePassword()));
            Assert.assertNotNull((Object)application.getTrustStorePassword());
            Assert.assertNotEquals((long)0L, (long)application.getTrustStorePassword().length);
            Assert.assertTrue((boolean)Arrays.equals(this.cryptoPassword, application.getTrustStorePassword()));
            Assert.assertNotEquals((long)-1L, (long)application.getCertificateExpiration());
        }
        if (this.conf.getBoolean(YarnConfiguration.RM_JWT_ENABLED, false)) {
            jwtParam.setExpirationDate(application.getJWTExpiration());
            ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).registerRenewer((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
            Assert.assertNotNull((Object)application.getJWT());
            Assert.assertNotEquals((long)0L, (long)application.getJWT().length());
            Assert.assertNotNull((Object)application.getJWTExpiration());
        }
        ((SystemMetricsPublisher)Mockito.verify((Object)this.publisher)).appCreated((RMApp)Matchers.eq((Object)application), Matchers.anyLong());
        return application;
    }

    protected RMApp testCreateAppSubmittedRecovery(ApplicationSubmissionContext submissionContext, boolean cryptoRecovered) throws Exception {
        RMApp application = this.createNewTestApp(submissionContext);
        RMStateStore.RMState state = new RMStateStore.RMState();
        ApplicationStateData appState = ApplicationStateData.newInstance((long)123L, (long)123L, null, (String)"user", null);
        if (cryptoRecovered) {
            appState.setKeyStore("some_bytes".getBytes());
            appState.setKeyStorePassword(new char[]{'a', 'b', 'c'});
            appState.setTrustStore("some_bytes".getBytes());
            appState.setTrustStorePassword(new char[]{'a', 'b', 'c'});
            appState.setCryptoMaterialVersion(Integer.valueOf(0));
            appState.setCertificateExpiration(System.currentTimeMillis());
            appState.setJWT("jwt_token");
            appState.setJWTExpiration(System.currentTimeMillis());
        }
        state.getApplicationState().put(application.getApplicationId(), appState);
        RMAppRecoverEvent event = new RMAppRecoverEvent(application.getApplicationId(), state);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        if (cryptoRecovered) {
            Integer cryptoMaterialVersionToRevoke = application.getCryptoMaterialVersion() + 1;
            X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), cryptoMaterialVersionToRevoke);
            ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)true)));
            x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
            x509Param.setExpiration(Long.valueOf(application.getCertificateExpiration()));
            ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).registerRenewer((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
            JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
            jwtParam.setExpirationDate(application.getJWTExpiration());
            ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).registerRenewer((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
            TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
            ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
            ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
        } else {
            this.rmDispatcher.await();
            X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
            ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)true)));
            x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
            ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
            JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
            ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial(jwtParam);
            TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
        }
        if (this.conf.getBoolean("ipc.server.ssl.enabled", false)) {
            Assert.assertNotNull((Object)application.getKeyStore());
            Assert.assertNotEquals((Object)0, (Object)application.getKeyStore());
            Assert.assertNotEquals((long)-1L, (long)application.getCertificateExpiration());
        }
        if (this.conf.getBoolean(YarnConfiguration.RM_JWT_ENABLED, false)) {
            Assert.assertNotNull((Object)application.getJWT());
            Assert.assertNotEquals((long)0L, (long)application.getJWT().length());
            Assert.assertNotNull((Object)application.getJWTExpiration());
        }
        return application;
    }

    protected RMApp testCreateAppAccepted(ApplicationSubmissionContext submissionContext) throws Exception {
        RMApp application = this.testCreateAppSubmittedNoRecovery(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
        return application;
    }

    protected RMApp testCreateAppRunning(ApplicationSubmissionContext submissionContext) throws Exception {
        RMApp application = this.testCreateAppAccepted(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.RUNNING, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.UNDEFINED, application);
        return application;
    }

    protected RMApp testCreateAppFinalSaving(ApplicationSubmissionContext submissionContext) throws Exception {
        RMApp application = this.testCreateAppRunning(submissionContext);
        RMAppEvent finishingEvent = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_UNREGISTERED);
        application.handle((Event)finishingEvent);
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        this.assertAppFinalStateSaved(application);
        return application;
    }

    protected RMApp testCreateAppFinishing(ApplicationSubmissionContext submissionContext) throws Exception {
        assert (submissionContext == null || !submissionContext.getUnmanagedAM());
        RMApp application = this.testCreateAppFinalSaving(submissionContext);
        RMAppEvent appUpdated = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_UPDATE_SAVED);
        application.handle((Event)appUpdated);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHING, application);
        this.assertTimesAtFinish(application);
        return application;
    }

    protected RMApp testCreateAppFinished(ApplicationSubmissionContext submissionContext, String diagnostics) throws Exception {
        RMApp application = null;
        application = submissionContext != null && submissionContext.getUnmanagedAM() ? this.testCreateAppRunning(submissionContext) : this.testCreateAppFinishing(submissionContext);
        RMAppEvent finishedEvent = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FINISHED, diagnostics);
        application.handle((Event)finishedEvent);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf(diagnostics) != -1 ? 1 : 0) != 0);
        return application;
    }

    @Test
    public void testUnmanagedApp() throws Exception {
        ApplicationSubmissionContextPBImpl subContext = new ApplicationSubmissionContextPBImpl();
        subContext.setUnmanagedAM(true);
        LOG.info((Object)"--- START: testUnmanagedAppSuccessPath ---");
        String diagMsg = "some diagnostics";
        RMApp application = this.testCreateAppFinished((ApplicationSubmissionContext)subContext, "some diagnostics");
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
        Mockito.reset((Object[])new RMApplicationHistoryWriter[]{this.writer});
        Mockito.reset((Object[])new SystemMetricsPublisher[]{this.publisher});
        LOG.info((Object)"--- START: testUnmanagedAppFailPath ---");
        application = this.testCreateAppRunning((ApplicationSubmissionContext)subContext);
        RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        RMAppAttempt appAttempt = application.getCurrentAppAttempt();
        Assert.assertEquals((long)1L, (long)appAttempt.getAppAttemptId().getAttemptId());
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*Unmanaged application.*Failing the application.*");
        this.assertAppFinalStateSaved(application);
    }

    @Test
    public void testAppSuccessPath() throws Exception {
        LOG.info((Object)"--- START: testAppSuccessPath ---");
        String diagMsg = "some diagnostics";
        RMApp application = this.testCreateAppFinished(null, "some diagnostics");
        Assert.assertTrue((String)"Finished application missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testAppRecoverPath() throws Exception {
        LOG.info((Object)"--- START: testAppRecoverPath ---");
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        ContainerLaunchContext clc = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Credentials credentials = new Credentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        clc.setTokens(securityTokens);
        sub.setAMContainerSpec(clc);
        this.testCreateAppSubmittedRecovery(sub, false);
    }

    @Test(timeout=30000L)
    public void testAppNewKill() throws IOException {
        LOG.info((Object)"--- START: testAppNewKill ---");
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppNewKill", (String[])new String[]{"foo_group"});
        RMApp application = this.createNewTestApp(null);
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateNotSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), (Boolean)Matchers.any(Boolean.class));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), (Boolean)Matchers.any(Boolean.class));
    }

    @Test
    public void testAppNewReject() throws Exception {
        LOG.info((Object)"--- START: testAppNewReject ---");
        RMApp application = this.createNewTestApp(null);
        String rejectedText = "Test Application Rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).registerRenewer((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).registerRenewer((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
    }

    @Test(timeout=30000L)
    public void testAppNewRejectAddToStore() throws Exception {
        LOG.info((Object)"--- START: testAppNewRejectAddToStore ---");
        RMApp application = this.createNewTestApp(null);
        String rejectedText = "Test Application Rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).registerRenewer((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).registerRenewer((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
        this.rmContext.getStateStore().removeApplication(application);
    }

    @Test(timeout=30000L)
    public void testAppNewSavingKill() throws Exception {
        LOG.info((Object)"--- START: testAppNewSavingKill ---");
        RMApp application = this.testCreateAppNewSaving(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppNewSavingKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).registerRenewer((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).registerRenewer((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
    }

    @Test(timeout=30000L)
    public void testAppNewSavingReject() throws Exception {
        LOG.info((Object)"--- START: testAppNewSavingReject ---");
        RMApp application = this.testCreateAppNewSaving(null);
        String rejectedText = "Test Application Rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).registerRenewer((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).registerRenewer((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
    }

    @Test(timeout=30000L)
    public void testAppSubmittedRejected() throws Exception {
        LOG.info((Object)"--- START: testAppSubmittedRejected ---");
        RMApp application = this.testCreateAppSubmittedNoRecovery(null);
        String rejectedText = "app rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)false)));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), Boolean.valueOf(Matchers.eq((boolean)false)));
    }

    @Test
    public void testAppSubmittedKill() throws Exception, InterruptedException {
        LOG.info((Object)"--- START: testAppSubmittedKill---");
        RMApp application = this.testCreateAppSubmittedNoRecovery(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppSubmittedKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)false)));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), Boolean.valueOf(Matchers.eq((boolean)false)));
    }

    @Test
    public void testAppAcceptedFailed() throws Exception {
        RMAppFailedAttemptEvent event;
        LOG.info((Object)"--- START: testAppAcceptedFailed ---");
        RMApp application = this.testCreateAppAccepted(null);
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
        for (int i = 1; i < maxAppAttempts; ++i) {
            event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
            application.handle((Event)event);
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
        }
        String message = "Test fail";
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, message, false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)false)));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), Boolean.valueOf(Matchers.eq((boolean)false)));
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*" + message + ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
    }

    @Test
    public void testAppAcceptedKill() throws Exception, InterruptedException {
        LOG.info((Object)"--- START: testAppAcceptedKill ---");
        RMApp application = this.testCreateAppAccepted(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppAcceptedKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.KILLING, application);
        RMAppEvent appAttemptKilled = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_KILLED, "Application killed by user.");
        application.handle((Event)appAttemptKilled);
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)false)));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), Boolean.valueOf(Matchers.eq((boolean)false)));
    }

    @Test
    public void testAppAcceptedAttemptKilled() throws Exception, InterruptedException {
        LOG.info((Object)"--- START: testAppAcceptedAttemptKilled ---");
        RMApp application = this.testCreateAppAccepted(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_KILLED, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)false)));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), Boolean.valueOf(Matchers.eq((boolean)false)));
    }

    @Test
    public void testAppRunningKill() throws Exception {
        LOG.info((Object)"--- START: testAppRunningKill ---");
        RMApp application = this.testCreateAppRunning(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppRunningKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)false)));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), Boolean.valueOf(Matchers.eq((boolean)false)));
    }

    @Test
    public void testAppRunningFailed() throws Exception {
        JWTSecurityHandler.JWTMaterialParameter jwtParam;
        X509SecurityHandler.X509MaterialParameter x509Param;
        LOG.info((Object)"--- START: testAppRunningFailed ---");
        RMApp application = this.testCreateAppRunning(null);
        RMAppAttempt appAttempt = application.getCurrentAppAttempt();
        int expectedAttemptId = 1;
        Assert.assertEquals((long)expectedAttemptId, (long)appAttempt.getAppAttemptId().getAttemptId());
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        for (int i = 1; i < maxAppAttempts; ++i) {
            RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
            application.handle((Event)event);
            this.rmDispatcher.await();
            x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
            ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), (Boolean)Matchers.any(Boolean.class));
            ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
            jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
            ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam));
            ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), (Boolean)Matchers.any(Boolean.class));
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
            appAttempt = application.getCurrentAppAttempt();
            Assert.assertEquals((long)(++expectedAttemptId), (long)appAttempt.getAppAttemptId().getAttemptId());
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.RUNNING, application);
        }
        RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertFailed(application, ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)false)));
        jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), Boolean.valueOf(Matchers.eq((boolean)false)));
    }

    @Test
    public void testAppAtFinishingIgnoreKill() throws Exception {
        LOG.info((Object)"--- START: testAppAtFinishingIgnoreKill ---");
        RMApp application = this.testCreateAppFinishing(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.FINISHING, application);
    }

    @Test
    public void testAppFinalSavingToFinished() throws Exception {
        LOG.info((Object)"--- START: testAppFinalSavingToFinished ---");
        RMApp application = this.testCreateAppFinalSaving(null);
        String diagMsg = "some diagnostics";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FINISHED, "some diagnostics");
        application.handle((Event)event);
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        RMAppEvent appUpdated = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_UPDATE_SAVED);
        application.handle((Event)appUpdated);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAppFinishedFinished() throws Exception {
        LOG.info((Object)"--- START: testAppFinishedFinished ---");
        RMApp application = this.testCreateAppFinished(null, "");
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (Object)"", (Object)diag.toString());
        this.verifyApplicationFinished(RMAppState.FINISHED);
    }

    @Test(timeout=30000L)
    public void testAppFailedFailed() throws Exception {
        LOG.info((Object)"--- START: testAppFailedFailed ---");
        RMApp application = this.testCreateAppNewSaving(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
    }

    @Test(timeout=30000L)
    public void testAppKilledKilled() throws Exception {
        LOG.info((Object)"--- START: testAppKilledKilled ---");
        RMApp application = this.testCreateAppRunning(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppKilledKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FINISHED, "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.eq((Object)x509Param), Boolean.valueOf(Matchers.eq((boolean)false)));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler)).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.eq((Object)jwtParam), Boolean.valueOf(Matchers.eq((boolean)false)));
    }

    @Test(timeout=30000L)
    public void testAppsRecoveringStates() throws Exception {
        RMStateStore.RMState state = new RMStateStore.RMState();
        Map applicationState = state.getApplicationState();
        this.createRMStateForApplications(applicationState, RMAppState.FINISHED);
        this.createRMStateForApplications(applicationState, RMAppState.KILLED);
        this.createRMStateForApplications(applicationState, RMAppState.FAILED);
        for (ApplicationStateData appState : applicationState.values()) {
            this.testRecoverApplication(appState, state);
        }
    }

    public void testRecoverApplication(ApplicationStateData appState, RMStateStore.RMState rmState) throws Exception {
        ApplicationSubmissionContext submissionContext = appState.getApplicationSubmissionContext();
        RMAppImpl application = new RMAppImpl(appState.getApplicationSubmissionContext().getApplicationId(), this.rmContext, this.conf, submissionContext.getApplicationName(), null, submissionContext.getQueue(), submissionContext, this.scheduler, null, appState.getSubmitTime(), submissionContext.getApplicationType(), submissionContext.getApplicationTags(), BuilderUtils.newResourceRequest((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)submissionContext.getResource(), (int)1));
        Assert.assertEquals((Object)RMAppState.NEW, (Object)application.getState());
        RMAppRecoverEvent recoverEvent = new RMAppRecoverEvent(application.getApplicationId(), rmState);
        application.handle((RMAppEvent)recoverEvent);
        Assert.assertTrue((String)"Application is not in recoveredFinalStatus.", (boolean)RMAppImpl.isAppInFinalState((RMApp)application));
        this.rmDispatcher.await();
        RMAppState finalState = appState.getState();
        Assert.assertEquals((String)"Application is not in finalState.", (Object)finalState, (Object)application.getState());
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class));
        ((X509SecurityHandler)Mockito.verify((Object)this.x509SecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Matchers.any(X509SecurityHandler.X509MaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).generateMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class));
        ((JWTSecurityHandler)Mockito.verify((Object)this.jwtSecurityHandler, (VerificationMode)Mockito.never())).revokeMaterial((JWTSecurityHandler.JWTMaterialParameter)Matchers.any(JWTSecurityHandler.JWTMaterialParameter.class), (Boolean)Matchers.any(Boolean.class));
    }

    public void createRMStateForApplications(Map<ApplicationId, ApplicationStateData> applicationState, RMAppState rmAppState) throws IOException {
        RMApp app = this.createNewTestApp(null);
        ApplicationStateData appState = ApplicationStateData.newInstance((long)app.getSubmitTime(), (long)app.getStartTime(), (String)app.getUser(), (ApplicationSubmissionContext)app.getApplicationSubmissionContext(), (RMAppState)rmAppState, null, (long)app.getFinishTime(), null);
        applicationState.put(app.getApplicationId(), appState);
    }

    @Test
    public void testGetAppReport() throws IOException {
        RMApp app = this.createNewTestApp(null);
        TestRMAppTransitions.assertAppState(RMAppState.NEW, app);
        ApplicationReport report = app.createAndGetApplicationReport(null, true);
        Assert.assertNotNull((Object)report.getApplicationResourceUsageReport());
        Assert.assertEquals((Object)report.getApplicationResourceUsageReport(), (Object)RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT);
        report = app.createAndGetApplicationReport("clientuser", true);
        Assert.assertNotNull((Object)report.getApplicationResourceUsageReport());
        Assert.assertTrue((String)"bad proxy url for app", (boolean)report.getTrackingUrl().endsWith("/proxy/" + app.getApplicationId() + "/"));
    }

    @Test
    public void testAppGeneratingCertsKill() throws IOException {
        LOG.info((Object)"--- START: testAppGeneratingCertsKill ---");
        this.rmDispatcher.unregisterHandlerForEvent(RMAppSecurityManagerEventType.class, true);
        RMApp app = this.testCreateAppGeneratingCerts(null);
        TestRMAppTransitions.assertAppState(RMAppState.GENERATING_SECURITY_MATERIAL, app);
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(app.getApplicationId(), "Application killed by user.", UserGroupInformation.getCurrentUser(), Server.getRemoteIp());
        app.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, app);
        this.sendAppUpdateSavedEvent(app);
        this.assertKilled(app);
        this.verifyApplicationFinished(RMAppState.KILLED);
    }

    @Test
    public void testGeneratingCertsRecoverWithCrypto() throws Exception {
        LOG.info((Object)"--- testGeneratingCertsRecoverWithCrypto ---");
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        ContainerLaunchContext clc = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Credentials credentials = new Credentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        clc.setTokens(securityTokens);
        sub.setAMContainerSpec(clc);
        this.testCreateAppSubmittedRecovery(sub, true);
    }

    private void verifyApplicationFinished(RMAppState state) {
        ArgumentCaptor finalState = ArgumentCaptor.forClass(RMAppState.class);
        ((RMApplicationHistoryWriter)Mockito.verify((Object)this.writer)).applicationFinished((RMApp)Matchers.any(RMApp.class), (RMAppState)finalState.capture());
        Assert.assertEquals((Object)state, (Object)finalState.getValue());
        finalState = ArgumentCaptor.forClass(RMAppState.class);
        ((SystemMetricsPublisher)Mockito.verify((Object)this.publisher)).appFinished((RMApp)Matchers.any(RMApp.class), (RMAppState)finalState.capture(), Matchers.anyLong());
        Assert.assertEquals((Object)state, (Object)finalState.getValue());
    }

    private void verifyAppRemovedSchedulerEvent(RMAppState finalState) {
        Assert.assertEquals((Object)SchedulerEventType.APP_REMOVED, (Object)this.schedulerDispatcher.lastSchedulerEvent.getType());
        if (this.schedulerDispatcher.lastSchedulerEvent instanceof AppRemovedSchedulerEvent) {
            AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)this.schedulerDispatcher.lastSchedulerEvent;
            Assert.assertEquals((Object)finalState, (Object)appRemovedEvent.getFinalState());
        }
    }

    private static final class TestSchedulerEventDispatcher
    implements EventHandler<SchedulerEvent> {
        public SchedulerEvent lastSchedulerEvent;

        private TestSchedulerEventDispatcher() {
        }

        public void handle(SchedulerEvent event) {
            this.lastSchedulerEvent = event;
        }
    }

    private static final class TestApplicationManagerEventDispatcher
    implements EventHandler<RMAppManagerEvent> {
        private TestApplicationManagerEventDispatcher() {
        }

        public void handle(RMAppManagerEvent event) {
        }
    }

    private static final class TestApplicationEventDispatcher
    implements EventHandler<RMAppEvent> {
        private final RMContext rmContext;

        public TestApplicationEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppEvent event) {
            ApplicationId appID = event.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appID);
            if (rmApp != null) {
                try {
                    rmApp.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appID), t);
                }
            }
        }
    }

    private static final class TestApplicationAttemptEventDispatcher
    implements EventHandler<RMAppAttemptEvent> {
        private final RMContext rmContext;

        public TestApplicationAttemptEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppAttemptEvent event) {
            ApplicationId appId = event.getApplicationAttemptId().getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appId);
            if (rmApp != null) {
                try {
                    rmApp.getRMAppAttempt(event.getApplicationAttemptId()).handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appId), t);
                }
            }
        }
    }
}

