/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecords;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.junit.Before;
import org.junit.Test;

public class TestFSQueueMetrics {
    private static final Configuration CONF = new Configuration();
    private MetricsSystem ms;

    @Before
    public void setUp() {
        this.ms = new MetricsSystemImpl();
        QueueMetrics.clearQueueMetrics();
    }

    @Test
    public void testSchedulingPolicy() {
        String queueName = "single";
        FSQueueMetrics metrics = FSQueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)CONF);
        metrics.setSchedulingPolicy("drf");
        this.checkSchedulingPolicy(queueName, "drf");
        metrics.setSchedulingPolicy("fair");
        this.checkSchedulingPolicy(queueName, "fair");
    }

    private void checkSchedulingPolicy(String queueName, String policy) {
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        queueSource.getMetrics((MetricsCollector)collector, true);
        MetricsRecords.assertTag((MetricsRecord)((MetricsRecord)collector.getRecords().get(0)), (String)"SchedulingPolicy", (String)policy);
    }
}

