/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueueManagerRealScheduler
extends FairSchedulerTestBase {
    private static final File ALLOC_FILE = new File(TEST_DIR, "test-queue-mgr");

    @Before
    public void setup() throws IOException {
        this.createConfiguration();
        this.writeAllocFile(30, 40);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE.getAbsolutePath());
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
    }

    @After
    public void teardown() {
        ALLOC_FILE.deleteOnExit();
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
    }

    private void writeAllocFile(int defaultFairShareTimeout, int fairShareTimeout) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<queue name=\"queueB1\">");
        out.println("<minSharePreemptionTimeout>5</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queue name=\"queueB2\">");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("</queue>");
        out.println("<defaultMinSharePreemptionTimeout>15</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionTimeout>" + defaultFairShareTimeout + "</defaultFairSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>" + fairShareTimeout + "</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
    }

    @Test
    public void testBackwardsCompatiblePreemptionConfiguration() throws IOException {
        QueueManager queueMgr = this.scheduler.getQueueManager();
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("default").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueA").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB.queueB1").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB.queueB2").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueC").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("root").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("default").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueA").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueB").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)5000L, (long)queueMgr.getQueue("queueB.queueB1").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueB.queueB2").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueC").getMinSharePreemptionTimeout());
        this.writeAllocFile(25, 30);
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)25000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
    }
}

