/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.leaderElection.LeaderElection;
import io.hops.leaderElection.YarnLeDescriptorFactory;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.election.entity.LeDescriptorFactory;
import io.hops.util.GroupMembership;
import io.hops.util.LiveRMsResponse;
import io.hops.util.SortedActiveRMList;
import io.hops.util.impl.ActiveRMPBImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.utils.YarnServerBuilderUtils;

public class GroupMembershipService
extends CompositeService
implements GroupMembership,
HAServiceProtocol {
    private static final Log LOG = LogFactory.getLog(GroupMembershipService.class);
    private final RMContext rmContext;
    private final ResourceManager rm;
    private Server server;
    private AccessControlList adminAcl;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private LeaderElection groupMembership;
    private boolean autoFailoverEnabled;
    private InetSocketAddress groupMembershipServiceAddress;
    boolean running = true;
    private String rmId = "";
    private Thread lEnGmMonitor;
    private YarnAuthorizationProvider authorizer;
    private UserGroupInformation daemonUser;
    private Configuration conf;
    boolean isReady = false;

    public GroupMembershipService(ResourceManager rm, RMContext rmContext) {
        super(GroupMembershipService.class.getName());
        this.rm = rm;
        this.rmContext = rmContext;
    }

    public synchronized void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        this.groupMembershipServiceAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.groupMembership.address", "localhost:8034", 8034);
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            this.rmId = HAUtil.getRMHAId((Configuration)conf);
        }
        this.daemonUser = UserGroupInformation.getCurrentUser();
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
        this.authorizer.setAdmins(this.getAdminAclList(conf), UserGroupInformation.getCurrentUser());
        LOG.info((Object)("init groupMembershipService " + this.rmId));
    }

    private AccessControlList getAdminAclList(Configuration conf) {
        AccessControlList aclList = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        aclList.addUser(this.daemonUser.getShortUserName());
        return aclList;
    }

    protected synchronized void serviceStart() throws Exception {
        this.startServer();
        LOG.info((Object)("Started GMS on " + this.rmId + " port: " + this.server.getPort()));
        this.groupMembershipServiceAddress = this.getConfig().updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.groupMembership.address", "localhost:8034", this.server.getListenerAddress());
        this.startGroupMembership();
        LOG.info((Object)("Started GMS: " + this.rmId + " on " + this.groupMembershipServiceAddress.getAddress().getHostAddress() + ":" + this.groupMembershipServiceAddress.getPort()));
        super.serviceStart();
    }

    protected synchronized void startGroupMembership() throws IOException {
        if (this.rmContext.isHAEnabled()) {
            this.initLEandGM(this.conf);
        }
        if (this.groupMembership != null) {
            this.groupMembership.start();
            try {
                this.groupMembership.waitActive();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Group membership service was interrupted");
            }
            this.lEnGmMonitor = new Thread(new LEnGmMonitor());
            this.lEnGmMonitor.setName("group membership monitor");
            this.lEnGmMonitor.start();
        }
    }

    protected synchronized void serviceStop() throws Exception {
        this.stopServer();
        LOG.info((Object)"stopping group membership service service");
        this.stopGroupMembership();
        LOG.info((Object)"stopped group membership service");
        super.serviceStop();
        LOG.info((Object)("stopped GMS on " + this.rmId));
    }

    protected synchronized void stopGroupMembership() throws Exception {
        if (this.groupMembership != null && this.groupMembership.isRunning()) {
            this.groupMembership.stopElectionThread();
        }
    }

    protected void startServer() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(GroupMembership.class, (Object)this, this.groupMembershipServiceAddress, conf, null, conf.getInt("yarn.resourcemanager.group_membership.client.thread-count", 1));
        this.server.start();
    }

    protected void stopServer() throws Exception {
        if (this.server != null) {
            LOG.info((Object)("stopping group membership service server on " + this.server.getListenerAddress().getHostName() + ":" + this.server.getPort()));
            this.server.stop();
        }
    }

    private synchronized Configuration getConfiguration(Configuration conf, String confFileName) throws YarnException, IOException {
        InputStream confFileInputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, confFileName);
        if (confFileInputStream != null) {
            conf.addResource(confFileInputStream);
        }
        return conf;
    }

    public String getRMId() {
        return this.rmId;
    }

    public boolean isLeader() {
        if (this.groupMembership != null && this.groupMembership.isRunning()) {
            return this.groupMembership.isLeader();
        }
        return false;
    }

    public boolean isLeadingRT() {
        if (this.groupMembership != null && this.groupMembership.isRunning()) {
            return this.groupMembership.isSecond();
        }
        return false;
    }

    public boolean isAlone() {
        return this.groupMembership.getActiveNamenodes().size() == 1;
    }

    public synchronized void monitorHealth() throws IOException {
        this.checkAccess("monitorHealth");
        if (this.isRMActive() && !this.rm.areActiveServicesRunning()) {
            throw new HealthCheckFailedException("Active ResourceManager services are not running!");
        }
    }

    private UserGroupInformation checkAccess(String method) throws IOException {
        return RMServerUtils.verifyAdminAccess(this.authorizer, method, LOG);
    }

    private UserGroupInformation checkAcls(String method) throws YarnException {
        try {
            return this.checkAccess(method);
        }
        catch (IOException ioe) {
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
    }

    private synchronized boolean isRMActive() {
        return HAServiceProtocol.HAServiceState.ACTIVE == this.rmContext.getHAServiceState();
    }

    private void throwStandbyException() throws StandbyException {
        throw new StandbyException("ResourceManager " + this.rmId + " is not Active!");
    }

    public synchronized void transitionToActive(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        try {
            this.refreshAdminAcls(false);
        }
        catch (YarnException ex) {
            throw new ServiceFailedException("Can not execute refreshAdminAcls", (Throwable)ex);
        }
        throw new UnsupportedOperationException("not implemented yet");
    }

    public synchronized void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        try {
            this.refreshAdminAcls(false);
        }
        catch (YarnException ex) {
            throw new ServiceFailedException("Can not execute refreshAdminAcls", (Throwable)ex);
        }
        throw new UnsupportedOperationException("not implemented yet");
    }

    private RefreshAdminAclsResponse refreshAdminAcls(boolean checkRMHAState) throws YarnException, IOException {
        String argName = "refreshAdminAcls";
        UserGroupInformation user = this.checkAcls(argName);
        if (checkRMHAState) {
            this.checkRMStatus(user.getShortUserName(), argName, "refresh Admin ACLs.");
        }
        Configuration conf = this.getConfiguration(new Configuration(false), "yarn-site.xml");
        this.authorizer.setAdmins(this.getAdminAclList(conf), UserGroupInformation.getCurrentUser());
        RMAuditLogger.logSuccess(user.getShortUserName(), argName, "AdminService");
        return (RefreshAdminAclsResponse)this.recordFactory.newRecordInstance(RefreshAdminAclsResponse.class);
    }

    private void checkRMStatus(String user, String argName, String msg) throws StandbyException {
        if (!this.isRMActive()) {
            RMAuditLogger.logFailure(user, argName, "", "AdminService", "ResourceManager is not active. Can not " + msg);
            this.throwStandbyException();
        }
    }

    public synchronized HAServiceStatus getServiceStatus() throws IOException {
        this.checkAccess("getServiceState");
        HAServiceProtocol.HAServiceState haState = this.rmContext.getHAServiceState();
        HAServiceStatus ret = new HAServiceStatus(haState);
        if (this.isRMActive() || haState == HAServiceProtocol.HAServiceState.STANDBY) {
            ret.setReadyToBecomeActive();
        } else {
            ret.setNotReadyToBecomeActive("State is " + haState);
        }
        return ret;
    }

    public LiveRMsResponse getLiveRMList() {
        return YarnServerBuilderUtils.newLiveRMsResponse((SortedActiveRMList)this.getSortedActiveRMList());
    }

    private SortedActiveRMList getSortedActiveRMList() {
        ArrayList<ActiveRMPBImpl> rmList = new ArrayList<ActiveRMPBImpl>();
        SortedActiveNodeList nnList = this.groupMembership.getActiveNamenodes();
        for (ActiveNode node : nnList.getSortedActiveNodes()) {
            rmList.add(new ActiveRMPBImpl(node.getId(), node.getHostname(), node.getRpcServerIpAddress(), node.getRpcServerPort(), node.getHttpAddress()));
        }
        return new SortedActiveRMList(rmList);
    }

    private void initLEandGM(Configuration conf) throws IOException {
        long leadercheckInterval = conf.getInt("dfs.leader.check.interval", 2000);
        int missedHeartBeatThreshold = conf.getInt("dfs.leader.missed.hb", 2);
        int leIncrement = conf.getInt("dfs.leader.tp.increment", 100);
        this.groupMembership = new LeaderElection((LeDescriptorFactory)new YarnLeDescriptorFactory(), leadercheckInterval, missedHeartBeatThreshold, (long)leIncrement, this.rmId, this.groupMembershipServiceAddress.getAddress().getHostAddress() + ":" + this.groupMembershipServiceAddress.getPort());
    }

    public void forceLeader() throws IOException {
        this.groupMembership.forceLead(this.groupMembership.getCurrentId());
    }

    public void relinquishId() throws InterruptedException {
        if (this.groupMembership != null) {
            this.groupMembership.relinquishCurrentIdInNextRound();
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public long getCurrentId() {
        return this.groupMembership.getCurrentId();
    }

    private class LEnGmMonitor
    implements Runnable {
        Boolean previousLeaderRole = null;
        Boolean previousLeadingRTRole = null;

        private LEnGmMonitor() {
        }

        @Override
        public void run() {
            try {
                while (GroupMembershipService.this.groupMembership.isRunning()) {
                    boolean currentLeaderRole = GroupMembershipService.this.isLeader();
                    if (this.previousLeaderRole == null || currentLeaderRole != this.previousLeaderRole) {
                        this.previousLeaderRole = currentLeaderRole;
                        this.switchLeaderRole(this.previousLeaderRole);
                    }
                    GroupMembershipService.this.isReady = true;
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }

        private void switchLeaderRole(boolean role) throws Exception {
            GroupMembershipService.this.conf.set("yarn.resourcemanager.ha.id", GroupMembershipService.this.rmId);
            if (role) {
                LOG.info((Object)(GroupMembershipService.this.groupMembership.getCurrentId() + " switching to active "));
                GroupMembershipService.this.rm.transitionToActive();
            } else {
                LOG.info((Object)(GroupMembershipService.this.groupMembership.getCurrentId() + " switching to standby "));
                GroupMembershipService.this.rm.transitionToStandby(true);
            }
        }
    }
}

