/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import com.google.common.annotations.VisibleForTesting;
import io.hops.exception.StorageException;
import io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.ConfDataAccess;
import io.hops.metadata.hdfs.dal.ConfMutationDataAccess;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.RMStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;

public class DBConfigurationStore
extends YarnConfigurationStore {
    private long maxLogs;
    private YarnConfigurationStore.LogMutation pendingMutation;
    @VisibleForTesting
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)0, (int)1);

    @Override
    public void initialize(Configuration conf, Configuration schedConf, RMContext rmContext) throws Exception {
        this.maxLogs = conf.getLong("yarn.scheduler.configuration.store.max-logs", 1000L);
        if (this.retrieve() == null) {
            HashMap<String, String> mapConf = new HashMap<String, String>();
            for (Map.Entry entry : schedConf) {
                mapConf.put((String)entry.getKey(), (String)entry.getValue());
            }
            this.persistConf(mapConf);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void logMutation(final YarnConfigurationStore.LogMutation logMutation) throws Exception {
        LightWeightRequestHandler logMutationHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ConfMutationDataAccess DA = (ConfMutationDataAccess)RMStorageFactory.getDataAccess(ConfMutationDataAccess.class);
                ArrayList<byte[]> storedLogs = DA.get();
                LinkedList<YarnConfigurationStore.LogMutation> logs = new LinkedList<YarnConfigurationStore.LogMutation>();
                if (storedLogs != null) {
                    for (byte[] storedLog : storedLogs) {
                        try {
                            logs.add((YarnConfigurationStore.LogMutation)DBConfigurationStore.deserializeObject(storedLog));
                        }
                        catch (Exception ex) {
                            throw new StorageException((Throwable)ex);
                        }
                    }
                }
                logs.add(logMutation);
                if ((long)logs.size() > DBConfigurationStore.this.maxLogs) {
                    logs.remove(logs.removeFirst());
                }
                storedLogs = new ArrayList<byte[]>();
                for (YarnConfigurationStore.LogMutation log : logs) {
                    try {
                        storedLogs.add(DBConfigurationStore.serializeObject(log));
                    }
                    catch (Exception ex) {
                        throw new StorageException((Throwable)ex);
                    }
                }
                DA.set(storedLogs);
                connector.commit();
                return null;
            }
        };
        logMutationHandler.handle();
        this.pendingMutation = logMutation;
    }

    @VisibleForTesting
    protected LinkedList<YarnConfigurationStore.LogMutation> getLogs() throws Exception {
        LightWeightRequestHandler getLogHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ConfMutationDataAccess DA = (ConfMutationDataAccess)RMStorageFactory.getDataAccess(ConfMutationDataAccess.class);
                List storedLogs = DA.get();
                LinkedList<YarnConfigurationStore.LogMutation> logs = new LinkedList<YarnConfigurationStore.LogMutation>();
                if (storedLogs != null) {
                    for (byte[] storedLog : storedLogs) {
                        try {
                            logs.add((YarnConfigurationStore.LogMutation)DBConfigurationStore.deserializeObject(storedLog));
                        }
                        catch (Exception ex) {
                            throw new StorageException((Throwable)ex);
                        }
                    }
                }
                connector.commit();
                return logs;
            }
        };
        return (LinkedList)getLogHandler.handle();
    }

    @Override
    public void confirmMutation(boolean isValid) throws Exception {
        if (isValid) {
            Configuration storedConfigs = this.retrieve();
            HashMap<String, String> mapConf = new HashMap<String, String>();
            for (Map.Entry storedConf : storedConfigs) {
                mapConf.put((String)storedConf.getKey(), (String)storedConf.getValue());
            }
            for (Map.Entry<String, String> confChange : this.pendingMutation.getUpdates().entrySet()) {
                if (confChange.getValue() == null || confChange.getValue().isEmpty()) {
                    mapConf.remove(confChange.getKey());
                    continue;
                }
                mapConf.put(confChange.getKey(), confChange.getValue());
            }
            this.persistConf(mapConf);
        }
        this.pendingMutation = null;
    }

    @Override
    public Configuration retrieve() throws IOException {
        return this.getConf();
    }

    @Override
    public List<YarnConfigurationStore.LogMutation> getConfirmedConfHistory(long fromId) {
        return null;
    }

    @Override
    protected Version getConfStoreVersion() throws Exception {
        byte[] data;
        ByteArrayVariable var = (ByteArrayVariable)this.getVariable(Variable.Finder.ConfigurationStoreVersion);
        byte[] byArray = data = var == null ? null : (byte[])var.getValue();
        if (data != null) {
            return new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
        }
        return null;
    }

    @Override
    protected void storeVersion() throws Exception {
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        this.setVariable((Variable)new ByteArrayVariable(Variable.Finder.ConfigurationStoreVersion, data));
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private void setVariable(final Variable var) throws IOException {
        LightWeightRequestHandler setVersionHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                VariableDataAccess vDA = (VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class);
                vDA.setVariable(var);
                connector.commit();
                return null;
            }
        };
        setVersionHandler.handle();
    }

    private Variable getVariable(final Variable.Finder finder) throws IOException {
        LightWeightRequestHandler getVersionHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.readCommitted();
                VariableDataAccess DA = (VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class);
                Variable var = (Variable)DA.getVariable((Object)finder);
                connector.commit();
                return var;
            }
        };
        return (Variable)getVersionHandler.handle();
    }

    /*
     * Exception decompiling
     */
    private static byte[] serializeObject(Object o) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static Object deserializeObject(byte[] bytes) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void persistConf(Map<String, String> mapConf) throws Exception {
        final byte[] confBytes = DBConfigurationStore.serializeObject(mapConf);
        LightWeightRequestHandler confHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ConfDataAccess DA = (ConfDataAccess)RMStorageFactory.getDataAccess(ConfDataAccess.class);
                DA.set((Object)confBytes);
                connector.commit();
                return null;
            }
        };
        confHandler.handle();
    }

    private Configuration getConf() throws IOException {
        LightWeightRequestHandler confHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ConfDataAccess DA = (ConfDataAccess)RMStorageFactory.getDataAccess(ConfDataAccess.class);
                byte[] result = (byte[])DA.get();
                connector.commit();
                return result;
            }
        };
        byte[] confBytes = (byte[])confHandler.handle();
        try {
            HashMap map = (HashMap)DBConfigurationStore.deserializeObject(confBytes);
            Configuration c = new Configuration();
            for (Map.Entry e : map.entrySet()) {
                c.set((String)e.getKey(), (String)e.getValue());
            }
            return c;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while deserializing scheduler configuration from store", (Throwable)e);
            return null;
        }
    }
}

