/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.curator.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FakeSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDominantResourceFairnessPolicy {
    @Before
    public void setup() {
        TestDominantResourceFairnessPolicy.addResources("test");
    }

    private Comparator<Schedulable> createComparator(int clusterMem, int clusterCpu) {
        DominantResourceFairnessPolicy policy = new DominantResourceFairnessPolicy();
        FSContext fsContext = (FSContext)Mockito.mock(FSContext.class);
        Mockito.when((Object)fsContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)clusterMem, (int)clusterCpu));
        policy.initialize(fsContext);
        return policy.getComparator();
    }

    private Schedulable createSchedulable(int memUsage, int cpuUsage) {
        return this.createSchedulable(memUsage, cpuUsage, 1.0f, 0, 0);
    }

    private Schedulable createSchedulable(int memUsage, int cpuUsage, int minMemShare, int minCpuShare) {
        return this.createSchedulable(memUsage, cpuUsage, 1.0f, minMemShare, minCpuShare);
    }

    private Schedulable createSchedulable(int memUsage, int cpuUsage, float weights) {
        return this.createSchedulable(memUsage, cpuUsage, weights, 0, 0);
    }

    private Schedulable createSchedulable(int memUsage, int cpuUsage, float weights, int minMemShare, int minCpuShare) {
        Resource usage = BuilderUtils.newResource((long)memUsage, (int)cpuUsage);
        Resource minShare = BuilderUtils.newResource((long)minMemShare, (int)minCpuShare);
        return new FakeSchedulable(minShare, Resources.createResource((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE), weights, Resources.none(), usage, 0L);
    }

    @Test
    public void testSameDominantResource() {
        Schedulable s2;
        Schedulable s1;
        Comparator<Schedulable> c = this.createComparator(8000, 4);
        Assert.assertTrue((String)"Comparison didn't return a value less than 0", (c.compare(s1 = this.createSchedulable(1000, 1), s2 = this.createSchedulable(2000, 1)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSameDominantResource2() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        this.testSameDominantResource();
    }

    @Test
    public void testDifferentDominantResource() {
        Schedulable s2;
        Schedulable s1;
        Comparator<Schedulable> c = this.createComparator(8000, 8);
        Assert.assertTrue((String)"Comparison didn't return a value less than 0", (c.compare(s1 = this.createSchedulable(4000, 3), s2 = this.createSchedulable(2000, 5)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDifferentDominantResource2() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        this.testDifferentDominantResource();
    }

    @Test
    public void testOneIsNeedy() {
        Schedulable s2;
        Schedulable s1;
        Comparator<Schedulable> c = this.createComparator(8000, 8);
        Assert.assertTrue((String)"Comparison didn't return a value less than 0", (c.compare(s1 = this.createSchedulable(2000, 5, 0, 6), s2 = this.createSchedulable(4000, 3, 0, 0)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOneIsNeedy2() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        this.testOneIsNeedy();
    }

    @Test
    public void testBothAreNeedy() {
        Schedulable s2;
        Schedulable s1;
        Comparator<Schedulable> c = this.createComparator(8000, 100);
        Assert.assertTrue((String)"Comparison didn't return a value less than 0", (c.compare(s1 = this.createSchedulable(2000, 5), s2 = this.createSchedulable(4000, 3)) < 0 ? 1 : 0) != 0);
        s1 = this.createSchedulable(2000, 5, 3000, 6);
        s2 = this.createSchedulable(4000, 3, 5000, 4);
        Assert.assertTrue((String)"Comparison didn't return a value less than 0", (c.compare(s1, s2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBothAreNeedy2() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        this.testBothAreNeedy();
    }

    @Test
    public void testEvenWeightsSameDominantResource() {
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(3000, 1, 2.0f), this.createSchedulable(2000, 1)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(1000, 3, 2.0f), this.createSchedulable(1000, 2)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEvenWeightsSameDominantResource2() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        this.testEvenWeightsSameDominantResource();
    }

    @Test
    public void testEvenWeightsDifferentDominantResource() {
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(1000, 3, 2.0f), this.createSchedulable(2000, 1)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.createComparator(8000, 8).compare(this.createSchedulable(3000, 1, 2.0f), this.createSchedulable(1000, 2)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEvenWeightsDifferentDominantResource2() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        this.testEvenWeightsDifferentDominantResource();
    }

    @Test
    public void testSortShares() {
        float[][] ratios1 = new float[][]{{0.3f, 2.0f}, {0.2f, 1.0f}, {0.4f, 0.1f}};
        float[][] ratios2 = new float[][]{{0.2f, 9.0f}, {0.3f, 2.0f}, {0.25f, 0.1f}};
        float[][] expected1 = new float[][]{{0.4f, 0.1f}, {0.3f, 2.0f}, {0.2f, 1.0f}};
        float[][] expected2 = new float[][]{{0.3f, 2.0f}, {0.25f, 0.1f}, {0.2f, 9.0f}};
        DominantResourceFairnessPolicy.DominantResourceFairnessComparatorN comparator = new DominantResourceFairnessPolicy.DominantResourceFairnessComparatorN();
        comparator.sortRatios((float[][])ratios1, (float[][])ratios2);
        for (int i = 0; i < ratios1.length; ++i) {
            Assert.assertArrayEquals((String)"The shares array was not sorted into the expected order: incorrect inner array encountered", (float[])expected1[i], (float[])ratios1[i], (float)1.0E-5f);
            Assert.assertArrayEquals((String)"The shares array was not sorted into the expected order: incorrect inner array encountered", (float[])expected2[i], (float[])ratios2[i], (float)1.0E-5f);
        }
    }

    @Test
    public void testCalculateClusterAndFairRatios() {
        Map index = ResourceUtils.getResourceTypeIndex();
        Resource used = Resources.createResource((int)10, (int)5);
        Resource capacity = Resources.createResource((int)100, (int)10);
        float[][] shares = new float[3][2];
        DominantResourceFairnessPolicy.DominantResourceFairnessComparatorN comparator = new DominantResourceFairnessPolicy.DominantResourceFairnessComparatorN();
        used.setResourceValue("test", 2L);
        capacity.setResourceValue("test", 5L);
        int dominant = comparator.calculateClusterAndFairRatios(used, capacity, shares, 1.0f);
        Assert.assertEquals((String)"Calculated usage ratio for memory (10MB out of 100MB) is incorrect", (double)0.1, (double)shares[(Integer)index.get(ResourceInformation.MEMORY_MB.getName())][0], (double)1.0E-5);
        Assert.assertEquals((String)"Calculated usage ratio for vcores (5 out of 10) is incorrect", (double)0.5, (double)shares[(Integer)index.get(ResourceInformation.VCORES.getName())][0], (double)1.0E-5);
        Assert.assertEquals((String)"Calculated usage ratio for test resource (2 out of 5) is incorrect", (double)0.4, (double)shares[(Integer)index.get("test")][0], (double)1.0E-5);
        Assert.assertEquals((String)"The wrong dominant resource index was returned", (long)((Integer)index.get(ResourceInformation.VCORES.getName())).intValue(), (long)dominant);
    }

    @Test
    public void testCalculateClusterAndFairRatios2() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        Resource used = Resources.createResource((int)10, (int)5);
        Resource capacity = Resources.createResource((int)100, (int)10);
        double[] shares = new double[2];
        DominantResourceFairnessPolicy.DominantResourceFairnessComparator2 comparator = new DominantResourceFairnessPolicy.DominantResourceFairnessComparator2();
        int dominant = comparator.calculateClusterAndFairRatios(used.getResources(), 1.0f, capacity.getResources(), shares);
        Assert.assertEquals((String)"Calculated usage ratio for memory (10MB out of 100MB) is incorrect", (double)0.1, (double)shares[0], (double)1.0E-5);
        Assert.assertEquals((String)"Calculated usage ratio for vcores (5 out of 10) is incorrect", (double)0.5, (double)shares[1], (double)1.0E-5);
        Assert.assertEquals((String)"The wrong dominant resource index was returned", (long)1L, (long)dominant);
    }

    @Test
    public void testCalculateMinShareRatios() {
        Map index = ResourceUtils.getResourceTypeIndex();
        Resource used = Resources.createResource((int)10, (int)5);
        Resource minShares = Resources.createResource((int)5, (int)10);
        float[][] ratios = new float[3][3];
        DominantResourceFairnessPolicy.DominantResourceFairnessComparatorN comparator = new DominantResourceFairnessPolicy.DominantResourceFairnessComparatorN();
        used.setResourceValue("test", 2L);
        minShares.setResourceValue("test", 0L);
        comparator.calculateMinShareRatios(used, minShares, ratios);
        Assert.assertEquals((String)"Calculated min share ratio for memory (10MB out of 5MB) is incorrect", (double)2.0, (double)ratios[(Integer)index.get(ResourceInformation.MEMORY_MB.getName())][2], (double)1.0E-5f);
        Assert.assertEquals((String)"Calculated min share ratio for vcores (5 out of 10) is incorrect", (double)0.5, (double)ratios[(Integer)index.get(ResourceInformation.VCORES.getName())][2], (double)1.0E-5f);
        Assert.assertEquals((String)"Calculated min share ratio for test resource (0 out of 5) is incorrect", (float)Float.POSITIVE_INFINITY, (float)ratios[(Integer)index.get("test")][2], (float)1.0E-5f);
    }

    @Test
    public void testCalculateMinShareRatios2() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        Resource used = Resources.createResource((int)10, (int)5);
        Resource minShares = Resources.createResource((int)5, (int)10);
        DominantResourceFairnessPolicy.DominantResourceFairnessComparator2 comparator = new DominantResourceFairnessPolicy.DominantResourceFairnessComparator2();
        double[] ratios = comparator.calculateMinShareRatios(used.getResources(), minShares.getResources());
        Assert.assertEquals((String)"Calculated min share ratio for memory (10MB out of 5MB) is incorrect", (double)2.0, (double)ratios[0], (double)1.0E-5f);
        Assert.assertEquals((String)"Calculated min share ratio for vcores (5 out of 10) is incorrect", (double)0.5, (double)ratios[1], (double)1.0E-5f);
    }

    @Test
    public void testCompareShares() {
        float[][] ratios1 = new float[][]{{0.4f, 0.1f, 2.0f}, {0.3f, 2.0f, 0.1f}, {0.2f, 1.0f, 9.0f}};
        float[][] ratios2 = new float[][]{{0.3f, 2.0f, 1.0f}, {0.2f, 0.1f, 0.5f}, {0.2f, 1.0f, 2.0f}};
        float[][] ratios3 = new float[][]{{0.3f, 2.0f, 1.0f}, {0.2f, 0.1f, 2.0f}, {0.1f, 2.0f, 1.0f}};
        DominantResourceFairnessPolicy.DominantResourceFairnessComparatorN comparator = new DominantResourceFairnessPolicy.DominantResourceFairnessComparatorN();
        int ret = comparator.compareRatios((float[][])ratios1, (float[][])ratios2, 0);
        Assert.assertEquals((String)"Expected the first array to be larger because the first usage ratio element is larger", (long)1L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios1, 0);
        Assert.assertEquals((String)"Expected the first array to be smaller because the first usage ratio element is smaller", (long)-1L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios1, (float[][])ratios1, 0);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios2, 0);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios3, (float[][])ratios3, 0);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios3, 0);
        Assert.assertEquals((String)"Expected the first array to be larger because the last usage ratio element is larger, and all other elements are equal", (long)1L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios1, (float[][])ratios2, 1);
        Assert.assertEquals((String)"Expected the first array to be smaller because the first fair share ratio element is smaller", (long)-1L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios1, 1);
        Assert.assertEquals((String)"Expected the first array to be larger because the first fair share ratio element is larger", (long)1L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios1, (float[][])ratios1, 1);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios2, 1);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios3, (float[][])ratios3, 1);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios3, 1);
        Assert.assertEquals((String)"Expected the first array to be smaller because the last usage ratio element is smaller, and all other elements are equal", (long)-1L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios1, (float[][])ratios2, 2);
        Assert.assertEquals((String)"Expected the first array to be larger because the first min share ratio element is larger", (long)1L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios1, 2);
        Assert.assertEquals((String)"Expected the first array to be smaller because the first min share ratio element is smaller", (long)-1L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios1, (float[][])ratios1, 2);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios2, 2);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios3, (float[][])ratios3, 2);
        Assert.assertEquals((String)"Expected the arrays to be equal, since they're the same array", (long)0L, (long)ret);
        ret = comparator.compareRatios((float[][])ratios2, (float[][])ratios3, 2);
        Assert.assertEquals((String)"Expected the first array to be smaller because the second min share ratio element is smaller, and all the first elements are equal", (long)-1L, (long)ret);
    }

    @Test
    public void testCompareSchedulablesWithClusterResourceChanges() {
        Schedulable schedulable1 = this.createSchedulable(2000, 1);
        Schedulable schedulable2 = this.createSchedulable(1000, 2);
        Assert.assertTrue((this.createComparator(4000, 5).compare(schedulable1, schedulable2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.createComparator(8000, 6).compare(schedulable1, schedulable2) < 0 ? 1 : 0) != 0);
    }

    private static void addResources(String ... resources) {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types", Joiner.on((char)',').join((Object[])resources));
        ResourceUtils.resetResourceTypes((Configuration)conf);
    }

    @Test
    public void testModWhileSorting() {
        ArrayList<FakeSchedulable> schedulableList = new ArrayList<FakeSchedulable>();
        for (int i = 0; i < 10000; ++i) {
            schedulableList.add((FakeSchedulable)this.createSchedulable(i % 10 * 100, i % 3 * 2));
        }
        Comparator<Schedulable> DRFComparator = this.createComparator(100000, 50000);
        TreeSet<Schedulable> sortedSchedulable = new TreeSet<Schedulable>(DRFComparator);
        Thread modThread = this.modificationThread(schedulableList);
        modThread.start();
        sortedSchedulable.addAll(schedulableList);
        try {
            modThread.join();
        }
        catch (InterruptedException ie) {
            Assert.fail((String)("ModThread join failed: " + ie.getMessage()));
        }
    }

    private Thread modificationThread(final List<FakeSchedulable> schedulableList) {
        Thread modThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    Assert.fail((String)("Modification thread interrupted while asleep " + ie.getMessage()));
                }
                Resource newUsage = Resources.createResource((int)0, (int)0);
                for (int j = 0; j < 1000; ++j) {
                    FakeSchedulable sched = (FakeSchedulable)schedulableList.get(j * 10);
                    newUsage.setMemorySize(20000L);
                    newUsage.setVirtualCores(j % 10);
                    sched.setResourceUsage(newUsage);
                }
            }
        };
        return modThread;
    }
}

