/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyIntraQueueFairOrdering
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", true);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testIntraQueuePreemptionFairOrderingPolicyEnabledOneAppPerUser() throws IOException {
        this.conf.set("yarn.scheduler.capacity.root.a.ordering-policy", "fair");
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 1.0f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 1 0]);-a(=[100 100 100 1 0])";
        String appsConfig = "a\t(1,1,n1,,60,false,0,user1);a\t(1,1,n1,,40,false,0,user2);a\t(1,1,n1,,0,false,20,user3)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testIntraQueuePreemptionFifoOrderingPolicyEnabled() throws IOException {
        this.conf.set("yarn.scheduler.capacity.root.a.ordering-policy", "fifo");
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 1.0f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 1 0]);-a(=[100 100 100 1 0])";
        String appsConfig = "a\t(1,1,n1,,60,false,0,user1);a\t(1,1,n1,,40,false,0,user2);a\t(1,1,n1,,0,false,5,user3)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        appsConfig = "a\t(1,1,n1,,60,false,0,user1);a\t(1,1,n1,,35,false,0,user2);a\t(1,1,n1,,5,false,15,user3)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testIntraQueuePreemptionFairOrderingPolicyMulitipleAppsPerUser() throws IOException {
        this.conf.set("yarn.scheduler.capacity.root.a.ordering-policy", "fair");
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 1.0f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 1 0]);-a(=[100 100 100 1 0])";
        String appsConfig = "a\t(1,1,n1,,35,false,0,user1);a\t(1,1,n1,,25,false,0,user1);a\t(1,1,n1,,40,false,0,user2);a\t(1,1,n1,,0,false,20,user3)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testIntraQueuePreemptionFifoOrderingPolicyMultipleAppsPerUser() throws IOException {
        this.conf.set("yarn.scheduler.capacity.root.a.ordering-policy", "fifo");
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 1.0f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 1 0]);-a(=[100 100 100 1 0])";
        String appsConfig = "a\t(1,1,n1,,40,false,0,user1);a\t(1,1,n1,,20,false,0,user1);a\t(1,1,n1,,40,false,0,user3);a\t(1,1,n1,,0,false,25,user4)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)1))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }
}

