/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.util.resource.TestResourceUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestAllocationFileLoaderService {
    private static final String A_CUSTOM_RESOURCE = "a-custom-resource";
    static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();
    private static final String TEST_FAIRSCHED_XML = "test-fair-scheduler.xml";

    @Test
    public void testGetAllocationFileFromFileSystem() throws IOException, URISyntaxException {
        YarnConfiguration conf = new YarnConfiguration();
        File baseDir = new File(TEST_DIR + "/" + "getAllocHDFS").getAbsoluteFile();
        FileUtil.fullyDelete((File)baseDir);
        conf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder((Configuration)conf);
        MiniDFSCluster hdfsCluster = builder.build();
        String fsAllocPath = "hdfs://localhost:" + hdfsCluster.getNameNodePort() + "/" + TEST_FAIRSCHED_XML;
        URL fschedURL = Thread.currentThread().getContextClassLoader().getResource(TEST_FAIRSCHED_XML);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.copyFromLocalFile(new Path(fschedURL.toURI()), new Path(fsAllocPath));
        conf.set("yarn.scheduler.fair.allocation.file", fsAllocPath);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        Path allocationFile = allocLoader.getAllocationFile((Configuration)conf);
        Assert.assertEquals((Object)fsAllocPath, (Object)allocationFile.toString());
        Assert.assertTrue((boolean)fs.exists(allocationFile));
        hdfsCluster.shutdown(true);
    }

    @Test(expected=UnsupportedFileSystemException.class)
    public void testDenyGetAllocationFileFromUnsupportedFileSystem() throws UnsupportedFileSystemException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.scheduler.fair.allocation.file", "badfs:///badfile");
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.getAllocationFile((Configuration)conf);
    }

    @Test
    public void testGetAllocationFileFromClasspath() {
        try {
            Configuration conf = new Configuration();
            FileSystem fs = FileSystem.get((Configuration)conf);
            conf.set("yarn.scheduler.fair.allocation.file", TEST_FAIRSCHED_XML);
            AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
            Path allocationFile = allocLoader.getAllocationFile(conf);
            Assert.assertEquals((Object)TEST_FAIRSCHED_XML, (Object)allocationFile.getName());
            Assert.assertTrue((boolean)fs.exists(allocationFile));
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to access allocation file from classpath: " + e));
        }
    }

    @Test(timeout=10000L)
    public void testReload() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\">");
        out.println("    <maxRunningApps>1</maxRunningApps>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueB\" />");
        out.println("  <queuePlacementPolicy>");
        out.println("    <rule name='default' />");
        out.println("  </queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        ControlledClock clock = new ControlledClock();
        clock.setTime(0L);
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService((Clock)clock);
        allocLoader.reloadIntervalMs = 5L;
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        QueuePlacementPolicy policy = allocConf.getPlacementPolicy();
        List rules = policy.getRules();
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(0)).getClass());
        Assert.assertEquals((long)1L, (long)allocConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)2L, (long)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueA"));
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueB"));
        confHolder.allocConf = null;
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueB\">");
        out.println("    <maxRunningApps>3</maxRunningApps>");
        out.println("  </queue>");
        out.println("  <queuePlacementPolicy>");
        out.println("    <rule name='specified' />");
        out.println("    <rule name='nestedUserQueue' >");
        out.println("         <rule name='primaryGroup' />");
        out.println("    </rule>");
        out.println("    <rule name='default' />");
        out.println("  </queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        clock.tickMsec(System.currentTimeMillis() + 5000L + 10000L);
        allocLoader.start();
        while (confHolder.allocConf == null) {
            Thread.sleep(20L);
        }
        allocConf = confHolder.allocConf;
        policy = allocConf.getPlacementPolicy();
        rules = policy.getRules();
        Assert.assertEquals((long)3L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Specified.class, ((QueuePlacementRule)rules.get(0)).getClass());
        Assert.assertEquals(QueuePlacementRule.NestedUserQueue.class, ((QueuePlacementRule)rules.get(1)).getClass());
        Assert.assertEquals(QueuePlacementRule.PrimaryGroup.class, ((QueuePlacementRule.NestedUserQueue)rules.get((int)1)).nestedRule.getClass());
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(2)).getClass());
        Assert.assertEquals((long)3L, (long)allocConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)1L, (long)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueB"));
    }

    @Test
    public void testAllocationFileParsing() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        TestResourceUtils.addNewTypesToResources((String[])new String[]{A_CUSTOM_RESOURCE});
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        AllocationFileWriter.create().queue("queueA").minResources("1024mb,0vcores").maxResources("2048mb,10vcores").buildQueue().queue("queueB").minResources("2048mb,0vcores").maxResources("5120mb,110vcores").aclAdministerApps("alice,bob admins").schedulingPolicy("fair").buildQueue().queue("queueC").minResources("5120mb,0vcores").aclSubmitApps("alice,bob admins").buildQueue().queue("queueD").maxRunningApps(3).maxAMShare(0.4).buildQueue().queue("queueE").minSharePreemptionTimeout(60).buildQueue().queue("queueF").parent(true).maxChildResources("2048mb,64vcores").buildQueue().queue("queueG").maxChildResources("2048mb,64vcores").fairSharePreemptionTimeout(120).minSharePreemptionTimeout(50).fairSharePreemptionThreshold(0.6).maxContainerAllocation("vcores=16, memory-mb=512, a-custom-resource=10").subQueue("queueH").fairSharePreemptionTimeout(180).minSharePreemptionTimeout(40).fairSharePreemptionThreshold(0.7).maxContainerAllocation("1024mb,8vcores").buildSubQueue().buildQueue().queueMaxAppsDefault(15).queueMaxResourcesDefault("4096mb,100vcores").userMaxAppsDefault(5).queueMaxAMShareDefault(0.5).defaultMinSharePreemptionTimeout(120).defaultFairSharePreemptionTimeout(300).defaultFairSharePreemptionThreshold(0.4).defaultQueueSchedulingPolicy("drf").userSettings("user1").maxRunningApps(10).build().writeToFile(ALLOC_FILE);
        allocLoader.init((Configuration)conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertEquals((long)6L, (long)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)10), (Object)queueConf.getMaxResources("root.queueA").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)5120, (int)110), (Object)queueConf.getMaxResources("root.queueB").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueC").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueD").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueE").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueF").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueG").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueG.queueH").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueConf.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueConf.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)5120, (int)0), (Object)queueConf.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueE"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueF"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueG"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueG.queueH"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueA", (Object)queueConf.getMaxChildResources("root.queueA"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueB", (Object)queueConf.getMaxChildResources("root.queueB"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueC", (Object)queueConf.getMaxChildResources("root.queueC"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueD", (Object)queueConf.getMaxChildResources("root.queueD"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueE", (Object)queueConf.getMaxChildResources("root.queueE"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)64), (Object)queueConf.getMaxChildResources("root.queueF").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)64), (Object)queueConf.getMaxChildResources("root.queueG").getResource());
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueG.queueH", (Object)queueConf.getMaxChildResources("root.queueG.queueH"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueConf.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueConf.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueConf.getUserMaxApps("user2"));
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.default"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueA"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueB"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueC"), (double)0.01);
        Assert.assertEquals((double)0.4f, (double)queueConf.getQueueMaxAMShare("root.queueD"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueE"), (double)0.01);
        Resource expectedResourceWithCustomType = Resources.createResource((int)512, (int)16);
        expectedResourceWithCustomType.setResourceValue(A_CUSTOM_RESOURCE, 10L);
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.default"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueA"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueB"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueC"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueD"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueE"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueF"));
        Assert.assertEquals((Object)expectedResourceWithCustomType, (Object)queueConf.getQueueMaxContainerAllocation("root.queueG"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)8), (Object)queueConf.getQueueMaxContainerAllocation("root.queueG.queueH"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)60000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueF"));
        Assert.assertEquals((long)50000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueG"));
        Assert.assertEquals((long)40000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueG.queueH"));
        Assert.assertEquals((long)300000L, (long)queueConf.getFairSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueF"));
        Assert.assertEquals((long)120000L, (long)queueConf.getFairSharePreemptionTimeout("root.queueG"));
        Assert.assertEquals((long)180000L, (long)queueConf.getFairSharePreemptionTimeout("root.queueG.queueH"));
        Assert.assertEquals((double)0.4f, (double)queueConf.getFairSharePreemptionThreshold("root"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.default"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueA"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueB"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueC"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueD"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueE"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueF"), (double)0.01);
        Assert.assertEquals((double)0.6f, (double)queueConf.getFairSharePreemptionThreshold("root.queueG"), (double)0.01);
        Assert.assertEquals((double)0.7f, (double)queueConf.getFairSharePreemptionThreshold("root.queueG.queueH"), (double)0.01);
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.PARENT)).contains("root.queueF"));
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.PARENT)).contains("root.queueG"));
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueG.queueH"));
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root").getName());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root.queueA").getName());
        Assert.assertEquals((Object)"fair", (Object)queueConf.getSchedulingPolicy("root.queueB").getName());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root.newqueue").getName());
    }

    @Test
    public void testBackwardsCompatibleAllocationFileParsing() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<pool name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</pool>");
        out.println("<pool name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<aclAdministerApps>alice,bob admins</aclAdministerApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueC\">");
        out.println("<aclSubmitApps>alice,bob admins</aclSubmitApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueD\">");
        out.println("<maxRunningApps>3</maxRunningApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueE\">");
        out.println("<minSharePreemptionTimeout>60</minSharePreemptionTimeout>");
        out.println("<fairSharePreemptionThreshold>0.3</fairSharePreemptionThreshold>");
        out.println("</pool>");
        out.println("<queueMaxAppsDefault>15</queueMaxAppsDefault>");
        out.println("<userMaxAppsDefault>5</userMaxAppsDefault>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>10</maxRunningApps>");
        out.println("</user>");
        out.println("<defaultMinSharePreemptionTimeout>120</defaultMinSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>300</fairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>0.6</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertEquals((long)5L, (long)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueConf.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueConf.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueE"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueConf.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueConf.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueConf.getUserMaxApps("user2"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)60000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)300000L, (long)queueConf.getFairSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((double)0.6f, (double)queueConf.getFairSharePreemptionThreshold("root"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.default"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueA"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueB"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueC"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueD"), (double)0.01);
        Assert.assertEquals((double)0.3f, (double)queueConf.getFairSharePreemptionThreshold("root.queueE"), (double)0.01);
    }

    @Test
    public void testSimplePlacementPolicyFromConf() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        conf.setBoolean("yarn.scheduler.fair.user-as-default-queue", false);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        QueuePlacementPolicy placementPolicy = allocConf.getPlacementPolicy();
        List rules = placementPolicy.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Specified.class, ((QueuePlacementRule)rules.get(0)).getClass());
        Assert.assertEquals((Object)false, (Object)((QueuePlacementRule)rules.get((int)0)).create);
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(1)).getClass());
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueAlongsideRoot() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("</queue>");
        out.println("<queue name=\"other\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueNameContainingPeriods() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"parent1.child1\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueNameContainingOnlyWhitespace() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"      \">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test
    public void testParentTagWithReservation() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"parent\" type=\"parent\">");
        out.println("<reservation>");
        out.println("</reservation>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        try {
            allocLoader.reloadAllocations();
        }
        catch (AllocationConfigurationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"The configuration settings for root.parent are invalid. A queue element that contains child queue elements or that has the type='parent' attribute cannot also include a reservation element.");
        }
    }

    @Test
    public void testParentWithReservation() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"parent\">");
        out.println("<reservation>");
        out.println("</reservation>");
        out.println(" <queue name=\"child\">");
        out.println(" </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        try {
            allocLoader.reloadAllocations();
        }
        catch (AllocationConfigurationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"The configuration settings for root.parent are invalid. A queue element that contains child queue elements or that has the type='parent' attribute cannot also include a reservation element.");
        }
    }

    @Test
    public void testParentTagWithChild() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"parent\" type=\"parent\">");
        out.println(" <queue name=\"child\">");
        out.println(" </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.PARENT)).contains("root.parent"));
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.parent.child"));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueNameContainingNBWhitespace() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ALLOC_FILE), StandardCharsets.UTF_8));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"\u00a0\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testDefaultQueueSchedulingModeIsFIFO() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>fifo</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test
    public void testReservableQueue() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"reservable\">");
        out.println("<reservation>");
        out.println("</reservation>");
        out.println("</queue>");
        out.println("<queue name=\"other\">");
        out.println("</queue>");
        out.println("<reservation-agent>DummyAgentName</reservation-agent>");
        out.println("<reservation-policy>AnyAdmissionPolicy</reservation-policy>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        String reservableQueueName = "root.reservable";
        String nonreservableQueueName = "root.other";
        Assert.assertFalse((boolean)allocConf.isReservable(nonreservableQueueName));
        Assert.assertTrue((boolean)allocConf.isReservable(reservableQueueName));
        Map configuredQueues = allocConf.getConfiguredQueues();
        Assert.assertTrue((String)"reservable queue is expected be to a parent queue", (boolean)((Set)configuredQueues.get(FSQueueType.PARENT)).contains(reservableQueueName));
        Assert.assertFalse((String)"reservable queue should not be a leaf queue", (boolean)((Set)configuredQueues.get(FSQueueType.LEAF)).contains(reservableQueueName));
        Assert.assertTrue((boolean)allocConf.getMoveOnExpiry(reservableQueueName));
        Assert.assertEquals((long)86400000L, (long)allocConf.getReservationWindow(reservableQueueName));
        Assert.assertEquals((double)100.0, (double)allocConf.getInstantaneousMaxCapacity(reservableQueueName), (double)1.0E-4);
        Assert.assertEquals((Object)"DummyAgentName", (Object)allocConf.getReservationAgent(reservableQueueName));
        Assert.assertEquals((double)100.0, (double)allocConf.getAverageCapacity(reservableQueueName), (double)0.001);
        Assert.assertFalse((boolean)allocConf.getShowReservationAsQueues(reservableQueueName));
        Assert.assertEquals((Object)"AnyAdmissionPolicy", (Object)allocConf.getReservationAdmissionPolicy(reservableQueueName));
        Assert.assertEquals((Object)"org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.SimpleCapacityReplanner", (Object)allocConf.getReplanner(reservableQueueName));
        Assert.assertEquals((long)3600000L, (long)allocConf.getEnforcementWindow(reservableQueueName));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testReservableCannotBeCombinedWithDynamicUserQueue() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"notboth\" type=\"parent\" >");
        out.println("<reservation>");
        out.println("</reservation>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    private class ReloadListener
    implements AllocationFileLoaderService.Listener {
        public AllocationConfiguration allocConf;

        private ReloadListener() {
        }

        public void onReload(AllocationConfiguration info) {
            this.allocConf = info;
        }

        public void onCheck() {
        }
    }
}

