/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;

public class MockSchedulableEntity
implements SchedulableEntity {
    private String id;
    private long serial = 0L;
    private Priority priority;
    private boolean isRecovering;
    private ResourceUsage schedulingResourceUsage = new ResourceUsage();

    public MockSchedulableEntity() {
    }

    public MockSchedulableEntity(long serial, int priority2, boolean isRecovering) {
        this.serial = serial;
        this.priority = Priority.newInstance((int)priority2);
        this.isRecovering = isRecovering;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setSerial(long serial) {
        this.serial = serial;
    }

    public long getSerial() {
        return this.serial;
    }

    public void setUsed(Resource value) {
        this.schedulingResourceUsage.setUsed("*", value);
    }

    public void setPending(Resource value) {
        this.schedulingResourceUsage.setPending("*", value);
    }

    public ResourceUsage getSchedulingResourceUsage() {
        return this.schedulingResourceUsage;
    }

    public int compareInputOrderTo(SchedulableEntity other) {
        if (other instanceof MockSchedulableEntity) {
            MockSchedulableEntity r2 = (MockSchedulableEntity)other;
            int res = (int)Math.signum(this.getSerial() - r2.getSerial());
            return res;
        }
        return 1;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setApplicationPriority(Priority priority2) {
        this.priority = priority2;
    }

    public boolean isRecovering() {
        return this.isRecovering;
    }

    protected void setRecovering(boolean entityRecovering) {
        this.isRecovering = entityRecovering;
    }
}

