/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import io.hops.security.AbstractSecurityActions;
import io.hops.security.BaseTestHopsworksSecurityActions;
import io.hops.security.HopsSecurityActionsFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.DateUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
public class TestHopsworksRMAppSecurityActions
extends BaseTestHopsworksSecurityActions {
    private static final Log LOG = LogFactory.getLog(TestHopsworksRMAppSecurityActions.class);
    private static final String O = "application_id";
    private static final String OU = "1";
    private static final String KEYSTORE_LOCATION = "/path/to/keystore";
    private static final String KEYSTORE_PASS = "12345";
    private static final String JWT_SUBJECT = "ProjectA1__Flock";
    private static String classPath;
    private Path sslServerPath;
    private Configuration conf;
    private Configuration sslServer;
    @Rule
    public final ExpectedException rule = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        classPath = KeyStoreTestUtil.getClasspathDir(TestHopsworksRMAppSecurityActions.class);
        byte[] jwtIssuerSecret = new byte[32];
        Random rand = new Random();
        rand.nextBytes(jwtIssuerSecret);
    }

    @Before
    public void beforeTest() throws Exception {
        HopsSecurityActionsFactory.getInstance().clear(this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        this.conf = new Configuration();
        String sslConfFilename = TestHopsworksRMAppSecurityActions.class.getSimpleName() + ".ssl-server.xml";
        this.sslServerPath = Paths.get(classPath, sslConfFilename);
        Pair jwtResponse = this.loginAndGetJWT();
        this.sslServer = new Configuration(false);
        this.sslServer.set("hops.jwt-manager.master-token", (String)jwtResponse.getFirst());
        for (int i = 0; i < ((String[])jwtResponse.getSecond()).length; ++i) {
            String renewalConfKey = String.format("hops.jwt-manager.renew-token-%d", i);
            this.sslServer.set(renewalConfKey, ((String[])jwtResponse.getSecond())[i]);
        }
        this.sslServer.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.location"), KEYSTORE_LOCATION);
        this.sslServer.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.password"), KEYSTORE_PASS);
        KeyStoreTestUtil.saveConfig((File)this.sslServerPath.toFile(), (Configuration)this.sslServer);
        this.conf.set("hadoop.ssl.server.conf", sslConfFilename);
        this.conf.set("hops.hopsworks.host", this.HOPSWORKS_ENDPOINT);
        this.conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.DevHopsworksRMAppSecurityActions");
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        this.conf.setBoolean(YarnConfiguration.RM_JWT_ENABLED, true);
    }

    @After
    public void afterTest() throws Exception {
        AbstractSecurityActions actorService = HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        actorService.stop();
        if (this.sslServerPath != null) {
            this.sslServerPath.toFile().delete();
        }
    }

    @Test
    public void testSign() throws Exception {
        PKCS10CertificationRequest csr = this.generateCSR(UUID.randomUUID().toString());
        RMAppSecurityActions actor = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        X509SecurityHandler.CertificateBundle singedBundle = actor.sign(csr);
        Assert.assertNotNull((Object)singedBundle);
    }

    @Test
    public void testRevoke() throws Exception {
        String cn = UUID.randomUUID().toString();
        PKCS10CertificationRequest csr = this.generateCSR(cn);
        RMAppSecurityActions actor = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        actor.sign(csr);
        int response = actor.revoke(cn + "__" + O + "__" + OU);
        Assert.assertEquals((long)200L, (long)response);
    }

    private PKCS10CertificationRequest generateCSR(String cn) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.CN, cn);
        x500NameBuilder.addRDN(BCStyle.O, O);
        x500NameBuilder.addRDN(BCStyle.OU, OU);
        X500Name x500Name = x500NameBuilder.build();
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(x500Name, keyPair.getPublic());
        return csrBuilder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(keyPair.getPrivate()));
    }

    @Test
    public void testGenerateJWT() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam = this.createJWTParameter(appId);
        RMAppSecurityActions actor = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        String jwt = actor.generateJWT(jwtParam);
        Assert.assertNotNull((Object)jwt);
        String[] tokenizedSubject = JWT_SUBJECT.split("__");
        JWT decoded = JWTParser.parse((String)jwt);
        String subject = decoded.getJWTClaimsSet().getSubject();
        Assert.assertEquals((Object)tokenizedSubject[1], (Object)subject);
        appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)2);
        jwtParam = new JWTSecurityHandler.JWTMaterialParameter(appId, "dorothy");
        jwtParam.setRenewable(false);
        LocalDateTime now = DateUtils.getNow();
        LocalDateTime expiresAt = now.plus(10L, ChronoUnit.MINUTES);
        jwtParam.setExpirationDate(expiresAt);
        jwtParam.setValidNotBefore(now);
        jwtParam.setAudiences(new String[]{"job"});
        jwt = actor.generateJWT(jwtParam);
        decoded = JWTParser.parse((String)jwt);
        subject = decoded.getJWTClaimsSet().getSubject();
        Assert.assertEquals((Object)"dorothy", (Object)subject);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        LocalDateTime nbfFromToken = DateUtils.date2LocalDateTime((Date)decoded.getJWTClaimsSet().getNotBeforeTime());
        Assert.assertEquals((Object)now.format(formatter), (Object)nbfFromToken.format(formatter));
        LocalDateTime expirationFromToken = DateUtils.date2LocalDateTime((Date)decoded.getJWTClaimsSet().getExpirationTime());
        Assert.assertEquals((Object)expiresAt.format(formatter), (Object)expirationFromToken.format(formatter));
    }

    @Test
    public void testInvalidateJWT() throws Exception {
        String signingKeyName = "lala";
        RMAppSecurityActions actor = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        actor.invalidateJWT(signingKeyName);
    }

    @Test
    public void testGenerateJWTSameSigningKeyShouldFail() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam = this.createJWTParameter(appId);
        RMAppSecurityActions actor = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        actor.generateJWT(jwtParam);
        this.rule.expect(IOException.class);
        actor.generateJWT(jwtParam);
    }

    @Test
    public void testGenerateJWTInvalidateGenerate() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam = this.createJWTParameter(appId);
        RMAppSecurityActions actor = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        String jwt0 = actor.generateJWT(jwtParam);
        Assert.assertNotNull((Object)jwt0);
        actor.invalidateJWT(appId.toString());
        String jwt1 = actor.generateJWT(jwtParam);
        Assert.assertNotEquals((Object)jwt0, (Object)jwt1);
    }

    @Test(timeout=15000L)
    public void testRenewJWT() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam0 = this.createJWTParameter(appId, 2L, ChronoUnit.SECONDS);
        RMAppSecurityActions actor = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        String jwt0 = actor.generateJWT(jwtParam0);
        TimeUnit.SECONDS.sleep(10L);
        JWTSecurityHandler.JWTMaterialParameter jwtParam1 = this.createJWTParameter(appId);
        jwtParam1.setToken(jwt0);
        String jwt1 = actor.renewJWT(jwtParam1);
        Assert.assertNotNull((Object)jwt1);
        Assert.assertNotEquals((Object)jwt0, (Object)jwt1);
    }

    private JWTSecurityHandler.JWTMaterialParameter createJWTParameter(ApplicationId appId) {
        return this.createJWTParameter(appId, 10L, ChronoUnit.MINUTES);
    }

    private JWTSecurityHandler.JWTMaterialParameter createJWTParameter(ApplicationId appId, long amountToAdd, TemporalUnit unit) {
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(appId, JWT_SUBJECT);
        jwtParam.setRenewable(false);
        LocalDateTime now = DateUtils.getNow();
        LocalDateTime expiresAt = now.plus(amountToAdd, unit);
        jwtParam.setExpirationDate(expiresAt);
        jwtParam.setValidNotBefore(now);
        jwtParam.setAudiences(new String[]{"job"});
        return jwtParam;
    }
}

