/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesDelegationTokenAuthentication;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRMWebappAuthentication {
    private static MockRM rm;
    private static Configuration simpleConf;
    private static Configuration kerberosConf;
    private static final File testRootDir;
    private static File httpSpnegoKeytabFile;
    private static boolean miniKDCStarted;
    private static MiniKdc testMiniKDC;

    @Parameterized.Parameters
    public static Collection params() {
        return Arrays.asList({1, simpleConf}, {2, kerberosConf});
    }

    public TestRMWebappAuthentication(int run, Configuration conf) {
        TestRMWebappAuthentication.setupAndStartRM(conf);
    }

    @BeforeClass
    public static void setUp() {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
            TestRMWebappAuthentication.setupKDC();
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't create MiniKDC", (boolean)false);
        }
    }

    @AfterClass
    public static void tearDown() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
    }

    private static void setupKDC() throws Exception {
        if (!miniKDCStarted) {
            testMiniKDC.start();
            TestRMWebappAuthentication.getKdc().createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost", "client", UserGroupInformation.getLoginUser().getShortUserName()});
            miniKDCStarted = true;
        }
    }

    private static MiniKdc getKdc() {
        return testMiniKDC;
    }

    private static void setupAndStartRM(Configuration conf) {
        UserGroupInformation.setConfiguration((Configuration)conf);
        rm = new MockRM(conf);
    }

    @Test
    public void testSimpleAuth() throws Exception {
        rm.start();
        URL url = new URL("http://localhost:8088/cluster");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.getInputStream();
            Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)conn.getResponseCode());
        }
        catch (Exception e) {
            Assert.fail((String)"Fetching url failed");
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            this.testAnonymousKerberosUser();
        } else {
            this.testAnonymousSimpleUser();
        }
        rm.stop();
    }

    private void testAnonymousKerberosUser() throws Exception {
        ApplicationSubmissionContextInfo app = new ApplicationSubmissionContextInfo();
        String appid = "application_123_0";
        app.setApplicationId(appid);
        String requestBody = TestRMWebServicesDelegationTokenAuthentication.getMarshalledAppInfo(app);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/apps/new-application");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/xml", requestBody);
        try {
            conn.getInputStream();
            Assert.fail((String)"Anonymous users should not be allowed to get new application ids in secure mode.");
        }
        catch (IOException ie) {
            Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
        }
        url = new URL("http://localhost:8088/ws/v1/cluster/apps");
        conn = (HttpURLConnection)url.openConnection();
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/xml", requestBody);
        try {
            conn.getInputStream();
            Assert.fail((String)"Anonymous users should not be allowed to submit apps in secure mode.");
        }
        catch (IOException ie) {
            Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
        }
        requestBody = "{ \"state\": \"KILLED\"}";
        url = new URL("http://localhost:8088/ws/v1/cluster/apps/application_123_0/state");
        conn = (HttpURLConnection)url.openConnection();
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "PUT", "application/json", requestBody);
        try {
            conn.getInputStream();
            Assert.fail((String)"Anonymous users should not be allowed to kill apps in secure mode.");
        }
        catch (IOException ie) {
            Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
        }
    }

    private void testAnonymousSimpleUser() throws Exception {
        ApplicationSubmissionContextInfo app = new ApplicationSubmissionContextInfo();
        String appid = "application_123_0";
        app.setApplicationId(appid);
        String requestBody = TestRMWebServicesDelegationTokenAuthentication.getMarshalledAppInfo(app);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/apps");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/xml", requestBody);
        conn.getInputStream();
        Assert.assertEquals((long)ClientResponse.Status.ACCEPTED.getStatusCode(), (long)conn.getResponseCode());
        boolean appExists = rm.getRMContext().getRMApps().containsKey(ApplicationId.fromString((String)appid));
        Assert.assertTrue((boolean)appExists);
        RMApp actualApp = (RMApp)rm.getRMContext().getRMApps().get(ApplicationId.fromString((String)appid));
        String owner = actualApp.getUser();
        Assert.assertEquals((Object)rm.getConfig().get("hadoop.http.staticuser.user", "dr.who"), (Object)owner);
        appid = "application_123_1";
        app.setApplicationId(appid);
        requestBody = TestRMWebServicesDelegationTokenAuthentication.getMarshalledAppInfo(app);
        url = new URL("http://localhost:8088/ws/v1/cluster/apps?user.name=client");
        conn = (HttpURLConnection)url.openConnection();
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "POST", "application/xml", requestBody);
        conn.getInputStream();
        appExists = rm.getRMContext().getRMApps().containsKey(ApplicationId.fromString((String)appid));
        Assert.assertTrue((boolean)appExists);
        actualApp = (RMApp)rm.getRMContext().getRMApps().get(ApplicationId.fromString((String)appid));
        owner = actualApp.getUser();
        Assert.assertEquals((Object)"client", (Object)owner);
    }

    static {
        testRootDir = new File("target", TestRMWebServicesDelegationTokenAuthentication.class.getName() + "-root");
        httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
        miniKDCStarted = false;
        simpleConf = new Configuration();
        simpleConf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        simpleConf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        simpleConf.setBoolean("mockrm.webapp.enabled", true);
        kerberosConf = new Configuration();
        kerberosConf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        kerberosConf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        kerberosConf.setBoolean("yarn.acl.enable", true);
        kerberosConf.set("hadoop.security.authentication", "kerberos");
        kerberosConf.set("yarn.resourcemanager.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        kerberosConf.setBoolean("mockrm.webapp.enabled", true);
    }
}

