/*
 * Decompiled with CFR 0.152.
 */
package io.hops.yarn.server.resourcemanager.quota;

import com.google.common.collect.ImmutableMap;
import io.hops.StorageConnector;
import io.hops.metadata.yarn.dal.quota.PriceMultiplicatorDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.metadata.yarn.entity.quota.PriceMultiplicator;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPriceMultiplicationFactorService {
    private static final Log LOG = LogFactory.getLog(TestPriceMultiplicationFactorService.class);
    private StorageConnector connector = null;
    private Configuration conf = null;
    private static final int WAIT_SLEEP_MS = 100;
    private final int GB = 1024;
    private volatile boolean stopped = false;

    @Before
    public void setup() throws IOException {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.resourcemanager.quota.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.quota.variable.price.enabled", true);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
    }

    @Test
    public void TestMultiplicatorEvaluation() throws Exception {
        this.conf.setFloat("yarn.resourcemanager.quota.multiplicator.threshold.general", 0.2f);
        this.conf.setFloat("yarn.resourcemanager.quota.multiplicator.threshold.gpu", 0.2f);
        this.conf.setFloat("yarn.resourcemanager.quota.multiplicator.increment.general", 10.0f);
        this.conf.setFloat("yarn.resourcemanager.quota.multiplicator.increment.gpu", 20.0f);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        this.conf.set("yarn.nodemanager.resource-plugins", "yarn.io/gpu");
        this.conf.set("yarn.resource-types", "yarn.io/gpu");
        MockRM rm = new MockRM(this.conf);
        rm.start();
        this.ConsumeSomeResources(rm);
        Thread.sleep(1000L);
        this.CheckCurrentMultiplicator(4.0f, 17.0f);
    }

    private void ConsumeSomeResources(MockRM rm) throws Exception {
        MockNM nm1 = rm.registerNode("h1:1234", 4096);
        MockNM nm2 = rm.registerNode("h2:5678", TestUtils.createResource(10240L, 10, (Map<String, Integer>)ImmutableMap.builder().put((Object)"yarn.io/gpu", (Object)1).build()));
        RMApp app = rm.submitApp(1024);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        int request = 3;
        am.allocate("h1", 1024, request, new ArrayList<ContainerId>());
        List conts = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        int contReceived = conts.size();
        while (contReceived < request) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            contReceived = conts.size();
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)request, (long)conts.size());
        Thread.sleep(5000L);
        request = 2;
        am.allocate("h1", 1024, request, new ArrayList<ContainerId>());
        conts = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        contReceived = conts.size();
        while (contReceived < request) {
            nm2.nodeHeartbeat(true);
            conts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            contReceived = conts.size();
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)request, (long)conts.size());
        am.allocate("h1", 1024, 1, new ArrayList<ContainerId>(), 1);
        conts = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        contReceived = conts.size();
        while (contReceived < 1) {
            nm2.nodeHeartbeat(true);
            conts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            contReceived = conts.size();
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)conts.size());
        Thread.sleep(1000L);
    }

    private void CheckCurrentMultiplicator(float generalMultiplicator, float gpuMultiplicator) throws Exception {
        LightWeightRequestHandler currentMultiplicatorHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                PriceMultiplicatorDataAccess pmDA = (PriceMultiplicatorDataAccess)RMStorageFactory.getDataAccess(PriceMultiplicatorDataAccess.class);
                Map priceList = pmDA.getAll();
                connector.commit();
                return priceList;
            }
        };
        Map currentMultiplicators = new HashMap();
        for (int nbTry = 0; nbTry < 10 && (((PriceMultiplicator)(currentMultiplicators = (Map)currentMultiplicatorHandler.handle()).get(PriceMultiplicator.MultiplicatorType.GENERAL)).getValue() != generalMultiplicator || ((PriceMultiplicator)currentMultiplicators.get(PriceMultiplicator.MultiplicatorType.GPU)).getValue() != gpuMultiplicator); ++nbTry) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((float)generalMultiplicator, (float)((PriceMultiplicator)currentMultiplicators.get(PriceMultiplicator.MultiplicatorType.GENERAL)).getValue(), (float)0.0f);
        Assert.assertEquals((float)gpuMultiplicator, (float)((PriceMultiplicator)currentMultiplicators.get(PriceMultiplicator.MultiplicatorType.GPU)).getValue(), (float)0.0f);
    }
}

