/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestApplicationLimits {
    private static final Log LOG = LogFactory.getLog(TestApplicationLimits.class);
    static final int GB = 1024;
    LeafQueue queue;
    CSQueue root;
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    RMContext rmContext = null;
    private static final String A = "a";
    private static final String B = "b";

    @Before
    public void setUp() throws IOException {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        YarnConfiguration conf = new YarnConfiguration();
        this.setupQueueConfiguration(csConf);
        this.rmContext = TestUtils.getMockRMContext();
        Resource clusterResource = Resources.createResource((int)163840, (int)320);
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)csContext.getRMContext()).thenReturn((Object)this.rmContext);
        Mockito.when((Object)csContext.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)conf);
        containerTokenSecretManager.rollMasterKey();
        Mockito.when((Object)csContext.getContainerTokenSecretManager()).thenReturn((Object)containerTokenSecretManager);
        HashMap queues = new HashMap();
        this.root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        this.queue = (LeafQueue)Mockito.spy((Object)new LeafQueue(csContext, A, this.root, null));
        QueueResourceQuotas queueResourceQuotas = ((LeafQueue)queues.get(A)).getQueueResourceQuotas();
        ((LeafQueue)Mockito.doReturn((Object)queueResourceQuotas).when((Object)this.queue)).getQueueResourceQuotas();
        ((LeafQueue)Mockito.doReturn((Object)true).when((Object)this.queue)).hasAccess((QueueACL)Matchers.any(QueueACL.class), (UserGroupInformation)Matchers.any(UserGroupInformation.class));
        ((LeafQueue)Mockito.doReturn((Object)100).when((Object)this.queue)).getMaxApplications();
        ((LeafQueue)Mockito.doReturn((Object)25).when((Object)this.queue)).getMaxApplicationsPerUser();
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{A, B});
        String Q_A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        String Q_B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        conf.setUserLimit("root.a", 50);
        conf.setUserLimitFactor("root.a", 5.0f);
        LOG.info((Object)"Setup top-level queues a and b");
    }

    private FiCaSchedulerApp getMockApplication(int appId, String user, Resource amResource) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ApplicationAttemptId applicationAttemptId = TestUtils.getMockApplicationAttemptId(appId, 0);
        ((FiCaSchedulerApp)Mockito.doReturn((Object)applicationAttemptId.getApplicationId()).when((Object)application)).getApplicationId();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)applicationAttemptId).when((Object)application)).getApplicationAttemptId();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)user).when((Object)application)).getUser();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)amResource).when((Object)application)).getAMResource();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)Priority.newInstance((int)0)).when((Object)application)).getPriority();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)"").when((Object)application)).getAppAMNodePartitionName();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)amResource).when((Object)application)).getAMResource("");
        Mockito.when((Object)application.compareInputOrderTo((SchedulableEntity)Matchers.any(FiCaSchedulerApp.class))).thenCallRealMethod();
        return application;
    }

    @Test
    public void testAMResourceLimit() throws Exception {
        String user_0 = "user_0";
        String user_1 = "user_1";
        Resource clusterResource = Resource.newInstance((int)81920, (int)40);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        this.queue.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        ActiveUsersManager activeUsersManager = (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class);
        Mockito.when((Object)this.queue.getAbstractUsersManager()).thenReturn((Object)activeUsersManager);
        Assert.assertEquals((Object)Resource.newInstance((int)8192, (int)1), (Object)this.queue.calculateAndGetAMResourceLimit());
        Assert.assertEquals((Object)Resource.newInstance((int)4096, (int)1), (Object)this.queue.getUserAMResourceLimit());
        int APPLICATION_ID = 0;
        FiCaSchedulerApp app_0 = this.getMockApplication(APPLICATION_ID++, "user_0", Resource.newInstance((int)2048, (int)1));
        this.queue.submitApplicationAttempt(app_0, "user_0");
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Mockito.when((Object)activeUsersManager.getNumActiveUsers()).thenReturn((Object)1);
        FiCaSchedulerApp app_1 = this.getMockApplication(APPLICATION_ID++, "user_0", Resource.newInstance((int)2048, (int)1));
        this.queue.submitApplicationAttempt(app_1, "user_0");
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertEquals((Object)Resource.newInstance((int)8192, (int)1), (Object)this.queue.getAMResourceLimit());
        Assert.assertEquals((Object)Resource.newInstance((int)4096, (int)1), (Object)this.queue.getUserAMResourceLimit());
        FiCaSchedulerApp app_2 = this.getMockApplication(APPLICATION_ID++, "user_1", Resource.newInstance((int)2048, (int)1));
        this.queue.submitApplicationAttempt(app_2, "user_1");
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_1"));
        Mockito.when((Object)activeUsersManager.getNumActiveUsers()).thenReturn((Object)2);
        Assert.assertEquals((Object)Resource.newInstance((int)8192, (int)1), (Object)this.queue.getAMResourceLimit());
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)1), (Object)this.queue.getUserAMResourceLimit());
        FiCaSchedulerApp app_3 = this.getMockApplication(APPLICATION_ID++, "user_1", Resource.newInstance((int)2048, (int)1));
        this.queue.submitApplicationAttempt(app_3, "user_1");
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_1"));
        this.queue.finishApplicationAttempt(app_2, A);
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_1"));
    }

    @Test
    public void testLimitsComputation() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)16));
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)csContext.getRMContext()).thenReturn((Object)this.rmContext);
        Mockito.when((Object)csContext.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        Resource clusterResource = Resources.createResource((int)0x190000, (int)1600);
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        HashMap queues = new HashMap();
        CSQueue root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        LeafQueue queue = (LeafQueue)queues.get(A);
        LOG.info((Object)("Queue 'A' - aMResourceLimit=" + queue.getAMResourceLimit() + " UserAMResourceLimit=" + queue.getUserAMResourceLimit()));
        Resource amResourceLimit = Resource.newInstance((int)163840, (int)1);
        Assert.assertEquals((Object)queue.calculateAndGetAMResourceLimit(), (Object)amResourceLimit);
        Assert.assertEquals((Object)queue.getUserAMResourceLimit(), (Object)Resource.newInstance((int)81920, (int)1));
        Assert.assertEquals((long)queue.getMetrics().getAMResourceLimitMB(), (long)amResourceLimit.getMemorySize());
        Assert.assertEquals((long)queue.getMetrics().getAMResourceLimitVCores(), (long)amResourceLimit.getVirtualCores());
        Assert.assertEquals((long)((int)((float)clusterResource.getMemorySize() * queue.getAbsoluteCapacity())), (long)queue.getMetrics().getAvailableMB());
        clusterResource = Resources.createResource((int)0x1E0000);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((Object)queue.calculateAndGetAMResourceLimit(), (Object)Resource.newInstance((int)196608, (int)1));
        Assert.assertEquals((Object)queue.getUserAMResourceLimit(), (Object)Resource.newInstance((int)98304, (int)1));
        Assert.assertEquals((long)((int)((float)clusterResource.getMemorySize() * queue.getAbsoluteCapacity())), (long)queue.getMetrics().getAvailableMB());
        Assert.assertEquals((long)-1L, (long)csConf.getMaximumApplicationsPerQueue(queue.getQueuePath()));
        int expectedMaxApps = (int)(10000.0f * queue.getAbsoluteCapacity());
        Assert.assertEquals((long)expectedMaxApps, (long)queue.getMaxApplications());
        int expectedMaxAppsPerUser = Math.min(expectedMaxApps, (int)((float)expectedMaxApps * ((float)queue.getUserLimit() / 100.0f) * queue.getUserLimitFactor()));
        Assert.assertEquals((long)expectedMaxAppsPerUser, (long)queue.getMaxApplicationsPerUser());
        Assert.assertEquals((long)0L, (long)((long)csConf.getMaximumApplicationMasterResourcePerQueuePercent(queue.getQueuePath())));
        csConf.setFloat("yarn.scheduler.capacity." + queue.getQueuePath() + ".maximum-am-resource-percent", 0.5f);
        queues = new HashMap();
        root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        clusterResource = Resources.createResource((int)0x190000);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        queue = (LeafQueue)queues.get(A);
        Assert.assertEquals((long)0L, (long)((long)csConf.getMaximumApplicationMasterResourcePerQueuePercent(queue.getQueuePath())));
        Assert.assertEquals((Object)queue.calculateAndGetAMResourceLimit(), (Object)Resource.newInstance((int)819200, (int)1));
        Assert.assertEquals((Object)queue.getUserAMResourceLimit(), (Object)Resource.newInstance((int)409600, (int)1));
        csConf.setInt("yarn.scheduler.capacity." + queue.getQueuePath() + ".maximum-applications", 9999);
        queues = new HashMap();
        root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        queue = (LeafQueue)queues.get(A);
        Assert.assertEquals((long)9999L, (long)csConf.getMaximumApplicationsPerQueue(queue.getQueuePath()));
        Assert.assertEquals((long)9999L, (long)queue.getMaxApplications());
        expectedMaxAppsPerUser = Math.min(9999, (int)(9999.0f * ((float)queue.getUserLimit() / 100.0f) * queue.getUserLimitFactor()));
        Assert.assertEquals((long)expectedMaxAppsPerUser, (long)queue.getMaxApplicationsPerUser());
    }

    @Test
    public void testActiveApplicationLimits() throws Exception {
        String user_0 = "user_0";
        String user_1 = "user_1";
        String user_2 = "user_2";
        Assert.assertEquals((Object)Resource.newInstance((int)16384, (int)1), (Object)this.queue.calculateAndGetAMResourceLimit());
        Assert.assertEquals((Object)Resource.newInstance((int)8192, (int)1), (Object)this.queue.getUserAMResourceLimit());
        int APPLICATION_ID = 0;
        FiCaSchedulerApp app_0 = this.getMockApplication(APPLICATION_ID++, "user_0", Resources.createResource((int)4096, (int)0));
        this.queue.submitApplicationAttempt(app_0, "user_0");
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        FiCaSchedulerApp app_1 = this.getMockApplication(APPLICATION_ID++, "user_0", Resources.createResource((int)4096, (int)0));
        this.queue.submitApplicationAttempt(app_1, "user_0");
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        FiCaSchedulerApp app_2 = this.getMockApplication(APPLICATION_ID++, "user_0", Resources.createResource((int)4096, (int)0));
        this.queue.submitApplicationAttempt(app_2, "user_0");
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        this.queue.finishApplicationAttempt(app_0, A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        FiCaSchedulerApp app_3 = this.getMockApplication(APPLICATION_ID++, "user_0", Resources.createResource((int)4096, (int)0));
        this.queue.submitApplicationAttempt(app_3, "user_0");
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        FiCaSchedulerApp app_4 = this.getMockApplication(APPLICATION_ID++, "user_1", Resources.createResource((int)8192, (int)0));
        this.queue.submitApplicationAttempt(app_4, "user_1");
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_1"));
        FiCaSchedulerApp app_5 = this.getMockApplication(APPLICATION_ID++, "user_2", Resources.createResource((int)8192, (int)0));
        this.queue.submitApplicationAttempt(app_5, "user_2");
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_1"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_2"));
        this.queue.finishApplicationAttempt(app_4, A);
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_1"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_2"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_2"));
    }

    @Test
    public void testActiveLimitsWithKilledApps() throws Exception {
        String user_0 = "user_0";
        int APPLICATION_ID = 0;
        FiCaSchedulerApp app_0 = this.getMockApplication(APPLICATION_ID++, "user_0", Resources.createResource((int)4096, (int)0));
        this.queue.submitApplicationAttempt(app_0, "user_0");
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.getApplications().contains(app_0));
        FiCaSchedulerApp app_1 = this.getMockApplication(APPLICATION_ID++, "user_0", Resources.createResource((int)4096, (int)0));
        this.queue.submitApplicationAttempt(app_1, "user_0");
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.getApplications().contains(app_1));
        FiCaSchedulerApp app_2 = this.getMockApplication(APPLICATION_ID++, "user_0", Resources.createResource((int)4096, (int)0));
        this.queue.submitApplicationAttempt(app_2, "user_0");
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.getPendingApplications().contains(app_2));
        FiCaSchedulerApp app_3 = this.getMockApplication(APPLICATION_ID++, "user_0", Resources.createResource((int)4096, (int)0));
        this.queue.submitApplicationAttempt(app_3, "user_0");
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)2L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.getPendingApplications().contains(app_3));
        this.queue.finishApplicationAttempt(app_2, A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertFalse((boolean)this.queue.getPendingApplications().contains(app_2));
        Assert.assertFalse((boolean)this.queue.getApplications().contains(app_2));
        this.queue.finishApplicationAttempt(app_0, A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.getApplications().contains(app_3));
        Assert.assertFalse((boolean)this.queue.getPendingApplications().contains(app_3));
        Assert.assertFalse((boolean)this.queue.getApplications().contains(app_0));
        this.queue.finishApplicationAttempt(app_1, A);
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertFalse((boolean)this.queue.getApplications().contains(app_1));
        this.queue.finishApplicationAttempt(app_3, A);
        Assert.assertEquals((long)0L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertFalse((boolean)this.queue.getApplications().contains(app_3));
    }

    @Test
    public void testHeadroom() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setUserLimit("root.a", 25);
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384));
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)csContext.getRMContext()).thenReturn((Object)this.rmContext);
        Mockito.when((Object)csContext.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        Resource clusterResource = Resources.createResource((int)0x190000);
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        HashMap queues = new HashMap();
        CSQueue rootQueue = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        rootQueue.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        ResourceUsage queueCapacities = rootQueue.getQueueResourceUsage();
        Mockito.when((Object)csContext.getClusterResourceUsage()).thenReturn((Object)queueCapacities);
        LeafQueue queue = TestLeafQueue.stubLeafQueue((LeafQueue)queues.get(A));
        queue.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        String host_0 = "host_0";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, rack_0, 0, 16384);
        String user_0 = "user_0";
        String user_1 = "user_1";
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        RMContext rmContext = TestUtils.getMockRMContext();
        RMContext spyRMContext = (RMContext)Mockito.spy((Object)rmContext);
        ConcurrentMap spyApps = (ConcurrentMap)Mockito.spy(new ConcurrentHashMap());
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        ResourceRequest amResourceRequest = (ResourceRequest)Mockito.mock(ResourceRequest.class);
        Resource amResource = Resources.createResource((int)0, (int)0);
        Mockito.when((Object)amResourceRequest.getCapability()).thenReturn((Object)amResource);
        Mockito.when((Object)rmApp.getAMResourceRequests()).thenReturn(Collections.singletonList(amResourceRequest));
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)spyApps)).get((ApplicationId)Matchers.any());
        Mockito.when((Object)spyRMContext.getRMApps()).thenReturn((Object)spyApps);
        RMAppAttempt rmAppAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)rmApp.getRMAppAttempt((ApplicationAttemptId)Matchers.any())).thenReturn((Object)rmAppAttempt);
        Mockito.when((Object)rmApp.getCurrentAppAttempt()).thenReturn((Object)rmAppAttempt);
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)spyApps)).get((ApplicationId)Matchers.any());
        ((ConcurrentMap)Mockito.doReturn((Object)true).when((Object)spyApps)).containsKey((ApplicationId)Matchers.any());
        Priority priority_1 = TestUtils.createMockPriority(1);
        ApplicationAttemptId appAttemptId_0_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0_0 = new FiCaSchedulerApp(appAttemptId_0_0, "user_0", (Queue)queue, queue.getAbstractUsersManager(), spyRMContext);
        queue.submitApplicationAttempt(app_0_0, "user_0");
        ArrayList<ResourceRequest> app_0_0_requests = new ArrayList<ResourceRequest>();
        app_0_0_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_0_0.updateResourceRequests(app_0_0_requests);
        queue.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        Resource expectedHeadroom = Resources.createResource((int)81920, (int)1);
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_0.getHeadroom());
        ApplicationAttemptId appAttemptId_0_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_0_1 = new FiCaSchedulerApp(appAttemptId_0_1, "user_0", (Queue)queue, queue.getAbstractUsersManager(), spyRMContext);
        queue.submitApplicationAttempt(app_0_1, "user_0");
        ArrayList<ResourceRequest> app_0_1_requests = new ArrayList<ResourceRequest>();
        app_0_1_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_0_1.updateResourceRequests(app_0_1_requests);
        queue.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_0.getHeadroom());
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_1.getHeadroom());
        ApplicationAttemptId appAttemptId_1_0 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_1_0 = new FiCaSchedulerApp(appAttemptId_1_0, "user_1", (Queue)queue, queue.getAbstractUsersManager(), spyRMContext);
        queue.submitApplicationAttempt(app_1_0, "user_1");
        ArrayList<ResourceRequest> app_1_0_requests = new ArrayList<ResourceRequest>();
        app_1_0_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_1_0.updateResourceRequests(app_1_0_requests);
        queue.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        expectedHeadroom = Resources.createResource((int)81920, (int)1);
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_0.getHeadroom());
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_1.getHeadroom());
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_1_0.getHeadroom());
        clusterResource = Resources.createResource((int)1474560);
        rootQueue.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        queue.getUsersManager().userLimitNeedsRecompute();
        queue.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        expectedHeadroom = Resources.createResource((int)73728, (int)1);
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_0.getHeadroom());
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_0_1.getHeadroom());
        Assert.assertEquals((Object)expectedHeadroom, (Object)app_1_0.getHeadroom());
    }

    private Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{A, B, "c", "d"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        conf.setCapacityByLabel("root", "z", 100.0f);
        conf.setInt("yarn.scheduler.capacity.global-queue-max-application", 20);
        conf.setInt("yarn.scheduler.capacity.root.a.a1.maximum-applications", 1);
        conf.setFloat("yarn.scheduler.capacity.root.d.user-limit-factor", 0.1f);
        conf.setInt("yarn.scheduler.capacity.maximum-applications", 4);
        String a = "root.a";
        String b = "root.b";
        String c = "root.c";
        String d = "root.d";
        String aa1 = "root.a.a1";
        String aa2 = "root.a.a2";
        String aa3 = "root.a.a3";
        conf.setQueues("root.a", new String[]{"a1", "a2", "a3"});
        conf.setCapacity("root.a", 50.0f);
        conf.setCapacity("root.b", 50.0f);
        conf.setCapacity("root.c", 0.0f);
        conf.setCapacity("root.d", 0.0f);
        conf.setCapacity("root.a.a1", 50.0f);
        conf.setCapacity("root.a.a2", 50.0f);
        conf.setCapacity("root.a.a3", 0.0f);
        conf.setCapacityByLabel("root.a", "y", 25.0f);
        conf.setCapacityByLabel("root.b", "y", 50.0f);
        conf.setCapacityByLabel("root.c", "y", 25.0f);
        conf.setCapacityByLabel("root.d", "y", 0.0f);
        conf.setCapacityByLabel("root.a", "x", 50.0f);
        conf.setCapacityByLabel("root.b", "x", 50.0f);
        conf.setCapacityByLabel("root.a", "z", 50.0f);
        conf.setCapacityByLabel("root.b", "z", 50.0f);
        conf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        conf.setCapacityByLabel("root.a.a2", "x", 0.0f);
        conf.setCapacityByLabel("root.a.a1", "y", 25.0f);
        conf.setCapacityByLabel("root.a.a2", "y", 75.0f);
        conf.setCapacityByLabel("root.a.a2", "z", 75.0f);
        conf.setCapacityByLabel("root.a.a3", "z", 25.0f);
        return conf;
    }

    private Set<String> toSet(String ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    @Test(timeout=120000L)
    public void testApplicationLimitSubmit() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)conf);
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager((RMNodeLabelsManager)mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 4096);
        MockNM nm2 = rm.registerNode("h2:1234", 4096);
        MockNM nm3 = rm.registerNode("h3:1234", 4096);
        RMApp app1 = rm.submitApp(1024, "app", "user", null, "c", false);
        rm.drainEvents();
        rm.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((Object)RMAppState.ACCEPTED, (Object)app1.getState());
        rm.killApp(app1.getApplicationId());
        RMApp app2 = rm.submitApp(1024, "app", "user", null, "a1", false);
        rm.drainEvents();
        rm.waitForState(app2.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((Object)RMAppState.ACCEPTED, (Object)app2.getState());
        RMApp app3 = rm.submitApp(1024, "app", "user", null, "a1", false);
        rm.drainEvents();
        rm.waitForState(app3.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)app3.getState());
        Assert.assertEquals((Object)("org.apache.hadoop.security.AccessControlException: Queue root.a.a1 already has 1 applications, cannot accept submission of application: " + app3.getApplicationId()), (Object)app3.getDiagnostics().toString());
        RMApp app11 = rm.submitApp(1024, "app", "user", null, "d", false);
        rm.drainEvents();
        rm.waitForState(app11.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((Object)RMAppState.ACCEPTED, (Object)app11.getState());
        RMApp app12 = rm.submitApp(1024, "app", "user", null, "d", false);
        rm.drainEvents();
        rm.waitForState(app12.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((Object)RMAppState.ACCEPTED, (Object)app12.getState());
        RMApp app13 = rm.submitApp(1024, "app", "user", null, "d", false);
        rm.drainEvents();
        rm.waitForState(app13.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)app13.getState());
        Assert.assertEquals((Object)("org.apache.hadoop.security.AccessControlException: Queue root.d already has 2 applications from user user cannot accept submission of application: " + app13.getApplicationId()), (Object)app13.getDiagnostics().toString());
        RMApp app14 = rm.submitApp(1024, "app", "user2", null, "a2", false);
        rm.drainEvents();
        rm.waitForState(app14.getApplicationId(), RMAppState.ACCEPTED);
        RMApp app15 = rm.submitApp(1024, "app", "user2", null, "a2", false);
        rm.drainEvents();
        rm.waitForState(app15.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)app15.getState());
        Assert.assertEquals((Object)("Maximum system application limit reached,cannot accept submission of application: " + app15.getApplicationId()), (Object)app15.getDiagnostics().toString());
        rm.killApp(app2.getApplicationId());
        rm.killApp(app11.getApplicationId());
        rm.killApp(app13.getApplicationId());
        rm.killApp(app14.getApplicationId());
        rm.stop();
    }
}

