/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueueProperties;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;

class AllocationFileQueue {
    private final AllocationFileQueueProperties properties;
    private final List<AllocationFileQueue> subQueues;

    AllocationFileQueue(AllocationFileQueueProperties properties, List<AllocationFileQueue> subQueues) {
        this.properties = properties;
        this.subQueues = subQueues;
    }

    String render() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printStartTag(pw);
        AllocationFileWriter.printQueues(pw, this.subQueues);
        AllocationFileWriter.addIfPresent(pw, "minResources", this.properties::getMinResources);
        AllocationFileWriter.addIfPresent(pw, "maxResources", this.properties::getMaxResources);
        AllocationFileWriter.addIfPresent(pw, "aclAdministerApps", this.properties::getAclAdministerApps);
        AllocationFileWriter.addIfPresent(pw, "aclSubmitApps", this.properties::getAclSubmitApps);
        AllocationFileWriter.addIfPresent(pw, "schedulingPolicy", this.properties::getSchedulingPolicy);
        AllocationFileWriter.addIfPresent(pw, "maxRunningApps", () -> AllocationFileWriter.createNumberSupplier(this.properties.getMaxRunningApps()));
        AllocationFileWriter.addIfPresent(pw, "maxAMShare", () -> AllocationFileWriter.createNumberSupplier(this.properties.getMaxAMShare()));
        AllocationFileWriter.addIfPresent(pw, "minSharePreemptionTimeout", () -> AllocationFileWriter.createNumberSupplier(this.properties.getMinSharePreemptionTimeout()));
        AllocationFileWriter.addIfPresent(pw, "maxChildResources", this.properties::getMaxChildResources);
        AllocationFileWriter.addIfPresent(pw, "fairSharePreemptionTimeout", () -> AllocationFileWriter.createNumberSupplier(this.properties.getFairSharePreemptionTimeout()));
        AllocationFileWriter.addIfPresent(pw, "fairSharePreemptionThreshold", () -> AllocationFileWriter.createNumberSupplier(this.properties.getFairSharePreemptionThreshold()));
        AllocationFileWriter.addIfPresent(pw, "maxContainerAllocation", () -> AllocationFileWriter.createNumberSupplier(this.properties.getMaxContainerAllocation()));
        this.printEndTag(pw);
        pw.close();
        return sw.toString();
    }

    private void printStartTag(PrintWriter pw) {
        pw.print("<queue name=\"" + this.properties.getQueueName() + "\" ");
        if (this.properties.getParent().booleanValue()) {
            pw.print("type=\"parent\"");
        }
        pw.println(">");
    }

    private void printEndTag(PrintWriter pw) {
        pw.println("</queue>");
    }
}

