/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.nodelabels.NodeAttributeStore;
import org.apache.hadoop.yarn.server.api.protocolrecords.AttributeMappingOperationType;
import org.apache.hadoop.yarn.server.resourcemanager.NodeAttributeTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.FileSystemNodeAttributeStore;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeAttributesManagerImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFileSystemNodeAttributeStore {
    private MockNodeAttrbuteManager mgr = null;
    private Configuration conf = null;

    @Before
    public void before() throws IOException {
        this.mgr = new MockNodeAttrbuteManager();
        this.conf = new Configuration();
        this.conf.setClass("yarn.node-attribute.fs-store.impl.class", FileSystemNodeAttributeStore.class, NodeAttributeStore.class);
        this.conf = NodeAttributeTestUtils.getRandomDirConf(this.conf);
        this.mgr.init(this.conf);
        this.mgr.start();
    }

    @After
    public void after() throws IOException {
        FileSystemNodeAttributeStore fsStore = (FileSystemNodeAttributeStore)this.mgr.store;
        fsStore.getFs().delete(fsStore.getFsWorkingPath(), true);
        this.mgr.stop();
    }

    @Test(timeout=10000L)
    public void testEmptyRecoverSkipInternalUdpate() throws Exception {
        this.mgr.stop();
        this.mgr = (MockNodeAttrbuteManager)((Object)Mockito.spy((Object)((Object)new MockNodeAttrbuteManager())));
        this.mgr.init(this.conf);
        this.mgr.start();
        ((MockNodeAttrbuteManager)((Object)Mockito.verify((Object)((Object)this.mgr), (VerificationMode)Mockito.times((int)0)))).internalUpdateAttributesOnNodes((Map)Matchers.any(), (AttributeMappingOperationType)Matchers.any(), (Map)Matchers.any(), (String)Matchers.any());
    }

    @Test(timeout=10000L)
    public void testRecoverWithMirror() throws Exception {
        NodeAttribute docker = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"DOCKER", (NodeAttributeType)NodeAttributeType.STRING, (String)"docker-0");
        NodeAttribute gpu = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"GPU", (NodeAttributeType)NodeAttributeType.STRING, (String)"nvidia");
        NodeAttribute fpga = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"FPGA", (NodeAttributeType)NodeAttributeType.STRING, (String)"asus");
        HashMap<String, ImmutableSet> toAddAttributes = new HashMap<String, ImmutableSet>();
        toAddAttributes.put("host0", ImmutableSet.of((Object)gpu, (Object)fpga));
        toAddAttributes.put("host1", ImmutableSet.of((Object)gpu));
        this.mgr.addNodeAttributes(toAddAttributes);
        Assert.assertEquals((String)"host0 size", (long)2L, (long)this.mgr.getAttributesForNode("host0").size());
        toAddAttributes.clear();
        toAddAttributes.put("host0", ImmutableSet.of((Object)gpu));
        this.mgr.removeNodeAttributes(toAddAttributes);
        toAddAttributes.clear();
        toAddAttributes.put("host0", ImmutableSet.of((Object)docker));
        this.mgr.replaceNodeAttributes("rm.yarn.io", toAddAttributes);
        Map attrs = this.mgr.getAttributesForNode("host0");
        Assert.assertEquals((long)attrs.size(), (long)1L);
        Assert.assertEquals((Object)attrs.keySet().toArray()[0], (Object)docker);
        this.mgr.stop();
        this.mgr = new MockNodeAttrbuteManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        this.mgr.getAttributesForNode("host0");
        Assert.assertEquals((String)"host0 size", (long)1L, (long)this.mgr.getAttributesForNode("host0").size());
        Assert.assertEquals((String)"host1 size", (long)1L, (long)this.mgr.getAttributesForNode("host1").size());
        attrs = this.mgr.getAttributesForNode("host0");
        Assert.assertEquals((long)attrs.size(), (long)1L);
        Assert.assertEquals((Object)attrs.keySet().toArray()[0], (Object)docker);
        toAddAttributes.clear();
        toAddAttributes.put("host0", ImmutableSet.of((Object)gpu));
        this.mgr.replaceNodeAttributes("rm.yarn.io", toAddAttributes);
        toAddAttributes.clear();
        toAddAttributes.put("host1", ImmutableSet.of((Object)docker));
        this.mgr.addNodeAttributes(toAddAttributes);
        this.mgr.stop();
        this.mgr = new MockNodeAttrbuteManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assert.assertEquals((String)"host0 size", (long)1L, (long)this.mgr.getAttributesForNode("host0").size());
        Assert.assertEquals((String)"host1 size", (long)2L, (long)this.mgr.getAttributesForNode("host1").size());
        attrs = this.mgr.getAttributesForNode("host0");
        Assert.assertEquals((long)attrs.size(), (long)1L);
        Assert.assertEquals((Object)attrs.keySet().toArray()[0], (Object)gpu);
        attrs = this.mgr.getAttributesForNode("host1");
        Assert.assertTrue((boolean)attrs.keySet().contains(docker));
        Assert.assertTrue((boolean)attrs.keySet().contains(gpu));
    }

    @Test(timeout=10000L)
    public void testRecoverFromEditLog() throws Exception {
        NodeAttribute docker = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"DOCKER", (NodeAttributeType)NodeAttributeType.STRING, (String)"docker-0");
        NodeAttribute gpu = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"GPU", (NodeAttributeType)NodeAttributeType.STRING, (String)"nvidia");
        NodeAttribute fpga = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"FPGA", (NodeAttributeType)NodeAttributeType.STRING, (String)"asus");
        HashMap<String, ImmutableSet> toAddAttributes = new HashMap<String, ImmutableSet>();
        toAddAttributes.put("host0", ImmutableSet.of((Object)gpu, (Object)fpga));
        toAddAttributes.put("host1", ImmutableSet.of((Object)docker));
        this.mgr.addNodeAttributes(toAddAttributes);
        Assert.assertEquals((String)"host0 size", (long)2L, (long)this.mgr.getAttributesForNode("host0").size());
        for (int i = 0; i < 5; ++i) {
            toAddAttributes.clear();
            toAddAttributes.put("host0", ImmutableSet.of((Object)gpu));
            this.mgr.removeNodeAttributes(toAddAttributes);
            toAddAttributes.clear();
            toAddAttributes.put("host1", ImmutableSet.of((Object)docker));
            this.mgr.addNodeAttributes(toAddAttributes);
            toAddAttributes.clear();
            toAddAttributes.put("host0", ImmutableSet.of((Object)gpu));
            this.mgr.replaceNodeAttributes("rm.yarn.io", toAddAttributes);
            toAddAttributes.clear();
            toAddAttributes.put("host1", ImmutableSet.of((Object)gpu));
            this.mgr.addNodeAttributes(toAddAttributes);
        }
        this.mgr.stop();
        this.mgr = new MockNodeAttrbuteManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Assert.assertEquals((String)"host0 size", (long)1L, (long)this.mgr.getAttributesForNode("host0").size());
        Assert.assertEquals((String)"host1 size", (long)2L, (long)this.mgr.getAttributesForNode("host1").size());
        toAddAttributes.clear();
        NodeAttribute replaced = NodeAttribute.newInstance((String)"GPU2", (NodeAttributeType)NodeAttributeType.STRING, (String)"nvidia2");
        toAddAttributes.put("host0", ImmutableSet.of((Object)replaced));
        this.mgr.replaceNodeAttributes("rm.yarn.io", toAddAttributes);
        this.mgr.stop();
        this.mgr = new MockNodeAttrbuteManager();
        this.mgr.init(this.conf);
        this.mgr.start();
        Map valueMap = this.mgr.getAttributesForNode("host0");
        Map.Entry entry = valueMap.entrySet().iterator().next();
        NodeAttribute attribute = (NodeAttribute)entry.getKey();
        Assert.assertEquals((String)"host0 size", (long)1L, (long)this.mgr.getAttributesForNode("host0").size());
        Assert.assertEquals((String)"host1 size", (long)2L, (long)this.mgr.getAttributesForNode("host1").size());
        this.checkNodeAttributeEqual(replaced, attribute);
    }

    public void checkNodeAttributeEqual(NodeAttribute atr1, NodeAttribute atr2) {
        Assert.assertEquals((Object)atr1.getAttributeType(), (Object)atr2.getAttributeType());
        Assert.assertEquals((Object)atr1.getAttributeKey().getAttributeName(), (Object)atr2.getAttributeKey().getAttributeName());
        Assert.assertEquals((Object)atr1.getAttributeKey().getAttributePrefix(), (Object)atr2.getAttributeKey().getAttributePrefix());
        Assert.assertEquals((Object)atr1.getAttributeValue(), (Object)atr2.getAttributeValue());
    }

    private static class MockNodeAttrbuteManager
    extends NodeAttributesManagerImpl {
        private MockNodeAttrbuteManager() {
        }

        protected void initDispatcher(Configuration conf) {
            this.dispatcher = new InlineDispatcher();
        }

        protected void startDispatcher() {
        }

        protected void stopDispatcher() {
        }
    }
}

