/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.junit.Assert;

public class CapacitySchedulerTestBase {
    protected final int GB = 1024;
    protected static final String A = "root.a";
    protected static final String B = "root.b";
    protected static final String A1 = "root.a.a1";
    protected static final String A2 = "root.a.a2";
    protected static final String B1 = "root.b.b1";
    protected static final String B2 = "root.b.b2";
    protected static final String B3 = "root.b.b3";
    protected static float A_CAPACITY = 10.5f;
    protected static float B_CAPACITY = 89.5f;
    protected static final String P1 = "root.p1";
    protected static final String P2 = "root.p2";
    protected static final String X1 = "root.p1.x1";
    protected static final String X2 = "root.p1.x2";
    protected static final String Y1 = "root.p2.y1";
    protected static final String Y2 = "root.p2.y2";
    protected static float A1_CAPACITY = 30.0f;
    protected static float A2_CAPACITY = 70.0f;
    protected static float B1_CAPACITY = 79.2f;
    protected static float B2_CAPACITY = 0.8f;
    protected static float B3_CAPACITY = 20.0f;

    protected <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    protected void checkPendingResource(MockRM rm, String queueName, int memory, String label) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertEquals((long)memory, (long)queue.getQueueResourceUsage().getPending(label == null ? "" : label).getMemorySize());
    }

    protected void checkPendingResourceGreaterThanZero(MockRM rm, String queueName, String label) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertTrue((queue.getQueueResourceUsage().getPending(label == null ? "" : label).getMemorySize() > 0L ? 1 : 0) != 0);
    }

    protected void waitforNMRegistered(ResourceScheduler scheduler, int nodecount, int timesec) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)(timesec * 1000) && scheduler.getNumClusterNodes() < nodecount) {
            Thread.sleep(100L);
        }
    }
}

