/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.DBRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.ConfigurationStoreBaseTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.DBConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.MutableCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDBConfigurationStore
extends ConfigurationStoreBaseTest {
    public static final Log LOG = LogFactory.getLog(TestDBConfigurationStore.class);
    private static final int ZK_TIMEOUT_MS = 10000;
    private TestingServer curatorTestingServer;
    private CuratorFramework curatorFramework;
    private ResourceManager rm;

    public static TestingServer setupCuratorServer() throws Exception {
        TestingServer curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        return curatorTestingServer;
    }

    public static CuratorFramework setupCuratorFramework(TestingServer curatorTestingServer) throws Exception {
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(curatorTestingServer.getConnectString()).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
        curatorFramework.start();
        return curatorFramework;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
        this.curatorTestingServer = TestDBConfigurationStore.setupCuratorServer();
        this.curatorFramework = TestDBConfigurationStore.setupCuratorFramework(this.curatorTestingServer);
        this.conf.set("hadoop.zk.address", this.curatorTestingServer.getConnectString());
        this.rm = new MockRM(this.conf);
        this.rm.start();
        this.rmContext = this.rm.getRMContext();
    }

    @After
    public void cleanup() throws IOException {
        this.rm.stop();
        this.curatorFramework.close();
        this.curatorTestingServer.stop();
    }

    @Test
    public void testVersioning() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertNull((Object)this.confStore.getConfStoreVersion());
        this.confStore.checkVersion();
        Assert.assertEquals((Object)DBConfigurationStore.CURRENT_VERSION_INFO, (Object)this.confStore.getConfStoreVersion());
    }

    @Test
    public void testPersistConfiguration() throws Exception {
        this.schedConf.set("key", "val");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore = this.createConfStore();
        this.schedConf.set("key", "badVal");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
    }

    @Test
    public void testPersistUpdatedConfiguration() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertNull((Object)this.confStore.retrieve().get("key"));
        HashMap<String, String> update = new HashMap<String, String>();
        update.put("key", "val");
        YarnConfigurationStore.LogMutation mutation = new YarnConfigurationStore.LogMutation(update, "testUser");
        this.confStore.logMutation(mutation);
        this.confStore.confirmMutation(true);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore = this.createConfStore();
        this.schedConf.set("key", "badVal");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
    }

    @Test
    public void testMaxLogs() throws Exception {
        this.conf.setLong("yarn.scheduler.configuration.store.max-logs", 2L);
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        LinkedList logs = ((DBConfigurationStore)this.confStore).getLogs();
        Assert.assertEquals((long)0L, (long)logs.size());
        HashMap<String, String> update1 = new HashMap<String, String>();
        update1.put("key1", "val1");
        YarnConfigurationStore.LogMutation mutation = new YarnConfigurationStore.LogMutation(update1, "testUser");
        this.confStore.logMutation(mutation);
        logs = ((DBConfigurationStore)this.confStore).getLogs();
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        this.confStore.confirmMutation(true);
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        HashMap<String, String> update2 = new HashMap<String, String>();
        update2.put("key2", "val2");
        mutation = new YarnConfigurationStore.LogMutation(update2, "testUser");
        this.confStore.logMutation(mutation);
        logs = ((DBConfigurationStore)this.confStore).getLogs();
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key2"));
        this.confStore.confirmMutation(true);
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key2"));
        HashMap<String, String> update3 = new HashMap<String, String>();
        update3.put("key3", "val3");
        mutation = new YarnConfigurationStore.LogMutation(update3, "testUser");
        this.confStore.logMutation(mutation);
        logs = ((DBConfigurationStore)this.confStore).getLogs();
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key2"));
        Assert.assertEquals((Object)"val3", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key3"));
        this.confStore.confirmMutation(true);
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key2"));
        Assert.assertEquals((Object)"val3", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key3"));
    }

    public Configuration createRMHAConf(String rmIds, String rmId, int adminPort) {
        YarnConfiguration conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, CapacityScheduler.class);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", rmIds);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.scheduler.configuration.store.class", "db");
        conf.set("yarn.resourcemanager.store.class", DBRMStateStore.class.getName());
        conf.set("yarn.resourcemanager.ha.id", rmId);
        conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        for (String rpcAddress : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
            for (String id : HAUtil.getRMHAIds((Configuration)conf)) {
                conf.set(HAUtil.addSuffix((String)rpcAddress, (String)id), "localhost:0");
            }
        }
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.admin.address", (String)rmId), "localhost:" + adminPort);
        return conf;
    }

    @Test
    public void testFailoverReadsFromUpdatedStore() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Configuration conf1 = this.createRMHAConf("rm1,rm2", "rm1", 1234);
        MockRM rm1 = new MockRM(conf1);
        rm1.start();
        rm1.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM didn't start", (Object)Service.STATE.STARTED, (Object)rm1.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertNull((Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("key"));
        Configuration conf2 = this.createRMHAConf("rm1,rm2", "rm2", 5678);
        MockRM rm2 = new MockRM(conf2);
        rm2.start();
        Assert.assertEquals((String)"RM should be Standby", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        SchedConfUpdateInfo schedConfUpdateInfo = new SchedConfUpdateInfo();
        schedConfUpdateInfo.getGlobalParams().put("key", "val");
        MutableConfigurationProvider confProvider = ((MutableConfScheduler)rm1.getResourceScheduler()).getMutableConfProvider();
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"testUser", (String[])new String[0]);
        confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.getResourceScheduler().reinitialize(conf1, rm1.getRMContext());
        Assert.assertEquals((Object)"val", (Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("key"));
        confProvider.confirmPendingMutation(true);
        Assert.assertEquals((Object)"val", (Object)((MutableCSConfigurationProvider)confProvider).getConfStore().retrieve().get("key"));
        schedConfUpdateInfo.getGlobalParams().put("key", "badVal");
        confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm2.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM didn't start", (Object)Service.STATE.STARTED, (Object)rm2.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        for (int i = 0; i < 200; ++i) {
            if (HAServiceProtocol.HAServiceState.ACTIVE != rm1.getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"RM should have been fenced", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((Object)"val", (Object)((MutableCSConfigurationProvider)((CapacityScheduler)rm2.getResourceScheduler()).getMutableConfProvider()).getConfStore().retrieve().get("key"));
        Assert.assertEquals((Object)"val", (Object)((MutableConfScheduler)rm2.getResourceScheduler()).getConfiguration().get("key"));
        Thread.sleep(10000L);
        rm1.close();
        rm2.close();
    }

    @Test
    public void testFailoverAfterRemoveQueue() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Configuration conf1 = this.createRMHAConf("rm1,rm2", "rm1", 1234);
        MockRM rm1 = new MockRM(conf1);
        rm1.start();
        rm1.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm1.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Configuration conf2 = this.createRMHAConf("rm1,rm2", "rm2", 5678);
        MockRM rm2 = new MockRM(conf2);
        rm2.start();
        Assert.assertEquals((String)"RM should be Standby", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"testUser", (String[])new String[0]);
        MutableConfigurationProvider confProvider = ((MutableConfScheduler)rm1.getResourceScheduler()).getMutableConfProvider();
        SchedConfUpdateInfo schedConfUpdateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> addParams = new HashMap<String, String>();
        addParams.put("capacity", "100");
        QueueConfigInfo addInfo = new QueueConfigInfo("root.a", addParams);
        schedConfUpdateInfo.getAddQueueInfo().add(addInfo);
        HashMap<String, String> stopParams = new HashMap<String, String>();
        stopParams.put("state", "STOPPED");
        stopParams.put("capacity", "0");
        QueueConfigInfo stopInfo = new QueueConfigInfo("root.default", stopParams);
        schedConfUpdateInfo.getUpdateQueueInfo().add(stopInfo);
        confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.getResourceScheduler().reinitialize(conf1, rm1.getRMContext());
        confProvider.confirmPendingMutation(true);
        Assert.assertTrue((boolean)Arrays.asList(((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("yarn.scheduler.capacity.root.queues").split(",")).contains("a"));
        schedConfUpdateInfo.getUpdateQueueInfo().clear();
        schedConfUpdateInfo.getAddQueueInfo().clear();
        schedConfUpdateInfo.getRemoveQueueInfo().add("root.default");
        confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.getResourceScheduler().reinitialize(conf1, rm1.getRMContext());
        confProvider.confirmPendingMutation(true);
        Assert.assertEquals((Object)"a", (Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("yarn.scheduler.capacity.root.queues"));
        rm2.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm2.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        for (int i = 0; i < 200; ++i) {
            if (HAServiceProtocol.HAServiceState.ACTIVE != rm1.getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"RM should have been fenced", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((Object)"a", (Object)((MutableCSConfigurationProvider)((CapacityScheduler)rm2.getResourceScheduler()).getMutableConfProvider()).getConfStore().retrieve().get("yarn.scheduler.capacity.root.queues"));
        Assert.assertEquals((Object)"a", (Object)((MutableConfScheduler)rm2.getResourceScheduler()).getConfiguration().get("yarn.scheduler.capacity.root.queues"));
        Thread.sleep(10000L);
        rm1.close();
        rm2.close();
    }

    @Override
    public YarnConfigurationStore createConfStore() {
        return new DBConfigurationStore();
    }
}

