/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;

class UserSettings {
    private final String username;
    private final Integer maxRunningApps;

    UserSettings(Builder builder) {
        this.username = builder.username;
        this.maxRunningApps = builder.maxRunningApps;
    }

    public String render() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.addStartTag(pw);
        AllocationFileWriter.addIfPresent(pw, "maxRunningApps", () -> AllocationFileWriter.createNumberSupplier(this.maxRunningApps));
        this.addEndTag(pw);
        pw.close();
        return sw.toString();
    }

    private void addStartTag(PrintWriter pw) {
        pw.println("<user name=\"" + this.username + "\">");
    }

    private void addEndTag(PrintWriter pw) {
        pw.println("</user>");
    }

    public static class Builder {
        private final AllocationFileWriter allocationFileWriter;
        private final String username;
        private Integer maxRunningApps;

        Builder(AllocationFileWriter allocationFileWriter, String username) {
            this.allocationFileWriter = allocationFileWriter;
            this.username = username;
        }

        public Builder maxRunningApps(int value) {
            this.maxRunningApps = value;
            return this;
        }

        public AllocationFileWriter build() {
            UserSettings userSettings = new UserSettings(this);
            this.allocationFileWriter.setUserSettings(userSettings);
            return this.allocationFileWriter;
        }
    }
}

