/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.AppManagerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestAppManagerWithFairScheduler
extends AppManagerTestBase {
    private static final String TEST_FOLDER = "test-queues";
    private static YarnConfiguration conf = new YarnConfiguration();

    @BeforeClass
    public static void setup() throws IOException {
        String allocFile = GenericTestUtils.getTestDir((String)TEST_FOLDER).getAbsolutePath();
        int queueMaxAllocation = 512;
        PrintWriter out = new PrintWriter(new FileWriter(allocFile));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println(" <queue name=\"queueA\">");
        out.println("  <maxContainerAllocation>" + queueMaxAllocation + " mb 1 vcores</maxContainerAllocation>");
        out.println(" </queue>");
        out.println(" <queue name=\"queueB\">");
        out.println(" </queue>");
        out.println("</allocations>");
        out.close();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        conf.set("yarn.scheduler.fair.allocation.file", allocFile);
    }

    @AfterClass
    public static void teardown() {
        File allocFile = GenericTestUtils.getTestDir((String)TEST_FOLDER);
        allocFile.delete();
    }

    @Test
    public void testQueueSubmitWithHighQueueContainerSize() throws YarnException {
        ApplicationId appId = MockApps.newAppID((int)1);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        Resource resource = Resources.createResource((int)1024);
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        asContext.setApplicationId(appId);
        asContext.setResource(resource);
        asContext.setPriority(Priority.newInstance((int)0));
        asContext.setAMContainerSpec(TestAppManagerWithFairScheduler.mockContainerLaunchContext(recordFactory));
        asContext.setQueue("queueA");
        QueueInfo mockDefaultQueueInfo = (QueueInfo)Mockito.mock(QueueInfo.class);
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ((PlacementManager)Mockito.doAnswer((Answer)new Answer<ApplicationPlacementContext>(){

            public ApplicationPlacementContext answer(InvocationOnMock invocation) throws Throwable {
                return new ApplicationPlacementContext("queueA");
            }
        }).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)Matchers.any(ApplicationSubmissionContext.class), Matchers.matches((String)"test1"));
        ((PlacementManager)Mockito.doAnswer((Answer)new Answer<ApplicationPlacementContext>(){

            public ApplicationPlacementContext answer(InvocationOnMock invocation) throws Throwable {
                return new ApplicationPlacementContext("queueB");
            }
        }).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)Matchers.any(ApplicationSubmissionContext.class), Matchers.matches((String)"test2"));
        MockRM newMockRM = new MockRM((Configuration)conf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        newMockRMContext.setQueuePlacementManager(placementMgr);
        ApplicationMasterService masterService = new ApplicationMasterService(newMockRMContext, (YarnScheduler)newMockRMContext.getScheduler());
        AppManagerTestBase.TestRMAppManager newAppMonitor = new AppManagerTestBase.TestRMAppManager(newMockRMContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)newMockRMContext.getScheduler(), masterService, new ApplicationACLsManager((Configuration)conf), (Configuration)conf);
        try {
            newAppMonitor.submitApplication(asContext, "test1");
            Assert.fail((String)"Test should fail on too high allocation!");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION, (Object)e.getInvalidResourceType());
        }
        newAppMonitor.submitApplication(asContext, "test2");
    }

    private static ContainerLaunchContext mockContainerLaunchContext(RecordFactory recordFactory) {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
        amContainer.setApplicationACLs(new HashMap());
        return amContainer;
    }
}

