/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTags;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplications;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAllocationTagsManager {
    private RMContext rmContext;

    @Before
    public void setup() {
        MockRM rm = new MockRM();
        rm.start();
        MockNodes.resetHostIds();
        List<RMNode> rmNodes = MockNodes.newNodes(2, 4, Resource.newInstance((int)4096, (int)4));
        for (RMNode rmNode : rmNodes) {
            rm.getRMContext().getRMNodes().putIfAbsent(rmNode.getNodeID(), rmNode);
        }
        this.rmContext = rm.getRMContext();
    }

    @Test
    public void testMultipleAddRemoveContainer() {
        AllocationTagsManager atm = new AllocationTagsManager(this.rmContext);
        NodeId nodeId = NodeId.fromString((String)"host1:123");
        ContainerId cid1 = TestUtils.getMockContainerId(1, 1);
        ContainerId cid2 = TestUtils.getMockContainerId(1, 2);
        ContainerId cid3 = TestUtils.getMockContainerId(1, 3);
        ImmutableSet tags1 = ImmutableSet.of((Object)"mapper", (Object)"reducer");
        ImmutableSet tags2 = ImmutableSet.of((Object)"mapper");
        ImmutableSet tags3 = ImmutableSet.of((Object)"zk");
        atm.addContainer(nodeId, cid1, (Set)tags1);
        atm.addContainer(nodeId, cid2, (Set)tags2);
        atm.addContainer(nodeId, cid3, (Set)tags3);
        Assert.assertEquals((long)2L, (long)((Long)atm.getAllocationTagsWithCount(nodeId).get("mapper")));
        Assert.assertEquals((long)1L, (long)((Long)atm.getAllocationTagsWithCount(nodeId).get("reducer")));
        atm.removeContainer(nodeId, cid1, (Set)tags1);
        Assert.assertEquals((long)1L, (long)((Long)atm.getAllocationTagsWithCount(nodeId).get("mapper")));
        Assert.assertNull(atm.getAllocationTagsWithCount(nodeId).get("reducer"));
        atm.removeContainer(nodeId, cid1, (Set)tags1);
        Assert.assertNull(atm.getAllocationTagsWithCount(nodeId).get("mapper"));
        Assert.assertNull(atm.getAllocationTagsWithCount(nodeId).get("reducer"));
    }

    @Test
    public void testAllocationTagsManagerSimpleCases() throws InvalidAllocationTagsQueryException {
        AllocationTagsManager atm = new AllocationTagsManager(this.rmContext);
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 2), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 3), (Set)ImmutableSet.of((Object)"service"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 4), (Set)ImmutableSet.of((Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(2, 3), (Set)ImmutableSet.of((Object)"service"));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host1:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper")), Long::max));
        Assert.assertEquals((long)2L, (long)atm.getRackCardinality("rack0", TestUtils.getMockApplicationId(1), "mapper"));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer")), Long::min));
        Assert.assertEquals((long)2L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer")), Long::max));
        Assert.assertEquals((long)3L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer")), Long::sum));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinality(NodeId.fromString((String)"host2:123"), TestUtils.getMockApplicationId(1), "mapper"));
        Assert.assertEquals((long)2L, (long)atm.getNodeCardinality(NodeId.fromString((String)"host2:123"), TestUtils.getMockApplicationId(1), "reducer"));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"no_existed", (Object)"reducer")), Long::min));
        Assert.assertEquals((long)2L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), null), Long::max));
        Assert.assertEquals((long)2L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), null), Long::max));
        Assert.assertEquals((long)2L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of()), Long::max));
        Assert.assertEquals((long)4L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createGlobalAllocationTags((Set)ImmutableSet.of()), Long::sum));
        Assert.assertEquals((long)3L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of()), Long::sum));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(2), (Set)ImmutableSet.of()), Long::sum));
        atm.removeContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.removeContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 2), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.removeContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 3), (Set)ImmutableSet.of((Object)"service"));
        atm.removeContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 4), (Set)ImmutableSet.of((Object)"reducer"));
        atm.removeContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(2, 3), (Set)ImmutableSet.of((Object)"service"));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host1:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper")), Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer")), Long::min));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer")), Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer")), Long::sum));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)TestUtils.getMockApplicationId(1).toString())), Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinality(NodeId.fromString((String)"host2:123"), TestUtils.getMockApplicationId(1), TestUtils.getMockApplicationId(1).toString()));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of()), Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createGlobalAllocationTags((Set)ImmutableSet.of()), Long::sum));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of()), Long::sum));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of()), Long::sum));
    }

    @Test
    public void testAllocationTagsManagerRackMapping() throws InvalidAllocationTagsQueryException {
        AllocationTagsManager atm = new AllocationTagsManager(this.rmContext);
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(2, 2), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(2, 4), (Set)ImmutableSet.of((Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 3), (Set)ImmutableSet.of((Object)"service"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(2, 3), (Set)ImmutableSet.of((Object)"service"));
        Assert.assertEquals((long)1L, (long)atm.getRackCardinality("rack0", TestUtils.getMockApplicationId(1), "mapper"));
        Assert.assertEquals((long)2L, (long)atm.getRackCardinality("rack0", TestUtils.getMockApplicationId(2), "reducer"));
        Assert.assertEquals((long)3L, (long)atm.getRackCardinality("rack0", null, "reducer"));
        Assert.assertEquals((long)1L, (long)atm.getRackCardinalityByOp("rack0", AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of()), Long::max));
        Assert.assertEquals((long)1L, (long)atm.getRackCardinalityByOp("rack0", AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of()), Long::min));
        Assert.assertEquals((long)3L, (long)atm.getRackCardinalityByOp("rack0", AllocationTags.createGlobalAllocationTags((Set)ImmutableSet.of()), Long::max));
    }

    @Test
    public void testAllocationTagsManagerMemoryAfterCleanup() {
        AllocationTagsManager atm = new AllocationTagsManager(this.rmContext);
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 2), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 3), (Set)ImmutableSet.of((Object)"service"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 4), (Set)ImmutableSet.of((Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(2, 3), (Set)ImmutableSet.of((Object)"service"));
        atm.removeContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.removeContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 2), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.removeContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 3), (Set)ImmutableSet.of((Object)"service"));
        atm.removeContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 4), (Set)ImmutableSet.of((Object)"reducer"));
        atm.removeContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(2, 3), (Set)ImmutableSet.of((Object)"service"));
        Assert.assertEquals((long)0L, (long)atm.getGlobalNodeMapping().getTypeToTagsWithCount().size());
        Assert.assertEquals((long)0L, (long)atm.getPerAppNodeMappings().size());
        Assert.assertEquals((long)0L, (long)atm.getGlobalRackMapping().getTypeToTagsWithCount().size());
        Assert.assertEquals((long)0L, (long)atm.getPerAppRackMappings().size());
    }

    @Test
    public void testQueryCardinalityWithIllegalParameters() {
        AllocationTagsManager atm = new AllocationTagsManager(this.rmContext);
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 2), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 3), (Set)ImmutableSet.of((Object)"service"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 4), (Set)ImmutableSet.of((Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(2, 3), (Set)ImmutableSet.of((Object)"service"));
        boolean caughtException = false;
        try {
            atm.getNodeCardinalityByOp(null, AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(2), (Set)ImmutableSet.of((Object)"mapper")), Long::min);
        }
        catch (InvalidAllocationTagsQueryException e1) {
            caughtException = true;
        }
        Assert.assertTrue((String)"should fail because of nodeId specified", (boolean)caughtException);
        caughtException = false;
        try {
            atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(2), (Set)ImmutableSet.of((Object)"mapper")), null);
        }
        catch (InvalidAllocationTagsQueryException e1) {
            caughtException = true;
        }
        Assert.assertTrue((String)"should fail because of nodeId specified", (boolean)caughtException);
    }

    @Test
    public void testNodeAllocationTagsAggregation() throws InvalidAllocationTagsQueryException {
        RMContext mockContext = (RMContext)Mockito.spy((Object)this.rmContext);
        ApplicationId app1 = TestUtils.getMockApplicationId(1);
        ApplicationId app2 = TestUtils.getMockApplicationId(2);
        ApplicationId app3 = TestUtils.getMockApplicationId(3);
        NodeId host1 = NodeId.fromString((String)"host1:123");
        NodeId host2 = NodeId.fromString((String)"host2:123");
        NodeId host3 = NodeId.fromString((String)"host3:123");
        ConcurrentHashMap<ApplicationId, MockRMApp> allApps = new ConcurrentHashMap<ApplicationId, MockRMApp>();
        allApps.put(app1, new MockRMApp(123, 1000L, RMAppState.NEW, "userA", (Set<String>)ImmutableSet.of((Object)"")));
        allApps.put(app2, new MockRMApp(124, 1001L, RMAppState.NEW, "userA", (Set<String>)ImmutableSet.of((Object)"")));
        allApps.put(app3, new MockRMApp(125, 1002L, RMAppState.NEW, "userA", (Set<String>)ImmutableSet.of((Object)"")));
        Mockito.when((Object)mockContext.getRMApps()).thenReturn(allApps);
        AllocationTagsManager atm = new AllocationTagsManager(mockContext);
        atm.addContainer(host1, TestUtils.getMockContainerId(1, 1), (Set)ImmutableSet.of((Object)"A", (Object)"B"));
        atm.addContainer(host1, TestUtils.getMockContainerId(1, 2), (Set)ImmutableSet.of((Object)"A"));
        atm.addContainer(host1, TestUtils.getMockContainerId(2, 1), (Set)ImmutableSet.of((Object)"A"));
        atm.addContainer(host1, TestUtils.getMockContainerId(2, 2), (Set)ImmutableSet.of((Object)"A"));
        atm.addContainer(host1, TestUtils.getMockContainerId(2, 3), (Set)ImmutableSet.of((Object)"A"));
        atm.addContainer(host1, TestUtils.getMockContainerId(3, 1), (Set)ImmutableSet.of((Object)"A"));
        atm.addContainer(host2, TestUtils.getMockContainerId(1, 3), (Set)ImmutableSet.of((Object)"C"));
        atm.addContainer(host2, TestUtils.getMockContainerId(2, 4), (Set)ImmutableSet.of((Object)"A"));
        atm.addContainer(host2, TestUtils.getMockContainerId(2, 5), (Set)ImmutableSet.of((Object)"B"));
        atm.addContainer(host2, TestUtils.getMockContainerId(2, 6), (Set)ImmutableSet.of((Object)"B"));
        atm.addContainer(host2, TestUtils.getMockContainerId(3, 2), (Set)ImmutableSet.of((Object)"B"));
        atm.addContainer(host3, TestUtils.getMockContainerId(2, 7), (Set)ImmutableSet.of((Object)"D"));
        atm.addContainer(host3, TestUtils.getMockContainerId(3, 3), (Set)ImmutableSet.of((Object)"D"));
        TargetApplications ta = new TargetApplications(app1, (Set)ImmutableSet.of((Object)app1, (Object)app2, (Object)app3));
        AllocationTags tags = AllocationTags.createSingleAppAllocationTags((ApplicationId)app1, (Set)ImmutableSet.of((Object)"A", (Object)"C"));
        Assert.assertEquals((long)2L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::min));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::min));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host3, tags, Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host3, tags, Long::min));
        tags = AllocationTags.createOtherAppAllocationTags((ApplicationId)app1, (Set)ImmutableSet.of((Object)"A", (Object)"B"));
        Assert.assertEquals((long)4L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::min));
        Assert.assertEquals((long)4L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::sum));
        tags = AllocationTags.createSingleAppAllocationTags((ApplicationId)app2, (Set)ImmutableSet.of((Object)"A", (Object)"B"));
        Assert.assertEquals((long)3L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::min));
        Assert.assertEquals((long)2L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::max));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::min));
        Assert.assertEquals((long)3L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::sum));
        tags = AllocationTags.createGlobalAllocationTags((Set)ImmutableSet.of((Object)"A"));
        Assert.assertEquals((long)6L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::sum));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::sum));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host3, tags, Long::sum));
        tags = AllocationTags.createGlobalAllocationTags((Set)ImmutableSet.of((Object)"A", (Object)"B"));
        Assert.assertEquals((long)7L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::sum));
        Assert.assertEquals((long)4L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::sum));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host3, tags, Long::sum));
        Assert.assertEquals((long)6L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::max));
        Assert.assertEquals((long)3L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::max));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host3, tags, Long::max));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(host1, tags, Long::min));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(host2, tags, Long::min));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(host3, tags, Long::min));
    }
}

