/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;

public class MockRMWithCustomAMLauncher
extends MockRM {
    private final ContainerManagementProtocol containerManager;
    private final YarnRPC yarnRPC;

    public MockRMWithCustomAMLauncher(ContainerManagementProtocol containerManager) {
        this(new Configuration(), containerManager, null);
    }

    public MockRMWithCustomAMLauncher(ContainerManagementProtocol containerManager, YarnRPC yarnRPC) {
        this(new Configuration(), containerManager, yarnRPC);
    }

    public MockRMWithCustomAMLauncher(Configuration conf, ContainerManagementProtocol containerManager) {
        this(conf, containerManager, null);
    }

    public MockRMWithCustomAMLauncher(Configuration conf, ContainerManagementProtocol containerManager, YarnRPC yarnRPC) {
        super(conf);
        this.containerManager = containerManager;
        this.yarnRPC = yarnRPC;
    }

    @Override
    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.getRMContext()){

            protected Runnable createRunnableLauncher(RMAppAttempt application, AMLauncherEventType event) {
                return new AMLauncher(this.context, application, event, this.getConfig()){

                    protected ContainerManagementProtocol getContainerMgrProxy(ContainerId containerId) {
                        this.rpc = MockRMWithCustomAMLauncher.this.yarnRPC;
                        return MockRMWithCustomAMLauncher.this.containerManager;
                    }

                    protected Token<AMRMTokenIdentifier> createAndSetAMRMToken() {
                        Token amRmToken = super.createAndSetAMRMToken();
                        InetSocketAddress serviceAddr = this.getConfig().getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
                        SecurityUtil.setTokenService((Token)amRmToken, (InetSocketAddress)serviceAddr);
                        return amRmToken;
                    }
                };
            }
        };
    }
}

