/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.AppManagerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestAppManager
extends AppManagerTestBase {
    private Log LOG = LogFactory.getLog(TestAppManager.class);
    private static RMAppEventType appEventType = RMAppEventType.KILL;
    private static String USER = "user_";
    private static String USER0 = USER + 0;
    private RMContext rmContext;
    private SystemMetricsPublisher metricsPublisher;
    private AppManagerTestBase.TestRMAppManager appMonitor;
    private ApplicationSubmissionContext asContext;
    private ApplicationId appId;
    private QueueInfo mockDefaultQueueInfo;

    public synchronized RMAppEventType getAppEventType() {
        return appEventType;
    }

    public synchronized void setAppEventType(RMAppEventType newType) {
        appEventType = newType;
    }

    private static List<RMApp> newRMApps(int n, long time, RMAppState state) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(new MockRMApp(i, time, state));
        }
        return list;
    }

    public RMContext mockRMContext(int n, long time) {
        List<RMApp> apps = TestAppManager.newRMApps(n, time, RMAppState.FINISHED);
        final ConcurrentMap map = Maps.newConcurrentMap();
        for (RMApp app : apps) {
            map.put(app.getApplicationId(), app);
        }
        AsyncDispatcher rmDispatcher = new AsyncDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = new ContainerAllocationExpirer((Dispatcher)rmDispatcher);
        AMLivelinessMonitor amLivelinessMonitor = new AMLivelinessMonitor((Dispatcher)rmDispatcher);
        AMLivelinessMonitor amFinishingMonitor = new AMLivelinessMonitor((Dispatcher)rmDispatcher);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl context = new RMContextImpl((Dispatcher)rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, null, null, null, null, null){

            public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
                return map;
            }
        };
        ((RMContextImpl)context).setStateStore((RMStateStore)Mockito.mock(RMStateStore.class));
        this.metricsPublisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        context.setSystemMetricsPublisher(this.metricsPublisher);
        context.setRMApplicationHistoryWriter(writer);
        return context;
    }

    protected void addToCompletedApps(AppManagerTestBase.TestRMAppManager appMonitor, RMContext rmContext) {
        for (RMApp app : rmContext.getRMApps().values()) {
            if (app.getState() != RMAppState.FINISHED && app.getState() != RMAppState.KILLED && app.getState() != RMAppState.FAILED) continue;
            appMonitor.finishApplication(app.getApplicationId());
        }
    }

    @Before
    public void setUp() throws IOException {
        long now = System.currentTimeMillis();
        this.rmContext = this.mockRMContext(1, now - 10L);
        this.rmContext.setRMTimelineCollectorManager((RMTimelineCollectorManager)Mockito.mock(RMTimelineCollectorManager.class));
        ResourceScheduler scheduler = TestAppManager.mockResourceScheduler();
        ((RMContextImpl)this.rmContext).setScheduler(scheduler);
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.node-labels.enabled", true);
        ((RMContextImpl)this.rmContext).setYarnConfiguration(conf);
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)scheduler);
        this.appMonitor = new AppManagerTestBase.TestRMAppManager(this, this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)scheduler, masterService, new ApplicationACLsManager(conf), conf);
        this.appId = MockApps.newAppID((int)1);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        this.asContext = (ApplicationSubmissionContext)recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        this.asContext.setApplicationId(this.appId);
        this.asContext.setAMContainerSpec(TestAppManager.mockContainerLaunchContext(recordFactory));
        this.asContext.setResource(TestAppManager.mockResource());
        this.asContext.setPriority(Priority.newInstance((int)0));
        this.asContext.setQueue("default");
        this.mockDefaultQueueInfo = (QueueInfo)Mockito.mock(QueueInfo.class);
        Mockito.when((Object)scheduler.getQueueInfo("default", false, false)).thenReturn((Object)this.mockDefaultQueueInfo);
        this.setupDispatcher(this.rmContext, conf);
    }

    @Test
    public void testQueueSubmitWithACLsEnabledWithQueueMapping() throws IOException, YarnException, InterruptedException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "default,test");
        csConf.setFloat("yarn.scheduler.capacity.root.default.capacity", 50.0f);
        csConf.setFloat("yarn.scheduler.capacity.root.default.maximum-capacity", 100.0f);
        csConf.setFloat("yarn.scheduler.capacity.root.test.capacity", 50.0f);
        csConf.setFloat("yarn.scheduler.capacity.root.test.maximum-capacity", 100.0f);
        csConf.set("yarn.scheduler.capacity.root.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.acl_administer_queue", " ");
        csConf.set("yarn.scheduler.capacity.root.default.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.default.acl_administer_queue", " ");
        csConf.set("yarn.scheduler.capacity.root.test.acl_submit_applications", "test");
        csConf.set("yarn.scheduler.capacity.root.test.acl_administer_queue", "test");
        csConf.set("yarn.scheduler.capacity.root.test.acl_submit_applications", "test");
        csConf.set("yarn.scheduler.capacity.root.test.acl_administer_queue", "test");
        csConf.set("yarn.acl.enable", "true");
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ((PlacementManager)Mockito.doAnswer((Answer)new Answer<ApplicationPlacementContext>(){

            public ApplicationPlacementContext answer(InvocationOnMock invocation) throws Throwable {
                return new ApplicationPlacementContext("test");
            }
        }).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)Matchers.any(ApplicationSubmissionContext.class), Matchers.matches((String)"test"));
        this.asContext.setQueue("oldQueue");
        MockRM newMockRM = new MockRM((Configuration)conf);
        RMContext newMockRMContext = newMockRM.getRMContext();
        newMockRMContext.setQueuePlacementManager(placementMgr);
        ApplicationMasterService masterService = new ApplicationMasterService(newMockRMContext, (YarnScheduler)newMockRMContext.getScheduler());
        AppManagerTestBase.TestRMAppManager newAppMonitor = new AppManagerTestBase.TestRMAppManager(this, newMockRMContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)newMockRMContext.getScheduler(), masterService, new ApplicationACLsManager((Configuration)conf), (Configuration)conf);
        newAppMonitor.submitApplication(this.asContext, "test");
        try {
            this.appId = MockApps.newAppID((int)2);
            this.asContext.setApplicationId(this.appId);
            newAppMonitor.submitApplication(this.asContext, "test1");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof AccessControlException));
        }
    }

    @Test
    public void testQueueSubmitWithACLsEnabledWithQueueMappingForAutoCreatedQueue() throws IOException, YarnException, InterruptedException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.acl.enable", "true");
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)conf, false);
        csConf.set("yarn.scheduler.capacity.root.queues", "default,managedparent");
        csConf.setFloat("yarn.scheduler.capacity.root.default.capacity", 50.0f);
        csConf.setFloat("yarn.scheduler.capacity.root.default.maximum-capacity", 100.0f);
        csConf.set("yarn.scheduler.capacity.root.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.acl_administer_queue", " ");
        csConf.set("yarn.scheduler.capacity.root.default.acl_submit_applications", " ");
        csConf.set("yarn.scheduler.capacity.root.default.acl_administer_queue", " ");
        csConf.set("yarn.scheduler.capacity.root.managedparent.acl_administer_queue", "admin");
        csConf.set("yarn.scheduler.capacity.root.managedparent.acl_submit_applications", "user1");
        csConf.setAutoCreateChildQueueEnabled("root.managedparent", true);
        csConf.setAutoCreatedLeafQueueConfigCapacity("root.managedparent", 30.0f);
        csConf.setAutoCreatedLeafQueueConfigMaxCapacity("root.managedparent", 100.0f);
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ((PlacementManager)Mockito.doAnswer((Answer)new Answer<ApplicationPlacementContext>(){

            public ApplicationPlacementContext answer(InvocationOnMock invocation) throws Throwable {
                return new ApplicationPlacementContext("user1", "managedparent");
            }
        }).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)Matchers.any(ApplicationSubmissionContext.class), Matchers.matches((String)"user1|user2"));
        this.asContext.setQueue("oldQueue");
        MockRM newMockRM = new MockRM((Configuration)conf);
        CapacityScheduler cs = (CapacityScheduler)newMockRM.getResourceScheduler();
        ManagedParentQueue managedParentQueue = new ManagedParentQueue((CapacitySchedulerContext)cs, "managedparent", cs.getQueue("root"), null);
        cs.getCapacitySchedulerQueueManager().addQueue("managedparent", (CSQueue)managedParentQueue);
        RMContext newMockRMContext = newMockRM.getRMContext();
        newMockRMContext.setQueuePlacementManager(placementMgr);
        ApplicationMasterService masterService = new ApplicationMasterService(newMockRMContext, (YarnScheduler)newMockRMContext.getScheduler());
        AppManagerTestBase.TestRMAppManager newAppMonitor = new AppManagerTestBase.TestRMAppManager(this, newMockRMContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)newMockRMContext.getScheduler(), masterService, new ApplicationACLsManager((Configuration)conf), (Configuration)conf);
        newAppMonitor.submitApplication(this.asContext, "user1");
        try {
            this.appId = MockApps.newAppID((int)2);
            this.asContext.setApplicationId(this.appId);
            newAppMonitor.submitApplication(this.asContext, "user2");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof AccessControlException));
        }
    }

    @After
    public void tearDown() {
        this.setAppEventType(RMAppEventType.KILL);
        ((Service)this.rmContext.getDispatcher()).stop();
        UserGroupInformation.reset();
    }

    @Test
    public void testRMAppRetireNone() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 10L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.max-completed-applications", 10);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this, rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before checkAppTimeLimit", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)10L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.never())).removeApplication((RMApp)Matchers.isA(RMApp.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueSubmitWithNoPermission() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.scheduler.capacity.root.acl_submit_applications", " ");
        conf.set("yarn.scheduler.capacity.root.acl_administer_queue", " ");
        conf.set("yarn.scheduler.capacity.root.default.acl_submit_applications", " ");
        conf.set("yarn.scheduler.capacity.root.default.acl_administer_queue", " ");
        conf.set("yarn.acl.enable", "true");
        MockRM mockRM = new MockRM((Configuration)conf);
        ClientRMService rmService = mockRM.getClientRMService();
        SubmitApplicationRequest req = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        sub.setApplicationId(this.appId);
        ResourceRequest resReg = ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1);
        sub.setAMContainerResourceRequests(Collections.singletonList(resReg));
        req.setApplicationSubmissionContext(sub);
        sub.setAMContainerSpec((ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class));
        try {
            rmService.submitApplication(req);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof YarnException) {
                Assert.assertTrue((boolean)(e.getCause() instanceof AccessControlException));
            } else {
                Assert.fail((String)("Yarn exception is expected : " + e.getMessage()));
            }
        }
        finally {
            mockRM.close();
        }
    }

    @Test
    public void testRMAppRetireSome() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 3);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 3);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this, rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)3L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)3L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)7))).removeApplication((RMApp)Matchers.isA(RMApp.class));
    }

    @Test
    public void testRMAppRetireSomeDifferentStates() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 2);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 2);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this, rmContext, (Configuration)conf);
        rmContext.getRMApps().clear();
        Assert.assertEquals((String)"map isn't empty", (long)0L, (long)rmContext.getRMApps().size());
        MockRMApp app = new MockRMApp(0, now - 20000L, RMAppState.KILLED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(1, now - 200000L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(2, now - 30000L, RMAppState.FINISHED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(3, now - 20000L, RMAppState.RUNNING);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(4, now - 20000L, RMAppState.NEW);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(5, now - 10001L, RMAppState.KILLED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(6, now - 30000L, RMAppState.ACCEPTED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(7, now - 20000L, RMAppState.SUBMITTED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(8, now - 10001L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(9, now - 20000L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)6L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)2L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)4))).removeApplication((RMApp)Matchers.isA(RMApp.class));
    }

    @Test
    public void testRMAppRetireNullApp() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this, rmContext, new Configuration());
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        appMonitor.finishApplication(null);
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)0L, (long)appMonitor.getCompletedAppsListSize());
    }

    @Test
    public void testRMAppRetireZeroSetting() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 0);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 0);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this, rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)0L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)0L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)10))).removeApplication((RMApp)Matchers.isA(RMApp.class));
    }

    @Test
    public void testStateStoreAppLimitLessThanMemoryAppLimit() {
        long now = System.currentTimeMillis();
        int allApps = 10;
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        int maxAppsInMemory = 8;
        int maxAppsInStateStore = 4;
        conf.setInt("yarn.resourcemanager.max-completed-applications", maxAppsInMemory);
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", maxAppsInStateStore);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this, rmContext, (Configuration)conf);
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)maxAppsInMemory, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)maxAppsInMemory, (long)appMonitor.getCompletedAppsListSize());
        int numRemoveAppsFromStateStore = 10 - maxAppsInStateStore;
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)numRemoveAppsFromStateStore))).removeApplication((RMApp)Matchers.isA(RMApp.class));
        Assert.assertEquals((long)maxAppsInStateStore, (long)appMonitor.getNumberOfCompletedAppsInStateStore());
    }

    @Test
    public void testStateStoreAppLimitGreaterThanMemoryAppLimit() {
        long now = System.currentTimeMillis();
        int allApps = 10;
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        int maxAppsInMemory = 8;
        conf.setInt("yarn.resourcemanager.max-completed-applications", maxAppsInMemory);
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 1000);
        AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this, rmContext, (Configuration)conf);
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        int numRemoveApps = 10 - maxAppsInMemory;
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)maxAppsInMemory, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)maxAppsInMemory, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)numRemoveApps))).removeApplication((RMApp)Matchers.isA(RMApp.class));
        Assert.assertEquals((long)maxAppsInMemory, (long)appMonitor.getNumberOfCompletedAppsInStateStore());
    }

    protected void setupDispatcher(RMContext rmContext, Configuration conf) {
        TestDispatcher testDispatcher = new TestDispatcher();
        TestAppManagerDispatcher testAppManagerDispatcher = new TestAppManagerDispatcher();
        rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)testDispatcher);
        rmContext.getDispatcher().register(RMAppManagerEventType.class, (EventHandler)testAppManagerDispatcher);
        ((Service)rmContext.getDispatcher()).init(conf);
        ((Service)rmContext.getDispatcher()).start();
        Assert.assertEquals((String)"app event type is wrong before", (Object)RMAppEventType.KILL, (Object)appEventType);
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequests() throws Exception {
        this.asContext.setResource(Resources.createResource((int)1024));
        this.asContext.setAMContainerResourceRequest(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true));
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"/rack", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"/rack/node", (Resource)Resources.createResource((int)1025), (int)1, (boolean)true));
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        Assert.assertEquals(reqs.get(0), (Object)this.asContext.getAMContainerResourceRequest());
        Assert.assertEquals(reqs, (Object)this.asContext.getAMContainerResourceRequests());
        RMApp app = this.testRMAppSubmit();
        for (ResourceRequest req : reqs) {
            req.setNodeLabelExpression("");
        }
        Assert.assertEquals(reqs, (Object)app.getAMResourceRequests());
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequest() throws Exception {
        this.asContext.setResource(Resources.createResource((int)1024));
        this.asContext.setAMContainerResourceRequests(null);
        ResourceRequest req = ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)1025), (int)1, (boolean)true);
        req.setNodeLabelExpression("");
        this.asContext.setAMContainerResourceRequest(ResourceRequest.clone((ResourceRequest)req));
        Assert.assertEquals((Object)req, (Object)this.asContext.getAMContainerResourceRequest());
        Assert.assertEquals((Object)req, this.asContext.getAMContainerResourceRequests().get(0));
        Assert.assertEquals((long)1L, (long)this.asContext.getAMContainerResourceRequests().size());
        RMApp app = this.testRMAppSubmit();
        Assert.assertEquals(Collections.singletonList(req), (Object)app.getAMResourceRequests());
    }

    @Test
    public void testRMAppSubmitResource() throws Exception {
        this.asContext.setResource(Resources.createResource((int)1024));
        this.asContext.setAMContainerResourceRequests(null);
        RMApp app = this.testRMAppSubmit();
        Assert.assertEquals(Collections.singletonList(ResourceRequest.newInstance((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true, (String)"")), (Object)app.getAMResourceRequests());
    }

    @Test
    public void testRMAppSubmitNoResourceRequests() throws Exception {
        this.asContext.setResource(null);
        this.asContext.setAMContainerResourceRequests(null);
        try {
            this.testRMAppSubmit();
            Assert.fail((String)"Should have failed due to no ResourceRequest");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)"Invalid resource request, no resources requested", (Object)e.getMessage());
        }
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequestsDisagree() throws Exception {
        this.asContext.setResource(null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        Mockito.when((Object)this.mockDefaultQueueInfo.getAccessibleNodeLabels()).thenReturn((Object)new HashSet<String>(){
            {
                this.add("label1");
                this.add("");
            }
        });
        ResourceRequest anyReq = ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)false, (String)"label1", (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED));
        reqs.add(anyReq);
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)2), (String)"/rack", (Resource)Resources.createResource((int)1025), (int)2, (boolean)false, (String)"", (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC)));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)3), (String)"/rack/node", (Resource)Resources.createResource((int)1026), (int)3, (boolean)true, (String)"", (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC)));
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        RMApp app = this.testRMAppSubmit();
        for (ResourceRequest req : reqs) {
            req.setCapability(anyReq.getCapability());
            req.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED));
            req.setNumContainers(1);
            req.setPriority(Priority.newInstance((int)0));
        }
        Assert.assertEquals(reqs, (Object)app.getAMResourceRequests());
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequestsNoAny() throws Exception {
        this.asContext.setResource(null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/rack", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/rack/node", (Resource)Resources.createResource((int)1025), (int)1, (boolean)true));
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        Assert.assertEquals(reqs, (Object)this.asContext.getAMContainerResourceRequests());
        try {
            this.testRMAppSubmit();
            Assert.fail((String)"Should have failed due to missing ANY ResourceRequest");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)"Invalid resource request, no resource request specified with *", (Object)e.getMessage());
        }
    }

    @Test
    public void testRMAppSubmitAMContainerResourceRequestsTwoManyAny() throws Exception {
        this.asContext.setResource(null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        reqs.add(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1025), (int)1, (boolean)false));
        this.asContext.setAMContainerResourceRequests(TestAppManager.cloneResourceRequests(reqs));
        Assert.assertEquals(reqs, (Object)this.asContext.getAMContainerResourceRequests());
        try {
            this.testRMAppSubmit();
            Assert.fail((String)"Should have failed due to too many ANY ResourceRequests");
        }
        catch (InvalidResourceRequestException e) {
            Assert.assertEquals((Object)"Invalid resource request, only one resource request with * is allowed", (Object)e.getMessage());
        }
    }

    private RMApp testRMAppSubmit() throws Exception {
        this.appMonitor.submitApplication(this.asContext, "test");
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)this.appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.NEW, (Object)app.getState());
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.START, (Object)this.getAppEventType());
        return app;
    }

    @Test
    public void testRMAppSubmitWithInvalidTokens() throws Exception {
        DataOutputBuffer dob = new DataOutputBuffer();
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.asContext.getAMContainerSpec().setTokens(securityTokens);
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Application submission should fail because Tokens are invalid.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not java.io.EOFException", (boolean)e.getMessage().contains("java.io.EOFException"));
        }
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.APP_REJECTED, (Object)this.getAppEventType());
        this.asContext.getAMContainerSpec().setTokens(null);
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitMaxAppAttempts() throws Exception {
        int[] globalMaxAppAttempts = new int[]{10, 1};
        int[][] individualMaxAppAttempts = new int[][]{{9, 10, 11, 0}, {1, 10, 0, -1}};
        int[][] expectedNums = new int[][]{{9, 10, 10, 10}, {1, 1, 1, 1}};
        for (int i = 0; i < globalMaxAppAttempts.length; ++i) {
            for (int j = 0; j < individualMaxAppAttempts.length; ++j) {
                ResourceScheduler scheduler = TestAppManager.mockResourceScheduler();
                Configuration conf = new Configuration();
                conf.setInt("yarn.resourcemanager.am.max-attempts", globalMaxAppAttempts[i]);
                ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)scheduler);
                AppManagerTestBase.TestRMAppManager appMonitor = new AppManagerTestBase.TestRMAppManager(this, this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)scheduler, masterService, new ApplicationACLsManager(conf), conf);
                ApplicationId appID = MockApps.newAppID((int)(i * 4 + j + 1));
                this.asContext.setApplicationId(appID);
                if (individualMaxAppAttempts[i][j] != 0) {
                    this.asContext.setMaxAppAttempts(individualMaxAppAttempts[i][j]);
                }
                appMonitor.submitApplication(this.asContext, "test");
                RMApp app = (RMApp)this.rmContext.getRMApps().get(appID);
                Assert.assertEquals((String)"max application attempts doesn't match", (long)expectedNums[i][j], (long)app.getMaxAppAttempts());
                int timeoutSecs = 0;
                while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
                    Thread.sleep(1000L);
                }
                this.setAppEventType(RMAppEventType.KILL);
            }
        }
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitDuplicateApplicationId() throws Exception {
        ApplicationId appId = MockApps.newAppID((int)0);
        this.asContext.setApplicationId(appId);
        RMApp appOrig = (RMApp)this.rmContext.getRMApps().get(appId);
        Assert.assertTrue((String)"app name matches but shouldn't", ("testApp1" != appOrig.getName() ? 1 : 0) != 0);
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Exception is expected when applicationId is duplicate.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not the expectd one.", (boolean)e.getMessage().contains("Cannot add a duplicate!"));
        }
        RMApp app = (RMApp)this.rmContext.getRMApps().get(appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.FINISHED, (Object)app.getState());
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitInvalidResourceRequest() throws Exception {
        this.asContext.setResource(Resources.createResource((int)8193));
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Application submission should fail because resource request is invalid.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not InvalidResourceRequestException", (boolean)e.getMessage().contains("Invalid resource request"));
        }
    }

    @Test(timeout=30000L)
    public void testEscapeApplicationSummary() {
        RMApp app = (RMApp)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)ApplicationId.newInstance((long)100L, (int)1));
        Mockito.when((Object)app.getName()).thenReturn((Object)"Multiline\n\n\r\rAppName");
        Mockito.when((Object)app.getUser()).thenReturn((Object)"Multiline\n\n\r\rUserName");
        Mockito.when((Object)app.getQueue()).thenReturn((Object)"Multiline\n\n\r\rQueueName");
        Mockito.when((Object)app.getState()).thenReturn((Object)RMAppState.RUNNING);
        Mockito.when((Object)app.getApplicationType()).thenReturn((Object)"MAPREDUCE");
        Mockito.when((Object)app.getSubmitTime()).thenReturn((Object)1000L);
        HashMap<String, Long> resourceSecondsMap = new HashMap<String, Long>();
        resourceSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), 16384L);
        resourceSecondsMap.put(ResourceInformation.VCORES.getName(), 64L);
        RMAppMetrics metrics = new RMAppMetrics(Resource.newInstance((int)1234, (int)56), 10, 1, resourceSecondsMap, new HashMap());
        Mockito.when((Object)app.getRMAppMetrics()).thenReturn((Object)metrics);
        new RMAppManager.ApplicationSummary();
        RMAppManager.ApplicationSummary.SummaryBuilder summary = RMAppManager.ApplicationSummary.createAppSummary((RMApp)app);
        String msg = summary.toString();
        this.LOG.info((Object)("summary: " + msg));
        Assert.assertFalse((boolean)msg.contains("\n"));
        Assert.assertFalse((boolean)msg.contains("\r"));
        String escaped = "\\n\\n\\r\\r";
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "AppName"));
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "UserName"));
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "QueueName"));
        Assert.assertTrue((boolean)msg.contains("submitTime=1000"));
        Assert.assertTrue((boolean)msg.contains("memorySeconds=16384"));
        Assert.assertTrue((boolean)msg.contains("vcoreSeconds=64"));
        Assert.assertTrue((boolean)msg.contains("preemptedAMContainers=1"));
        Assert.assertTrue((boolean)msg.contains("preemptedNonAMContainers=10"));
        Assert.assertTrue((boolean)msg.contains("preemptedResources=<memory:1234\\, vCores:56>"));
        Assert.assertTrue((boolean)msg.contains("applicationType=MAPREDUCE"));
    }

    @Test
    public void testRMAppSubmitWithQueueChanged() throws Exception {
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ((PlacementManager)Mockito.doAnswer((Answer)new Answer<ApplicationPlacementContext>(){

            public ApplicationPlacementContext answer(InvocationOnMock invocation) throws Throwable {
                return new ApplicationPlacementContext("newQueue");
            }
        }).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)Matchers.any(ApplicationSubmissionContext.class), (String)Matchers.any(String.class));
        this.rmContext.setQueuePlacementManager(placementMgr);
        this.asContext.setQueue("oldQueue");
        this.appMonitor.submitApplication(this.asContext, "test");
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        RMAppEvent event = new RMAppEvent(this.appId, RMAppEventType.START);
        ((RMApp)this.rmContext.getRMApps().get(this.appId)).handle((Event)event);
        event = new RMAppEvent(this.appId, RMAppEventType.APP_NEW_SAVED);
        ((RMApp)this.rmContext.getRMApps().get(this.appId)).handle((Event)event);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((Object)"newQueue", (Object)this.asContext.getQueue());
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.START, (Object)this.getAppEventType());
    }

    private static ResourceScheduler mockResourceScheduler() {
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)scheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)scheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)scheduler.getMaximumResourceCapability((String)Matchers.any(String.class))).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)scheduler.getMaximumResourceCapability(Matchers.anyString())).thenReturn((Object)Resources.createResource((int)8192));
        ResourceCalculator rs = (ResourceCalculator)Mockito.mock(ResourceCalculator.class);
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)rs);
        Mockito.when((Object)scheduler.getNormalizedResource((Resource)Matchers.any(), (Resource)Matchers.any())).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocationOnMock) throws Throwable {
                return (Resource)invocationOnMock.getArguments()[0];
            }
        });
        return scheduler;
    }

    private static ContainerLaunchContext mockContainerLaunchContext(RecordFactory recordFactory) {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
        amContainer.setApplicationACLs(new HashMap());
        return amContainer;
    }

    private static Resource mockResource() {
        return Resources.createResource((int)1024);
    }

    private static List<ResourceRequest> cloneResourceRequests(List<ResourceRequest> reqs) {
        ArrayList<ResourceRequest> cloneReqs = new ArrayList<ResourceRequest>();
        for (ResourceRequest req : reqs) {
            cloneReqs.add(ResourceRequest.clone((ResourceRequest)req));
        }
        return cloneReqs;
    }

    public class TestDispatcher
    implements EventHandler<RMAppEvent> {
        public void handle(RMAppEvent event) {
            TestAppManager.this.setAppEventType((RMAppEventType)event.getType());
            System.out.println("in handle routine " + TestAppManager.this.getAppEventType().toString());
        }
    }

    public class TestAppManagerDispatcher
    implements EventHandler<RMAppManagerEvent> {
        public void handle(RMAppManagerEvent event) {
        }
    }
}

