/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMappingEntity;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestCapacitySchedulerQueueMappingFactory {
    private static final String QUEUE_MAPPING_NAME = "app-name";
    private static final String QUEUE_MAPPING_RULE_APP_NAME = "org.apache.hadoop.yarn.server.resourcemanager.placement.AppNameMappingPlacementRule";
    private static final String QUEUE_MAPPING_RULE_USER_GROUP = "org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule";
    public static final String USER = "user_";
    public static final String PARENT_QUEUE = "c";
    private MockRM mockRM = null;

    public static CapacitySchedulerConfiguration setupQueueMappingsForRules(CapacitySchedulerConfiguration conf, String parentQueue, boolean overrideWithQueueMappings, int[] sourceIds) {
        ArrayList<String> queuePlacementRules = new ArrayList<String>();
        queuePlacementRules.add(QUEUE_MAPPING_RULE_USER_GROUP);
        queuePlacementRules.add(QUEUE_MAPPING_RULE_APP_NAME);
        conf.setQueuePlacementRules(queuePlacementRules);
        List existingMappingsForUG = conf.getQueueMappings();
        ArrayList<UserGroupMappingPlacementRule.QueueMapping> queueMappingsForUG = new ArrayList<UserGroupMappingPlacementRule.QueueMapping>();
        for (int i = 0; i < sourceIds.length; ++i) {
            UserGroupMappingPlacementRule.QueueMapping userQueueMapping = new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, USER + sourceIds[i], TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, USER + sourceIds[i]));
            queueMappingsForUG.add(userQueueMapping);
        }
        existingMappingsForUG.addAll(queueMappingsForUG);
        conf.setQueueMappings(existingMappingsForUG);
        List existingMappingsForAN = conf.getQueueMappingEntity(QUEUE_MAPPING_NAME);
        ArrayList<QueueMappingEntity> queueMappingsForAN = new ArrayList<QueueMappingEntity>();
        for (int i = 0; i < sourceIds.length; ++i) {
            QueueMappingEntity queueMapping = new QueueMappingEntity(USER + sourceIds[i], TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, USER + sourceIds[i]));
            queueMappingsForAN.add(queueMapping);
        }
        existingMappingsForAN.addAll(queueMappingsForAN);
        conf.setQueueMappingEntities(existingMappingsForAN, QUEUE_MAPPING_NAME);
        conf.setOverrideWithQueueMappings(overrideWithQueueMappings);
        return conf;
    }

    @Test
    public void testUpdatePlacementRulesFactory() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestCapacitySchedulerQueueMappingFactory.setupQueueMappingsForRules(conf, PARENT_QUEUE, true, new int[]{1, 2, 3});
        this.mockRM = new MockRM((Configuration)conf);
        CapacityScheduler cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        cs.updatePlacementRules();
        this.mockRM.start();
        cs.start();
        List rules = cs.getRMContext().getQueuePlacementManager().getPlacementRules();
        ArrayList<String> placementRuleNames = new ArrayList<String>();
        for (PlacementRule pr : rules) {
            placementRuleNames.add(pr.getName());
        }
        Assert.assertThat(placementRuleNames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{QUEUE_MAPPING_RULE_USER_GROUP}));
        Assert.assertThat(placementRuleNames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{QUEUE_MAPPING_RULE_APP_NAME}));
    }
}

