/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWorkPreservingRMRestartForNodeLabel {
    private Configuration conf;
    private static final int GB = 1024;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init(this.conf);
    }

    private <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    private void checkRMContainerLabelExpression(ContainerId containerId, MockRM rm, String labelExpression) {
        RMContainer container = rm.getRMContext().getScheduler().getRMContainer(containerId);
        Assert.assertNotNull((String)("Cannot find RMContainer=" + containerId), (Object)container);
        Assert.assertEquals((Object)labelExpression, (Object)container.getNodeLabelExpression());
    }

    public static void waitForNumContainersToRecover(int num, MockRM rm, ApplicationAttemptId attemptId) throws Exception {
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        SchedulerApplicationAttempt attempt = scheduler.getApplicationAttempt(attemptId);
        while (attempt == null) {
            System.out.println("Wait for scheduler attempt " + attemptId + " to be created");
            Thread.sleep(200L);
            attempt = scheduler.getApplicationAttempt(attemptId);
        }
        while (attempt.getLiveContainers().size() < num) {
            System.out.println("Wait for " + num + " containers to recover. currently: " + attempt.getLiveContainers().size());
            Thread.sleep(200L);
        }
    }

    private void checkAppResourceUsage(String partition, ApplicationId appId, MockRM rm, int expectedMemUsage) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        FiCaSchedulerApp app = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(appId)).getCurrentAppAttempt();
        Assert.assertEquals((long)expectedMemUsage, (long)app.getAppAttemptResourceUsage().getUsed(partition).getMemorySize());
    }

    private void checkQueueResourceUsage(String partition, String queueName, MockRM rm, int expectedMemUsage) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertEquals((long)expectedMemUsage, (long)queue.getQueueResourceUsage().getUsed(partition).getMemorySize());
    }

    @Test
    public void testWorkPreservingRestartForNodeLabel() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        this.conf = TestUtils.getConfigurationWithDefaultQueueLabels(this.conf);
        MockRM rm1 = new MockRM(this.conf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestWorkPreservingRMRestartForNodeLabel.this.mgr;
            }
        };
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockNM nm2 = rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        RMApp app1 = rm1.submitApp(200, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L), rm1, "x");
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L), rm1, "x");
        RMApp app2 = rm1.submitApp(200, "app", "user", null, "b1");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L), rm1, "y");
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L), rm1, "y");
        RMApp app3 = rm1.submitApp(200, "app", "user", null, "c1");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm3);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)1L), rm1, "");
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L), rm1, "");
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init(this.conf);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm2 = new MockRM(this.conf, (RMStateStore)memStore){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestWorkPreservingRMRestartForNodeLabel.this.mgr;
            }
        };
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        nm2.setResourceTrackerService(rm2.getResourceTrackerService());
        nm3.setResourceTrackerService(rm2.getResourceTrackerService());
        NMContainerStatus app1c1 = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 1, ContainerState.RUNNING, "x");
        NMContainerStatus app1c2 = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 2, ContainerState.RUNNING, "x");
        nm1.registerNode(Arrays.asList(app1c1, app1c2), null);
        TestWorkPreservingRMRestartForNodeLabel.waitForNumContainersToRecover(2, rm2, am1.getApplicationAttemptId());
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L), rm1, "x");
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L), rm1, "x");
        NMContainerStatus app2c1 = TestRMRestart.createNMContainerStatus(am2.getApplicationAttemptId(), 1, ContainerState.RUNNING, "y");
        NMContainerStatus app2c2 = TestRMRestart.createNMContainerStatus(am2.getApplicationAttemptId(), 2, ContainerState.RUNNING, "y");
        nm2.registerNode(Arrays.asList(app2c1, app2c2), null);
        TestWorkPreservingRMRestartForNodeLabel.waitForNumContainersToRecover(2, rm2, am2.getApplicationAttemptId());
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L), rm1, "y");
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L), rm1, "y");
        NMContainerStatus app3c1 = TestRMRestart.createNMContainerStatus(am3.getApplicationAttemptId(), 1, ContainerState.RUNNING, "");
        NMContainerStatus app3c2 = TestRMRestart.createNMContainerStatus(am3.getApplicationAttemptId(), 2, ContainerState.RUNNING, "");
        nm3.registerNode(Arrays.asList(app3c1, app3c2), null);
        TestWorkPreservingRMRestartForNodeLabel.waitForNumContainersToRecover(2, rm2, am3.getApplicationAttemptId());
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)1L), rm1, "");
        this.checkRMContainerLabelExpression(ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L), rm1, "");
        this.checkAppResourceUsage("x", app1.getApplicationId(), rm1, 2048);
        this.checkAppResourceUsage("y", app2.getApplicationId(), rm1, 2048);
        this.checkAppResourceUsage("", app3.getApplicationId(), rm1, 2048);
        this.checkQueueResourceUsage("x", "a1", rm1, 2048);
        this.checkQueueResourceUsage("y", "b1", rm1, 2048);
        this.checkQueueResourceUsage("", "c1", rm1, 2048);
        this.checkQueueResourceUsage("x", "a", rm1, 2048);
        this.checkQueueResourceUsage("y", "b", rm1, 2048);
        this.checkQueueResourceUsage("", "c", rm1, 2048);
        this.checkQueueResourceUsage("x", "root", rm1, 2048);
        this.checkQueueResourceUsage("y", "root", rm1, 2048);
        this.checkQueueResourceUsage("", "root", rm1, 2048);
        rm1.close();
        rm2.close();
    }
}

