/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.TreeSet;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.junit.Assert;
import org.junit.Test;

public class TestProportionalCapacityPreemptionPolicyMockFramework
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Test
    public void testBuilder() throws Exception {
        String labelsConfig = "=200,true;red=100,false;blue=200,true";
        String nodesConfig = "n1=red;n2=blue;n3=";
        String queuesConfig = "root(=[200 200 100 100],red=[100 100 100 100],blue=[200 200 200 200]);-a(=[100 200 100 100],red=[0 0 0 0],blue=[200 200 200 200]);--a1(=[50 100 50 100],red=[0 0 0 0],blue=[100 200 200 0]);--a2(=[50 200 50 0],red=[0 0 0 0],blue=[100 200 0 200]){priority=2};-b(=[100 200 0 0],red=[100 100 100 100],blue=[0 0 0 0]){priority=1,disable_preemption=true}";
        String appsConfig = "a1\t(1,1,n3,red,50,false);a1\t(2,1,n2,,50,true)(2,1,n2,,50,false)(2,1,n2,blue,50,true)(2,1,n2,blue,50,true);a2\t(1,1,n3,red,50,false);b\t(1,1,n1,red,100,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.checkAbsCapacities(this.cs.getQueue("root"), "", 1.0f, 1.0f, 0.5f);
        this.checkPendingResource(this.cs.getQueue("root"), "", 100);
        this.checkAbsCapacities(this.cs.getQueue("root"), "red", 1.0f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue("root"), "red", 100);
        this.checkAbsCapacities(this.cs.getQueue("root"), "blue", 1.0f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue("root"), "blue", 200);
        this.checkPriority(this.cs.getQueue("root"), 0);
        this.checkAbsCapacities(this.cs.getQueue("a"), "", 0.5f, 1.0f, 0.5f);
        this.checkPendingResource(this.cs.getQueue("a"), "", 100);
        this.checkAbsCapacities(this.cs.getQueue("a"), "red", 0.0f, 0.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("a"), "red", 0);
        this.checkAbsCapacities(this.cs.getQueue("a"), "blue", 1.0f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue("a"), "blue", 200);
        this.checkPriority(this.cs.getQueue("a"), 0);
        this.checkAbsCapacities(this.cs.getQueue("a1"), "", 0.25f, 0.5f, 0.25f);
        this.checkPendingResource(this.cs.getQueue("a1"), "", 100);
        this.checkAbsCapacities(this.cs.getQueue("a1"), "red", 0.0f, 0.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("a1"), "red", 0);
        this.checkAbsCapacities(this.cs.getQueue("a1"), "blue", 0.5f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue("a1"), "blue", 0);
        this.checkPriority(this.cs.getQueue("a1"), 0);
        this.checkAbsCapacities(this.cs.getQueue("a2"), "", 0.25f, 1.0f, 0.25f);
        this.checkPendingResource(this.cs.getQueue("a2"), "", 0);
        this.checkAbsCapacities(this.cs.getQueue("a2"), "red", 0.0f, 0.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("a2"), "red", 0);
        this.checkAbsCapacities(this.cs.getQueue("a2"), "blue", 0.5f, 1.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("a2"), "blue", 200);
        this.checkPriority(this.cs.getQueue("a2"), 2);
        Assert.assertFalse((boolean)this.cs.getQueue("a2").getPreemptionDisabled());
        this.checkAbsCapacities(this.cs.getQueue("b"), "", 0.5f, 1.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("b"), "", 0);
        this.checkAbsCapacities(this.cs.getQueue("b"), "red", 1.0f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue("b"), "red", 100);
        this.checkAbsCapacities(this.cs.getQueue("b"), "blue", 0.0f, 0.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("b"), "blue", 0);
        this.checkPriority(this.cs.getQueue("b"), 1);
        Assert.assertTrue((boolean)this.cs.getQueue("b").getPreemptionDisabled());
        Assert.assertEquals((long)100L, (long)((TreeSet)((LeafQueue)this.cs.getQueue("a1")).getIgnoreExclusivityRMContainers().get("blue")).size());
        Assert.assertEquals((long)2L, (long)((LeafQueue)this.cs.getQueue("a1")).getApplications().size());
        Assert.assertEquals((long)1L, (long)((LeafQueue)this.cs.getQueue("a2")).getApplications().size());
        Assert.assertEquals((long)1L, (long)((LeafQueue)this.cs.getQueue("b")).getApplications().size());
        FiCaSchedulerApp app1 = this.getApp("a1", 1);
        FiCaSchedulerApp app2 = this.getApp("a1", 2);
        FiCaSchedulerApp app3 = this.getApp("a2", 3);
        FiCaSchedulerApp app4 = this.getApp("b", 4);
        Assert.assertEquals((long)50L, (long)app1.getLiveContainers().size());
        this.checkContainerNodesInApp(app1, 50, "n3");
        Assert.assertEquals((long)50L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((long)150L, (long)app2.getReservedContainers().size());
        this.checkContainerNodesInApp(app2, 200, "n2");
        Assert.assertEquals((long)50L, (long)app3.getLiveContainers().size());
        this.checkContainerNodesInApp(app3, 50, "n3");
        Assert.assertEquals((long)100L, (long)app4.getLiveContainers().size());
        this.checkContainerNodesInApp(app4, 100, "n1");
    }

    @Test
    public void testBuilderWithReservedResource() throws Exception {
        String labelsConfig = "=200,true;red=100,false;blue=200,true";
        String nodesConfig = "n1=red;n2=blue;n3=";
        String queuesConfig = "root(=[200 200 100 100 100],red=[100 100 100 100 90],blue=[200 200 200 200 80]);-a(=[100 200 100 100 50],red=[0 0 0 0 40],blue=[200 200 200 200 30]);--a1(=[50 100 50 100 40],red=[0 0 0 0 20],blue=[100 200 200 0]);--a2(=[50 200 50 0 10],red=[0 0 0 0 20],blue=[100 200 0 200]);-b(=[100 200 0 0],red=[100 100 100 100],blue=[0 0 0 0])";
        String appsConfig = "a1\t(1,1,n3,red,50,false);a1\t(2,1,n2,,50,true)(2,1,n2,,50,false)(2,1,n2,blue,50,true)(2,1,n2,blue,50,true);a2\t(1,1,n3,red,50,false);b\t(1,1,n1,red,100,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.checkReservedResource(this.cs.getQueue("root"), "", 100);
        this.checkReservedResource(this.cs.getQueue("root"), "red", 90);
        this.checkReservedResource(this.cs.getQueue("a"), "", 50);
        this.checkReservedResource(this.cs.getQueue("a"), "red", 40);
        this.checkReservedResource(this.cs.getQueue("a1"), "", 40);
        this.checkReservedResource(this.cs.getQueue("a1"), "red", 20);
        this.checkReservedResource(this.cs.getQueue("b"), "", 0);
        this.checkReservedResource(this.cs.getQueue("b"), "red", 0);
    }

    @Test
    public void testBuilderWithSpecifiedNodeResources() throws Exception {
        String labelsConfig = "=200,true;red=100,false;blue=200,true";
        String nodesConfig = "n1=red res=100;n2=blue;n3= res=30";
        String queuesConfig = "root(=[200 200 100 100 100],red=[100 100 100 100 90],blue=[200 200 200 200 80]);-a(=[100 200 100 100 50],red=[0 0 0 0 40],blue=[200 200 200 200 30]);--a1(=[50 100 50 100 40],red=[0 0 0 0 20],blue=[100 200 200 0]);--a2(=[50 200 50 0 10],red=[0 0 0 0 20],blue=[100 200 0 200]);-b(=[100 200 0 0],red=[100 100 100 100],blue=[0 0 0 0])";
        String appsConfig = "a1\t(1,1,n3,red,50,false);a1\t(2,1,n2,,50,true)(2,1,n2,,50,false)(2,1,n2,blue,50,true)(2,1,n2,blue,50,true);a2\t(1,1,n3,red,50,false);b\t(1,1,n1,red,100,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        Assert.assertEquals((long)3L, (long)this.cs.getAllNodes().size());
        SchedulerNode node1 = this.cs.getSchedulerNode(NodeId.newInstance((String)"n1", (int)1));
        Assert.assertEquals((long)100L, (long)node1.getTotalResource().getMemorySize());
        Assert.assertEquals((long)100L, (long)node1.getCopiedListOfRunningContainers().size());
        Assert.assertNull((Object)node1.getReservedContainer());
        SchedulerNode node2 = this.cs.getSchedulerNode(NodeId.newInstance((String)"n2", (int)1));
        Assert.assertEquals((long)0L, (long)node2.getTotalResource().getMemorySize());
        Assert.assertEquals((long)50L, (long)node2.getCopiedListOfRunningContainers().size());
        Assert.assertNotNull((Object)node2.getReservedContainer());
        SchedulerNode node3 = this.cs.getSchedulerNode(NodeId.newInstance((String)"n3", (int)1));
        Assert.assertEquals((long)30L, (long)node3.getTotalResource().getMemorySize());
        Assert.assertEquals((long)100L, (long)node3.getCopiedListOfRunningContainers().size());
        Assert.assertNull((Object)node3.getReservedContainer());
    }
}

