/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.nodelabels.NodeAttributeStore;
import org.apache.hadoop.yarn.nodelabels.NodeAttributesManager;
import org.apache.hadoop.yarn.nodelabels.NodeLabelUtil;
import org.apache.hadoop.yarn.server.resourcemanager.NodeAttributeTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.FileSystemNodeAttributeStore;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeAttributesManagerImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNodeAttributesManager {
    private NodeAttributesManager attributesManager;
    private static final String[] PREFIXES = new String[]{"yarn.test1.io", "yarn.test2.io", "yarn.test3.io"};
    private static final String[] HOSTNAMES = new String[]{"host1", "host2", "host3"};

    @Before
    public void init() throws IOException {
        Configuration conf = new Configuration();
        this.attributesManager = new NodeAttributesManagerImpl();
        conf.setClass("yarn.node-attribute.fs-store.impl.class", FileSystemNodeAttributeStore.class, NodeAttributeStore.class);
        conf = NodeAttributeTestUtils.getRandomDirConf(conf);
        this.attributesManager.init(conf);
        this.attributesManager.start();
    }

    @After
    public void cleanUp() {
        if (this.attributesManager != null) {
            this.attributesManager.stop();
        }
    }

    private Set<NodeAttribute> createAttributesForTest(String attributePrefix, int numOfAttributes, String attributeNamePrefix, String attributeValuePrefix) {
        HashSet<NodeAttribute> attributes = new HashSet<NodeAttribute>();
        for (int i = 0; i < numOfAttributes; ++i) {
            NodeAttribute attribute = NodeAttribute.newInstance((String)attributePrefix, (String)(attributeNamePrefix + "_" + i), (NodeAttributeType)NodeAttributeType.STRING, (String)(attributeValuePrefix + "_" + i));
            attributes.add(attribute);
        }
        return attributes;
    }

    private boolean sameAttributeSet(Set<NodeAttribute> set1, Set<NodeAttribute> set2) {
        return Sets.difference(set1, set2).isEmpty();
    }

    @Test
    public void testAddNodeAttributes() throws IOException {
        HashMap<String, Set<NodeAttribute>> toAddAttributes = new HashMap<String, Set<NodeAttribute>>();
        toAddAttributes.put(HOSTNAMES[0], this.createAttributesForTest(PREFIXES[0], 3, "A", "host1_v1"));
        this.attributesManager.addNodeAttributes(toAddAttributes);
        Map nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)3L, (long)nodeAttributes.size());
        Assert.assertTrue((boolean)this.sameAttributeSet((Set)toAddAttributes.get(HOSTNAMES[0]), nodeAttributes.keySet()));
        toAddAttributes.clear();
        toAddAttributes.put(HOSTNAMES[1], this.createAttributesForTest(PREFIXES[0], 2, "A", "host2_v1"));
        this.attributesManager.addNodeAttributes(toAddAttributes);
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)3L, (long)nodeAttributes.size());
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[1]);
        Assert.assertEquals((long)2L, (long)nodeAttributes.size());
        Assert.assertTrue((boolean)this.sameAttributeSet((Set)toAddAttributes.get(HOSTNAMES[1]), nodeAttributes.keySet()));
        Set clusterAttributes = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{PREFIXES[0]}));
        Assert.assertEquals((long)3L, (long)clusterAttributes.size());
        clusterAttributes = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{"non_exist_prefix"}));
        Assert.assertEquals((long)0L, (long)clusterAttributes.size());
        clusterAttributes = this.attributesManager.getClusterNodeAttributes(null);
        Assert.assertEquals((long)3L, (long)clusterAttributes.size());
        toAddAttributes.clear();
        toAddAttributes.put(HOSTNAMES[0], this.createAttributesForTest(PREFIXES[1], 10, "C", "host1_v2"));
        toAddAttributes.put(HOSTNAMES[1], this.createAttributesForTest(PREFIXES[1], 20, "C", "host1_v2"));
        this.attributesManager.addNodeAttributes(toAddAttributes);
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)13L, (long)nodeAttributes.size());
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[1]);
        Assert.assertEquals((long)22L, (long)nodeAttributes.size());
    }

    @Test
    public void testRemoveNodeAttributes() throws IOException {
        HashMap toAddAttributes = new HashMap();
        HashMap toRemoveAttributes = new HashMap();
        Set allAttributesPerPrefix = new HashSet();
        HashSet<NodeAttribute> host1set = new HashSet<NodeAttribute>();
        Set<NodeAttribute> host1set1 = this.createAttributesForTest(PREFIXES[0], 3, "A", "host1_v1");
        Set<NodeAttribute> host1set2 = this.createAttributesForTest(PREFIXES[1], 5, "B", "host1_v1");
        host1set.addAll(host1set1);
        host1set.addAll(host1set2);
        HashSet<NodeAttribute> host2set = new HashSet<NodeAttribute>();
        Set<NodeAttribute> host2set1 = this.createAttributesForTest(PREFIXES[0], 2, "A", "host2_v1");
        Set<NodeAttribute> host2set2 = this.createAttributesForTest(PREFIXES[2], 2, "C", "host2_v3");
        host2set.addAll(host2set1);
        host2set.addAll(host2set2);
        toAddAttributes.put(HOSTNAMES[0], host1set);
        toAddAttributes.put(HOSTNAMES[1], host2set);
        this.attributesManager.addNodeAttributes(toAddAttributes);
        Map nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)8L, (long)nodeAttributes.size());
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[1]);
        Assert.assertEquals((long)4L, (long)nodeAttributes.size());
        allAttributesPerPrefix = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{PREFIXES[0]}));
        Assert.assertEquals((long)3L, (long)allAttributesPerPrefix.size());
        allAttributesPerPrefix = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{PREFIXES[1]}));
        Assert.assertEquals((long)5L, (long)allAttributesPerPrefix.size());
        allAttributesPerPrefix = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{PREFIXES[2]}));
        Assert.assertEquals((long)2L, (long)allAttributesPerPrefix.size());
        HashSet<NodeAttribute> attributes2rm1 = new HashSet<NodeAttribute>();
        attributes2rm1.add(NodeAttribute.newInstance((String)PREFIXES[0], (String)"A_2", (NodeAttributeType)NodeAttributeType.STRING, (String)"anyValue"));
        toRemoveAttributes.put(HOSTNAMES[0], attributes2rm1);
        this.attributesManager.removeNodeAttributes(toRemoveAttributes);
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)7L, (long)nodeAttributes.size());
        attributes2rm1.clear();
        toRemoveAttributes.clear();
        attributes2rm1.add(NodeAttribute.newInstance((String)PREFIXES[0], (String)"non_exist_name", (NodeAttributeType)NodeAttributeType.STRING, (String)"anyValue"));
        toRemoveAttributes.put(HOSTNAMES[0], attributes2rm1);
        this.attributesManager.removeNodeAttributes(toRemoveAttributes);
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)7L, (long)nodeAttributes.size());
        HashSet<NodeAttribute> attributes2rm2 = new HashSet<NodeAttribute>();
        attributes2rm2.add(NodeAttribute.newInstance((String)PREFIXES[0], (String)"A_2", (NodeAttributeType)NodeAttributeType.STRING, (String)"anyValue"));
        toRemoveAttributes.clear();
        toRemoveAttributes.put(HOSTNAMES[1], attributes2rm2);
        this.attributesManager.removeNodeAttributes(toRemoveAttributes);
        allAttributesPerPrefix = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{PREFIXES[0]}));
        Assert.assertEquals((long)2L, (long)allAttributesPerPrefix.size());
    }

    @Test
    public void testReplaceNodeAttributes() throws IOException {
        HashMap<String, Set<NodeAttribute>> toAddAttributes = new HashMap<String, Set<NodeAttribute>>();
        HashMap<String, Set<NodeAttribute>> toReplaceMap = new HashMap<String, Set<NodeAttribute>>();
        toAddAttributes.put(HOSTNAMES[0], this.createAttributesForTest(PREFIXES[0], 3, "A", "host1_v1"));
        this.attributesManager.addNodeAttributes(toAddAttributes);
        Map nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)3L, (long)nodeAttributes.size());
        toAddAttributes.clear();
        toAddAttributes.put(HOSTNAMES[0], this.createAttributesForTest("nm.yarn.io", 10, "dist-node-attribute", "dist_v1"));
        this.attributesManager.addNodeAttributes(toAddAttributes);
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)13L, (long)nodeAttributes.size());
        Set clusterAttributes = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{"nm.yarn.io", PREFIXES[0]}));
        Assert.assertEquals((long)13L, (long)clusterAttributes.size());
        Set<NodeAttribute> toReplaceAttributes = this.createAttributesForTest("nm.yarn.io", 5, "dist-node-attribute", "dist_v2");
        this.attributesManager.replaceNodeAttributes("nm.yarn.io", (Map)ImmutableMap.of((Object)HOSTNAMES[0], toReplaceAttributes));
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)8L, (long)nodeAttributes.size());
        clusterAttributes = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{"nm.yarn.io", PREFIXES[0]}));
        Assert.assertEquals((long)8L, (long)clusterAttributes.size());
        Set filteredAttributes = NodeLabelUtil.filterAttributesByPrefix(nodeAttributes.keySet(), (String)"nm.yarn.io");
        Assert.assertEquals((long)5L, (long)filteredAttributes.size());
        Assert.assertTrue((boolean)filteredAttributes.stream().allMatch(nodeAttribute -> nodeAttribute.getAttributeValue().startsWith("dist_v2")));
        filteredAttributes = NodeLabelUtil.filterAttributesByPrefix(nodeAttributes.keySet(), (String)PREFIXES[0]);
        Assert.assertEquals((long)3L, (long)filteredAttributes.size());
        toReplaceAttributes = this.createAttributesForTest("nm.yarn.io", 1, "dist-node-attribute-v2", "dist_v3");
        this.attributesManager.replaceNodeAttributes("nm.yarn.io", (Map)ImmutableMap.of((Object)HOSTNAMES[0], toReplaceAttributes));
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)4L, (long)nodeAttributes.size());
        clusterAttributes = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{"nm.yarn.io"}));
        Assert.assertEquals((long)1L, (long)clusterAttributes.size());
        NodeAttribute attr = (NodeAttribute)clusterAttributes.iterator().next();
        Assert.assertEquals((Object)"dist-node-attribute-v2_0", (Object)attr.getAttributeKey().getAttributeName());
        Assert.assertEquals((Object)"nm.yarn.io", (Object)attr.getAttributeKey().getAttributePrefix());
        Assert.assertEquals((Object)"dist_v3_0", (Object)attr.getAttributeValue());
        toReplaceMap.put(HOSTNAMES[0], this.createAttributesForTest(PREFIXES[1], 2, "B", "B_v1"));
        this.attributesManager.replaceNodeAttributes(null, toReplaceMap);
        nodeAttributes = this.attributesManager.getAttributesForNode(HOSTNAMES[0]);
        Assert.assertEquals((long)2L, (long)nodeAttributes.size());
        clusterAttributes = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{PREFIXES[1]}));
        Assert.assertEquals((long)2L, (long)clusterAttributes.size());
        clusterAttributes = this.attributesManager.getClusterNodeAttributes((Set)Sets.newHashSet((Object[])new String[]{"nm.yarn.io"}));
        Assert.assertEquals((long)0L, (long)clusterAttributes.size());
    }
}

