/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestQueueState {
    private static final String Q1 = "q1";
    private static final String Q2 = "q2";
    private static final String Q3 = "q3";
    private static final String Q1_PATH = "root.q1";
    private static final String Q2_PATH = "root.q1.q2";
    private static final String Q3_PATH = "root.q1.q3";
    private CapacityScheduler cs;
    private YarnConfiguration conf;

    @Test(timeout=15000L)
    public void testQueueState() throws IOException {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{Q1});
        csConf.setQueues(Q1_PATH, new String[]{Q2});
        csConf.setCapacity(Q1_PATH, 100.0f);
        csConf.setCapacity(Q2_PATH, 100.0f);
        this.conf = new YarnConfiguration((Configuration)csConf);
        this.cs = new CapacityScheduler();
        RMContext rmContext = TestUtils.getMockRMContext();
        this.cs.setConf((Configuration)this.conf);
        this.cs.setRMContext(rmContext);
        this.cs.init((Configuration)this.conf);
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q2).getState());
        csConf.setState(Q1_PATH, QueueState.STOPPED);
        this.conf = new YarnConfiguration((Configuration)csConf);
        this.cs.reinitialize((Configuration)this.conf, rmContext);
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q2).getState());
        csConf.setState(Q1_PATH, QueueState.RUNNING);
        csConf.setState(Q2_PATH, QueueState.STOPPED);
        this.conf = new YarnConfiguration((Configuration)csConf);
        this.cs.reinitialize((Configuration)this.conf, rmContext);
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q2).getState());
        csConf.setState(Q1_PATH, QueueState.STOPPED);
        csConf.setState(Q2_PATH, QueueState.RUNNING);
        this.conf = new YarnConfiguration((Configuration)csConf);
        try {
            this.cs.reinitialize((Configuration)this.conf, rmContext);
            Assert.fail((String)"Should throw an Exception.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getCause().getMessage().contains("The parent queue:q1 state is STOPPED, child queue:q2 state cannot be RUNNING."));
        }
    }

    @Test(timeout=15000L)
    public void testQueueStateTransit() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{Q1});
        csConf.setQueues(Q1_PATH, new String[]{Q2, Q3});
        csConf.setCapacity(Q1_PATH, 100.0f);
        csConf.setCapacity(Q2_PATH, 50.0f);
        csConf.setCapacity(Q3_PATH, 50.0f);
        this.conf = new YarnConfiguration((Configuration)csConf);
        this.cs = new CapacityScheduler();
        RMContext rmContext = TestUtils.getMockRMContext();
        this.cs.setConf((Configuration)this.conf);
        this.cs.setRMContext(rmContext);
        this.cs.init((Configuration)this.conf);
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q3).getState());
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        String userName = "testUser";
        this.cs.getQueue(Q2).submitApplication(appId, userName, Q2);
        FiCaSchedulerApp app = this.getMockApplication(appId, userName, Resources.createResource((int)4, (int)0));
        this.cs.getQueue(Q2).submitApplicationAttempt(app, userName);
        csConf.setState(Q2_PATH, QueueState.STOPPED);
        this.conf = new YarnConfiguration((Configuration)csConf);
        this.cs.reinitialize((Configuration)this.conf, rmContext);
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)this.cs.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q3).getState());
        csConf.setState(Q1_PATH, QueueState.STOPPED);
        this.conf = new YarnConfiguration((Configuration)csConf);
        this.cs.reinitialize((Configuration)this.conf, rmContext);
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)this.cs.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q3).getState());
        csConf.setState(Q3_PATH, QueueState.RUNNING);
        this.conf = new YarnConfiguration((Configuration)csConf);
        try {
            this.cs.reinitialize((Configuration)this.conf, rmContext);
            Assert.fail((String)"Should throw an Exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cs.getQueue(Q2).finishApplicationAttempt(app, Q2);
        this.cs.getQueue(Q2).finishApplication(appId, userName);
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q3).getState());
    }

    private FiCaSchedulerApp getMockApplication(ApplicationId appId, String user, Resource amResource) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        ((FiCaSchedulerApp)Mockito.doReturn((Object)applicationAttemptId.getApplicationId()).when((Object)application)).getApplicationId();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)applicationAttemptId).when((Object)application)).getApplicationAttemptId();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)user).when((Object)application)).getUser();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)amResource).when((Object)application)).getAMResource();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)Priority.newInstance((int)0)).when((Object)application)).getPriority();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)"").when((Object)application)).getAppAMNodePartitionName();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)amResource).when((Object)application)).getAMResource("");
        Mockito.when((Object)application.compareInputOrderTo((SchedulableEntity)Matchers.any(FiCaSchedulerApp.class))).thenCallRealMethod();
        return application;
    }

    @Test(timeout=30000L)
    public void testRecoverDrainingStateAfterRMRestart() throws Exception {
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration();
        newConf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        newConf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        newConf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        newConf.setInt("yarn.resourcemanager.max-completed-applications", 1);
        newConf.setQueues("root", new String[]{Q1});
        newConf.setQueues(Q1_PATH, new String[]{Q2});
        newConf.setCapacity(Q1_PATH, 100.0f);
        newConf.setCapacity(Q2_PATH, 100.0f);
        MemoryRMStateStore newMemStore = new MemoryRMStateStore();
        newMemStore.init((Configuration)newConf);
        MockRM rm = new MockRM((Configuration)newConf, (RMStateStore)newMemStore);
        rm.start();
        MockNM nm = rm.registerNode("h1:1234", 204800);
        RMApp app = rm.submitApp(1024, "appname", "appuser", null, Q2);
        MockRM.launchAM(app, rm, nm);
        rm.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        newConf.setState(Q1_PATH, QueueState.STOPPED);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getRMContext().getScheduler();
        capacityScheduler.reinitialize((Configuration)newConf, rm.getRMContext());
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)capacityScheduler.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)capacityScheduler.getQueue(Q1).getState());
        rm = new MockRM((Configuration)newConf, (RMStateStore)newMemStore);
        rm.start();
        rm.registerNode("h1:1234", 204800);
        rm.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        capacityScheduler = (CapacityScheduler)rm.getRMContext().getScheduler();
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)capacityScheduler.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)capacityScheduler.getQueue(Q1).getState());
        rm.close();
    }
}

