/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestApplicationMasterServiceWithFS {
    private static final Log LOG = LogFactory.getLog(TestApplicationMasterServiceWithFS.class);
    private static final int GB = 1024;
    private static final int MEMORY_ALLOCATION = 3072;
    private static final String TEST_FOLDER = "test-queues";
    private AllocateResponse allocateResponse;
    private static YarnConfiguration configuration;

    @BeforeClass
    public static void setup() throws IOException {
        String allocFile = GenericTestUtils.getTestDir((String)TEST_FOLDER).getAbsolutePath();
        configuration = new YarnConfiguration();
        configuration.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        configuration.set("yarn.scheduler.fair.allocation.file", allocFile);
        PrintWriter out = new PrintWriter(new FileWriter(allocFile));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\">");
        out.println("   <maxContainerAllocation>2048 mb 1 vcores</maxContainerAllocation>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueB\">");
        out.println("   <maxContainerAllocation>3072 mb 1 vcores</maxContainerAllocation>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueC\">");
        out.println("  </queue>");
        out.println("</allocations>");
        out.close();
    }

    @AfterClass
    public static void teardown() {
        File allocFile = GenericTestUtils.getTestDir((String)TEST_FOLDER);
        allocFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000000L)
    public void testQueueLevelContainerAllocationFail() throws Exception {
        MockRM rm = new MockRM((Configuration)configuration);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048, "queueA");
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.addRequests(new String[]{"127.0.0.1"}, 3072, 1, 1);
        try {
            this.allocateResponse = am1.schedule();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvalidResourceRequestException));
            Assert.assertEquals((Object)InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION, (Object)((InvalidResourceRequestException)((Object)e)).getInvalidResourceType());
        }
        finally {
            rm.stop();
        }
    }

    @Test(timeout=3000000L)
    public void testQueueLevelContainerAllocationSuccess() throws Exception {
        this.testFairSchedulerContainerAllocationSuccess("queueB");
    }

    @Test(timeout=3000000L)
    public void testSchedulerLevelContainerAllocationSuccess() throws Exception {
        this.testFairSchedulerContainerAllocationSuccess("queueC");
    }

    private void testFairSchedulerContainerAllocationSuccess(String queueName) throws Exception {
        MockRM rm = new MockRM((Configuration)configuration);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048, queueName);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.addRequests(new String[]{"127.0.0.1"}, 3072, 1, 1);
        this.allocateResponse = am1.schedule();
        ((FairScheduler)rm.getResourceScheduler()).update();
        nm1.nodeHeartbeat(true);
        GenericTestUtils.waitFor(() -> {
            LOG.info((Object)"Waiting for containers to be created for app 1");
            try {
                this.allocateResponse = am1.schedule();
            }
            catch (Exception e) {
                Assert.fail((String)"Allocation should be successful");
            }
            return this.allocateResponse.getAllocatedContainers().size() > 0;
        }, (int)1000, (int)10000);
        Container allocatedContainer = (Container)this.allocateResponse.getAllocatedContainers().get(0);
        Assert.assertEquals((long)3072L, (long)allocatedContainer.getResource().getMemorySize());
        Assert.assertEquals((long)1L, (long)allocatedContainer.getResource().getVirtualCores());
        rm.stop();
    }
}

