/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;

public class MockMemoryRMStateStore
extends MemoryRMStateStore {
    private Map<ApplicationId, ApplicationSubmissionContext> appSubCtxtCopy = new HashMap<ApplicationId, ApplicationSubmissionContext>();

    protected EventHandler getRMStateStoreEventHandler() {
        return this.rmStateStoreEventHandler;
    }

    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState cloneState = super.loadState();
        for (Map.Entry state : cloneState.getApplicationState().entrySet()) {
            ApplicationStateData oldStateData = (ApplicationStateData)state.getValue();
            oldStateData.setApplicationSubmissionContext(this.appSubCtxtCopy.get(state.getKey()));
            cloneState.getApplicationState().put(state.getKey(), oldStateData);
        }
        return cloneState;
    }

    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appState) throws Exception {
        this.cloneAppSubmissionContext(appState);
        super.storeApplicationStateInternal(appId, appState);
    }

    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appState) throws Exception {
        this.cloneAppSubmissionContext(appState);
        super.updateApplicationStateInternal(appId, appState);
    }

    private void cloneAppSubmissionContext(ApplicationStateData appState) {
        ApplicationSubmissionContext oldAppSubCtxt = appState.getApplicationSubmissionContext();
        ApplicationSubmissionContext context = ApplicationSubmissionContext.newInstance((ApplicationId)oldAppSubCtxt.getApplicationId(), (String)oldAppSubCtxt.getApplicationName(), (String)oldAppSubCtxt.getQueue(), (Priority)oldAppSubCtxt.getPriority(), (ContainerLaunchContext)oldAppSubCtxt.getAMContainerSpec(), (boolean)oldAppSubCtxt.getUnmanagedAM(), (boolean)oldAppSubCtxt.getCancelTokensWhenComplete(), (int)oldAppSubCtxt.getMaxAppAttempts(), (Resource)oldAppSubCtxt.getResource());
        context.setAttemptFailuresValidityInterval(oldAppSubCtxt.getAttemptFailuresValidityInterval());
        context.setKeepContainersAcrossApplicationAttempts(oldAppSubCtxt.getKeepContainersAcrossApplicationAttempts());
        context.setAMContainerResourceRequests(oldAppSubCtxt.getAMContainerResourceRequests());
        context.setLogAggregationContext(oldAppSubCtxt.getLogAggregationContext());
        context.setApplicationType(oldAppSubCtxt.getApplicationType());
        context.setNodeLabelExpression(oldAppSubCtxt.getNodeLabelExpression());
        this.appSubCtxtCopy.put(oldAppSubCtxt.getApplicationId(), context);
    }

    @VisibleForTesting
    public RMStateStore.RMState reloadStateWithClonedAppSubCtxt(RMStateStore.RMState actualState) {
        for (Map.Entry state : actualState.getApplicationState().entrySet()) {
            ApplicationStateData oldStateData = (ApplicationStateData)state.getValue();
            oldStateData.setApplicationSubmissionContext(this.appSubCtxtCopy.get(state.getKey()));
            actualState.getApplicationState().put(state.getKey(), oldStateData);
        }
        return actualState;
    }
}

