/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSorter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSortingManager;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCapacitySchedulerMultiNodes
extends CapacitySchedulerTestBase {
    private static final Log LOG = LogFactory.getLog(TestCapacitySchedulerMultiNodes.class);
    private CapacitySchedulerConfiguration conf;
    private static final String POLICY_CLASS_NAME = "org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.ResourceUsageMultiNodeLookupPolicy";

    @Before
    public void setUp() {
        CapacitySchedulerConfiguration config = new CapacitySchedulerConfiguration();
        config.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        this.conf = new CapacitySchedulerConfiguration((Configuration)config);
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.conf.set("yarn.scheduler.capacity.multi-node-sorting.policy.names", "resource-based");
        this.conf.set("yarn.scheduler.capacity.multi-node-sorting.policy", "resource-based");
        String policyName = "yarn.scheduler.capacity.multi-node-sorting.policy.resource-based.class";
        this.conf.set(policyName, POLICY_CLASS_NAME);
        this.conf.setBoolean("yarn.scheduler.capacity.multi-node-placement-enabled", true);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 512);
        this.conf.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
    }

    @Test
    public void testMultiNodeSorterForScheduling() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 10240);
        rm.registerNode("127.0.0.1:1235", 10240);
        rm.registerNode("127.0.0.1:1236", 10240);
        rm.registerNode("127.0.0.1:1237", 10240);
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        this.waitforNMRegistered(scheduler, 4, 5);
        MultiNodeSortingManager mns = rm.getRMContext().getMultiNodeSortingManager();
        MultiNodeSorter sorter = mns.getMultiNodePolicy(POLICY_CLASS_NAME);
        sorter.reSortClusterNodes();
        Set nodes = sorter.getMultiNodeLookupPolicy().getNodesPerPartition("");
        Assert.assertEquals((long)4L, (long)nodes.size());
        rm.stop();
    }

    @Test
    public void testMultiNodeSorterForSchedulingWithOrdering() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 10240, 10);
        MockNM nm2 = rm.registerNode("127.0.0.2:1235", 10240, 10);
        MockNM nm3 = rm.registerNode("127.0.0.3:1236", 10240, 10);
        MockNM nm4 = rm.registerNode("127.0.0.4:1237", 10240, 10);
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        this.waitforNMRegistered(scheduler, 4, 5);
        MultiNodeSortingManager mns = rm.getRMContext().getMultiNodeSortingManager();
        MultiNodeSorter sorter = mns.getMultiNodePolicy(POLICY_CLASS_NAME);
        sorter.reSortClusterNodes();
        Set nodes = sorter.getMultiNodeLookupPolicy().getNodesPerPartition("");
        Assert.assertEquals((long)4L, (long)nodes.size());
        RMApp app1 = rm.submitApp(2048, "app-1", "user1", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        SchedulerNodeReport reportNm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)8192L, (long)reportNm1.getAvailableResource().getMemorySize());
        sorter.reSortClusterNodes();
        RMApp app2 = rm.submitApp(1024, "app-2", "user2", null, "default");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        SchedulerNodeReport reportNm2 = rm.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)1024L, (long)reportNm2.getUsedResource().getMemorySize());
        Assert.assertEquals((long)9216L, (long)reportNm2.getAvailableResource().getMemorySize());
        sorter.reSortClusterNodes();
        nodes = sorter.getMultiNodeLookupPolicy().getNodesPerPartition("");
        ArrayList<NodeId> currentNodes = new ArrayList<NodeId>();
        currentNodes.add(nm3.getNodeId());
        currentNodes.add(nm4.getNodeId());
        currentNodes.add(nm2.getNodeId());
        currentNodes.add(nm1.getNodeId());
        Iterator it = nodes.iterator();
        int i = 0;
        while (it.hasNext()) {
            SchedulerNode current = (SchedulerNode)it.next();
            Assert.assertEquals((Object)current.getNodeID(), currentNodes.get(i++));
        }
        rm.stop();
    }
}

