/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import io.hops.security.AbstractSecurityActions;
import io.hops.security.HopsSecurityActionsFactory;
import io.hops.security.SuperuserKeystoresLoader;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.DateUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.DBRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.MockX509SecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityMaterial;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMSecurityHandlersBaseTest;
import org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestX509SecurityHandler
extends RMSecurityHandlersBaseTest {
    private static final Log LOG = LogFactory.getLog(TestX509SecurityHandler.class);
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestX509SecurityHandler.class.getSimpleName()).toString();
    private static final File BASE_DIR_FILE = new File(BASE_DIR);
    private static Configuration conf;
    private DrainDispatcher dispatcher;
    private RMContext rmContext;
    private static UserGroupInformation currentUGI;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        BASE_DIR_FILE.mkdirs();
        currentUGI = UserGroupInformation.getCurrentUser();
    }

    @Before
    public void beforeTest() throws Exception {
        conf = new Configuration();
        conf.set(YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD, "5s");
        HopsSecurityActionsFactory.getInstance().clear(conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
        this.dispatcher = new DrainDispatcher();
        this.rmContext = new RMContextImpl((Dispatcher)this.dispatcher, null, null, null, null, null, null, null, null);
        this.dispatcher.init(conf);
        this.dispatcher.start();
    }

    @After
    public void afterTest() throws Exception {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (BASE_DIR_FILE.exists()) {
            FileUtils.deleteDirectory((File)BASE_DIR_FILE);
        }
        HopsSecurityActionsFactory.getInstance().clear(conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
    }

    @Test
    public void testSuccessfulCertificateCreationTesting() throws Exception {
        conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        RMAppSecurityActions testActor = (RMAppSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(conf, conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions"));
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        String trustStore = Paths.get(BASE_DIR, loader.getSuperTruststoreFilename(currentUGI.getUserName())).toString();
        X509Certificate caCert = ((TestingRMAppSecurityActions)testActor).getCaCert();
        String principal = caCert.getIssuerX500Principal().getName();
        String alias = principal.split("=")[1];
        String password = "password";
        Path passwd = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(currentUGI.getUserName()));
        FileUtils.writeStringToFile((File)passwd.toFile(), (String)password);
        conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        this.createTrustStore(trustStore, password, alias, caCert);
        RMSecurityHandlersBaseTest.MockRMAppEventHandler eventHandler = new RMSecurityHandlersBaseTest.MockRMAppEventHandler(RMAppEventType.SECURITY_MATERIAL_GENERATED);
        this.rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)eventHandler);
        RMAppSecurityManager rmAppSecurityManager = new RMAppSecurityManager(this.rmContext);
        MockX509SecurityHandler x509SecurityHandler = new MockX509SecurityHandler(this.rmContext, rmAppSecurityManager, true);
        rmAppSecurityManager.registerRMAppSecurityHandler((RMAppSecurityHandler)x509SecurityHandler);
        rmAppSecurityManager.init(conf);
        rmAppSecurityManager.start();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(appId, "Dorothy", Integer.valueOf(1));
        RMAppSecurityMaterial securityMaterial = new RMAppSecurityMaterial();
        securityMaterial.addMaterial((RMAppSecurityManager.SecurityManagerMaterial)x509Param);
        RMAppSecurityManagerEvent genSecurityMaterialEvent = new RMAppSecurityManagerEvent(appId, securityMaterial, RMAppSecurityManagerEventType.GENERATE_SECURITY_MATERIAL);
        rmAppSecurityManager.handle(genSecurityMaterialEvent);
        this.dispatcher.await();
        eventHandler.verifyEvent();
        rmAppSecurityManager.stop();
    }

    @Test
    public void testCertificateRenewal() throws Exception {
        conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        RMAppSecurityManager rmAppSecurityManager = new RMAppSecurityManager(this.rmContext);
        MockX509SecurityHandler x509SecurityHandler = new MockX509SecurityHandler(this.rmContext, rmAppSecurityManager, false);
        rmAppSecurityManager.registerRMAppSecurityHandler((RMAppSecurityHandler)x509SecurityHandler);
        rmAppSecurityManager.init(conf);
        rmAppSecurityManager.start();
        LocalDateTime now = DateUtils.getNow();
        LocalDateTime expiration = now.plus(10L, ChronoUnit.SECONDS);
        ApplicationId appId = ApplicationId.newInstance((long)DateUtils.localDateTime2UnixEpoch((LocalDateTime)now), (int)1);
        x509SecurityHandler.setOldCertificateExpiration(DateUtils.localDateTime2UnixEpoch((LocalDateTime)expiration));
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(appId, "Dolores", Integer.valueOf(1));
        x509Param.setExpiration(Long.valueOf(DateUtils.localDateTime2UnixEpoch((LocalDateTime)expiration)));
        x509SecurityHandler.registerRenewer(x509Param);
        Map tasks = x509SecurityHandler.getRenewalTasks();
        ScheduledFuture renewalTask = (ScheduledFuture)tasks.get(appId);
        Assert.assertFalse((boolean)renewalTask.isCancelled());
        Assert.assertFalse((boolean)renewalTask.isDone());
        TimeUnit.SECONDS.sleep(10L);
        TestCase.assertTrue((boolean)renewalTask.isDone());
        Assert.assertFalse((boolean)x509SecurityHandler.getRenewalException());
        TestCase.assertTrue((boolean)tasks.isEmpty());
        rmAppSecurityManager.stop();
    }

    @Test(timeout=12000L)
    public void testFailedCertificateRenewal() throws Exception {
        conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        RMAppSecurityManager securityManager = new RMAppSecurityManager(this.rmContext);
        MockX509SecurityHandler.MockFailingX509SecurityHandler x509Handler = new MockX509SecurityHandler.MockFailingX509SecurityHandler(this.rmContext, securityManager, Integer.MAX_VALUE);
        securityManager.registerRMAppSecurityHandlerWithType((RMAppSecurityHandler)x509Handler, X509SecurityHandler.class);
        securityManager.init(conf);
        securityManager.start();
        LocalDateTime now = DateUtils.getNow();
        LocalDateTime expiration = now.plus(10L, ChronoUnit.SECONDS);
        ApplicationId appId = ApplicationId.newInstance((long)DateUtils.localDateTime2UnixEpoch((LocalDateTime)now), (int)1);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(appId, "Dolores", Integer.valueOf(1));
        x509Param.setExpiration(Long.valueOf(DateUtils.localDateTime2UnixEpoch((LocalDateTime)expiration)));
        x509Handler.registerRenewer(x509Param);
        Map tasks = x509Handler.getRenewalTasks();
        ScheduledFuture task = (ScheduledFuture)tasks.get(appId);
        Assert.assertFalse((boolean)task.isCancelled());
        Assert.assertFalse((boolean)task.isDone());
        Assert.assertFalse((boolean)x509Handler.hasRenewalFailed());
        Assert.assertEquals((long)0L, (long)x509Handler.getNumberOfRenewalFailures());
        TimeUnit.SECONDS.sleep(10L);
        TestCase.assertTrue((boolean)tasks.isEmpty());
        Assert.assertEquals((long)4L, (long)x509Handler.getNumberOfRenewalFailures());
        TestCase.assertTrue((boolean)x509Handler.hasRenewalFailed());
        securityManager.stop();
    }

    @Test(timeout=12000L)
    public void testRetryCertificateRenewal() throws Exception {
        conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        RMAppSecurityManager securityManager = new RMAppSecurityManager(this.rmContext);
        MockX509SecurityHandler.MockFailingX509SecurityHandler x509Handler = new MockX509SecurityHandler.MockFailingX509SecurityHandler(this.rmContext, securityManager, 2);
        securityManager.registerRMAppSecurityHandlerWithType((RMAppSecurityHandler)x509Handler, X509SecurityHandler.class);
        securityManager.init(conf);
        securityManager.start();
        LocalDateTime now = DateUtils.getNow();
        LocalDateTime expiration = now.plus(10L, ChronoUnit.SECONDS);
        ApplicationId appId = ApplicationId.newInstance((long)DateUtils.localDateTime2UnixEpoch((LocalDateTime)now), (int)1);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(appId, "Dolores", Integer.valueOf(1));
        x509Param.setExpiration(Long.valueOf(DateUtils.localDateTime2UnixEpoch((LocalDateTime)expiration)));
        x509Handler.registerRenewer(x509Param);
        TimeUnit.SECONDS.sleep(10L);
        Assert.assertEquals((long)2L, (long)x509Handler.getNumberOfRenewalFailures());
        Assert.assertFalse((boolean)x509Handler.hasRenewalFailed());
        TestCase.assertTrue((boolean)x509Handler.getRenewalTasks().isEmpty());
        securityManager.stop();
    }

    @Test
    public void testFailingCertificateCreationLocal() throws Exception {
        conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        RMSecurityHandlersBaseTest.MockRMAppEventHandler eventHandler = new RMSecurityHandlersBaseTest.MockRMAppEventHandler(RMAppEventType.KILL);
        this.rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)eventHandler);
        RMAppSecurityManager securityManager = new RMAppSecurityManager(this.rmContext);
        MockX509SecurityHandler.MockFailingX509SecurityHandler x509Handler = new MockX509SecurityHandler.MockFailingX509SecurityHandler(this.rmContext, securityManager, Integer.MAX_VALUE);
        securityManager.registerRMAppSecurityHandlerWithType((RMAppSecurityHandler)x509Handler, X509SecurityHandler.class);
        securityManager.init(conf);
        securityManager.start();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(appId, "Dolores", Integer.valueOf(1));
        RMAppSecurityMaterial securityMaterial = new RMAppSecurityMaterial();
        securityMaterial.addMaterial((RMAppSecurityManager.SecurityManagerMaterial)x509Param);
        securityManager.handle(new RMAppSecurityManagerEvent(appId, securityMaterial, RMAppSecurityManagerEventType.GENERATE_SECURITY_MATERIAL));
        this.dispatcher.await();
        eventHandler.verifyEvent();
        securityManager.stop();
    }

    @Test(timeout=20000L)
    public void testCertificateRevocationMonitor() throws Exception {
        conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        RMAppSecurityActions actor = (RMAppSecurityActions)Mockito.spy((Object)new TestingRMAppSecurityActions());
        ((AbstractSecurityActions)actor).init(conf);
        ((AbstractSecurityActions)actor).start();
        HopsSecurityActionsFactory.getInstance().register(conf.get(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY), (AbstractSecurityActions)actor);
        conf.set(YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD, "40s");
        conf.set(YarnConfiguration.RM_APP_CERTIFICATE_REVOCATION_MONITOR_INTERVAL, "3s");
        conf.setBoolean("ipc.server.ssl.enabled", true);
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        Path passwd = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(currentUGI.getUserName()));
        FileUtils.writeStringToFile((File)passwd.toFile(), (String)"password");
        conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        MyMockRM rm = new MyMockRM(conf);
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:8032", 15360, rm.getResourceTrackerService());
        nm.registerNode();
        RMApp application = rm.submitApp(1024, "application1", "Phil", new HashMap<ApplicationAccessType, String>(), false, "default", 2, null, "MAPREDUCE", true, false);
        nm.nodeHeartbeat(true);
        while (!application.isAppRotatingCryptoMaterial()) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        LOG.info((Object)">> Rotation has happened");
        TestCase.assertTrue((boolean)application.isAppRotatingCryptoMaterial());
        Assert.assertNotEquals((long)-1L, (long)application.getMaterialRotationStartTime());
        TimeUnit.SECONDS.sleep(6L);
        Assert.assertFalse((boolean)application.isAppRotatingCryptoMaterial());
        Assert.assertEquals((long)-1L, (long)application.getMaterialRotationStartTime());
        String certId = X509SecurityHandler.getCertificateIdentifier((ApplicationId)application.getApplicationId(), (String)application.getUser(), (Integer)(application.getCryptoMaterialVersion() - 1));
        ((RMAppSecurityActions)Mockito.verify((Object)actor)).revoke((String)Mockito.eq((Object)certId));
        ((RMAppSecurityManager)Mockito.verify((Object)rm.getRMContext().getRMAppSecurityManager(), (VerificationMode)Mockito.never())).revokeSecurityMaterial((RMAppSecurityManagerEvent)Mockito.any(RMAppSecurityManagerEvent.class));
        rm.stop();
    }

    @Test
    public void testApplicationSubmission() throws Exception {
        conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", DBRMStateStore.class.getName());
        conf.set(YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD, "45s");
        conf.setBoolean("ipc.server.ssl.enabled", true);
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        Path passwd = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(currentUGI.getUserName()));
        FileUtils.writeStringToFile((File)passwd.toFile(), (String)"password");
        conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        MyMockRM rm = new MyMockRM(conf);
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:8032", 15360, rm.getResourceTrackerService());
        nm.registerNode();
        RMApp application = rm.submitApp(1024, "application1", "Phil", new HashMap<ApplicationAccessType, String>(), false, "default", 2, null, "MAPREDUCE", true, false);
        NodeHeartbeatResponse response = nm.nodeHeartbeat(true);
        int responseId = response.getResponseId();
        Assert.assertNotNull((Object)application);
        byte[] keyStore = application.getKeyStore();
        Assert.assertNotNull((Object)keyStore);
        Assert.assertNotEquals((long)0L, (long)keyStore.length);
        char[] keyStorePassword = application.getKeyStorePassword();
        Assert.assertNotNull((Object)keyStorePassword);
        Assert.assertNotEquals((long)0L, (long)keyStorePassword.length);
        byte[] trustStore = application.getTrustStore();
        Assert.assertNotNull((Object)trustStore);
        Assert.assertNotEquals((long)0L, (long)trustStore.length);
        char[] trustStorePassword = application.getTrustStorePassword();
        Integer cryptoMaterialVersion = application.getCryptoMaterialVersion();
        Assert.assertNotNull((Object)trustStorePassword);
        Assert.assertNotEquals((long)0L, (long)trustStorePassword.length);
        TimeUnit.SECONDS.sleep(6L);
        byte[] newKeyStore = application.getKeyStore();
        Assert.assertFalse((boolean)Arrays.equals(keyStore, newKeyStore));
        Assert.assertNotEquals((long)0L, (long)newKeyStore.length);
        byte[] newTrustStore = application.getTrustStore();
        Assert.assertFalse((boolean)Arrays.equals(trustStore, newTrustStore));
        Assert.assertNotEquals((long)0L, (long)newTrustStore.length);
        char[] newKeyStorePass = application.getKeyStorePassword();
        Assert.assertFalse((boolean)Arrays.equals(keyStorePassword, newKeyStorePass));
        Assert.assertNotEquals((long)0L, (long)newKeyStorePass.length);
        char[] newTrustStorePass = application.getTrustStorePassword();
        Assert.assertFalse((boolean)Arrays.equals(trustStorePassword, newTrustStorePass));
        Assert.assertNotEquals((long)0L, (long)newTrustStorePass.length);
        Integer currentCryptoMaterialVersion = application.getCryptoMaterialVersion();
        cryptoMaterialVersion = cryptoMaterialVersion + 1;
        Assert.assertEquals((Object)cryptoMaterialVersion, (Object)currentCryptoMaterialVersion);
        ApplicationStateData appState = (ApplicationStateData)rm.getRMContext().getStateStore().loadState().getApplicationState().get(application.getApplicationId());
        TestCase.assertTrue((boolean)Arrays.equals(newKeyStore, appState.getKeyStore()));
        TestCase.assertTrue((boolean)Arrays.equals(newTrustStore, appState.getTrustStore()));
        TestCase.assertTrue((boolean)Arrays.equals(newKeyStorePass, appState.getKeyStorePassword()));
        TestCase.assertTrue((boolean)Arrays.equals(newTrustStorePass, appState.getTrustStorePassword()));
        Assert.assertEquals((Object)currentCryptoMaterialVersion, (Object)appState.getCryptoMaterialVersion());
        TestCase.assertTrue((boolean)appState.isDuringMaterialRotation());
        Assert.assertNotEquals((long)-1L, (long)appState.getMaterialRotationStartTime());
        HashSet<ApplicationId> updatedAppCrypto = new HashSet<ApplicationId>(1);
        updatedAppCrypto.add(application.getApplicationId());
        nm.nodeHeartbeat(Collections.emptyList(), Collections.emptyList(), true, responseId, updatedAppCrypto);
        TimeUnit.MILLISECONDS.sleep(100L);
        RMAppImpl appImpl = (RMAppImpl)application;
        Assert.assertNull((Object)appImpl.getRMNodesUpdatedCryptoMaterial());
        Assert.assertFalse((boolean)application.isAppRotatingCryptoMaterial());
        appState = (ApplicationStateData)rm.getRMContext().getStateStore().loadState().getApplicationState().get(application.getApplicationId());
        Assert.assertFalse((boolean)appState.isDuringMaterialRotation());
        Assert.assertEquals((long)-1L, (long)appState.getMaterialRotationStartTime());
        Thread.sleep(1000L);
        X509SecurityHandler x509SecurityHandler = (X509SecurityHandler)rm.getRMContext().getRMAppSecurityManager().getSecurityHandler(X509SecurityHandler.class);
        TestCase.assertTrue((boolean)x509SecurityHandler.getRenewalTasks().containsKey(application.getApplicationId()));
        TimeUnit.MILLISECONDS.sleep(100L);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), Integer.valueOf(application.getCryptoMaterialVersion() - 1), true);
        ((X509SecurityHandler)Mockito.verify((Object)x509SecurityHandler)).revokeMaterial((X509SecurityHandler.X509MaterialParameter)Mockito.eq((Object)x509Param), Boolean.valueOf(Mockito.eq((boolean)false)));
        rm.stop();
        conf.set(YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD, "1s");
        MyMockRM rm2 = new MyMockRM(conf);
        rm2.start();
        nm.setResourceTrackerService(rm2.getResourceTrackerService());
        nm.nodeHeartbeat(true);
        RMApp recoveredApp = (RMApp)rm2.getRMContext().getRMApps().get(application.getApplicationId());
        Assert.assertNotNull((Object)recoveredApp);
        TestCase.assertTrue((boolean)Arrays.equals(newKeyStore, recoveredApp.getKeyStore()));
        appState = (ApplicationStateData)rm2.getRMContext().getStateStore().loadState().getApplicationState().get(application.getApplicationId());
        Assert.assertFalse((boolean)appState.isDuringMaterialRotation());
        Assert.assertEquals((long)-1L, (long)appState.getMaterialRotationStartTime());
        x509SecurityHandler = (X509SecurityHandler)rm2.getRMContext().getRMAppSecurityManager().getSecurityHandler(X509SecurityHandler.class);
        TestCase.assertTrue((boolean)x509SecurityHandler.getRenewalTasks().containsKey(application.getApplicationId()));
        rm2.killApp(application.getApplicationId());
        rm2.waitForState(application.getApplicationId(), RMAppState.KILLED);
        rm2.stop();
    }

    @Test
    public void testContainerAllocationDuringMaterialRotation() throws Exception {
        conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppSecurityActions");
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", DBRMStateStore.class.getName());
        conf.set(YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD, "40s");
        conf.setBoolean("ipc.server.ssl.enabled", true);
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        Path passwd = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(currentUGI.getUserName()));
        FileUtils.writeStringToFile((File)passwd.toFile(), (String)"password");
        conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        MyMockRM2 rm = new MyMockRM2(conf);
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 2048, rm.getResourceTrackerService());
        nm1.registerNode();
        RMApp app = rm.submitApp(1024);
        nm1.nodeHeartbeat(true);
        RMAppAttempt appAttempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(appAttempt.getAppAttemptId());
        am.registerAppAttempt(true);
        am.allocate("127.0.0.1", 512, 1, Collections.emptyList());
        nm1.nodeHeartbeat(true);
        List allocatedContainers = am.allocate(Collections.emptyList(), Collections.emptyList()).getAllocatedContainers();
        while (allocatedContainers.size() < 1) {
            nm1.nodeHeartbeat(true);
            TimeUnit.MILLISECONDS.sleep(200L);
            allocatedContainers = am.allocate(Collections.emptyList(), Collections.emptyList()).getAllocatedContainers();
        }
        while (!app.isAppRotatingCryptoMaterial()) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        MockNM nm2 = new MockNM("127.0.0.2:1234", 2048, rm.getResourceTrackerService());
        nm2.registerNode();
        TestCase.assertTrue((boolean)app.isAppRotatingCryptoMaterial());
        am.allocate("127.0.0.2", 512, 1, Collections.emptyList());
        NodeHeartbeatResponse nmResponse = nm2.nodeHeartbeat(true);
        TestCase.assertTrue((boolean)nmResponse.getUpdatedCryptoForApps().isEmpty());
        allocatedContainers = am.allocate(Collections.emptyList(), Collections.emptyList()).getAllocatedContainers();
        while (allocatedContainers.size() < 1) {
            nmResponse = nm2.nodeHeartbeat(true);
            TestCase.assertTrue((boolean)nmResponse.getUpdatedCryptoForApps().isEmpty());
            TimeUnit.MILLISECONDS.sleep(200L);
            allocatedContainers = am.allocate(Collections.emptyList(), Collections.emptyList()).getAllocatedContainers();
        }
        Assert.assertEquals((long)1L, (long)allocatedContainers.size());
        Assert.assertEquals((Object)nm2.getNodeId(), (Object)((Container)allocatedContainers.get(0)).getNodeId());
        TimeUnit.MILLISECONDS.sleep(500L);
        RMNodeImpl rmNode2 = (RMNodeImpl)rm.getRMContext().getRMNodes().get(nm2.getNodeId());
        Assert.assertNotNull((Object)rmNode2);
        for (int wait = 0; rmNode2.getAppX509ToUpdate().isEmpty() && wait < 10; ++wait) {
            TimeUnit.MILLISECONDS.sleep(300L);
        }
        Assert.assertFalse((boolean)rmNode2.getAppX509ToUpdate().isEmpty());
        nmResponse = nm2.nodeHeartbeat(true);
        TestCase.assertTrue((boolean)nmResponse.getUpdatedCryptoForApps().containsKey(app.getApplicationId()));
        rm.stop();
    }

    private String getClasspathDir(Class klass) throws Exception {
        String file = klass.getName();
        file = file.replace('.', '/') + ".class";
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        String baseDir = url.toURI().getPath();
        baseDir = baseDir.substring(0, baseDir.length() - file.length() - 1);
        return baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTrustStore(String filename, String password, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setCertificateEntry(alias, cert);
        try (FileOutputStream out = new FileOutputStream(filename);){
            ks.store(out, password.toCharArray());
        }
    }

    private class MyMockRM
    extends MockRM {
        public MyMockRM(Configuration conf) {
            super(conf);
        }

        @Override
        protected RMAppSecurityManager createRMAppSecurityManager() throws Exception {
            RMAppSecurityManager rmAppSecurityManager = (RMAppSecurityManager)Mockito.spy((Object)new RMAppSecurityManager((RMContext)this.rmContext){

                protected void clearRMAppSecurityActionsFactory() {
                }
            });
            rmAppSecurityManager.registerRMAppSecurityHandlerWithType(this.createX509SecurityHandler(rmAppSecurityManager), X509SecurityHandler.class);
            rmAppSecurityManager.registerRMAppSecurityHandler(this.createJWTSecurityHandler(rmAppSecurityManager));
            return rmAppSecurityManager;
        }

        @Override
        protected RMAppSecurityHandler createX509SecurityHandler(RMAppSecurityManager rmAppSecurityManager) {
            RMAppSecurityHandler x509SecurityHandler = (RMAppSecurityHandler)Mockito.spy((Object)((Object)new MockX509SecurityHandler((RMContext)this.rmContext, rmAppSecurityManager, false)));
            return x509SecurityHandler;
        }

        @Override
        protected RMAppSecurityHandler createJWTSecurityHandler(RMAppSecurityManager rmAppSecurityManager) {
            JWTSecurityHandler jwtSecurityHandler = new JWTSecurityHandler((RMContext)this.rmContext, rmAppSecurityManager);
            return jwtSecurityHandler;
        }
    }

    private class MyMockRM2
    extends MockRM {
        public MyMockRM2(Configuration conf) {
            super(conf);
        }

        protected RMAppManager createRMAppManager() {
            return new MyRMAppManager((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.masterService, this.applicationACLsManager, this.getConfig());
        }

        private class MyRMApp
        extends RMAppImpl {
            public MyRMApp(ApplicationId applicationId, RMContext rmContext, Configuration config, String name, String user, String queue, ApplicationSubmissionContext submissionContext, YarnScheduler scheduler, ApplicationMasterService masterService, long submitTime, String applicationType, Set<String> applicationTags, List<ResourceRequest> amReqs, ApplicationPlacementContext placementContext, long startTime) {
                super(applicationId, rmContext, config, name, user, queue, submissionContext, scheduler, masterService, submitTime, applicationType, applicationTags, amReqs, placementContext, startTime);
            }

            public void rmNodeHasUpdatedCryptoMaterial(NodeId nodeId) {
            }
        }

        private class MyRMAppManager
        extends RMAppManager {
            public MyRMAppManager(RMContext context, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
                super(context, scheduler, masterService, applicationACLsManager, conf);
            }

            protected RMAppImpl createRMApp(ApplicationId applicationId, RMContext rmContext, Configuration config, String name, String user, String queue, ApplicationSubmissionContext submissionContext, YarnScheduler scheduler, ApplicationMasterService masterService, long submitTime, String applicationType, Set<String> applicationTags, List<ResourceRequest> amReqs, ApplicationPlacementContext placementContext, long startTime) {
                return new MyRMApp(applicationId, rmContext, config, name, user, queue, submissionContext, scheduler, masterService, submitTime, applicationType, applicationTags, amReqs, placementContext, startTime);
            }
        }
    }
}

