/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerSurgicalPreemption;
import org.junit.Before;
import org.junit.Test;

public class TestCapacitySchedulerAutoCreatedQueuePreemption
extends TestCapacitySchedulerSurgicalPreemption {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public static CapacitySchedulerConfiguration setupQueueConfigurationForSimpleSurgicalPreemption(CapacitySchedulerConfiguration conf) {
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, "c", true, new int[]{1, 2});
        conf.setQueues("root", new String[]{"c"});
        conf.setCapacity("root.c", 100.0f);
        conf.setUserLimitFactor("root.c", 1.0f);
        conf.setAutoCreateChildQueueEnabled("root.c", true);
        conf.setAutoCreatedLeafQueueConfigCapacity("root.c", 30.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity("root.c", 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit("root.c", 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor("root.c", 3.0f);
        return conf;
    }

    protected CapacitySchedulerConfiguration setupQueueConfigurationForPriorityBasedPreemption(CapacitySchedulerConfiguration conf) {
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, "c", true, new int[]{1, 2});
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, "d", true, new int[]{3, 4});
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, "e", true, new int[]{0});
        conf.setQueues("root", new String[]{"c", "d", "e"});
        conf.setCapacity("root.c", 45.0f);
        conf.setCapacity("root.d", 45.0f);
        conf.setCapacity("root.e", 10.0f);
        conf.setUserLimitFactor("root.e", 3.0f);
        conf.setUserLimitFactor("root.c", 3.0f);
        conf.setUserLimitFactor("root.d", 3.0f);
        conf.setAutoCreateChildQueueEnabled("root.c", true);
        conf.setAutoCreateChildQueueEnabled("root.d", true);
        conf.setAutoCreateChildQueueEnabled("root.e", true);
        conf.setAutoCreatedLeafQueueConfigCapacity("root.c", 100.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity("root.c", 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit("root.c", 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor("root.c", 3.0f);
        conf.setAutoCreatedLeafQueueConfigCapacity("root.d", 100.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity("root.d", 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit("root.d", 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor("root.d", 3.0f);
        conf.setAutoCreatedLeafQueueConfigCapacity("root.e", 100.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity("root.e", 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit("root.e", 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor("root.e", 3.0f);
        conf.setQueuePriority("root.c", 1);
        conf.setQueuePriority("root.d", 2);
        return conf;
    }

    @Test(timeout=60000L)
    public void testSimpleSurgicalPreemptionOnAutoCreatedLeafQueues() throws Exception {
        TestCapacitySchedulerAutoCreatedQueuePreemption.setupQueueConfigurationForSimpleSurgicalPreemption(this.conf);
        this.testSimpleSurgicalPreemption("user_1", "user_2", "user_1", "user_2");
    }

    @Test(timeout=600000L)
    public void testPreemptionFromHighestPriorityManagedParentQueueAndOldestContainer() throws Exception {
        this.setupQueueConfigurationForPriorityBasedPreemption(this.conf);
        this.testPriorityPreemptionFromHighestPriorityQueueAndOldestContainer(new String[]{"user_1", "user_3", "user_0"}, new String[]{"user_1", "user_3", "user_0"});
    }
}

