/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.MemoryPlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManagerService;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPlacementConstraintManagerService {
    private PlacementConstraintManagerService pcm;
    private ApplicationId appId1;
    private ApplicationId appId2;
    private PlacementConstraint c1;
    private PlacementConstraint c2;
    private PlacementConstraint c3;
    private PlacementConstraint c4;
    private Set<String> sourceTag1;
    private Set<String> sourceTag2;
    private Set<String> sourceTag3;
    private Set<String> sourceTag4;
    private Map<Set<String>, PlacementConstraint> constraintMap1;
    private Map<Set<String>, PlacementConstraint> constraintMap2;

    protected PlacementConstraintManagerService createPCM() {
        return new MemoryPlacementConstraintManager();
    }

    @Before
    public void before() {
        this.pcm = this.createPCM();
        long ts = System.currentTimeMillis();
        this.appId1 = BuilderUtils.newApplicationId((long)ts, (int)123);
        this.appId2 = BuilderUtils.newApplicationId((long)ts, (int)234);
        this.c1 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})}));
        this.c2 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-rs"})}));
        this.c3 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"java", (String[])new String[]{"1.8"})}));
        this.c4 = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetCardinality((String)"rack", (int)2, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})}));
        this.sourceTag1 = new HashSet<String>(Arrays.asList("spark"));
        this.sourceTag2 = new HashSet<String>(Arrays.asList("zk"));
        this.sourceTag3 = new HashSet<String>(Arrays.asList("storm"));
        this.sourceTag4 = new HashSet<String>(Arrays.asList("hbase-m", "hbase-sec"));
        this.constraintMap1 = Stream.of(new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag1, this.c1), new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag2, this.c2)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.constraintMap2 = Stream.of(new AbstractMap.SimpleEntry<Set<String>, PlacementConstraint>(this.sourceTag3, this.c4)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    @Test
    public void testRegisterUnregisterApps() {
        Assert.assertEquals((long)0L, (long)this.pcm.getNumRegisteredApplications());
        this.pcm.registerApplication(this.appId1, this.constraintMap1);
        Assert.assertEquals((long)1L, (long)this.pcm.getNumRegisteredApplications());
        Map constrMap = this.pcm.getConstraints(this.appId1);
        Assert.assertNotNull((Object)constrMap);
        Assert.assertEquals((long)2L, (long)constrMap.size());
        Assert.assertNotNull(constrMap.get(this.sourceTag1));
        Assert.assertNotNull(constrMap.get(this.sourceTag2));
        this.pcm.registerApplication(this.appId2, this.constraintMap2);
        Assert.assertEquals((long)2L, (long)this.pcm.getNumRegisteredApplications());
        constrMap = this.pcm.getConstraints(this.appId2);
        Assert.assertNotNull((Object)constrMap);
        Assert.assertEquals((long)1L, (long)constrMap.size());
        Assert.assertNotNull(constrMap.get(this.sourceTag3));
        Assert.assertNull(constrMap.get(this.sourceTag2));
        this.pcm.registerApplication(this.appId2, this.constraintMap1);
        Assert.assertEquals((long)2L, (long)this.pcm.getNumRegisteredApplications());
        this.pcm.unregisterApplication(this.appId1);
        Assert.assertEquals((long)1L, (long)this.pcm.getNumRegisteredApplications());
        Assert.assertNull((Object)this.pcm.getConstraints(this.appId1));
        Assert.assertNotNull((Object)this.pcm.getConstraints(this.appId2));
    }

    @Test
    public void testAddConstraint() {
        Assert.assertEquals((long)0L, (long)this.pcm.getNumRegisteredApplications());
        this.pcm.addConstraint(this.appId1, this.sourceTag1, this.c1, false);
        Assert.assertEquals((long)0L, (long)this.pcm.getNumRegisteredApplications());
        this.pcm.registerApplication(this.appId1, new HashMap());
        Assert.assertEquals((long)1L, (long)this.pcm.getNumRegisteredApplications());
        Assert.assertEquals((long)0L, (long)this.pcm.getConstraints(this.appId1).size());
        this.pcm.addConstraint(this.appId1, this.sourceTag1, this.c1, false);
        this.pcm.addConstraint(this.appId1, this.sourceTag2, this.c3, false);
        Assert.assertEquals((long)2L, (long)this.pcm.getConstraints(this.appId1).size());
        this.pcm.addConstraint(this.appId1, this.sourceTag1, this.c2, false);
        Assert.assertEquals((long)2L, (long)this.pcm.getConstraints(this.appId1).size());
        Assert.assertEquals((Object)this.c1, (Object)this.pcm.getConstraint(this.appId1, this.sourceTag1));
        Assert.assertNotEquals((Object)this.c2, (Object)this.pcm.getConstraint(this.appId1, this.sourceTag1));
        this.pcm.addConstraint(this.appId1, this.sourceTag1, this.c2, true);
        Assert.assertEquals((long)2L, (long)this.pcm.getConstraints(this.appId1).size());
        Assert.assertEquals((Object)this.c2, (Object)this.pcm.getConstraint(this.appId1, this.sourceTag1));
    }

    @Test
    public void testGlobalConstraints() {
        Assert.assertEquals((long)0L, (long)this.pcm.getNumGlobalConstraints());
        this.pcm.addGlobalConstraint(this.sourceTag1, this.c1, false);
        Assert.assertEquals((long)1L, (long)this.pcm.getNumGlobalConstraints());
        Assert.assertNotNull((Object)this.pcm.getGlobalConstraint(this.sourceTag1));
        this.pcm.addGlobalConstraint(this.sourceTag1, this.c2, false);
        Assert.assertEquals((long)1L, (long)this.pcm.getNumGlobalConstraints());
        Assert.assertEquals((Object)this.c1, (Object)this.pcm.getGlobalConstraint(this.sourceTag1));
        Assert.assertNotEquals((Object)this.c2, (Object)this.pcm.getGlobalConstraint(this.sourceTag1));
        this.pcm.addGlobalConstraint(this.sourceTag1, this.c2, true);
        Assert.assertEquals((long)1L, (long)this.pcm.getNumGlobalConstraints());
        Assert.assertEquals((Object)this.c2, (Object)this.pcm.getGlobalConstraint(this.sourceTag1));
        this.pcm.removeGlobalConstraint(this.sourceTag1);
        Assert.assertEquals((long)0L, (long)this.pcm.getNumGlobalConstraints());
    }

    @Test
    public void testValidateConstraint() {
        Assert.assertTrue((boolean)this.pcm.validateConstraint(this.sourceTag1, this.c1));
        Assert.assertFalse((boolean)this.pcm.validateConstraint(this.sourceTag4, this.c1));
    }

    @Test
    public void testGetRequestConstraint() {
        PlacementConstraint constraint = this.pcm.getMultilevelConstraint(this.appId1, null, this.c1);
        Assert.assertTrue((boolean)(constraint.getConstraintExpr() instanceof PlacementConstraint.And));
        PlacementConstraint.And mergedConstraint = (PlacementConstraint.And)constraint.getConstraintExpr();
        Assert.assertEquals((long)1L, (long)mergedConstraint.getChildren().size());
        Assert.assertEquals((Object)this.c1, (Object)((PlacementConstraint.AbstractConstraint)mergedConstraint.getChildren().get(0)).build());
        this.pcm.registerApplication(this.appId1, this.constraintMap1);
        constraint = this.pcm.getMultilevelConstraint(this.appId1, (Set)Sets.newHashSet((Object[])new String[]{"not_exist_tag"}), null);
        Assert.assertTrue((boolean)(constraint.getConstraintExpr() instanceof PlacementConstraint.And));
        mergedConstraint = (PlacementConstraint.And)constraint.getConstraintExpr();
        Assert.assertEquals((long)0L, (long)mergedConstraint.getChildren().size());
        constraint = this.pcm.getMultilevelConstraint(this.appId1, this.sourceTag1, null);
        Assert.assertTrue((boolean)(constraint.getConstraintExpr() instanceof PlacementConstraint.And));
        mergedConstraint = (PlacementConstraint.And)constraint.getConstraintExpr();
        Assert.assertEquals((long)1L, (long)mergedConstraint.getChildren().size());
        Assert.assertEquals((Object)this.c1, (Object)((PlacementConstraint.AbstractConstraint)mergedConstraint.getChildren().get(0)).build());
        this.pcm.unregisterApplication(this.appId1);
        this.pcm.addGlobalConstraint(this.sourceTag1, this.c1, true);
        constraint = this.pcm.getMultilevelConstraint(this.appId1, (Set)Sets.newHashSet(this.sourceTag1), null);
        Assert.assertTrue((boolean)(constraint.getConstraintExpr() instanceof PlacementConstraint.And));
        mergedConstraint = (PlacementConstraint.And)constraint.getConstraintExpr();
        Assert.assertEquals((long)1L, (long)mergedConstraint.getChildren().size());
        Assert.assertEquals((Object)this.c1, (Object)((PlacementConstraint.AbstractConstraint)mergedConstraint.getChildren().get(0)).build());
        this.pcm.removeGlobalConstraint(this.sourceTag1);
        this.pcm.addGlobalConstraint(this.sourceTag1, this.c3, true);
        this.pcm.registerApplication(this.appId1, this.constraintMap1);
        constraint = this.pcm.getMultilevelConstraint(this.appId1, this.sourceTag1, this.c2);
        Assert.assertTrue((boolean)(constraint.getConstraintExpr() instanceof PlacementConstraint.And));
        mergedConstraint = (PlacementConstraint.And)constraint.getConstraintExpr();
        Assert.assertEquals((long)3L, (long)mergedConstraint.getChildren().size());
        this.pcm.removeGlobalConstraint(this.sourceTag1);
        this.pcm.unregisterApplication(this.appId1);
        this.pcm.addGlobalConstraint(this.sourceTag1, this.c2, true);
        this.pcm.registerApplication(this.appId1, this.constraintMap1);
        constraint = this.pcm.getMultilevelConstraint(this.appId1, (Set)Sets.newHashSet(this.sourceTag1), this.c1);
        Assert.assertTrue((boolean)(constraint.getConstraintExpr() instanceof PlacementConstraint.And));
        mergedConstraint = (PlacementConstraint.And)constraint.getConstraintExpr();
        Assert.assertEquals((long)2L, (long)mergedConstraint.getChildren().size());
        this.pcm.removeGlobalConstraint(this.sourceTag1);
        this.pcm.unregisterApplication(this.appId1);
    }
}

