/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceProfilesManagerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceProfiles {
    public static final String TEST_CONF_RESET_RESOURCE_TYPES = "yarn.test.reset-resource-types";

    @Test
    public void testProfilesEnabled() throws Exception {
        ResourceProfilesManagerImpl manager = new ResourceProfilesManagerImpl();
        Configuration conf = new Configuration();
        manager.init(conf);
        try {
            manager.getResourceProfiles();
            Assert.fail((String)"Exception should be thrown as resource profile is not enabled and getResourceProfiles is invoked.");
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        conf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", true);
        try {
            manager.init(conf);
            Assert.fail((String)"Exception should be thrown due to missing resource profiles file");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        conf.set("yarn.resourcemanager.resource-profiles.source-file", "profiles/sample-profiles-1.json");
        manager.init(conf);
    }

    @Test
    public void testLoadProfiles() throws Exception {
        ResourceProfilesManagerImpl manager = new ResourceProfilesManagerImpl();
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", true);
        conf.set("yarn.resourcemanager.resource-profiles.source-file", "profiles/sample-profiles-1.json");
        manager.init(conf);
        Map profiles = manager.getResourceProfiles();
        HashMap<String, Resource> expected = new HashMap<String, Resource>();
        expected.put("minimum", Resource.newInstance((int)1024, (int)1));
        expected.put("default", Resource.newInstance((int)2048, (int)2));
        expected.put("maximum", Resource.newInstance((int)8192, (int)4));
        for (Map.Entry entry : expected.entrySet()) {
            String profile = (String)entry.getKey();
            Resource res = (Resource)entry.getValue();
            Assert.assertTrue((String)("Mandatory profile '" + profile + "' missing"), (boolean)profiles.containsKey(profile));
            Assert.assertEquals((String)("Profile " + profile + "' resources don't match"), (Object)res, (Object)manager.getProfile(profile));
        }
    }

    @Test
    public void testLoadIllegalProfiles() throws Exception {
        String[] badProfiles;
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", true);
        for (String file : badProfiles = new String[]{"profiles/illegal-profiles-1.json", "profiles/illegal-profiles-2.json", "profiles/illegal-profiles-3.json"}) {
            ResourceProfilesManagerImpl manager = new ResourceProfilesManagerImpl();
            conf.set("yarn.resourcemanager.resource-profiles.source-file", file);
            try {
                manager.init(conf);
                Assert.fail((String)("Bad profile '" + file + "' is not valid"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetProfile() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", true);
        ResourceProfilesManagerImpl manager = new ResourceProfilesManagerImpl();
        conf.set("yarn.resourcemanager.resource-profiles.source-file", "profiles/sample-profiles-2.json");
        manager.init(conf);
        HashMap<String, Resource> expected = new HashMap<String, Resource>();
        expected.put("minimum", Resource.newInstance((int)1024, (int)1));
        expected.put("default", Resource.newInstance((int)2048, (int)2));
        expected.put("maximum", Resource.newInstance((int)8192, (int)4));
        expected.put("small", Resource.newInstance((int)1024, (int)1));
        expected.put("medium", Resource.newInstance((int)2048, (int)1));
        expected.put("large", Resource.newInstance((int)4096, (int)4));
        for (Map.Entry entry : expected.entrySet()) {
            String profile = (String)entry.getKey();
            Resource res = (Resource)entry.getValue();
            Assert.assertEquals((String)("Profile " + profile + "' resources don't match"), (Object)res, (Object)manager.getProfile(profile));
        }
    }

    @Test
    public void testGetMandatoryProfiles() throws Exception {
        ResourceProfilesManagerImpl manager = new ResourceProfilesManagerImpl();
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", true);
        conf.set("yarn.resourcemanager.resource-profiles.source-file", "profiles/sample-profiles-1.json");
        manager.init(conf);
        HashMap<String, Resource> expected = new HashMap<String, Resource>();
        expected.put("minimum", Resource.newInstance((int)1024, (int)1));
        expected.put("default", Resource.newInstance((int)2048, (int)2));
        expected.put("maximum", Resource.newInstance((int)8192, (int)4));
        Assert.assertEquals((String)"Profile 'minimum' resources don't match", expected.get("minimum"), (Object)manager.getMinimumProfile());
        Assert.assertEquals((String)"Profile 'default' resources don't match", expected.get("default"), (Object)manager.getDefaultProfile());
        Assert.assertEquals((String)"Profile 'maximum' resources don't match", expected.get("maximum"), (Object)manager.getMaximumProfile());
    }

    @Test(timeout=30000L)
    public void testResourceProfilesInAMResponse() throws Exception {
        Configuration conf = new Configuration();
        MockRM rm = new MockRM(conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        RegisterApplicationMasterResponse resp = am1.registerAppAttempt();
        Assert.assertEquals((long)0L, (long)resp.getResourceProfiles().size());
        rm.stop();
        conf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", true);
        conf.set("yarn.resourcemanager.resource-profiles.source-file", "profiles/sample-profiles-1.json");
        rm = new MockRM(conf);
        rm.start();
        nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        attempt1 = app1.getCurrentAppAttempt();
        am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        resp = am1.registerAppAttempt();
        Assert.assertEquals((long)3L, (long)resp.getResourceProfiles().size());
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), resp.getResourceProfiles().get("minimum"));
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)2), resp.getResourceProfiles().get("default"));
        Assert.assertEquals((Object)Resource.newInstance((int)8192, (int)4), resp.getResourceProfiles().get("maximum"));
        rm.stop();
    }
}

