/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.AbstractComparatorOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FairOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.MockSchedulableEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestFairOrderingPolicy {
    static final int GB = 1024;

    @Test
    public void testSimpleComparison() {
        FairOrderingPolicy policy = new FairOrderingPolicy();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertTrue((policy.getComparator().compare(r1, r2) == 0 ? 1 : 0) != 0);
        r1.setUsed(Resources.createResource((int)1, (int)0));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSizeBasedWeight() {
        FairOrderingPolicy policy = new FairOrderingPolicy();
        policy.setSizeBasedWeight(true);
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertTrue((policy.getComparator().compare(r1, r2) == 0 ? 1 : 0) != 0);
        r1.setUsed(Resources.createResource((int)4096));
        r2.setUsed(Resources.createResource((int)4096));
        r1.setPending(Resources.createResource((int)4096));
        r2.setPending(Resources.createResource((int)4096));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) == 0 ? 1 : 0) != 0);
        r2.setUsed(Resources.createResource((int)5120));
        r2.setPending(Resources.createResource((int)5120));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) < 0 ? 1 : 0) != 0);
        r2.setPending(Resources.createResource((int)102400));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIterators() {
        FairOrderingPolicy schedOrder = new FairOrderingPolicy();
        MockSchedulableEntity msp1 = new MockSchedulableEntity();
        MockSchedulableEntity msp2 = new MockSchedulableEntity();
        MockSchedulableEntity msp3 = new MockSchedulableEntity();
        msp1.setId("1");
        msp2.setId("2");
        msp3.setId("3");
        msp1.setUsed(Resources.createResource((int)3));
        msp2.setUsed(Resources.createResource((int)2));
        msp3.setUsed(Resources.createResource((int)1));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)msp1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)msp2.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)msp2.getSchedulingResourceUsage());
        schedOrder.addSchedulableEntity((SchedulableEntity)msp1);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp2);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp3);
        this.checkIds(schedOrder.getAssignmentIterator(), new String[]{"3", "2", "1"});
        this.checkIds(schedOrder.getPreemptionIterator(), new String[]{"1", "2", "3"});
        msp2.setUsed(Resources.createResource((int)6));
        this.checkIds(schedOrder.getAssignmentIterator(), new String[]{"3", "2", "1"});
        this.checkIds(schedOrder.getPreemptionIterator(), new String[]{"1", "2", "3"});
        schedOrder.containerAllocated((SchedulableEntity)msp2, null);
        this.checkIds(schedOrder.getAssignmentIterator(), new String[]{"3", "1", "2"});
        this.checkIds(schedOrder.getPreemptionIterator(), new String[]{"2", "1", "3"});
    }

    @Test
    public void testSizeBasedWeightNotAffectAppActivation() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        String queuePath = "root.default";
        csConf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getCanonicalName());
        csConf.setOrderingPolicy(queuePath, "fair");
        csConf.setOrderingPolicyParameter(queuePath, "fair.enable-size-based-weight", "true");
        csConf.setMaximumApplicationMasterResourcePerQueuePercent(queuePath, 0.1f);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue lq = (LeafQueue)cs.getQueue("default");
        OrderingPolicy policy = lq.getOrderingPolicy();
        Assert.assertTrue((boolean)(policy instanceof FairOrderingPolicy));
        Assert.assertTrue((boolean)((FairOrderingPolicy)policy).getSizeBasedWeight());
        rm.registerNode("h1:1234", 10240);
        rm.submitApp(1024, "app", "user", null, "default");
        rm.submitApp(1024, "app", "user", null, "default");
        rm.submitApp(1024, "app", "user", null, "default");
        rm.submitApp(1024, "app", "user", null, "default");
        Assert.assertEquals((long)1L, (long)lq.getNumActiveApplications());
        Assert.assertEquals((long)3L, (long)lq.getNumPendingApplications());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(NodeId.newInstance((String)"h1", (int)1234))));
        Assert.assertEquals((long)1L, (long)lq.getNumActiveApplications());
        Assert.assertEquals((long)3L, (long)lq.getNumPendingApplications());
    }

    public void checkIds(Iterator<MockSchedulableEntity> si, String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            Assert.assertEquals((Object)si.next().getId(), (Object)ids[i]);
        }
    }
}

