/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ReservationQueueConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation.AllocationFileParser;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation.AllocationFileQueueParser;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation.QueueProperties;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AllocationFileLoaderService
extends AbstractService {
    public static final Log LOG = LogFactory.getLog((String)AllocationFileLoaderService.class.getName());
    public static final long ALLOC_RELOAD_INTERVAL_MS = 10000L;
    public static final long ALLOC_RELOAD_WAIT_MS = 5000L;
    public static final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    private static final String SUPPORTED_FS_REGEX = "(?i)(hdfs)|(file)|(s3a)|(viewfs)";
    private final Clock clock;
    private volatile long lastSuccessfulReload;
    private volatile boolean lastReloadAttemptFailed = false;
    private Path allocFile;
    private FileSystem fs;
    private Listener reloadListener;
    @VisibleForTesting
    long reloadIntervalMs = 10000L;
    private Thread reloadThread;
    private volatile boolean running = true;
    private List<Permission> defaultPermissions;

    public AllocationFileLoaderService() {
        this((Clock)SystemClock.getInstance());
    }

    public AllocationFileLoaderService(Clock clock) {
        super(AllocationFileLoaderService.class.getName());
        this.clock = clock;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.allocFile = this.getAllocationFile(conf);
        if (this.allocFile != null) {
            this.fs = this.allocFile.getFileSystem(conf);
            this.reloadThread = new Thread(() -> {
                while (this.running) {
                    try {
                        AllocationFileLoaderService allocationFileLoaderService = this;
                        synchronized (allocationFileLoaderService) {
                            this.reloadListener.onCheck();
                        }
                        long time = this.clock.getTime();
                        long lastModified = this.fs.getFileStatus(this.allocFile).getModificationTime();
                        if (lastModified > this.lastSuccessfulReload && time > lastModified + 5000L) {
                            try {
                                this.reloadAllocations();
                            }
                            catch (Exception ex) {
                                if (!this.lastReloadAttemptFailed) {
                                    LOG.error((Object)"Failed to reload fair scheduler config file - will use existing allocations.", (Throwable)ex);
                                }
                                this.lastReloadAttemptFailed = true;
                            }
                        } else if (lastModified == 0L) {
                            if (!this.lastReloadAttemptFailed) {
                                LOG.warn((Object)("Failed to reload fair scheduler config file because last modified returned 0. File exists: " + this.fs.exists(this.allocFile)));
                            }
                            this.lastReloadAttemptFailed = true;
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Exception while loading allocation file: " + e));
                    }
                    try {
                        Thread.sleep(this.reloadIntervalMs);
                    }
                    catch (InterruptedException ex) {
                        LOG.info((Object)"Interrupted while waiting to reload alloc configuration");
                    }
                }
            });
            this.reloadThread.setName("AllocationFileReloader");
            this.reloadThread.setDaemon(true);
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        if (this.reloadThread != null) {
            this.reloadThread.start();
        }
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        this.running = false;
        if (this.reloadThread != null) {
            this.reloadThread.interrupt();
            try {
                this.reloadThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"reloadThread fails to join.");
            }
        }
        super.serviceStop();
    }

    @VisibleForTesting
    Path getAllocationFile(Configuration conf) throws UnsupportedFileSystemException {
        String allocFilePath = conf.get("yarn.scheduler.fair.allocation.file", "fair-scheduler.xml");
        Path allocPath = new Path(allocFilePath);
        String allocPathScheme = allocPath.toUri().getScheme();
        if (allocPathScheme != null && !allocPathScheme.matches(SUPPORTED_FS_REGEX)) {
            throw new UnsupportedFileSystemException("Allocation file " + allocFilePath + " uses an unsupported filesystem");
        }
        if (!allocPath.isAbsolute()) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(allocFilePath);
            if (url == null) {
                LOG.warn((Object)(allocFilePath + " not found on the classpath."));
                allocPath = null;
            } else {
                if (!url.getProtocol().equalsIgnoreCase("file")) {
                    throw new RuntimeException("Allocation file " + url + " found on the classpath is not on the local filesystem.");
                }
                allocPath = new Path(url.getProtocol(), null, url.getPath());
            }
        } else if (allocPath.isAbsoluteAndSchemeAuthorityNull()) {
            allocPath = new Path("file", null, allocFilePath);
        }
        return allocPath;
    }

    public synchronized void setReloadListener(Listener reloadListener) {
        this.reloadListener = reloadListener;
    }

    public synchronized void reloadAllocations() throws IOException, ParserConfigurationException, SAXException, AllocationConfigurationException {
        if (this.allocFile == null) {
            this.reloadListener.onReload(null);
            return;
        }
        LOG.info((Object)("Loading allocation file " + this.allocFile));
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse((InputStream)this.fs.open(this.allocFile));
        Element root = doc.getDocumentElement();
        if (!"allocations".equals(root.getTagName())) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: top-level element not <allocations>");
        }
        NodeList elements = root.getChildNodes();
        AllocationFileParser allocationFileParser = new AllocationFileParser(elements);
        allocationFileParser.parse();
        AllocationFileQueueParser queueParser = new AllocationFileQueueParser(allocationFileParser.getQueueElements());
        QueueProperties queueProperties = queueParser.parse();
        Configuration conf = this.getConfig();
        QueuePlacementPolicy newPlacementPolicy = this.getQueuePlacementPolicy(allocationFileParser, queueProperties, conf);
        this.setupRootQueueProperties(allocationFileParser, queueProperties);
        ReservationQueueConfiguration globalReservationQueueConfig = this.createReservationQueueConfig(allocationFileParser);
        AllocationConfiguration info = new AllocationConfiguration(queueProperties, allocationFileParser, newPlacementPolicy, globalReservationQueueConfig);
        this.lastSuccessfulReload = this.clock.getTime();
        this.lastReloadAttemptFailed = false;
        this.reloadListener.onReload(info);
    }

    private QueuePlacementPolicy getQueuePlacementPolicy(AllocationFileParser allocationFileParser, QueueProperties queueProperties, Configuration conf) throws AllocationConfigurationException {
        if (allocationFileParser.getQueuePlacementPolicy().isPresent()) {
            return QueuePlacementPolicy.fromXml(allocationFileParser.getQueuePlacementPolicy().get(), queueProperties.getConfiguredQueues(), conf);
        }
        return QueuePlacementPolicy.fromConfiguration(conf, queueProperties.getConfiguredQueues());
    }

    private void setupRootQueueProperties(AllocationFileParser allocationFileParser, QueueProperties queueProperties) {
        if (!queueProperties.getMinSharePreemptionTimeouts().containsKey("root")) {
            queueProperties.getMinSharePreemptionTimeouts().put("root", allocationFileParser.getDefaultMinSharePreemptionTimeout());
        }
        if (!queueProperties.getFairSharePreemptionTimeouts().containsKey("root")) {
            queueProperties.getFairSharePreemptionTimeouts().put("root", allocationFileParser.getDefaultFairSharePreemptionTimeout());
        }
        if (!queueProperties.getFairSharePreemptionThresholds().containsKey("root")) {
            queueProperties.getFairSharePreemptionThresholds().put("root", Float.valueOf(allocationFileParser.getDefaultFairSharePreemptionThreshold()));
        }
    }

    private ReservationQueueConfiguration createReservationQueueConfig(AllocationFileParser allocationFileParser) {
        ReservationQueueConfiguration globalReservationQueueConfig = new ReservationQueueConfiguration();
        if (allocationFileParser.getReservationPlanner().isPresent()) {
            globalReservationQueueConfig.setPlanner(allocationFileParser.getReservationPlanner().get());
        }
        if (allocationFileParser.getReservationAdmissionPolicy().isPresent()) {
            globalReservationQueueConfig.setReservationAdmissionPolicy(allocationFileParser.getReservationAdmissionPolicy().get());
        }
        if (allocationFileParser.getReservationAgent().isPresent()) {
            globalReservationQueueConfig.setReservationAgent(allocationFileParser.getReservationAgent().get());
        }
        return globalReservationQueueConfig;
    }

    protected List<Permission> getDefaultPermissions() {
        if (this.defaultPermissions == null) {
            this.defaultPermissions = new ArrayList<Permission>();
            HashMap<AccessType, AccessControlList> acls = new HashMap<AccessType, AccessControlList>();
            for (QueueACL acl : QueueACL.values()) {
                acls.put(SchedulerUtils.toAccessType(acl), AllocationFileQueueParser.EVERYBODY_ACL);
            }
            this.defaultPermissions.add(new Permission(new PrivilegedEntity(PrivilegedEntity.EntityType.QUEUE, "root"), acls));
        }
        return this.defaultPermissions;
    }

    public static interface Listener {
        public void onReload(AllocationConfiguration var1) throws IOException;

        default public void onCheck() {
        }
    }
}

