/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockMemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;

public class TestAMRestart
extends ParameterizedSchedulerTestBase {
    public TestAMRestart(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    @Test(timeout=30000L)
    public void testAMRestartWithExistingContainers() throws Exception {
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        rm1.start();
        RMApp app1 = rm1.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "MAPREDUCE", false, true);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockNM nm2 = new MockNM("127.0.0.1:2351", 4089, rm1.getResourceTrackerService());
        nm2.registerNode();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        int NUM_CONTAINERS = 3;
        TestAMRestart.allocateContainers(nm1, am1, NUM_CONTAINERS);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 3L, ContainerState.RUNNING);
        ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        rm1.waitForState(nm1, containerId3, RMContainerState.RUNNING);
        ContainerId containerId4 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)4L);
        rm1.waitForState(nm1, containerId4, RMContainerState.ACQUIRED);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        ContainerId containerId5 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)5L);
        rm1.waitForState(nm1, containerId5, RMContainerState.ALLOCATED);
        am1.allocate("127.0.0.1", 6000, 1, new ArrayList<ContainerId>());
        ContainerId containerId6 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)6L);
        nm1.nodeHeartbeat(true);
        SchedulerApplicationAttempt schedulerAttempt = ((AbstractYarnScheduler)rm1.getResourceScheduler()).getCurrentAttemptForContainer(containerId6);
        while (schedulerAttempt.getReservedContainers().isEmpty()) {
            System.out.println("Waiting for container " + containerId6 + " to be reserved.");
            nm1.nodeHeartbeat(true);
            Thread.sleep(200L);
        }
        Assert.assertEquals((Object)containerId6, (Object)((RMContainer)schedulerAttempt.getReservedContainers().get(0)).getContainerId());
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Thread.sleep(3000L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        Assert.assertNull((Object)rm1.getResourceScheduler().getRMContainer(containerId4));
        Assert.assertNull((Object)rm1.getResourceScheduler().getRMContainer(containerId5));
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        ApplicationAttemptId newAttemptId = app1.getCurrentAppAttempt().getAppAttemptId();
        Assert.assertFalse((boolean)newAttemptId.equals((Object)am1.getApplicationAttemptId()));
        MockAM am2 = MockRM.launchAM(app1, rm1, nm1);
        RegisterApplicationMasterResponse registerResponse = am2.registerAppAttempt();
        Assert.assertEquals((long)2L, (long)registerResponse.getContainersFromPreviousAttempts().size());
        boolean containerId2Exists = false;
        boolean containerId3Exists = false;
        for (Container container : registerResponse.getContainersFromPreviousAttempts()) {
            if (container.getId().equals((Object)containerId2)) {
                containerId2Exists = true;
            }
            if (!container.getId().equals((Object)containerId3)) continue;
            containerId3Exists = true;
        }
        Assert.assertTrue((containerId2Exists && containerId3Exists ? 1 : 0) != 0);
        rm1.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 3L, ContainerState.COMPLETE);
        RMAppAttempt newAttempt = app1.getRMAppAttempt(am2.getApplicationAttemptId());
        this.waitForContainersToFinish(4, newAttempt);
        boolean container3Exists = false;
        boolean container4Exists = false;
        boolean container5Exists = false;
        boolean container6Exists = false;
        for (ContainerStatus status : newAttempt.getJustFinishedContainers()) {
            if (status.getContainerId().equals((Object)containerId3)) {
                container3Exists = true;
            }
            if (status.getContainerId().equals((Object)containerId4)) {
                container4Exists = true;
            }
            if (status.getContainerId().equals((Object)containerId5)) {
                container5Exists = true;
            }
            if (!status.getContainerId().equals((Object)containerId6)) continue;
            container6Exists = true;
        }
        Assert.assertTrue((container3Exists && container4Exists && container5Exists && container6Exists ? 1 : 0) != 0);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        SchedulerApplicationAttempt schedulerNewAttempt = ((AbstractYarnScheduler)rm1.getResourceScheduler()).getCurrentAttemptForContainer(containerId2);
        MockRM.finishAMAndVerifyAppState(app1, rm1, nm1, am2);
        Assert.assertFalse((boolean)schedulerNewAttempt.getLiveContainers().contains(containerId2));
        System.out.println("New attempt's just finished containers: " + newAttempt.getJustFinishedContainers());
        this.waitForContainersToFinish(5, newAttempt);
        rm1.stop();
    }

    public static List<Container> allocateContainers(MockNM nm1, MockAM am1, int NUM_CONTAINERS) throws Exception {
        am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (containers.size() != NUM_CONTAINERS) {
            nm1.nodeHeartbeat(true);
            containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(200L);
        }
        Assert.assertEquals((String)"Did not get all containers allocated", (long)NUM_CONTAINERS, (long)containers.size());
        return containers;
    }

    private void waitForContainersToFinish(int expectedNum, RMAppAttempt attempt) throws InterruptedException {
        for (int count = 0; attempt.getJustFinishedContainers().size() < expectedNum && count < 500; ++count) {
            Thread.sleep(100L);
        }
    }

    @Test(timeout=30000L)
    public void testNMTokensRebindOnAMRestart() throws Exception {
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 3);
        this.getConf().setFloat("yarn.resourcemanager.am-scheduling.node-blacklisting-disable-threshold", 0.5f);
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        rm1.start();
        RMApp app1 = rm1.submitApp(200, "myname", "myuser", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "MAPREDUCE", false, true);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockNM nm2 = new MockNM("127.1.1.1:4321", 8000, rm1.getResourceTrackerService());
        nm2.registerNode();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        ArrayList containers = new ArrayList();
        ArrayList expectedNMTokens = new ArrayList();
        while (true) {
            AllocateResponse response = am1.allocate("127.0.0.1", 2000, 2, new ArrayList<ContainerId>());
            nm1.nodeHeartbeat(true);
            containers.addAll(response.getAllocatedContainers());
            expectedNMTokens.addAll(response.getNMTokens());
            if (containers.size() == 2) break;
            Thread.sleep(200L);
            System.out.println("Waiting for container to be allocated.");
        }
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 3L, ContainerState.RUNNING);
        ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        rm1.waitForState(nm1, containerId3, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am2 = MockRM.launchAM(app1, rm1, nm1);
        RegisterApplicationMasterResponse registerResponse = am2.registerAppAttempt();
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        Assert.assertEquals((long)expectedNMTokens.size(), (long)registerResponse.getNMTokensFromPreviousAttempts().size());
        for (int i = 0; i < expectedNMTokens.size(); ++i) {
            Assert.assertTrue((boolean)((NMToken)expectedNMTokens.get(i)).equals(registerResponse.getNMTokensFromPreviousAttempts().get(i)));
        }
        containers = new ArrayList();
        while (true) {
            AllocateResponse allocateResponse = am2.allocate("127.1.1.1", 4000, 1, new ArrayList<ContainerId>());
            nm2.nodeHeartbeat(true);
            containers.addAll(allocateResponse.getAllocatedContainers());
            expectedNMTokens.addAll(allocateResponse.getNMTokens());
            if (containers.size() == 1) break;
            Thread.sleep(200L);
            System.out.println("Waiting for container to be allocated.");
        }
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId am2ContainerId2 = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, am2ContainerId2, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am3 = MockRM.launchAM(app1, rm1, nm1);
        registerResponse = am3.registerAppAttempt();
        rm1.waitForState(am3.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        List transferredTokens = registerResponse.getNMTokensFromPreviousAttempts();
        Assert.assertEquals((long)2L, (long)transferredTokens.size());
        Assert.assertTrue((boolean)transferredTokens.containsAll(expectedNMTokens));
        rm1.stop();
    }

    @Test(timeout=100000L)
    public void testShouldNotCountFailureToMaxAttemptRetry() throws Exception {
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.getConf().setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.getConf().set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm1.getResourceScheduler();
        ContainerId amContainer = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        scheduler.killContainer(scheduler.getRMContainer(amContainer));
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am1.getApplicationAttemptId());
        Assert.assertTrue((!attempt1.shouldCountTowardsMaxAttemptRetry() ? 1 : 0) != 0);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        ApplicationStateData appState = (ApplicationStateData)((MemoryRMStateStore)rm1.getRMStateStore()).getState().getApplicationState().get(app1.getApplicationId());
        MockAM am2 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 2, nm1);
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        ContainerId amContainer2 = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
        scheduler.killContainer(scheduler.getRMContainer(amContainer2));
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am2.getApplicationAttemptId());
        Assert.assertTrue((!attempt2.shouldCountTowardsMaxAttemptRetry() ? 1 : 0) != 0);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am3 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 3, nm1);
        RMAppAttempt attempt3 = app1.getCurrentAppAttempt();
        ContainerStatus containerStatus = (ContainerStatus)Records.newRecord(ContainerStatus.class);
        containerStatus.setContainerId(attempt3.getMasterContainer().getId());
        containerStatus.setDiagnostics("mimic NM disk_failure");
        containerStatus.setState(ContainerState.COMPLETE);
        containerStatus.setExitStatus(-101);
        HashMap<ApplicationId, List<ContainerStatus>> conts = new HashMap<ApplicationId, List<ContainerStatus>>();
        conts.put(app1.getApplicationId(), Collections.singletonList(containerStatus));
        nm1.nodeHeartbeat(conts, true);
        rm1.waitForState(am3.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am3.getApplicationAttemptId());
        Assert.assertTrue((!attempt3.shouldCountTowardsMaxAttemptRetry() ? 1 : 0) != 0);
        Assert.assertEquals((long)-101L, (long)appState.getAttempt(am3.getApplicationAttemptId()).getAMContainerExitStatus());
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am4 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 4, nm1);
        RMAppAttempt attempt4 = app1.getCurrentAppAttempt();
        MockNM nm2 = new MockNM("127.0.0.1:2234", 8000, rm1.getResourceTrackerService());
        nm2.registerNode();
        nm1.nodeHeartbeat(false);
        rm1.waitForState(am4.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am4.getApplicationAttemptId());
        Assert.assertFalse((boolean)attempt4.shouldCountTowardsMaxAttemptRetry());
        Assert.assertEquals((long)-100L, (long)appState.getAttempt(am4.getApplicationAttemptId()).getAMContainerExitStatus());
        MockAM am5 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 5, nm2);
        RMAppAttempt attempt5 = app1.getCurrentAppAttempt();
        nm2.nodeHeartbeat(am5.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am5.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am5.getApplicationAttemptId());
        Assert.assertTrue((boolean)attempt5.shouldCountTowardsMaxAttemptRetry());
        MockAM am6 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 6, nm2);
        RMAppAttempt attempt6 = app1.getCurrentAppAttempt();
        nm2.nodeHeartbeat(am6.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am6.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am6.getApplicationAttemptId());
        Assert.assertTrue((boolean)attempt6.shouldCountTowardsMaxAttemptRetry());
        rm1.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((long)6L, (long)app1.getAppAttempts().size());
        rm1.stop();
    }

    @Test(timeout=100000L)
    public void testMaxAttemptOneMeansOne() throws Exception {
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 1);
        this.getConf().setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.getConf().set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm1.getResourceScheduler();
        ContainerId amContainer = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        scheduler.killContainer(scheduler.getRMContainer(amContainer));
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am1.getApplicationAttemptId());
        rm1.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((long)1L, (long)app1.getAppAttempts().size());
        rm1.stop();
    }

    @Test(timeout=60000L)
    public void testPreemptedAMRestartOnRMRestart() throws Exception {
        this.getConf().setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.getConf().setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        this.getConf().set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm1.getResourceScheduler();
        ContainerId amContainer = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am1.getApplicationAttemptId());
        Assert.assertTrue((boolean)attempt1.shouldCountTowardsMaxAttemptRetry());
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am2 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 2, nm1);
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        amContainer = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
        scheduler.killContainer(scheduler.getRMContainer(amContainer));
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Assert.assertFalse((boolean)attempt2.shouldCountTowardsMaxAttemptRetry());
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        ApplicationStateData appState = (ApplicationStateData)memStore.getState().getApplicationState().get(app1.getApplicationId());
        Assert.assertEquals((long)2L, (long)appState.getAttemptCount());
        if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.FAIR)) {
            Assert.assertEquals((long)-106L, (long)appState.getAttempt(am2.getApplicationAttemptId()).getAMContainerExitStatus());
        } else {
            Assert.assertEquals((long)-102L, (long)appState.getAttempt(am2.getApplicationAttemptId()).getAMContainerExitStatus());
        }
        MockRM rm2 = new MockRM((Configuration)this.getConf(), (RMStateStore)memStore);
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        nm1.registerNode();
        rm2.start();
        MockAM am3 = rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 2, nm1);
        MockRM.finishAMAndVerifyAppState(app1, rm2, nm1, am3);
        RMAppAttempt attempt3 = ((RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId())).getCurrentAppAttempt();
        Assert.assertTrue((boolean)attempt3.shouldCountTowardsMaxAttemptRetry());
        Assert.assertEquals((long)-1000L, (long)appState.getAttempt(am3.getApplicationAttemptId()).getAMContainerExitStatus());
        rm1.stop();
        rm2.stop();
    }

    @Test(timeout=50000L)
    public void testRMRestartOrFailoverNotCountedForAMFailures() throws Exception {
        this.getConf().setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.getConf().setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        this.getConf().set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        rm1.start();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm1.getResourceScheduler();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped(scheduler, am1.getApplicationAttemptId());
        Assert.assertTrue((boolean)attempt1.shouldCountTowardsMaxAttemptRetry());
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am2 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 2, nm1);
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        MockRM rm2 = new MockRM((Configuration)this.getConf(), (RMStateStore)memStore);
        rm2.start();
        ApplicationStateData appState = (ApplicationStateData)memStore.getState().getApplicationState().get(app1.getApplicationId());
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        NMContainerStatus status = (NMContainerStatus)Records.newRecord(NMContainerStatus.class);
        status.setContainerExitStatus(-106);
        status.setContainerId(attempt2.getMasterContainer().getId());
        status.setContainerState(ContainerState.COMPLETE);
        status.setDiagnostics("");
        nm1.registerNode(Collections.singletonList(status), null);
        rm2.waitForState(attempt2.getAppAttemptId(), RMAppAttemptState.FAILED);
        Assert.assertEquals((long)-106L, (long)appState.getAttempt(am2.getApplicationAttemptId()).getAMContainerExitStatus());
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am3 = rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 3, nm1);
        MockRM.finishAMAndVerifyAppState(app1, rm2, nm1, am3);
        RMAppAttempt attempt3 = ((RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId())).getCurrentAppAttempt();
        Assert.assertTrue((boolean)attempt3.shouldCountTowardsMaxAttemptRetry());
        Assert.assertEquals((long)-1000L, (long)appState.getAttempt(am3.getApplicationAttemptId()).getAMContainerExitStatus());
        rm1.stop();
        rm2.stop();
    }

    @Test(timeout=120000L)
    public void testRMAppAttemptFailuresValidityInterval() throws Exception {
        this.getConf().setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.getConf().setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        this.getConf().set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app = rm1.submitApp(200, 60000L, false);
        MockAM am = MockRM.launchAM(app, rm1, nm1);
        nm1.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)2L, (long)app.getAppAttempts().size());
        MockAM am_2 = MockRM.launchAndRegisterAM(app, rm1, nm1);
        rm1.waitForState(am_2.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        nm1.nodeHeartbeat(am_2.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am_2.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app.getApplicationId(), RMAppState.FAILED);
        ControlledClock clock = new ControlledClock();
        RMAppImpl app1 = (RMAppImpl)rm1.submitApp(200, 10000L, false);
        app1.setSystemClock((Clock)clock);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, rm1, nm1);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Thread.sleep(15000L);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)2L, (long)app1.getAppAttempts().size());
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        MockAM am2 = MockRM.launchAndRegisterAM((RMApp)app1, rm1, nm1);
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        clock.setTime(System.currentTimeMillis() + 10000L);
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)3L, (long)app1.getAppAttempts().size());
        RMAppAttempt attempt3 = app1.getCurrentAppAttempt();
        clock.reset();
        MockAM am3 = MockRM.launchAndRegisterAM((RMApp)app1, rm1, nm1);
        rm1.waitForState(am3.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        MockRM rm2 = new MockRM((Configuration)this.getConf(), (RMStateStore)memStore);
        rm2.start();
        MockMemoryRMStateStore memStore1 = (MockMemoryRMStateStore)rm2.getRMStateStore();
        ApplicationStateData app1State = (ApplicationStateData)memStore1.getState().getApplicationState().get(app1.getApplicationId());
        Assert.assertEquals((long)1L, (long)app1State.getFirstAttemptId());
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        NMContainerStatus status = (NMContainerStatus)Records.newRecord(NMContainerStatus.class);
        status.setContainerExitStatus(-106);
        status.setContainerId(attempt3.getMasterContainer().getId());
        status.setContainerState(ContainerState.COMPLETE);
        status.setDiagnostics("");
        nm1.registerNode(Collections.singletonList(status), null);
        rm2.waitForState(attempt3.getAppAttemptId(), RMAppAttemptState.FAILED);
        Thread.sleep(15000L);
        Assert.assertEquals((long)2L, (long)app1State.getAttemptCount());
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am4 = rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 4, nm1);
        clock.setTime(System.currentTimeMillis() + 10000L);
        nm1.nodeHeartbeat(am4.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm2.waitForState(am4.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Assert.assertEquals((long)2L, (long)app1State.getAttemptCount());
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am5 = rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 5, nm1);
        clock.reset();
        rm2.waitForState(am5.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        nm1.nodeHeartbeat(am5.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm2.waitForState(am5.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Assert.assertEquals((long)2L, (long)app1State.getAttemptCount());
        rm2.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        rm1.stop();
        rm2.stop();
    }

    private boolean isContainerIdInContainerStatus(List<ContainerStatus> containerStatuses, ContainerId containerId) {
        for (ContainerStatus status : containerStatuses) {
            if (!status.getContainerId().equals((Object)containerId)) continue;
            return true;
        }
        return false;
    }

    @Test(timeout=40000L)
    public void testAMRestartNotLostContainerCompleteMsg() throws Exception {
        AllocateResponse response;
        List containerStatuses;
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        rm1.start();
        RMApp app1 = rm1.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "MAPREDUCE", false, true);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        TestAMRestart.allocateContainers(nm1, am1, 1);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.COMPLETE);
        rm1.waitForState(nm1, containerId2, RMContainerState.COMPLETED);
        while (!this.isContainerIdInContainerStatus(containerStatuses = (response = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>())).getCompletedContainersStatuses(), containerId2)) {
            Thread.sleep(100L);
        }
        containerStatuses = app1.getCurrentAppAttempt().getJustFinishedContainers();
        if (this.isContainerIdInContainerStatus(containerStatuses, containerId2)) {
            Assert.fail();
        }
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        ApplicationAttemptId newAttemptId = app1.getCurrentAppAttempt().getAppAttemptId();
        Assert.assertFalse((boolean)newAttemptId.equals((Object)am1.getApplicationAttemptId()));
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        MockAM am2 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        AllocateResponse allocateResponse = am2.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
        List containerStatuses2 = allocateResponse.getCompletedContainersStatuses();
        if (!this.isContainerIdInContainerStatus(containerStatuses2, containerId2)) {
            Assert.fail();
        }
        if (this.isContainerIdInContainerStatus(containerStatuses2 = attempt2.getJustFinishedContainers(), containerId2)) {
            Assert.fail();
        }
        if (this.isContainerIdInContainerStatus(containerStatuses2 = (allocateResponse = am2.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>())).getCompletedContainersStatuses(), containerId2)) {
            Assert.fail();
        }
        rm1.stop();
    }

    @Test(timeout=20000L)
    public void testAMRestartNotLostContainerAfterAttemptFailuresValidityInterval() throws Exception {
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMAppImpl app1 = (RMAppImpl)rm1.submitApp(200, 10000L, true);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, rm1, nm1);
        int NUM_CONTAINERS = 2;
        TestAMRestart.allocateContainers(nm1, am1, NUM_CONTAINERS);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)2L, (long)app1.getAppAttempts().size());
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        MockAM am2 = MockRM.launchAndRegisterAM((RMApp)app1, rm1, nm1);
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        Thread.sleep(10000L);
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am2.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)3L, (long)app1.getAppAttempts().size());
        MockAM am3 = MockRM.launchAM((RMApp)app1, rm1, nm1);
        RegisterApplicationMasterResponse registerResponse = am3.registerAppAttempt();
        Assert.assertEquals((long)1L, (long)registerResponse.getContainersFromPreviousAttempts().size());
        boolean containerId2Exists = false;
        Container container = (Container)registerResponse.getContainersFromPreviousAttempts().get(0);
        if (container.getId().equals((Object)containerId2)) {
            containerId2Exists = true;
        }
        Assert.assertTrue((boolean)containerId2Exists);
        rm1.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        rm1.stop();
    }

    @Test(timeout=200000L)
    public void testContainersFromPreviousAttemptsWithRMRestart() throws Exception {
        this.getConf().setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.getConf().setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.getConf().setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        this.getConf().setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        this.getConf().set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MockRM rm1 = new MockRM((Configuration)this.getConf());
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        rm1.start();
        ResourceScheduler scheduler = rm1.getResourceScheduler();
        String nm1Address = "127.0.0.1:1234";
        MockNM nm1 = new MockNM(nm1Address, 10240, rm1.getResourceTrackerService());
        nm1.registerNode();
        String nm2Address = "127.0.0.1:2351";
        MockNM nm2 = new MockNM(nm2Address, 4089, rm1.getResourceTrackerService());
        nm2.registerNode();
        RMApp app1 = rm1.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "MAPREDUCE", false, true);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        TestAMRestart.allocateContainers(nm1, am1, 1);
        TestAMRestart.allocateContainers(nm2, am1, 1);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        nm2.nodeHeartbeat(am1.getApplicationAttemptId(), 3L, ContainerState.RUNNING);
        ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        rm1.waitForState(nm2, containerId3, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        TestSchedulerUtils.waitSchedulerApplicationAttemptStopped((AbstractYarnScheduler)scheduler, am1.getApplicationAttemptId());
        MockRM rm2 = new MockRM((Configuration)this.getConf(), (RMStateStore)memStore);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        NMContainerStatus container2Status = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        nm1.registerNode(Lists.newArrayList((Object[])new NMContainerStatus[]{container2Status}), null);
        Thread.sleep(3000L);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        rm2.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        Assert.assertNotNull((Object)rm2.getResourceScheduler().getRMContainer(containerId2));
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        ApplicationAttemptId newAttemptId = app1.getCurrentAppAttempt().getAppAttemptId();
        Assert.assertFalse((boolean)newAttemptId.equals((Object)am1.getApplicationAttemptId()));
        MockAM am2 = MockRM.launchAMWhenAsyncSchedulingEnabled(app1, rm2);
        RegisterApplicationMasterResponse registerResponse = am2.registerAppAttempt();
        Assert.assertEquals((long)1L, (long)registerResponse.getContainersFromPreviousAttempts().size());
        Assert.assertEquals((String)"container 2", (Object)containerId2, (Object)((Container)registerResponse.getContainersFromPreviousAttempts().get(0)).getId());
        List prevNMTokens = registerResponse.getNMTokensFromPreviousAttempts();
        Assert.assertEquals((long)1L, (long)prevNMTokens.size());
        Assert.assertEquals((Object)nm1Address, (Object)((NMToken)prevNMTokens.get(0)).getNodeId().toString());
        rm2.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        nm2.setResourceTrackerService(rm2.getResourceTrackerService());
        NMContainerStatus container3Status = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 3, ContainerState.RUNNING);
        nm2.registerNode(Lists.newArrayList((Object[])new NMContainerStatus[]{container3Status}), null);
        nm2.nodeHeartbeat(am1.getApplicationAttemptId(), 3L, ContainerState.RUNNING);
        rm2.waitForState(nm2, containerId3, RMContainerState.RUNNING);
        Assert.assertNotNull((Object)rm2.getResourceScheduler().getRMContainer(containerId3));
        ArrayList containersFromPreviousAttempts = new ArrayList();
        GenericTestUtils.waitFor(() -> {
            try {
                AllocateResponse allocateResponse = am2.doHeartbeat();
                if (allocateResponse.getContainersFromPreviousAttempts().size() > 0) {
                    containersFromPreviousAttempts.addAll(allocateResponse.getContainersFromPreviousAttempts());
                    Assert.assertEquals((String)"new containers should not be allocated", (long)0L, (long)allocateResponse.getAllocatedContainers().size());
                    List nmTokens = allocateResponse.getNMTokens();
                    Assert.assertEquals((long)1L, (long)nmTokens.size());
                    Assert.assertEquals((Object)nm2Address, (Object)((NMToken)nmTokens.get(0)).getNodeId().toString());
                    return true;
                }
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
            return false;
        }, (int)2000, (int)200000);
        Assert.assertEquals((String)"container 3", (Object)containerId3, (Object)((Container)containersFromPreviousAttempts.get(0)).getId());
        rm2.stop();
        rm1.stop();
    }
}

