/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQueueManager {
    private FairSchedulerConfiguration conf;
    private QueueManager queueManager;
    private Set<FSQueue> notEmptyQueues;
    private FairScheduler scheduler;

    @Before
    public void setUp() throws Exception {
        this.conf = new FairSchedulerConfiguration();
        this.scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).add("root.test");
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).add("root.test.childA");
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).add("root.test.childB");
        Mockito.when((Object)this.scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        Mockito.when((Object)this.scheduler.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        SystemClock clock = SystemClock.getInstance();
        Mockito.when((Object)this.scheduler.getClock()).thenReturn((Object)clock);
        this.notEmptyQueues = new HashSet<FSQueue>();
        this.queueManager = new QueueManager(this.scheduler){

            public boolean isEmpty(FSQueue queue) {
                return !TestQueueManager.this.notEmptyQueues.contains(queue);
            }
        };
        FSQueueMetrics.forQueue((String)"root", null, (boolean)true, (Configuration)this.conf);
        this.queueManager.initialize((Configuration)this.conf);
    }

    @Test
    public void testReloadTurnsLeafQueueIntoParent() throws Exception {
        this.updateConfiguredLeafQueues(this.queueManager, "queue1");
        this.updateConfiguredLeafQueues(this.queueManager, "queue1.queue2");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        this.updateConfiguredLeafQueues(this.queueManager, "queue1");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.notEmptyQueues.add((FSQueue)this.queueManager.getLeafQueue("queue1", false));
        this.updateConfiguredLeafQueues(this.queueManager, "queue1.queue2");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.notEmptyQueues.clear();
        this.updateConfiguredLeafQueues(this.queueManager, "queue1.queue2");
        this.notEmptyQueues.add(this.queueManager.getQueue("root.queue1"));
        this.updateConfiguredLeafQueues(this.queueManager, "queue1");
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.updateConfiguredLeafQueues(this.queueManager, "default.queue3");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("default.queue3", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("default", false));
    }

    @Test
    public void testReloadTurnsLeafToParentWithNoLeaf() {
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).add("root.queue1");
        this.queueManager.updateAllocationConfiguration(allocConf);
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("root.queue1", false));
        this.notEmptyQueues.add((FSQueue)this.queueManager.getLeafQueue("root.queue1", false));
        allocConf = new AllocationConfiguration((Configuration)this.conf);
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).add("root.queue1");
        this.queueManager.updateAllocationConfiguration(allocConf);
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("root.queue1", false));
        Assert.assertNull((Object)this.queueManager.getParentQueue("root.queue1", false));
        this.notEmptyQueues.clear();
        this.queueManager.updateAllocationConfiguration(allocConf);
        Assert.assertNull((Object)this.queueManager.getLeafQueue("root.queue1", false));
        Assert.assertNotNull((Object)this.queueManager.getParentQueue("root.queue1", false));
        Assert.assertTrue((boolean)this.queueManager.getParentQueue("root.queue1", false).getChildQueues().isEmpty());
    }

    @Test
    public void testCheckQueueNodeName() {
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid(""));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("  "));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid(" a"));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("a "));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid(" a "));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("\u00a0"));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("a\u00a0"));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("\u00a0a\u00a0"));
        Assert.assertTrue((boolean)this.queueManager.isQueueNameValid("a b"));
        Assert.assertTrue((boolean)this.queueManager.isQueueNameValid("a"));
    }

    private void updateConfiguredLeafQueues(QueueManager queueMgr, String ... confLeafQueues) {
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).addAll(Sets.newHashSet((Object[])confLeafQueues));
        queueMgr.updateAllocationConfiguration(allocConf);
    }

    @Test
    public void testCreateLeafQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSQueue q1 = this.queueManager.createQueue("root.queue1", FSQueueType.LEAF);
        Assert.assertNotNull((String)"Leaf queue root.queue1 was not created", (Object)this.queueManager.getLeafQueue("root.queue1", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1", (Object)q1.getName());
    }

    @Test
    public void testCreateLeafQueueAndParent() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSQueue q2 = this.queueManager.createQueue("root.queue1.queue2", FSQueueType.LEAF);
        Assert.assertNotNull((String)"Parent queue root.queue1 was not created", (Object)this.queueManager.getParentQueue("root.queue1", false));
        Assert.assertNotNull((String)"Leaf queue root.queue1.queue2 was not created", (Object)this.queueManager.getLeafQueue("root.queue1.queue2", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1.queue2", (Object)q2.getName());
    }

    @Test
    public void testCreateQueueWithChildDefaults() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        this.queueManager.getQueue("root.test").setMaxChildQueueResource(new ConfigurableResource(Resources.createResource((int)8192, (int)256)));
        FSQueue q1 = this.queueManager.createQueue("root.test.childC", FSQueueType.LEAF);
        Assert.assertNotNull((String)"Leaf queue root.test.childC was not created", (Object)this.queueManager.getLeafQueue("root.test.childC", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.test.childC", (Object)q1.getName());
        Assert.assertEquals((String)"Max resources for root.queue1 were not inherited from parent's max child resources", (Object)Resources.createResource((int)8192, (int)256), (Object)q1.getMaxShare());
        FSQueue q2 = this.queueManager.createQueue("root.test.childD", FSQueueType.PARENT);
        Assert.assertNotNull((String)"Leaf queue root.test.childD was not created", (Object)this.queueManager.getParentQueue("root.test.childD", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.test.childD", (Object)q2.getName());
        Assert.assertEquals((String)"Max resources for root.test.childD were not inherited from parent's max child resources", (Object)Resources.createResource((int)8192, (int)256), (Object)q2.getMaxShare());
        Assert.assertNotNull((String)"Leaf queue root.test.childA was not created during setup", (Object)this.queueManager.getLeafQueue("root.test.childA", false));
        Assert.assertEquals((String)"Max resources for root.test.childA were inherited from parent's max child resources", (Object)Resources.unbounded(), (Object)this.queueManager.getLeafQueue("root.test.childA", false).getMaxShare());
        Assert.assertNotNull((String)"Leaf queue root.test.childB was not created during setup", (Object)this.queueManager.getParentQueue("root.test.childB", false));
        Assert.assertEquals((String)"Max resources for root.test.childB were inherited from parent's max child resources", (Object)Resources.unbounded(), (Object)this.queueManager.getParentQueue("root.test.childB", false).getMaxShare());
    }

    @Test
    public void testCreateLeafQueueWithDefaults() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        FSQueue q1 = this.queueManager.createQueue("root.queue1", FSQueueType.LEAF);
        Assert.assertNotNull((String)"Leaf queue root.queue1 was not created", (Object)this.queueManager.getLeafQueue("root.queue1", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1", (Object)q1.getName());
        Assert.assertEquals((String)"Min resources were not set to default", (Object)Resources.createResource((int)0, (int)0), (Object)q1.getMinShare());
        Assert.assertEquals((String)"Max resources were not set to default", (Object)Resources.unbounded(), (Object)q1.getMaxShare());
    }

    @Test
    public void testCreateParentQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSQueue q1 = this.queueManager.createQueue("root.queue1", FSQueueType.PARENT);
        Assert.assertNotNull((String)"Parent queue root.queue1 was not created", (Object)this.queueManager.getParentQueue("root.queue1", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1", (Object)q1.getName());
    }

    @Test
    public void testCreateParentQueueAndParent() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSQueue q2 = this.queueManager.createQueue("root.queue1.queue2", FSQueueType.PARENT);
        Assert.assertNotNull((String)"Parent queue root.queue1 was not created", (Object)this.queueManager.getParentQueue("root.queue1", false));
        Assert.assertNotNull((String)"Leaf queue root.queue1.queue2 was not created", (Object)this.queueManager.getParentQueue("root.queue1.queue2", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1.queue2", (Object)q2.getName());
    }

    @Test
    public void testRemovalOfDynamicLeafQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSLeafQueue q1 = this.queueManager.getLeafQueue("root.test.childB.dynamic1", true);
        Assert.assertNotNull((String)"Queue root.test.childB.dynamic1 was not created", (Object)q1);
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.test.childB.dynamic1", (Object)q1.getName());
        Assert.assertTrue((String)"root.test.childB.dynamic1 is not a dynamic queue", (boolean)q1.isDynamic());
        this.notEmptyQueues.add((FSQueue)q1);
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getLeafQueue("root.test.childB.dynamic1", false);
        Assert.assertNotNull((String)"Queue root.test.childB.dynamic1 was deleted", (Object)q1);
        this.notEmptyQueues.remove(q1);
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getLeafQueue("root.test.childB.dynamic1", false);
        Assert.assertNull((String)"Queue root.test.childB.dynamic1 was not deleted", (Object)q1);
        Assert.assertNotNull((String)"The static parent of root.test.childB.dynamic1 was deleted", (Object)this.queueManager.getParentQueue("root.test.childB", false));
    }

    @Test
    public void testRemovalOfDynamicParentQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSLeafQueue q1 = this.queueManager.getLeafQueue("root.parent1.dynamic1", true);
        Assert.assertNotNull((String)"Queue root.parent1.dynamic1 was not created", (Object)q1);
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.parent1.dynamic1", (Object)q1.getName());
        Assert.assertTrue((String)"root.parent1.dynamic1 is not a dynamic queue", (boolean)q1.isDynamic());
        FSParentQueue p1 = this.queueManager.getParentQueue("root.parent1", false);
        Assert.assertNotNull((String)"Queue root.parent1 was not created", (Object)p1);
        Assert.assertTrue((String)"root.parent1 is not a dynamic queue", (boolean)p1.isDynamic());
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getLeafQueue("root.parent1.dynamic1", false);
        p1 = this.queueManager.getParentQueue("root.parent1", false);
        Assert.assertNull((String)"Queue root.parent1.dynamic1 was not deleted", (Object)q1);
        Assert.assertNull((String)"Queue root.parent1 was not deleted", (Object)p1);
    }

    @Test
    public void testNonEmptyDynamicQueueBecomingStaticQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSLeafQueue q1 = this.queueManager.getLeafQueue("root.leaf1", true);
        Assert.assertNotNull((String)"Queue root.leaf1 was not created", (Object)q1);
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.leaf1", (Object)q1.getName());
        Assert.assertTrue((String)"root.leaf1 is not a dynamic queue", (boolean)q1.isDynamic());
        this.notEmptyQueues.add((FSQueue)q1);
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getLeafQueue("root.leaf1", false);
        Assert.assertNotNull((String)"Queue root.leaf1 was deleted", (Object)q1);
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).add("root.leaf1");
        this.queueManager.updateAllocationConfiguration(allocConf);
        Assert.assertFalse((String)"root.leaf1 is not a static queue", (boolean)q1.isDynamic());
        this.notEmptyQueues.clear();
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getLeafQueue("root.leaf1", false);
        Assert.assertNotNull((String)"Queue root.leaf1 was deleted", (Object)q1);
        Assert.assertFalse((String)"root.leaf1 is not a static queue", (boolean)q1.isDynamic());
    }

    @Test
    public void testNonEmptyStaticQueueBecomingDynamicQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSLeafQueue q1 = this.queueManager.getLeafQueue("root.test.childA", false);
        Assert.assertNotNull((String)"Queue root.test.childA does not exist", (Object)q1);
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.test.childA", (Object)q1.getName());
        Assert.assertFalse((String)"root.test.childA is not a static queue", (boolean)q1.isDynamic());
        this.notEmptyQueues.add((FSQueue)q1);
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getLeafQueue("root.test.childA", false);
        Assert.assertNotNull((String)"Queue root.test.childA was deleted", (Object)q1);
        Assert.assertFalse((String)"root.test.childA is not a dynamic queue", (boolean)q1.isDynamic());
        for (Set queueNames : allocConf.configuredQueues.values()) {
            this.queueManager.setQueuesToDynamic(queueNames);
            queueNames.clear();
        }
        this.queueManager.updateAllocationConfiguration(allocConf);
        q1 = this.queueManager.getLeafQueue("root.test.childA", false);
        Assert.assertNotNull((String)"Queue root.test.childA was deleted", (Object)q1);
        Assert.assertTrue((String)"root.test.childA is not a dynamic queue", (boolean)q1.isDynamic());
        this.notEmptyQueues.remove(q1);
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getLeafQueue("root.test.childA", false);
        Assert.assertNull((String)"Queue root.test.childA was not deleted", (Object)q1);
        FSParentQueue p1 = this.queueManager.getParentQueue("root.test", false);
        Assert.assertNull((String)"Queue root.test was not deleted", (Object)p1);
    }

    @Test
    public void testRemovalOfChildlessParentQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSParentQueue q1 = this.queueManager.getParentQueue("root.test.childB", false);
        Assert.assertNotNull((String)"Queue root.test.childB was not created", (Object)q1);
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.test.childB", (Object)q1.getName());
        Assert.assertFalse((String)"root.test.childB is a dynamic queue", (boolean)q1.isDynamic());
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getParentQueue("root.test.childB", false);
        Assert.assertNotNull((String)"Queue root.test.childB was deleted", (Object)q1);
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).remove("root.test.childB");
        this.queueManager.updateAllocationConfiguration(allocConf);
        this.queueManager.setQueuesToDynamic(Collections.singleton("root.test.childB"));
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q1 = this.queueManager.getParentQueue("root.leaf1", false);
        Assert.assertNull((String)"Queue root.leaf1 was not deleted", (Object)q1);
    }

    @Test
    public void testQueueTypeChange() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSLeafQueue q1 = this.queueManager.getLeafQueue("root.parent1.leaf1", true);
        Assert.assertNotNull((String)"Queue root.parent1.leaf1 was not created", (Object)q1);
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.parent1.leaf1", (Object)q1.getName());
        Assert.assertTrue((String)"root.parent1.leaf1 is not a dynamic queue", (boolean)q1.isDynamic());
        FSParentQueue p1 = this.queueManager.getParentQueue("root.parent1", false);
        Assert.assertNotNull((String)"Queue root.parent1 was not created", (Object)p1);
        Assert.assertTrue((String)"root.parent1 is not a dynamic queue", (boolean)p1.isDynamic());
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).add("root.parent1");
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).add("root.parent1.leaf1");
        this.queueManager.updateAllocationConfiguration(allocConf);
        q1 = this.queueManager.getLeafQueue("root.parent1.leaf1", false);
        Assert.assertFalse((String)"root.parent1.leaf1 is not a static queue", (boolean)q1.isDynamic());
        p1 = this.queueManager.getParentQueue("root.parent1", false);
        Assert.assertFalse((String)"root.parent1 is not a static queue", (boolean)p1.isDynamic());
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).remove("root.parent1");
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).remove("root.parent1.leaf1");
        this.queueManager.updateAllocationConfiguration(allocConf);
        this.queueManager.setQueuesToDynamic((Set)ImmutableSet.of((Object)"root.parent1", (Object)"root.parent1.leaf1"));
        q1 = this.queueManager.getLeafQueue("root.parent1.leaf1", false);
        Assert.assertTrue((String)"root.parent1.leaf1 is not a dynamic queue", (boolean)q1.isDynamic());
        p1 = this.queueManager.getParentQueue("root.parent1", false);
        Assert.assertTrue((String)"root.parent1 is not a dynamic queue", (boolean)p1.isDynamic());
    }

    @Test
    public void testApplicationAssignmentPreventsRemovalOfDynamicQueue() throws Exception {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager = new QueueManager(this.scheduler);
        this.queueManager.initialize((Configuration)this.conf);
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSLeafQueue q = this.queueManager.getLeafQueue("root.leaf1", true);
        Assert.assertNotNull((String)"root.leaf1 does not exist", (Object)q);
        Assert.assertTrue((String)"root.leaf1 is not empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        ApplicationId applicationId = ApplicationId.newInstance((long)1L, (int)0);
        q.addAssignedApp(applicationId);
        q = this.queueManager.getLeafQueue("root.leaf1", false);
        Assert.assertFalse((String)"root.leaf1 is empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q = this.queueManager.getLeafQueue("root.leaf1", false);
        Assert.assertNotNull((String)"root.leaf1 has been removed", (Object)q);
        Assert.assertFalse((String)"root.leaf1 is empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)0);
        ActiveUsersManager activeUsersManager = (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        FSAppAttempt appAttempt = new FSAppAttempt(this.scheduler, applicationAttemptId, "a_user", q, activeUsersManager, rmContext);
        q.addApp(appAttempt, true);
        this.queueManager.removeEmptyDynamicQueues();
        q = this.queueManager.getLeafQueue("root.leaf1", false);
        Assert.assertNotNull((String)"root.leaf1 has been removed", (Object)q);
        Assert.assertFalse((String)"root.leaf1 is empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        q.removeApp(appAttempt);
        q = this.queueManager.getLeafQueue("root.leaf1", false);
        Assert.assertTrue((String)"root.leaf1 is not empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q = this.queueManager.getLeafQueue("root.leaf1", false);
        Assert.assertNull((String)"root.leaf1 has not been removed", (Object)q);
    }

    @Test
    public void testRemovalOfIncompatibleNonEmptyQueue() throws Exception {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).add("root.a");
        this.scheduler.allocConf = allocConf;
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSLeafQueue q = this.queueManager.getLeafQueue("root.a", true);
        Assert.assertNotNull((String)"root.a does not exist", (Object)q);
        Assert.assertTrue((String)"root.a is not empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        this.notEmptyQueues.add((FSQueue)q);
        q = this.queueManager.getLeafQueue("root.a", false);
        Assert.assertNotNull((String)"root.a does not exist", (Object)q);
        Assert.assertFalse((String)"root.a is empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        q = this.queueManager.getLeafQueue("root.a", false);
        Assert.assertNotNull((String)"root.a does not exist", (Object)q);
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).remove("root.a");
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).add("root.a");
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).add("root.a.b");
        this.queueManager.updateAllocationConfiguration(allocConf);
        q = this.queueManager.getLeafQueue("root.a", false);
        Assert.assertNotNull((String)"root.a has been removed", (Object)q);
        Assert.assertFalse((String)"root.a is empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        this.queueManager.removePendingIncompatibleQueues();
        q = this.queueManager.getLeafQueue("root.a", false);
        Assert.assertNotNull((String)"root.a has been removed", (Object)q);
        Assert.assertFalse((String)"root.a is empty", (boolean)this.queueManager.isEmpty((FSQueue)q));
        this.notEmptyQueues.clear();
        this.queueManager.removePendingIncompatibleQueues();
        this.queueManager.removeEmptyDynamicQueues();
        FSParentQueue p = this.queueManager.getParentQueue("root.a", false);
        Assert.assertNotNull((String)"root.a does not exist", (Object)p);
    }
}

