/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.util.Arrays;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.AppNameMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMappingEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAppNameMappingPlacementRule {
    private static final String APP_NAME = "DistributedShell";
    private YarnConfiguration conf = new YarnConfiguration();

    @Before
    public void setup() {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    private void verifyQueueMapping(QueueMappingEntity queueMapping, String user, String expectedQueue) throws YarnException {
        this.verifyQueueMapping(queueMapping, user, queueMapping.getQueue(), expectedQueue, false);
    }

    private void verifyQueueMapping(QueueMappingEntity queueMapping, String user, String inputQueue, String expectedQueue, boolean overwrite) throws YarnException {
        AppNameMappingPlacementRule rule = new AppNameMappingPlacementRule(overwrite, Arrays.asList(queueMapping));
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        if (inputQueue.equals("%application")) {
            inputQueue = APP_NAME;
        }
        asc.setQueue(inputQueue);
        String appName = queueMapping.getSource();
        if (appName.equals("%application")) {
            appName = APP_NAME;
        }
        asc.setApplicationName(appName);
        ApplicationPlacementContext ctx = rule.getPlacementForApp(asc, user);
        Assert.assertEquals((Object)expectedQueue, (Object)(ctx != null ? ctx.getQueue() : inputQueue));
    }

    @Test
    public void testMapping() throws YarnException {
        this.verifyQueueMapping(new QueueMappingEntity(APP_NAME, "q1"), "user_1", "q1");
        this.verifyQueueMapping(new QueueMappingEntity("%application", "q2"), "user_1", "q2");
        this.verifyQueueMapping(new QueueMappingEntity("%application", "%application"), "user_1", APP_NAME);
        this.verifyQueueMapping(new QueueMappingEntity(APP_NAME, "q1"), "1", "q2", "q1", true);
        this.verifyQueueMapping(new QueueMappingEntity(APP_NAME, "q1"), "1", "q2", "q2", false);
    }
}

