/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationTimeout;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.TestWorkPreservingRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.util.Times;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestApplicationLifetimeMonitor {
    private final long maxLifetime = 30L;
    private YarnConfiguration conf;
    private Class scheduler;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{CapacityScheduler.class});
        params.add(new Object[]{FairScheduler.class});
        return params;
    }

    public TestApplicationLifetimeMonitor(Class schedulerParameter) {
        this.scheduler = schedulerParameter;
    }

    @Before
    public void setup() throws IOException {
        if (this.scheduler.equals(CapacityScheduler.class)) {
            long defaultLifetime = 15L;
            CapacitySchedulerConfiguration capacitySchedulerConfiguration = this.setUpCSQueue(30L, defaultLifetime);
            this.conf = new YarnConfiguration((Configuration)capacitySchedulerConfiguration);
        } else {
            this.conf = new YarnConfiguration();
        }
        this.conf.setClass("yarn.resourcemanager.scheduler.class", this.scheduler, ResourceScheduler.class);
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.setLong("yarn.resourcemanager.application-timeouts.monitor.interval-ms", 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testApplicationLifetimeMonitor() throws Exception {
        MockRM rm = null;
        try {
            rm = new MockRM((Configuration)this.conf);
            rm.start();
            Priority appPriority = Priority.newInstance((int)0);
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 16384);
            HashMap<ApplicationTimeoutType, Long> timeouts = new HashMap<ApplicationTimeoutType, Long>();
            timeouts.put(ApplicationTimeoutType.LIFETIME, 10L);
            RMApp app1 = rm.submitApp(1024, appPriority, timeouts);
            timeouts.put(ApplicationTimeoutType.LIFETIME, 20L);
            RMApp app2 = rm.submitApp(1024, appPriority, timeouts);
            RMApp app3 = rm.submitApp(1024, appPriority, Collections.emptyMap());
            timeouts.put(ApplicationTimeoutType.LIFETIME, 40L);
            RMApp app4 = rm.submitApp(1024, appPriority, timeouts);
            nm1.nodeHeartbeat(true);
            MockAM am1 = rm.sendAMLaunched(app1.getCurrentAppAttempt().getAppAttemptId());
            am1.registerAppAttempt();
            rm.waitForState(app1.getApplicationId(), RMAppState.KILLED);
            Assert.assertTrue((String)"Application killed before lifetime value", (System.currentTimeMillis() - app1.getSubmitTime() > 10000L ? 1 : 0) != 0);
            HashMap<ApplicationTimeoutType, String> updateTimeout = new HashMap<ApplicationTimeoutType, String>();
            long newLifetime = 40L;
            String formatISO8601 = Times.formatISO8601((long)(System.currentTimeMillis() + newLifetime * 1000L));
            updateTimeout.put(ApplicationTimeoutType.LIFETIME, formatISO8601);
            UpdateApplicationTimeoutsRequest request = UpdateApplicationTimeoutsRequest.newInstance((ApplicationId)app2.getApplicationId(), updateTimeout);
            Map applicationTimeouts = app2.getApplicationTimeouts();
            long beforeUpdate = (Long)applicationTimeouts.get(ApplicationTimeoutType.LIFETIME);
            rm.getRMContext().getClientRMService().updateApplicationTimeouts(request);
            applicationTimeouts = app2.getApplicationTimeouts();
            long afterUpdate = (Long)applicationTimeouts.get(ApplicationTimeoutType.LIFETIME);
            Assert.assertTrue((String)"Application lifetime value not updated", (afterUpdate > beforeUpdate ? 1 : 0) != 0);
            RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
            GetApplicationReportRequest appRequest = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
            appRequest.setApplicationId(app2.getApplicationId());
            Map appTimeouts = rm.getRMContext().getClientRMService().getApplicationReport(appRequest).getApplicationReport().getApplicationTimeouts();
            Assert.assertTrue((String)"Application Timeout are empty.", (!appTimeouts.isEmpty() ? 1 : 0) != 0);
            ApplicationTimeout timeout = (ApplicationTimeout)appTimeouts.get(ApplicationTimeoutType.LIFETIME);
            Assert.assertTrue((String)"Application remaining time is incorrect", (timeout.getRemainingTime() > 0L ? 1 : 0) != 0);
            rm.waitForState(app2.getApplicationId(), RMAppState.KILLED);
            Assert.assertTrue((String)"Application killed before lifetime value", (app2.getFinishTime() > afterUpdate ? 1 : 0) != 0);
            if (this.scheduler.equals(CapacityScheduler.class)) {
                rm.waitForState(app3.getApplicationId(), RMAppState.KILLED);
                rm.waitForState(app4.getApplicationId(), RMAppState.KILLED);
                long totalTimeRun = (app4.getFinishTime() - app4.getSubmitTime()) / 1000L;
                Assert.assertTrue((String)"Application killed before lifetime value", (totalTimeRun > 30L ? 1 : 0) != 0);
                Assert.assertTrue((String)("Application killed before lifetime value " + totalTimeRun), (totalTimeRun < 40L ? 1 : 0) != 0);
            }
            this.stopRM(rm);
        }
        catch (Throwable throwable) {
            this.stopRM(rm);
            throw throwable;
        }
    }

    @Test(timeout=180000L)
    public void testApplicationLifetimeOnRMRestart() throws Exception {
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MockRM rm1 = new MockRM((Configuration)this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm1.getRMStateStore();
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, rm1.getResourceTrackerService());
        nm1.registerNode();
        nm1.nodeHeartbeat(true);
        long appLifetime = 30L;
        HashMap<ApplicationTimeoutType, Long> timeouts = new HashMap<ApplicationTimeoutType, Long>();
        timeouts.put(ApplicationTimeoutType.LIFETIME, appLifetime);
        RMApp app1 = rm1.submitApp(200, Priority.newInstance((int)0), timeouts);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRM rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.getRMContext().getRMAppLifetimeMonitor().unregisterApp(app1.getApplicationId(), ApplicationTimeoutType.LIFETIME);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        RMApp recoveredApp1 = (RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        nm1.registerNode(Arrays.asList(amContainer, runningContainer), null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, rm2, am1.getApplicationAttemptId());
        Set launchedContainers = ((RMNodeImpl)rm2.getRMContext().getRMNodes().get(nm1.getNodeId())).getLaunchedContainers();
        Assert.assertTrue((boolean)launchedContainers.contains(amContainer.getContainerId()));
        Assert.assertTrue((boolean)launchedContainers.contains(runningContainer.getContainerId()));
        rm2.waitForState(nm1, amContainer.getContainerId(), RMContainerState.RUNNING);
        rm2.waitForState(nm1, runningContainer.getContainerId(), RMContainerState.RUNNING);
        rm2.waitForState(recoveredApp1.getApplicationId(), RMAppState.ACCEPTED);
        am1.setAMRMProtocol((ApplicationMasterProtocol)rm2.getApplicationMasterService(), rm2.getRMContext());
        am1.registerAppAttempt();
        rm2.waitForState(recoveredApp1.getApplicationId(), RMAppState.RUNNING);
        rm2.waitForState(recoveredApp1.getApplicationId(), RMAppState.KILLED);
        Assert.assertTrue((String)"Application killed before lifetime value", (recoveredApp1.getFinishTime() > recoveredApp1.getSubmitTime() + appLifetime * 1000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testUpdateApplicationTimeoutForStateStoreUpdateFail() throws Exception {
        MockRM rm1 = null;
        try {
            MemoryRMStateStore memStore = new MemoryRMStateStore(){
                private int count = 0;

                public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appState) throws Exception {
                    if (this.count++ == 0) {
                        throw new Exception("State-store update failed");
                    }
                    super.updateApplicationStateInternal(appId, appState);
                }
            };
            memStore.init((Configuration)this.conf);
            rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
            rm1.start();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, rm1.getResourceTrackerService());
            nm1.registerNode();
            nm1.nodeHeartbeat(true);
            long appLifetime = 30L;
            HashMap<ApplicationTimeoutType, Long> timeouts = new HashMap<ApplicationTimeoutType, Long>();
            timeouts.put(ApplicationTimeoutType.LIFETIME, appLifetime);
            RMApp app1 = rm1.submitApp(200, Priority.newInstance((int)0), timeouts);
            HashMap<ApplicationTimeoutType, String> updateTimeout = new HashMap<ApplicationTimeoutType, String>();
            long newLifetime = 10L;
            updateTimeout.put(ApplicationTimeoutType.LIFETIME, Times.formatISO8601((long)(System.currentTimeMillis() + newLifetime * 1000L)));
            UpdateApplicationTimeoutsRequest request = UpdateApplicationTimeoutsRequest.newInstance((ApplicationId)app1.getApplicationId(), updateTimeout);
            Map applicationTimeouts = app1.getApplicationTimeouts();
            long beforeUpdate = (Long)applicationTimeouts.get(ApplicationTimeoutType.LIFETIME);
            try {
                rm1.getRMContext().getClientRMService().updateApplicationTimeouts(request);
                Assert.fail((String)"Update application should fail.");
            }
            catch (YarnException e) {
                Assert.assertTrue((String)"State-store exception does not containe appId", (boolean)e.getMessage().contains(app1.getApplicationId().toString()));
            }
            applicationTimeouts = app1.getApplicationTimeouts();
            long afterUpdate = (Long)applicationTimeouts.get(ApplicationTimeoutType.LIFETIME);
            Assert.assertEquals((String)"Application timeout is updated", (long)beforeUpdate, (long)afterUpdate);
            rm1.waitForState(app1.getApplicationId(), RMAppState.KILLED);
            Assert.assertTrue((String)"Application killed before lifetime value", (app1.getFinishTime() > afterUpdate ? 1 : 0) != 0);
            this.stopRM(rm1);
        }
        catch (Throwable throwable) {
            this.stopRM(rm1);
            throw throwable;
        }
    }

    private CapacitySchedulerConfiguration setUpCSQueue(long maxLifetime, long defaultLifetime) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"default"});
        csConf.setCapacity("root.default", 100.0f);
        csConf.setMaximumLifetimePerQueue("root.default", maxLifetime);
        csConf.setDefaultLifetimePerQueue("root.default", defaultLifetime);
        return csConf;
    }

    private void stopRM(MockRM rm) {
        if (rm != null) {
            rm.stop();
        }
    }
}

