/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSchedulingRequestContainerAllocationAsync {
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    private void testIntraAppAntiAffinityAsync(int numThreads) throws Exception {
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.setInt("yarn.scheduler.capacity.schedule-asynchronously.maximum-threads", numThreads);
        csConf.setInt("yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms", 0);
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocationAsync.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        int nNMs = 200;
        MockNM[] nms = new MockNM[nNMs];
        RMNode[] rmNodes = new RMNode[nNMs];
        for (int i = 0; i < nNMs; ++i) {
            nms[i] = rm1.registerNode("127.0.0." + i + ":1234", 10240);
            rmNodes[i] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)1000, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"mapper"), "mapper");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < nNMs; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)(nNMs + 1), (long)schedulerApp.getLiveContainers().size());
        rm1.close();
    }

    @Test(timeout=300000L)
    public void testSingleThreadAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(1);
    }

    @Test(timeout=300000L)
    public void testTwoThreadsAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(2);
    }

    @Test(timeout=300000L)
    public void testThreeThreadsAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(3);
    }

    @Test(timeout=300000L)
    public void testFourThreadsAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(4);
    }

    @Test(timeout=300000L)
    public void testFiveThreadsAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(5);
    }
}

