/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import io.hops.exception.StorageException;
import io.hops.exception.TransientStorageException;
import io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.metadata.common.entity.IntVariable;
import io.hops.metadata.common.entity.LongVariable;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.metadata.yarn.dal.AppProvenanceDataAccess;
import io.hops.metadata.yarn.dal.ReservationStateDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationAttemptStateDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationStateDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.DelegationKeyDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.DelegationTokenDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.metadata.yarn.entity.AppProvenanceEntry;
import io.hops.metadata.yarn.entity.rmstatestore.ApplicationAttemptState;
import io.hops.metadata.yarn.entity.rmstatestore.ApplicationState;
import io.hops.metadata.yarn.entity.rmstatestore.DelegationKey;
import io.hops.metadata.yarn.entity.rmstatestore.DelegationToken;
import io.hops.metadata.yarn.entity.rmstatestore.ReservationState;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.RMStorageFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class DBRMStateStore
extends RMStateStore {
    private int maxDBTries;
    private boolean stateStoreRunning = false;
    private long resourceRecheckInterval;
    private double databaseResourcesThreshold;
    private Daemon resourceMonitorthread = null;
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)5);
    private Thread verifyActiveStatusThread;
    private int dbSessionTimeout;
    private long localFenceID = 0L;

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.dbSessionTimeout = conf.getInt("dfs.leader.check.interval", 2000);
        this.resourceRecheckInterval = conf.getLong("yarn.resourcemanager.resource.check.interval", 5000L);
        this.maxDBTries = conf.getInt("yarn.resourcemanager.db.check.max.tries", 3);
        this.databaseResourcesThreshold = conf.getDouble("yarn.resourcemanager.resource.check.threshold", 0.9);
    }

    @Override
    public synchronized void startInternal() throws Exception {
        if (HAUtil.isHAEnabled((Configuration)this.getConfig()) && !HAUtil.isAutomaticFailoverEnabled((Configuration)this.getConfig())) {
            this.verifyActiveStatusThread = new VerifyActiveStatusThread();
            this.verifyActiveStatusThread.start();
        }
        this.stateStoreRunning = true;
        this.resourceMonitorthread = new Daemon((Runnable)new ResourceMonitor());
        this.resourceMonitorthread.start();
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        if (this.verifyActiveStatusThread != null) {
            this.verifyActiveStatusThread.interrupt();
            this.verifyActiveStatusThread.join(1000L);
        }
        this.stateStoreRunning = false;
        if (this.resourceMonitorthread != null) {
            ((ResourceMonitor)this.resourceMonitorthread.getRunnable()).stopMonitor();
            this.resourceMonitorthread.interrupt();
        }
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        byte[] version = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        this.storeVersiondb(version);
    }

    void storeVersiondb(byte[] version) throws Exception {
        this.setVariable((Variable)new ByteArrayVariable(Variable.Finder.RMStateStoreVersion, version));
    }

    private void setVariable(final Variable var) throws IOException {
        LightWeightRequestHandler setVersionHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                VariableDataAccess vDA = (VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class);
                vDA.setVariable(var);
                connector.commit();
                return null;
            }
        };
        setVersionHandler.handle();
    }

    @Override
    protected synchronized Version loadVersion() throws Exception {
        byte[] protoFound = this.loadVersionInternal();
        VersionPBImpl versionFound = null;
        if (protoFound != null) {
            versionFound = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])protoFound));
        }
        return versionFound;
    }

    private byte[] loadVersionInternal() throws IOException {
        ByteArrayVariable var = (ByteArrayVariable)this.getVariable(Variable.Finder.RMStateStoreVersion);
        return (byte[])var.getValue();
    }

    private Variable getVariableInt(Variable.Finder finder) throws StorageException {
        VariableDataAccess DA = (VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class);
        return (Variable)DA.getVariable((Object)finder);
    }

    private Variable getVariable(final Variable.Finder finder) throws IOException {
        LightWeightRequestHandler getVersionHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.readCommitted();
                Variable var = DBRMStateStore.this.getVariableInt(finder);
                connector.commit();
                return var;
            }
        };
        return (Variable)getVersionHandler.handle();
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        final Variable.Finder dbKey = Variable.Finder.RMStateStoreEpoch;
        LightWeightRequestHandler getAndIncrementEpochHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                VariableDataAccess DA = (VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class);
                LongVariable var = (LongVariable)DA.getVariable((Object)dbKey);
                long currentEpoch = DBRMStateStore.this.baseEpoch;
                if (var != null && var.getValue() != null) {
                    currentEpoch = var.getValue();
                }
                LongVariable newVar = new LongVariable(dbKey, DBRMStateStore.this.nextEpoch(currentEpoch));
                DA.setVariable((Variable)newVar);
                connector.commit();
                return currentEpoch;
            }
        };
        return (Long)getAndIncrementEpochHandler.handle();
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        final RMStateStore.RMState rmState = new RMStateStore.RMState();
        LightWeightRequestHandler loadStateHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException, IOException {
                connector.beginTransaction();
                connector.readLock();
                DBRMStateStore.this.loadRMDTSecretManagerState(rmState);
                DBRMStateStore.this.loadRMApps(rmState);
                DBRMStateStore.this.loadAMRMTokenSecretManagerState(rmState);
                DBRMStateStore.this.loadReservationSystemState(rmState);
                connector.commit();
                return null;
            }
        };
        loadStateHandler.handle();
        return rmState;
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws IOException {
        ByteArrayVariable var = (ByteArrayVariable)this.getVariableInt(Variable.Finder.AMRMToken);
        if (var == null || var.getValue() == null) {
            return;
        }
        AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom((byte[])var.getValue()));
        rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
    }

    private void loadRMApps(RMStateStore.RMState state) throws IOException {
        ApplicationStateDataAccess DA = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
        ApplicationAttemptStateDataAccess attemptDA = (ApplicationAttemptStateDataAccess)RMStorageFactory.getDataAccess(ApplicationAttemptStateDataAccess.class);
        List appStates = DA.getAll();
        Map applicationAttemptStates = attemptDA.getAll();
        if (appStates != null) {
            for (ApplicationState hopAppState : appStates) {
                ApplicationStateData appState = this.createApplicationState(hopAppState.getApplicationid(), hopAppState.getAppstate());
                ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
                state.appState.put(appId, appState);
                if (applicationAttemptStates.get(hopAppState.getApplicationid()) == null) continue;
                for (ApplicationAttemptState hopsAttemptState : (List)applicationAttemptStates.get(hopAppState.getApplicationid())) {
                    ApplicationAttemptStateData attemptState = this.createAttemptState(hopsAttemptState.getApplicationattemptid(), hopsAttemptState.getApplicationattemptstate());
                    appState.attempts.put(attemptState.getAttemptId(), attemptState);
                }
            }
        }
    }

    @VisibleForTesting
    ApplicationAttemptStateData loadRMAppAttemptState(final ApplicationAttemptId attemptId) throws IOException {
        LightWeightRequestHandler loadStateHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException, IOException {
                ApplicationAttemptStateDataAccess attemptDA = (ApplicationAttemptStateDataAccess)RMStorageFactory.getDataAccess(ApplicationAttemptStateDataAccess.class);
                return attemptDA.get(attemptId.getApplicationId().toString(), attemptId.toString());
            }
        };
        return (ApplicationAttemptStateData)loadStateHandler.handle();
    }

    private void loadReservationSystemState(RMStateStore.RMState rmState) throws IOException {
        ReservationStateDataAccess DA = (ReservationStateDataAccess)RMStorageFactory.getDataAccess(ReservationStateDataAccess.class);
        List reservationStates = DA.getAll();
        for (ReservationState state : reservationStates) {
            if (!rmState.getReservationState().containsKey(state.getPlanName())) {
                rmState.getReservationState().put(state.getPlanName(), new HashMap());
            }
            rmState.getReservationState().get(state.getPlanName()).put(ReservationId.parseReservationId((String)state.getReservationIdName()), YarnProtos.ReservationAllocationStateProto.parseFrom((byte[])state.getState()));
        }
    }

    private ApplicationStateData createApplicationState(String appIdStr, byte[] data) throws IOException {
        ApplicationStateDataPBImpl appState;
        ApplicationId appId = ConverterUtils.toApplicationId((String)appIdStr);
        if (!appId.equals((Object)(appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(data))).getApplicationSubmissionContext().getApplicationId())) {
            throw new YarnRuntimeException("The database entry for " + appId + " contains data for " + appState.getApplicationSubmissionContext().getApplicationId());
        }
        return appState;
    }

    private ApplicationAttemptStateData createAttemptState(String itemName, byte[] data) throws IOException {
        ApplicationAttemptStateDataPBImpl attemptState;
        ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)itemName);
        if (!attemptId.equals((Object)(attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(data))).getAttemptId())) {
            throw new YarnRuntimeException("The database entry for " + attemptId + " contains data for " + attemptState.getAttemptId());
        }
        return attemptState;
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState state) throws IOException {
        int numKeys = this.loadRMDTSecretManagerKeys(state);
        LOG.info((Object)("Recovered " + numKeys + " RM delegation token master keys "));
        int numTokens = this.loadRMDTSecretManagerTokens(state);
        LOG.info((Object)("Recovered " + numTokens + " RM delegation tokens"));
        this.loadRMDTSecretManagerTokenSequenceNumber(state);
    }

    private int loadRMDTSecretManagerKeys(RMStateStore.RMState state) throws IOException {
        int numKeys = 0;
        DelegationKeyDataAccess DA = (DelegationKeyDataAccess)RMStorageFactory.getDataAccess(DelegationKeyDataAccess.class);
        List delKeys = DA.getAll();
        if (delKeys != null) {
            for (DelegationKey delKey : delKeys) {
                org.apache.hadoop.security.token.delegation.DelegationKey masterKey = this.loadDelegationKey(delKey.getDelegationkey());
                state.rmSecretManagerState.masterKeyState.add(masterKey);
                ++numKeys;
            }
        }
        return numKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.hadoop.security.token.delegation.DelegationKey loadDelegationKey(byte[] data) throws IOException {
        org.apache.hadoop.security.token.delegation.DelegationKey key = new org.apache.hadoop.security.token.delegation.DelegationKey();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            key.readFields((DataInput)in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        return key;
    }

    private int loadRMDTSecretManagerTokens(RMStateStore.RMState state) throws IOException {
        int numTokens = 0;
        DelegationTokenDataAccess DA = (DelegationTokenDataAccess)RMStorageFactory.getDataAccess(DelegationTokenDataAccess.class);
        List delTokens = DA.getAll();
        if (delTokens != null) {
            for (DelegationToken delToken : delTokens) {
                RMDelegationTokenIdentifierData tokenData = this.loadDelegationToken(delToken.getRmdtidentifier());
                RMDelegationTokenIdentifier tokenId = tokenData.getTokenIdentifier();
                long renewDate = tokenData.getRenewDate();
                state.rmSecretManagerState.delegationTokenState.put(tokenId, renewDate);
                ++numTokens;
            }
        }
        return numTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMDelegationTokenIdentifierData loadDelegationToken(byte[] data) throws IOException {
        RMDelegationTokenIdentifierData tokenData = new RMDelegationTokenIdentifierData();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            tokenData.readFields(in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        return tokenData;
    }

    private void loadRMDTSecretManagerTokenSequenceNumber(RMStateStore.RMState state) throws IOException {
        IntVariable var = (IntVariable)this.getVariableInt(Variable.Finder.RMDTSequenceNumber);
        if (var != null && var.getValue() != null) {
            state.rmSecretManagerState.dtSequenceNumber = var.getValue();
        }
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        final String appIdString = appId.toString();
        final byte[] appState = appStateDataPB.getProto().toByteArray();
        final String user = appStateDataPB.getUser();
        final String name = appStateDataPB.getApplicationSubmissionContext().getApplicationName();
        String stateName = null;
        if (appStateDataPB.getState() != null) {
            stateName = appStateDataPB.getState().toString();
        }
        final String stateN = stateName;
        final long submitTime = appStateDataPB.getSubmitTime();
        final long startTime = appStateDataPB.getStartTime();
        final long finishTime = appStateDataPB.getFinishTime();
        LightWeightRequestHandler setApplicationStateHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ApplicationStateDataAccess DA = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
                ApplicationState state = new ApplicationState(appIdString, appState, user, name, stateN);
                DA.add((Object)state);
                DBRMStateStore.this.logProvenance(state, submitTime, startTime, finishTime);
                connector.commit();
                return null;
            }
        };
        setApplicationStateHandler.handle();
    }

    private void logProvenance(ApplicationState state, long submitTime, long startTime, long finishTime) throws StorageException {
        long now = System.currentTimeMillis();
        AppProvenanceDataAccess da = (AppProvenanceDataAccess)RMStorageFactory.getDataAccess(AppProvenanceDataAccess.class);
        AppProvenanceEntry provEntry = new AppProvenanceEntry(state, now, submitTime, startTime, finishTime);
        if (state.getState() == null) {
            provEntry.setState("null");
        }
        da.add((Object)provEntry);
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        this.storeApplicationStateInternal(appId, appStateDataPB);
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        final String appId = appAttemptId.getApplicationId().toString();
        final String attemptId = appAttemptId.toString();
        final byte[] attemptData = attemptStateDataPB.getProto().toByteArray();
        final String trakingURL = attemptStateDataPB.getTrackingUrl();
        LightWeightRequestHandler setApplicationAttemptIdHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ApplicationAttemptStateDataAccess DA = (ApplicationAttemptStateDataAccess)RMStorageFactory.getDataAccess(ApplicationAttemptStateDataAccess.class);
                DA.add((Object)new ApplicationAttemptState(appId, attemptId, attemptData, trakingURL));
                connector.commit();
                return null;
            }
        };
        setApplicationAttemptIdHandler.handle();
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        this.storeApplicationAttemptStateInternal(appAttemptId, attemptStateDataPB);
    }

    @Override
    public synchronized void removeApplicationAttemptInternal(ApplicationAttemptId appAttemptId) throws Exception {
        String appId = appAttemptId.getApplicationId().toString();
        String appAttemptIdString = appAttemptId.toString();
        final ArrayList<ApplicationAttemptState> attemptsToRemove = new ArrayList<ApplicationAttemptState>();
        attemptsToRemove.add(new ApplicationAttemptState(appId, appAttemptIdString));
        LightWeightRequestHandler removeApplicationAttemptHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ApplicationAttemptStateDataAccess attemptDA = (ApplicationAttemptStateDataAccess)RMStorageFactory.getDataAccess(ApplicationAttemptStateDataAccess.class);
                attemptDA.removeAll((Collection)attemptsToRemove);
                connector.commit();
                return null;
            }
        };
        removeApplicationAttemptHandler.handle();
    }

    @Override
    public synchronized void removeApplicationStateInternal(ApplicationStateData appState) throws Exception {
        final String appId = appState.getApplicationSubmissionContext().getApplicationId().toString();
        final ArrayList<ApplicationAttemptState> attemptsToRemove = new ArrayList<ApplicationAttemptState>();
        for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
            attemptsToRemove.add(new ApplicationAttemptState(appId, attemptId.toString()));
        }
        LightWeightRequestHandler setApplicationStateHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                if (appId != null) {
                    connector.beginTransaction();
                    connector.writeLock();
                    ApplicationStateDataAccess DA = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
                    ApplicationState hop = new ApplicationState(appId);
                    DA.remove((Object)hop);
                    ApplicationAttemptStateDataAccess attemptDA = (ApplicationAttemptStateDataAccess)RMStorageFactory.getDataAccess(ApplicationAttemptStateDataAccess.class);
                    attemptDA.removeAll((Collection)attemptsToRemove);
                    connector.commit();
                }
                return null;
            }
        };
        setApplicationStateHandler.handle();
    }

    @Override
    protected synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDT(rmDTIdentifier, renewDate, false);
    }

    @Override
    protected synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        final int seqNumber = rmDTIdentifier.getSequenceNumber();
        LightWeightRequestHandler setDelegationTokenHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws IOException {
                if (seqNumber != Integer.MIN_VALUE) {
                    connector.beginTransaction();
                    connector.writeLock();
                    DelegationTokenDataAccess DA = (DelegationTokenDataAccess)RMStorageFactory.getDataAccess(DelegationTokenDataAccess.class);
                    DelegationToken dtToRemove = new DelegationToken(seqNumber);
                    DA.remove((Object)dtToRemove);
                    connector.commit();
                }
                return null;
            }
        };
        setDelegationTokenHandler.handle();
    }

    @Override
    protected synchronized void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDT(rmDTIdentifier, renewDate, true);
    }

    private void storeOrUpdateRMDT(RMDelegationTokenIdentifier tokenId, Long renewDate, final boolean isUpdate) throws IOException {
        final int tokenNumber = tokenId.getSequenceNumber();
        final RMDelegationTokenIdentifierData tokenData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)tokenId, renewDate);
        LightWeightRequestHandler setTokenAndSequenceNumberHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                DelegationTokenDataAccess DA = (DelegationTokenDataAccess)RMStorageFactory.getDataAccess(DelegationTokenDataAccess.class);
                DA.add((Object)new DelegationToken(tokenNumber, tokenData.toByteArray()));
                if (!isUpdate) {
                    VariableDataAccess vDA = (VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class);
                    vDA.setVariable((Variable)new IntVariable(Variable.Finder.RMDTSequenceNumber, tokenNumber));
                }
                connector.commit();
                return null;
            }
        };
        setTokenAndSequenceNumberHandler.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void storeRMDTMasterKeyState(org.apache.hadoop.security.token.delegation.DelegationKey delegationKey) throws Exception {
        final int keyId = delegationKey.getKeyId();
        try (final ByteArrayOutputStream os = new ByteArrayOutputStream();){
            DataOutputStream fsOut = new DataOutputStream(os);
            delegationKey.write((DataOutput)fsOut);
        }
        LightWeightRequestHandler setRMDTMasterKeyHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                DelegationKeyDataAccess DA = (DelegationKeyDataAccess)RMStorageFactory.getDataAccess(DelegationKeyDataAccess.class);
                DA.add((Object)new DelegationKey(keyId, os.toByteArray()));
                connector.commit();
                return null;
            }
        };
        setRMDTMasterKeyHandler.handle();
    }

    @Override
    protected synchronized void removeRMDTMasterKeyState(org.apache.hadoop.security.token.delegation.DelegationKey delegationKey) throws Exception {
        final int key = delegationKey.getKeyId();
        LightWeightRequestHandler setRMDTMasterKeyHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                RMStateStore.LOG.debug((Object)("HOP :: key=" + key));
                if (key != Integer.MIN_VALUE) {
                    connector.beginTransaction();
                    connector.writeLock();
                    DelegationKeyDataAccess DA = (DelegationKeyDataAccess)RMStorageFactory.getDataAccess(DelegationKeyDataAccess.class);
                    DelegationKey dkeyToremove = new DelegationKey(key, null);
                    DA.remove((Object)dkeyToremove);
                    connector.commit();
                    RMStateStore.LOG.debug((Object)"HOP :: committed");
                }
                return null;
            }
        };
        setRMDTMasterKeyHandler.handle();
    }

    @Override
    public synchronized void deleteStore() throws Exception {
        LightWeightRequestHandler deleteStoreHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ApplicationAttemptStateDataAccess appAttemptDA = (ApplicationAttemptStateDataAccess)RMStorageFactory.getDataAccess(ApplicationAttemptStateDataAccess.class);
                ApplicationStateDataAccess appDA = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
                DelegationKeyDataAccess dkDA = (DelegationKeyDataAccess)RMStorageFactory.getDataAccess(DelegationKeyDataAccess.class);
                DelegationTokenDataAccess dtDA = (DelegationTokenDataAccess)RMStorageFactory.getDataAccess(DelegationTokenDataAccess.class);
                appAttemptDA.removeAll();
                appDA.removeAll();
                dkDA.removeAll();
                dtDA.removeAll();
                VariableDataAccess vDA = (VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class);
                vDA.setVariable((Variable)new ByteArrayVariable(Variable.Finder.AMRMToken, null));
                vDA.setVariable((Variable)new ByteArrayVariable(Variable.Finder.RMStateStoreVersion, null));
                vDA.setVariable((Variable)new LongVariable(Variable.Finder.RMStateStoreEpoch, 0L));
                vDA.setVariable((Variable)new IntVariable(Variable.Finder.RMDTSequenceNumber, 0));
                connector.commit();
                return null;
            }
        };
        deleteStoreHandler.handle();
    }

    @Override
    public synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState state, boolean isUpdate) throws Exception {
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(state);
        byte[] stateData = data.getProto().toByteArray();
        this.setVariable((Variable)new ByteArrayVariable(Variable.Finder.AMRMToken, stateData));
    }

    @VisibleForTesting
    ApplicationStateData loadRMAppState(ApplicationId appId) throws IOException {
        final String appIdString = appId.toString();
        LightWeightRequestHandler getRMAppStateHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.readLock();
                ApplicationStateDataAccess appDA = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
                ApplicationState appState = (ApplicationState)appDA.findByApplicationId(appIdString);
                connector.commit();
                return appState;
            }
        };
        ApplicationState appState = (ApplicationState)getRMAppStateHandler.handle();
        if (appState != null) {
            return this.createApplicationState(appId.toString(), appState.getAppstate());
        }
        return null;
    }

    @VisibleForTesting
    public synchronized int getNumEntriesInDatabase() throws Exception {
        LightWeightRequestHandler countEntriesHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ApplicationAttemptStateDataAccess appAttemptDA = (ApplicationAttemptStateDataAccess)RMStorageFactory.getDataAccess(ApplicationAttemptStateDataAccess.class);
                ApplicationStateDataAccess appDA = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
                DelegationKeyDataAccess dkDA = (DelegationKeyDataAccess)RMStorageFactory.getDataAccess(DelegationKeyDataAccess.class);
                DelegationTokenDataAccess dtDA = (DelegationTokenDataAccess)RMStorageFactory.getDataAccess(DelegationTokenDataAccess.class);
                int numEntries = 0;
                for (Object o : appAttemptDA.getAll().values()) {
                    List l = (List)o;
                    numEntries += l.size();
                }
                numEntries += appDA.getAll().size();
                numEntries += dkDA.getAll().size();
                connector.commit();
                return numEntries += dtDA.getAll().size();
            }
        };
        return (Integer)countEntriesHandler.handle();
    }

    @Override
    public void removeApplication(final ApplicationId removeAppId) throws Exception {
        LightWeightRequestHandler removeApplicationHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                if (removeAppId != null) {
                    connector.beginTransaction();
                    connector.writeLock();
                    ApplicationStateDataAccess DA = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
                    ApplicationState hop = new ApplicationState(removeAppId.toString());
                    DA.remove((Object)hop);
                    ApplicationAttemptStateDataAccess attemptDA = (ApplicationAttemptStateDataAccess)RMStorageFactory.getDataAccess(ApplicationAttemptStateDataAccess.class);
                    List attemptsToRemove = attemptDA.getByAppId(removeAppId.toString());
                    attemptDA.removeAll((Collection)attemptsToRemove);
                    connector.commit();
                }
                return null;
            }
        };
        removeApplicationHandler.handle();
    }

    @Override
    protected void removeReservationState(final String planName, final String reservationIdName) throws Exception {
        LightWeightRequestHandler removeReservationStateHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ReservationStateDataAccess DA = (ReservationStateDataAccess)RMStorageFactory.getDataAccess(ReservationStateDataAccess.class);
                DA.remove((Object)new ReservationState(planName, reservationIdName));
                connector.commit();
                return null;
            }
        };
        removeReservationStateHandler.handle();
    }

    @Override
    protected void storeReservationState(final YarnProtos.ReservationAllocationStateProto reservationAllocation, final String planName, final String reservationIdName) throws Exception {
        LightWeightRequestHandler storeReservationStateHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ReservationStateDataAccess DA = (ReservationStateDataAccess)RMStorageFactory.getDataAccess(ReservationStateDataAccess.class);
                DA.add((Object)new ReservationState(reservationAllocation.toByteArray(), planName, reservationIdName));
                connector.commit();
                return null;
            }
        };
        storeReservationStateHandler.handle();
    }

    private void checkFence() throws StorageException {
        Variable var = this.getVariableInt(Variable.Finder.FenceID);
        long fenceId = (Long)var.getValue();
        if (fenceId != this.localFenceID) {
            throw new StorageException("state store fenced");
        }
    }

    private void checkFenceTransaction() throws IOException {
        LightWeightRequestHandler fenceHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                DBRMStateStore.this.checkFence();
                return null;
            }
        };
        fenceHandler.handle();
    }

    @Override
    public void fence() throws IOException {
        LightWeightRequestHandler fenceHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.OTHER){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                LongVariable var = (LongVariable)DBRMStateStore.this.getVariableInt(Variable.Finder.FenceID);
                long storedFenceID = 0L;
                if (var.getValue() != null) {
                    storedFenceID = var.getValue();
                }
                DBRMStateStore.this.localFenceID = storedFenceID + 1L;
                var = new LongVariable(Variable.Finder.FenceID, DBRMStateStore.this.localFenceID);
                VariableDataAccess vDA = (VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class);
                vDA.setVariable((Variable)var);
                connector.commit();
                return null;
            }
        };
        fenceHandler.handle();
    }

    class ResourceMonitor
    implements Runnable {
        boolean shouldRmRun = true;

        ResourceMonitor() {
        }

        @Override
        public void run() {
            try {
                while (DBRMStateStore.this.stateStoreRunning && this.shouldRmRun) {
                    this.checkAvailableResources();
                    try {
                        Thread.sleep(DBRMStateStore.this.resourceRecheckInterval);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (Exception e) {
                RMStateStore.LOG.error((Object)"Exception in NameNodeResourceMonitor: ", (Throwable)e);
            }
        }

        public void stopMonitor() {
            this.shouldRmRun = false;
        }

        void checkAvailableResources() {
            int tries = 0;
            Throwable lastThrowable = null;
            while (tries < DBRMStateStore.this.maxDBTries) {
                try {
                    if (!RMStorageFactory.hasResources(DBRMStateStore.this.databaseResourcesThreshold)) {
                        throw new IOException("not enough resources in the database");
                    }
                    return;
                }
                catch (StorageException e) {
                    RMStateStore.LOG.warn((Object)("StorageException in checkAvailableResources (" + tries + "/" + DBRMStateStore.this.maxDBTries + ")."), (Throwable)e);
                    if (e instanceof TransientStorageException) {
                        RMStateStore.LOG.debug((Object)"transiant exception");
                        continue;
                    }
                    lastThrowable = e;
                    ++tries;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable t) {
                    RMStateStore.LOG.error((Object)"Runtime exception in checkAvailableResources. ", t);
                    lastThrowable = t;
                    ++tries;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (tries >= DBRMStateStore.this.maxDBTries) {
                ExitUtil.terminate((int)1, lastThrowable);
            }
        }
    }

    private class VerifyActiveStatusThread
    extends Thread {
        VerifyActiveStatusThread() {
            super(VerifyActiveStatusThread.class.getName());
        }

        @Override
        public void run() {
            try {
                while (!DBRMStateStore.this.isFencedState()) {
                    DBRMStateStore.this.checkFenceTransaction();
                    Thread.sleep(DBRMStateStore.this.dbSessionTimeout);
                }
            }
            catch (InterruptedException ie) {
                RMStateStore.LOG.info((Object)(this.getName() + " thread interrupted! Exiting!"));
                this.interrupt();
            }
            catch (Exception e) {
                DBRMStateStore.this.notifyStoreOperationFailed((Exception)((Object)new StoreFencedException()));
            }
        }
    }
}

