/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationDefinitionPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestsPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.AlignedPlannerWithGreedy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.GreedyReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestReservationAgents {
    @Parameterized.Parameter(value=0)
    public Class agentClass;
    @Parameterized.Parameter(value=1)
    public boolean allocateLeft;
    @Parameterized.Parameter(value=2)
    public String recurrenceExpression;
    @Parameterized.Parameter(value=3)
    public int numOfNodes;
    private long step;
    private Random rand = new Random(2L);
    private ReservationAgent agent;
    private Plan plan;
    private ResourceCalculator resCalc = new DefaultResourceCalculator();
    private Resource minAlloc = Resource.newInstance((int)1024, (int)1);
    private Resource maxAlloc = Resource.newInstance((int)32736, (int)32);
    private long timeHorizon = 172800000L;
    private static final Logger LOG = LoggerFactory.getLogger(TestReservationAgents.class);

    @Parameterized.Parameters(name="Testing: agent {0}, allocateLeft: {1}, recurrenceExpression: {2}, numNodes: {3})")
    public static Collection<Object[]> data() {
        return Arrays.asList({GreedyReservationAgent.class, true, "0", 100}, {GreedyReservationAgent.class, false, "0", 100}, {GreedyReservationAgent.class, true, "7200000", 100}, {GreedyReservationAgent.class, false, "7200000", 100}, {GreedyReservationAgent.class, true, "86400000", 100}, {GreedyReservationAgent.class, false, "86400000", 100}, {AlignedPlannerWithGreedy.class, true, "0", 100}, {AlignedPlannerWithGreedy.class, false, "0", 100}, {AlignedPlannerWithGreedy.class, true, "7200000", 100}, {AlignedPlannerWithGreedy.class, false, "7200000", 100}, {AlignedPlannerWithGreedy.class, true, "86400000", 100}, {AlignedPlannerWithGreedy.class, false, "86400000", 100});
    }

    @Before
    public void setup() throws Exception {
        long seed = this.rand.nextLong();
        this.rand.setSeed(seed);
        LOG.info("Running with seed: " + seed);
        long timeWindow = 1000000L;
        Resource clusterCapacity = Resource.newInstance((int)(this.numOfNodes * 1024), (int)this.numOfNodes);
        this.step = 1000L;
        String reservationQ = ReservationSystemTestUtil.getFullReservationQueueName();
        float instConstraint = 100.0f;
        float avgConstraint = 100.0f;
        ReservationSchedulerConfiguration conf = ReservationSystemTestUtil.createConf(reservationQ, timeWindow, instConstraint, avgConstraint);
        CapacityOverTimePolicy policy = new CapacityOverTimePolicy();
        policy.init(reservationQ, conf);
        conf.setBoolean("yarn.resourcemanager.reservation-system.favor-early-allocation", this.allocateLeft);
        this.agent = (ReservationAgent)this.agentClass.newInstance();
        this.agent.init((Configuration)conf);
        QueueMetrics queueMetrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
        RMContext context = ReservationSystemTestUtil.createMockRMContext();
        this.plan = new InMemoryPlan(queueMetrics, (SharingPolicy)policy, this.agent, clusterCapacity, this.step, this.resCalc, this.minAlloc, this.maxAlloc, "dedicated", null, true, context);
    }

    @Test
    public void test() throws Exception {
        long period = Long.parseLong(this.recurrenceExpression);
        for (int i = 0; i < 1000; ++i) {
            ReservationDefinition rr = this.createRandomRequest(i);
            if (rr == null) continue;
            ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
            try {
                this.agent.createReservation(reservationID, "u1", this.plan, rr);
                continue;
            }
            catch (PlanningException planningException) {
                // empty catch block
            }
        }
    }

    private ReservationDefinition createRandomRequest(int i) throws PlanningException {
        long arrival = (long)Math.floor(this.rand.nextDouble() * (double)this.timeHorizon);
        long period = Long.parseLong(this.recurrenceExpression);
        long duration = Math.round(Math.min(this.rand.nextDouble() * 3600.0 * 1000.0, (double)period));
        long deadline = (long)Math.ceil((double)arrival + Math.min((double)duration * this.rand.nextDouble() * 10.0, (double)period));
        assert (deadline - arrival <= period);
        RLESparseResourceAllocation available = this.plan.getAvailableResourceOverTime("u1", null, arrival, deadline, period);
        NavigableMap availableMap = available.getCumulative();
        ArrayList<ReservationRequest> reservationRequests = new ArrayList<ReservationRequest>();
        for (Map.Entry e : availableMap.entrySet()) {
            if (e.getValue() == null || !(this.rand.nextDouble() > 0.001)) continue;
            int numContainers = (int)Math.ceil(Resources.divide((ResourceCalculator)this.resCalc, (Resource)this.plan.getTotalCapacity(), (Resource)((Resource)e.getValue()), (Resource)this.minAlloc) / 2.0f);
            long tempDur = Math.min(duration, (Long)availableMap.higherKey(e.getKey()) - (Long)e.getKey());
            reservationRequests.add(ReservationRequest.newInstance((Resource)this.minAlloc, (int)numContainers, (int)1, (long)tempDur));
        }
        if (reservationRequests.size() < 1) {
            return null;
        }
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(arrival);
        rr.setDeadline(deadline);
        rr.setRecurrenceExpression(this.recurrenceExpression);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ORDER);
        reqs.setReservationResources(reservationRequests);
        rr.setReservationRequests((ReservationRequests)reqs);
        rr.setReservationName("res_" + i);
        return rr;
    }
}

